/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.imagebuilder.model.ComponentState;
import software.amazon.awssdk.services.imagebuilder.model.ComponentType;
import software.amazon.awssdk.services.imagebuilder.model.OsVersionListCopier;
import software.amazon.awssdk.services.imagebuilder.model.Platform;
import software.amazon.awssdk.services.imagebuilder.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ComponentSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ComponentSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(ComponentSummary.getter(ComponentSummary::arn)).setter(ComponentSummary.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ComponentSummary.getter(ComponentSummary::name)).setter(ComponentSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(ComponentSummary.getter(ComponentSummary::version)).setter(ComponentSummary.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platform").getter(ComponentSummary.getter(ComponentSummary::platformAsString)).setter(ComponentSummary.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_OS_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("supportedOsVersions").getter(ComponentSummary.getter(ComponentSummary::supportedOsVersions)).setter(ComponentSummary.setter(Builder::supportedOsVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("supportedOsVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ComponentState> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("state").getter(ComponentSummary.getter(ComponentSummary::state)).setter(ComponentSummary.setter(Builder::state)).constructor(ComponentState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(ComponentSummary.getter(ComponentSummary::typeAsString)).setter(ComponentSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("owner").getter(ComponentSummary.getter(ComponentSummary::owner)).setter(ComponentSummary.setter(Builder::owner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(ComponentSummary.getter(ComponentSummary::description)).setter(ComponentSummary.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> CHANGE_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("changeDescription").getter(ComponentSummary.getter(ComponentSummary::changeDescription)).setter(ComponentSummary.setter(Builder::changeDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("changeDescription").build()}).build();
    private static final SdkField<String> DATE_CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dateCreated").getter(ComponentSummary.getter(ComponentSummary::dateCreated)).setter(ComponentSummary.setter(Builder::dateCreated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateCreated").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(ComponentSummary.getter(ComponentSummary::tags)).setter(ComponentSummary.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> PUBLISHER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("publisher").getter(ComponentSummary.getter(ComponentSummary::publisher)).setter(ComponentSummary.setter(Builder::publisher)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publisher").build()}).build();
    private static final SdkField<Boolean> OBFUSCATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("obfuscate").getter(ComponentSummary.getter(ComponentSummary::obfuscate)).setter(ComponentSummary.setter(Builder::obfuscate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("obfuscate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, VERSION_FIELD, PLATFORM_FIELD, SUPPORTED_OS_VERSIONS_FIELD, STATE_FIELD, TYPE_FIELD, OWNER_FIELD, DESCRIPTION_FIELD, CHANGE_DESCRIPTION_FIELD, DATE_CREATED_FIELD, TAGS_FIELD, PUBLISHER_FIELD, OBFUSCATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ComponentSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String version;
    private final String platform;
    private final List<String> supportedOsVersions;
    private final ComponentState state;
    private final String type;
    private final String owner;
    private final String description;
    private final String changeDescription;
    private final String dateCreated;
    private final Map<String, String> tags;
    private final String publisher;
    private final Boolean obfuscate;

    private ComponentSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.version = builder.version;
        this.platform = builder.platform;
        this.supportedOsVersions = builder.supportedOsVersions;
        this.state = builder.state;
        this.type = builder.type;
        this.owner = builder.owner;
        this.description = builder.description;
        this.changeDescription = builder.changeDescription;
        this.dateCreated = builder.dateCreated;
        this.tags = builder.tags;
        this.publisher = builder.publisher;
        this.obfuscate = builder.obfuscate;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String version() {
        return this.version;
    }

    public final Platform platform() {
        return Platform.fromValue(this.platform);
    }

    public final String platformAsString() {
        return this.platform;
    }

    public final boolean hasSupportedOsVersions() {
        return this.supportedOsVersions != null && !(this.supportedOsVersions instanceof SdkAutoConstructList);
    }

    public final List<String> supportedOsVersions() {
        return this.supportedOsVersions;
    }

    public final ComponentState state() {
        return this.state;
    }

    public final ComponentType type() {
        return ComponentType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String owner() {
        return this.owner;
    }

    public final String description() {
        return this.description;
    }

    public final String changeDescription() {
        return this.changeDescription;
    }

    public final String dateCreated() {
        return this.dateCreated;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String publisher() {
        return this.publisher;
    }

    public final Boolean obfuscate() {
        return this.obfuscate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedOsVersions() ? this.supportedOsVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.changeDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.publisher());
        hashCode = 31 * hashCode + Objects.hashCode(this.obfuscate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComponentSummary)) {
            return false;
        }
        ComponentSummary other = (ComponentSummary)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.platformAsString(), other.platformAsString()) && this.hasSupportedOsVersions() == other.hasSupportedOsVersions() && Objects.equals(this.supportedOsVersions(), other.supportedOsVersions()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.owner(), other.owner()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.changeDescription(), other.changeDescription()) && Objects.equals(this.dateCreated(), other.dateCreated()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.publisher(), other.publisher()) && Objects.equals(this.obfuscate(), other.obfuscate());
    }

    public final String toString() {
        return ToString.builder((String)"ComponentSummary").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("Version", (Object)this.version()).add("Platform", (Object)this.platformAsString()).add("SupportedOsVersions", this.hasSupportedOsVersions() ? this.supportedOsVersions() : null).add("State", (Object)this.state()).add("Type", (Object)this.typeAsString()).add("Owner", (Object)this.owner()).add("Description", (Object)this.description()).add("ChangeDescription", (Object)this.changeDescription()).add("DateCreated", (Object)this.dateCreated()).add("Tags", this.hasTags() ? this.tags() : null).add("Publisher", (Object)this.publisher()).add("Obfuscate", (Object)this.obfuscate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
            case "supportedOsVersions": {
                return Optional.ofNullable(clazz.cast(this.supportedOsVersions()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "changeDescription": {
                return Optional.ofNullable(clazz.cast(this.changeDescription()));
            }
            case "dateCreated": {
                return Optional.ofNullable(clazz.cast(this.dateCreated()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "publisher": {
                return Optional.ofNullable(clazz.cast(this.publisher()));
            }
            case "obfuscate": {
                return Optional.ofNullable(clazz.cast(this.obfuscate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("platform", PLATFORM_FIELD);
        map.put("supportedOsVersions", SUPPORTED_OS_VERSIONS_FIELD);
        map.put("state", STATE_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("owner", OWNER_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("changeDescription", CHANGE_DESCRIPTION_FIELD);
        map.put("dateCreated", DATE_CREATED_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("publisher", PUBLISHER_FIELD);
        map.put("obfuscate", OBFUSCATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComponentSummary, T> g) {
        return obj -> g.apply((ComponentSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String version;
        private String platform;
        private List<String> supportedOsVersions = DefaultSdkAutoConstructList.getInstance();
        private ComponentState state;
        private String type;
        private String owner;
        private String description;
        private String changeDescription;
        private String dateCreated;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String publisher;
        private Boolean obfuscate;

        private BuilderImpl() {
        }

        private BuilderImpl(ComponentSummary model) {
            this.arn(model.arn);
            this.name(model.name);
            this.version(model.version);
            this.platform(model.platform);
            this.supportedOsVersions(model.supportedOsVersions);
            this.state(model.state);
            this.type(model.type);
            this.owner(model.owner);
            this.description(model.description);
            this.changeDescription(model.changeDescription);
            this.dateCreated(model.dateCreated);
            this.tags(model.tags);
            this.publisher(model.publisher);
            this.obfuscate(model.obfuscate);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(Platform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final Collection<String> getSupportedOsVersions() {
            if (this.supportedOsVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedOsVersions;
        }

        public final void setSupportedOsVersions(Collection<String> supportedOsVersions) {
            this.supportedOsVersions = OsVersionListCopier.copy(supportedOsVersions);
        }

        @Override
        public final Builder supportedOsVersions(Collection<String> supportedOsVersions) {
            this.supportedOsVersions = OsVersionListCopier.copy(supportedOsVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedOsVersions(String ... supportedOsVersions) {
            this.supportedOsVersions(Arrays.asList(supportedOsVersions));
            return this;
        }

        public final ComponentState.Builder getState() {
            return this.state != null ? this.state.toBuilder() : null;
        }

        public final void setState(ComponentState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(ComponentState state) {
            this.state = state;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ComponentType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getOwner() {
            return this.owner;
        }

        public final void setOwner(String owner) {
            this.owner = owner;
        }

        @Override
        public final Builder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getChangeDescription() {
            return this.changeDescription;
        }

        public final void setChangeDescription(String changeDescription) {
            this.changeDescription = changeDescription;
        }

        @Override
        public final Builder changeDescription(String changeDescription) {
            this.changeDescription = changeDescription;
            return this;
        }

        public final String getDateCreated() {
            return this.dateCreated;
        }

        public final void setDateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
        }

        @Override
        public final Builder dateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getPublisher() {
            return this.publisher;
        }

        public final void setPublisher(String publisher) {
            this.publisher = publisher;
        }

        @Override
        public final Builder publisher(String publisher) {
            this.publisher = publisher;
            return this;
        }

        public final Boolean getObfuscate() {
            return this.obfuscate;
        }

        public final void setObfuscate(Boolean obfuscate) {
            this.obfuscate = obfuscate;
        }

        @Override
        public final Builder obfuscate(Boolean obfuscate) {
            this.obfuscate = obfuscate;
            return this;
        }

        public ComponentSummary build() {
            return new ComponentSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ComponentSummary> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder version(String var1);

        public Builder platform(String var1);

        public Builder platform(Platform var1);

        public Builder supportedOsVersions(Collection<String> var1);

        public Builder supportedOsVersions(String ... var1);

        public Builder state(ComponentState var1);

        default public Builder state(Consumer<ComponentState.Builder> state) {
            return this.state((ComponentState)((ComponentState.Builder)ComponentState.builder().applyMutation(state)).build());
        }

        public Builder type(String var1);

        public Builder type(ComponentType var1);

        public Builder owner(String var1);

        public Builder description(String var1);

        public Builder changeDescription(String var1);

        public Builder dateCreated(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder publisher(String var1);

        public Builder obfuscate(Boolean var1);
    }
}

