/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.imagebuilder.model.ImagePipeline;
import software.amazon.awssdk.services.imagebuilder.model.ImagePipelineListCopier;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListImagePipelinesResponse
extends ImagebuilderResponse
implements ToCopyableBuilder<Builder, ListImagePipelinesResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestId").getter(ListImagePipelinesResponse.getter(ListImagePipelinesResponse::requestId)).setter(ListImagePipelinesResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()}).build();
    private static final SdkField<List<ImagePipeline>> IMAGE_PIPELINE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("imagePipelineList").getter(ListImagePipelinesResponse.getter(ListImagePipelinesResponse::imagePipelineList)).setter(ListImagePipelinesResponse.setter(Builder::imagePipelineList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imagePipelineList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImagePipeline::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListImagePipelinesResponse.getter(ListImagePipelinesResponse::nextToken)).setter(ListImagePipelinesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, IMAGE_PIPELINE_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("requestId", REQUEST_ID_FIELD);
            this.put("imagePipelineList", IMAGE_PIPELINE_LIST_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final String requestIdValue;
    private final List<ImagePipeline> imagePipelineList;
    private final String nextToken;

    private ListImagePipelinesResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.imagePipelineList = builder.imagePipelineList;
        this.nextToken = builder.nextToken;
    }

    public final String requestId() {
        return this.requestIdValue;
    }

    public final boolean hasImagePipelineList() {
        return this.imagePipelineList != null && !(this.imagePipelineList instanceof SdkAutoConstructList);
    }

    public final List<ImagePipeline> imagePipelineList() {
        return this.imagePipelineList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImagePipelineList() ? this.imagePipelineList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImagePipelinesResponse)) {
            return false;
        }
        ListImagePipelinesResponse other = (ListImagePipelinesResponse)((Object)obj);
        return Objects.equals(this.requestId(), other.requestId()) && this.hasImagePipelineList() == other.hasImagePipelineList() && Objects.equals(this.imagePipelineList(), other.imagePipelineList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListImagePipelinesResponse").add("RequestId", (Object)this.requestId()).add("ImagePipelineList", this.hasImagePipelineList() ? this.imagePipelineList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "imagePipelineList": {
                return Optional.ofNullable(clazz.cast(this.imagePipelineList()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListImagePipelinesResponse, T> g) {
        return obj -> g.apply((ListImagePipelinesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderResponse.BuilderImpl
    implements Builder {
        private String requestIdValue;
        private List<ImagePipeline> imagePipelineList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImagePipelinesResponse model) {
            super(model);
            this.requestId(model.requestIdValue);
            this.imagePipelineList(model.imagePipelineList);
            this.nextToken(model.nextToken);
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final List<ImagePipeline.Builder> getImagePipelineList() {
            List<ImagePipeline.Builder> result = ImagePipelineListCopier.copyToBuilder(this.imagePipelineList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImagePipelineList(Collection<ImagePipeline.BuilderImpl> imagePipelineList) {
            this.imagePipelineList = ImagePipelineListCopier.copyFromBuilder(imagePipelineList);
        }

        @Override
        public final Builder imagePipelineList(Collection<ImagePipeline> imagePipelineList) {
            this.imagePipelineList = ImagePipelineListCopier.copy(imagePipelineList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imagePipelineList(ImagePipeline ... imagePipelineList) {
            this.imagePipelineList(Arrays.asList(imagePipelineList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imagePipelineList(Consumer<ImagePipeline.Builder> ... imagePipelineList) {
            this.imagePipelineList(Stream.of(imagePipelineList).map(c -> (ImagePipeline)((ImagePipeline.Builder)ImagePipeline.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListImagePipelinesResponse build() {
            return new ListImagePipelinesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ImagebuilderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListImagePipelinesResponse> {
        public Builder requestId(String var1);

        public Builder imagePipelineList(Collection<ImagePipeline> var1);

        public Builder imagePipelineList(ImagePipeline ... var1);

        public Builder imagePipelineList(Consumer<ImagePipeline.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

