/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderAsyncClient;
import software.amazon.awssdk.services.imagebuilder.internal.UserAgentUtils;
import software.amazon.awssdk.services.imagebuilder.model.ListWaitingWorkflowStepsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListWaitingWorkflowStepsResponse;
import software.amazon.awssdk.services.imagebuilder.model.WorkflowStepExecution;

public class ListWaitingWorkflowStepsPublisher
implements SdkPublisher<ListWaitingWorkflowStepsResponse> {
    private final ImagebuilderAsyncClient client;
    private final ListWaitingWorkflowStepsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWaitingWorkflowStepsPublisher(ImagebuilderAsyncClient client, ListWaitingWorkflowStepsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWaitingWorkflowStepsPublisher(ImagebuilderAsyncClient client, ListWaitingWorkflowStepsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWaitingWorkflowStepsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWaitingWorkflowStepsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<WorkflowStepExecution> steps() {
        Function<ListWaitingWorkflowStepsResponse, Iterator> getIterator = response -> {
            if (response != null && response.steps() != null) {
                return response.steps().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWaitingWorkflowStepsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWaitingWorkflowStepsResponseFetcher
    implements AsyncPageFetcher<ListWaitingWorkflowStepsResponse> {
        private ListWaitingWorkflowStepsResponseFetcher() {
        }

        public boolean hasNextPage(ListWaitingWorkflowStepsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWaitingWorkflowStepsResponse> nextPage(ListWaitingWorkflowStepsResponse previousPage) {
            if (previousPage == null) {
                return ListWaitingWorkflowStepsPublisher.this.client.listWaitingWorkflowSteps(ListWaitingWorkflowStepsPublisher.this.firstRequest);
            }
            return ListWaitingWorkflowStepsPublisher.this.client.listWaitingWorkflowSteps((ListWaitingWorkflowStepsRequest)((Object)ListWaitingWorkflowStepsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

