/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderClient;
import software.amazon.awssdk.services.imagebuilder.internal.UserAgentUtils;
import software.amazon.awssdk.services.imagebuilder.model.ImagePipeline;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImagePipelinesResponse;

public class ListImagePipelinesIterable
implements SdkIterable<ListImagePipelinesResponse> {
    private final ImagebuilderClient client;
    private final ListImagePipelinesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListImagePipelinesIterable(ImagebuilderClient client, ListImagePipelinesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListImagePipelinesResponseFetcher();
    }

    public Iterator<ListImagePipelinesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ImagePipeline> imagePipelineList() {
        Function<ListImagePipelinesResponse, Iterator> getIterator = response -> {
            if (response != null && response.imagePipelineList() != null) {
                return response.imagePipelineList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListImagePipelinesResponseFetcher
    implements SyncPageFetcher<ListImagePipelinesResponse> {
        private ListImagePipelinesResponseFetcher() {
        }

        public boolean hasNextPage(ListImagePipelinesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListImagePipelinesResponse nextPage(ListImagePipelinesResponse previousPage) {
            if (previousPage == null) {
                return ListImagePipelinesIterable.this.client.listImagePipelines(ListImagePipelinesIterable.this.firstRequest);
            }
            return ListImagePipelinesIterable.this.client.listImagePipelines((ListImagePipelinesRequest)((Object)ListImagePipelinesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

