/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderClient;
import software.amazon.awssdk.services.imagebuilder.internal.UserAgentUtils;
import software.amazon.awssdk.services.imagebuilder.model.ImageScanFindingAggregation;
import software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingAggregationsRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImageScanFindingAggregationsResponse;

public class ListImageScanFindingAggregationsIterable
implements SdkIterable<ListImageScanFindingAggregationsResponse> {
    private final ImagebuilderClient client;
    private final ListImageScanFindingAggregationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListImageScanFindingAggregationsIterable(ImagebuilderClient client, ListImageScanFindingAggregationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListImageScanFindingAggregationsResponseFetcher();
    }

    public Iterator<ListImageScanFindingAggregationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ImageScanFindingAggregation> responses() {
        Function<ListImageScanFindingAggregationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.responses() != null) {
                return response.responses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListImageScanFindingAggregationsResponseFetcher
    implements SyncPageFetcher<ListImageScanFindingAggregationsResponse> {
        private ListImageScanFindingAggregationsResponseFetcher() {
        }

        public boolean hasNextPage(ListImageScanFindingAggregationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListImageScanFindingAggregationsResponse nextPage(ListImageScanFindingAggregationsResponse previousPage) {
            if (previousPage == null) {
                return ListImageScanFindingAggregationsIterable.this.client.listImageScanFindingAggregations(ListImageScanFindingAggregationsIterable.this.firstRequest);
            }
            return ListImageScanFindingAggregationsIterable.this.client.listImageScanFindingAggregations((ListImageScanFindingAggregationsRequest)((Object)ListImageScanFindingAggregationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

