/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionResourcesImpactedSummary;
import software.amazon.awssdk.services.imagebuilder.model.LifecycleExecutionState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LifecycleExecution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LifecycleExecution> {
    private static final SdkField<String> LIFECYCLE_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lifecycleExecutionId").getter(LifecycleExecution.getter(LifecycleExecution::lifecycleExecutionId)).setter(LifecycleExecution.setter(Builder::lifecycleExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleExecutionId").build()}).build();
    private static final SdkField<String> LIFECYCLE_POLICY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lifecyclePolicyArn").getter(LifecycleExecution.getter(LifecycleExecution::lifecyclePolicyArn)).setter(LifecycleExecution.setter(Builder::lifecyclePolicyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecyclePolicyArn").build()}).build();
    private static final SdkField<LifecycleExecutionResourcesImpactedSummary> RESOURCES_IMPACTED_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resourcesImpactedSummary").getter(LifecycleExecution.getter(LifecycleExecution::resourcesImpactedSummary)).setter(LifecycleExecution.setter(Builder::resourcesImpactedSummary)).constructor(LifecycleExecutionResourcesImpactedSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourcesImpactedSummary").build()}).build();
    private static final SdkField<LifecycleExecutionState> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("state").getter(LifecycleExecution.getter(LifecycleExecution::state)).setter(LifecycleExecution.setter(Builder::state)).constructor(LifecycleExecutionState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startTime").getter(LifecycleExecution.getter(LifecycleExecution::startTime)).setter(LifecycleExecution.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(LifecycleExecution.getter(LifecycleExecution::endTime)).setter(LifecycleExecution.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_EXECUTION_ID_FIELD, LIFECYCLE_POLICY_ARN_FIELD, RESOURCES_IMPACTED_SUMMARY_FIELD, STATE_FIELD, START_TIME_FIELD, END_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String lifecycleExecutionId;
    private final String lifecyclePolicyArn;
    private final LifecycleExecutionResourcesImpactedSummary resourcesImpactedSummary;
    private final LifecycleExecutionState state;
    private final Instant startTime;
    private final Instant endTime;

    private LifecycleExecution(BuilderImpl builder) {
        this.lifecycleExecutionId = builder.lifecycleExecutionId;
        this.lifecyclePolicyArn = builder.lifecyclePolicyArn;
        this.resourcesImpactedSummary = builder.resourcesImpactedSummary;
        this.state = builder.state;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    public final String lifecycleExecutionId() {
        return this.lifecycleExecutionId;
    }

    public final String lifecyclePolicyArn() {
        return this.lifecyclePolicyArn;
    }

    public final LifecycleExecutionResourcesImpactedSummary resourcesImpactedSummary() {
        return this.resourcesImpactedSummary;
    }

    public final LifecycleExecutionState state() {
        return this.state;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecyclePolicyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourcesImpactedSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecycleExecution)) {
            return false;
        }
        LifecycleExecution other = (LifecycleExecution)obj;
        return Objects.equals(this.lifecycleExecutionId(), other.lifecycleExecutionId()) && Objects.equals(this.lifecyclePolicyArn(), other.lifecyclePolicyArn()) && Objects.equals(this.resourcesImpactedSummary(), other.resourcesImpactedSummary()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime());
    }

    public final String toString() {
        return ToString.builder((String)"LifecycleExecution").add("LifecycleExecutionId", (Object)this.lifecycleExecutionId()).add("LifecyclePolicyArn", (Object)this.lifecyclePolicyArn()).add("ResourcesImpactedSummary", (Object)this.resourcesImpactedSummary()).add("State", (Object)this.state()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lifecycleExecutionId": {
                return Optional.ofNullable(clazz.cast(this.lifecycleExecutionId()));
            }
            case "lifecyclePolicyArn": {
                return Optional.ofNullable(clazz.cast(this.lifecyclePolicyArn()));
            }
            case "resourcesImpactedSummary": {
                return Optional.ofNullable(clazz.cast(this.resourcesImpactedSummary()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LifecycleExecution, T> g) {
        return obj -> g.apply((LifecycleExecution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String lifecycleExecutionId;
        private String lifecyclePolicyArn;
        private LifecycleExecutionResourcesImpactedSummary resourcesImpactedSummary;
        private LifecycleExecutionState state;
        private Instant startTime;
        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecycleExecution model) {
            this.lifecycleExecutionId(model.lifecycleExecutionId);
            this.lifecyclePolicyArn(model.lifecyclePolicyArn);
            this.resourcesImpactedSummary(model.resourcesImpactedSummary);
            this.state(model.state);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
        }

        public final String getLifecycleExecutionId() {
            return this.lifecycleExecutionId;
        }

        public final void setLifecycleExecutionId(String lifecycleExecutionId) {
            this.lifecycleExecutionId = lifecycleExecutionId;
        }

        @Override
        public final Builder lifecycleExecutionId(String lifecycleExecutionId) {
            this.lifecycleExecutionId = lifecycleExecutionId;
            return this;
        }

        public final String getLifecyclePolicyArn() {
            return this.lifecyclePolicyArn;
        }

        public final void setLifecyclePolicyArn(String lifecyclePolicyArn) {
            this.lifecyclePolicyArn = lifecyclePolicyArn;
        }

        @Override
        public final Builder lifecyclePolicyArn(String lifecyclePolicyArn) {
            this.lifecyclePolicyArn = lifecyclePolicyArn;
            return this;
        }

        public final LifecycleExecutionResourcesImpactedSummary.Builder getResourcesImpactedSummary() {
            return this.resourcesImpactedSummary != null ? this.resourcesImpactedSummary.toBuilder() : null;
        }

        public final void setResourcesImpactedSummary(LifecycleExecutionResourcesImpactedSummary.BuilderImpl resourcesImpactedSummary) {
            this.resourcesImpactedSummary = resourcesImpactedSummary != null ? resourcesImpactedSummary.build() : null;
        }

        @Override
        public final Builder resourcesImpactedSummary(LifecycleExecutionResourcesImpactedSummary resourcesImpactedSummary) {
            this.resourcesImpactedSummary = resourcesImpactedSummary;
            return this;
        }

        public final LifecycleExecutionState.Builder getState() {
            return this.state != null ? this.state.toBuilder() : null;
        }

        public final void setState(LifecycleExecutionState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(LifecycleExecutionState state) {
            this.state = state;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public LifecycleExecution build() {
            return new LifecycleExecution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LifecycleExecution> {
        public Builder lifecycleExecutionId(String var1);

        public Builder lifecyclePolicyArn(String var1);

        public Builder resourcesImpactedSummary(LifecycleExecutionResourcesImpactedSummary var1);

        default public Builder resourcesImpactedSummary(Consumer<LifecycleExecutionResourcesImpactedSummary.Builder> resourcesImpactedSummary) {
            return this.resourcesImpactedSummary((LifecycleExecutionResourcesImpactedSummary)((LifecycleExecutionResourcesImpactedSummary.Builder)LifecycleExecutionResourcesImpactedSummary.builder().applyMutation(resourcesImpactedSummary)).build());
        }

        public Builder state(LifecycleExecutionState var1);

        default public Builder state(Consumer<LifecycleExecutionState.Builder> state) {
            return this.state((LifecycleExecutionState)((LifecycleExecutionState.Builder)LifecycleExecutionState.builder().applyMutation(state)).build());
        }

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);
    }
}

