/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.imagebuilder.model.BuildType;
import software.amazon.awssdk.services.imagebuilder.model.ContainerRecipe;
import software.amazon.awssdk.services.imagebuilder.model.DistributionConfiguration;
import software.amazon.awssdk.services.imagebuilder.model.ImageRecipe;
import software.amazon.awssdk.services.imagebuilder.model.ImageSource;
import software.amazon.awssdk.services.imagebuilder.model.ImageState;
import software.amazon.awssdk.services.imagebuilder.model.ImageTestsConfiguration;
import software.amazon.awssdk.services.imagebuilder.model.ImageType;
import software.amazon.awssdk.services.imagebuilder.model.InfrastructureConfiguration;
import software.amazon.awssdk.services.imagebuilder.model.OutputResources;
import software.amazon.awssdk.services.imagebuilder.model.Platform;
import software.amazon.awssdk.services.imagebuilder.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Image
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Image> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Image.getter(Image::arn)).setter(Image.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(Image.getter(Image::typeAsString)).setter(Image.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Image.getter(Image::name)).setter(Image.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(Image.getter(Image::version)).setter(Image.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> PLATFORM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("platform").getter(Image.getter(Image::platformAsString)).setter(Image.setter(Builder::platform)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("platform").build()}).build();
    private static final SdkField<Boolean> ENHANCED_IMAGE_METADATA_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("enhancedImageMetadataEnabled").getter(Image.getter(Image::enhancedImageMetadataEnabled)).setter(Image.setter(Builder::enhancedImageMetadataEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedImageMetadataEnabled").build()}).build();
    private static final SdkField<String> OS_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("osVersion").getter(Image.getter(Image::osVersion)).setter(Image.setter(Builder::osVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("osVersion").build()}).build();
    private static final SdkField<ImageState> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("state").getter(Image.getter(Image::state)).setter(Image.setter(Builder::state)).constructor(ImageState::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<ImageRecipe> IMAGE_RECIPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("imageRecipe").getter(Image.getter(Image::imageRecipe)).setter(Image.setter(Builder::imageRecipe)).constructor(ImageRecipe::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageRecipe").build()}).build();
    private static final SdkField<ContainerRecipe> CONTAINER_RECIPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("containerRecipe").getter(Image.getter(Image::containerRecipe)).setter(Image.setter(Builder::containerRecipe)).constructor(ContainerRecipe::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerRecipe").build()}).build();
    private static final SdkField<String> SOURCE_PIPELINE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourcePipelineName").getter(Image.getter(Image::sourcePipelineName)).setter(Image.setter(Builder::sourcePipelineName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourcePipelineName").build()}).build();
    private static final SdkField<String> SOURCE_PIPELINE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourcePipelineArn").getter(Image.getter(Image::sourcePipelineArn)).setter(Image.setter(Builder::sourcePipelineArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourcePipelineArn").build()}).build();
    private static final SdkField<InfrastructureConfiguration> INFRASTRUCTURE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("infrastructureConfiguration").getter(Image.getter(Image::infrastructureConfiguration)).setter(Image.setter(Builder::infrastructureConfiguration)).constructor(InfrastructureConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("infrastructureConfiguration").build()}).build();
    private static final SdkField<DistributionConfiguration> DISTRIBUTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("distributionConfiguration").getter(Image.getter(Image::distributionConfiguration)).setter(Image.setter(Builder::distributionConfiguration)).constructor(DistributionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("distributionConfiguration").build()}).build();
    private static final SdkField<ImageTestsConfiguration> IMAGE_TESTS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("imageTestsConfiguration").getter(Image.getter(Image::imageTestsConfiguration)).setter(Image.setter(Builder::imageTestsConfiguration)).constructor(ImageTestsConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTestsConfiguration").build()}).build();
    private static final SdkField<String> DATE_CREATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dateCreated").getter(Image.getter(Image::dateCreated)).setter(Image.setter(Builder::dateCreated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dateCreated").build()}).build();
    private static final SdkField<OutputResources> OUTPUT_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputResources").getter(Image.getter(Image::outputResources)).setter(Image.setter(Builder::outputResources)).constructor(OutputResources::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputResources").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(Image.getter(Image::tags)).setter(Image.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> BUILD_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("buildType").getter(Image.getter(Image::buildTypeAsString)).setter(Image.setter(Builder::buildType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildType").build()}).build();
    private static final SdkField<String> IMAGE_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageSource").getter(Image.getter(Image::imageSourceAsString)).setter(Image.setter(Builder::imageSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageSource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, TYPE_FIELD, NAME_FIELD, VERSION_FIELD, PLATFORM_FIELD, ENHANCED_IMAGE_METADATA_ENABLED_FIELD, OS_VERSION_FIELD, STATE_FIELD, IMAGE_RECIPE_FIELD, CONTAINER_RECIPE_FIELD, SOURCE_PIPELINE_NAME_FIELD, SOURCE_PIPELINE_ARN_FIELD, INFRASTRUCTURE_CONFIGURATION_FIELD, DISTRIBUTION_CONFIGURATION_FIELD, IMAGE_TESTS_CONFIGURATION_FIELD, DATE_CREATED_FIELD, OUTPUT_RESOURCES_FIELD, TAGS_FIELD, BUILD_TYPE_FIELD, IMAGE_SOURCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String type;
    private final String name;
    private final String version;
    private final String platform;
    private final Boolean enhancedImageMetadataEnabled;
    private final String osVersion;
    private final ImageState state;
    private final ImageRecipe imageRecipe;
    private final ContainerRecipe containerRecipe;
    private final String sourcePipelineName;
    private final String sourcePipelineArn;
    private final InfrastructureConfiguration infrastructureConfiguration;
    private final DistributionConfiguration distributionConfiguration;
    private final ImageTestsConfiguration imageTestsConfiguration;
    private final String dateCreated;
    private final OutputResources outputResources;
    private final Map<String, String> tags;
    private final String buildType;
    private final String imageSource;

    private Image(BuilderImpl builder) {
        this.arn = builder.arn;
        this.type = builder.type;
        this.name = builder.name;
        this.version = builder.version;
        this.platform = builder.platform;
        this.enhancedImageMetadataEnabled = builder.enhancedImageMetadataEnabled;
        this.osVersion = builder.osVersion;
        this.state = builder.state;
        this.imageRecipe = builder.imageRecipe;
        this.containerRecipe = builder.containerRecipe;
        this.sourcePipelineName = builder.sourcePipelineName;
        this.sourcePipelineArn = builder.sourcePipelineArn;
        this.infrastructureConfiguration = builder.infrastructureConfiguration;
        this.distributionConfiguration = builder.distributionConfiguration;
        this.imageTestsConfiguration = builder.imageTestsConfiguration;
        this.dateCreated = builder.dateCreated;
        this.outputResources = builder.outputResources;
        this.tags = builder.tags;
        this.buildType = builder.buildType;
        this.imageSource = builder.imageSource;
    }

    public final String arn() {
        return this.arn;
    }

    public final ImageType type() {
        return ImageType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String name() {
        return this.name;
    }

    public final String version() {
        return this.version;
    }

    public final Platform platform() {
        return Platform.fromValue(this.platform);
    }

    public final String platformAsString() {
        return this.platform;
    }

    public final Boolean enhancedImageMetadataEnabled() {
        return this.enhancedImageMetadataEnabled;
    }

    public final String osVersion() {
        return this.osVersion;
    }

    public final ImageState state() {
        return this.state;
    }

    public final ImageRecipe imageRecipe() {
        return this.imageRecipe;
    }

    public final ContainerRecipe containerRecipe() {
        return this.containerRecipe;
    }

    public final String sourcePipelineName() {
        return this.sourcePipelineName;
    }

    public final String sourcePipelineArn() {
        return this.sourcePipelineArn;
    }

    public final InfrastructureConfiguration infrastructureConfiguration() {
        return this.infrastructureConfiguration;
    }

    public final DistributionConfiguration distributionConfiguration() {
        return this.distributionConfiguration;
    }

    public final ImageTestsConfiguration imageTestsConfiguration() {
        return this.imageTestsConfiguration;
    }

    public final String dateCreated() {
        return this.dateCreated;
    }

    public final OutputResources outputResources() {
        return this.outputResources;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final BuildType buildType() {
        return BuildType.fromValue(this.buildType);
    }

    public final String buildTypeAsString() {
        return this.buildType;
    }

    public final ImageSource imageSource() {
        return ImageSource.fromValue(this.imageSource);
    }

    public final String imageSourceAsString() {
        return this.imageSource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enhancedImageMetadataEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.osVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageRecipe());
        hashCode = 31 * hashCode + Objects.hashCode(this.containerRecipe());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePipelineName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourcePipelineArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.infrastructureConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.distributionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageTestsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.dateCreated());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.buildTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageSourceAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Image)) {
            return false;
        }
        Image other = (Image)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.platformAsString(), other.platformAsString()) && Objects.equals(this.enhancedImageMetadataEnabled(), other.enhancedImageMetadataEnabled()) && Objects.equals(this.osVersion(), other.osVersion()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.imageRecipe(), other.imageRecipe()) && Objects.equals(this.containerRecipe(), other.containerRecipe()) && Objects.equals(this.sourcePipelineName(), other.sourcePipelineName()) && Objects.equals(this.sourcePipelineArn(), other.sourcePipelineArn()) && Objects.equals(this.infrastructureConfiguration(), other.infrastructureConfiguration()) && Objects.equals(this.distributionConfiguration(), other.distributionConfiguration()) && Objects.equals(this.imageTestsConfiguration(), other.imageTestsConfiguration()) && Objects.equals(this.dateCreated(), other.dateCreated()) && Objects.equals(this.outputResources(), other.outputResources()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.buildTypeAsString(), other.buildTypeAsString()) && Objects.equals(this.imageSourceAsString(), other.imageSourceAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Image").add("Arn", (Object)this.arn()).add("Type", (Object)this.typeAsString()).add("Name", (Object)this.name()).add("Version", (Object)this.version()).add("Platform", (Object)this.platformAsString()).add("EnhancedImageMetadataEnabled", (Object)this.enhancedImageMetadataEnabled()).add("OsVersion", (Object)this.osVersion()).add("State", (Object)this.state()).add("ImageRecipe", (Object)this.imageRecipe()).add("ContainerRecipe", (Object)this.containerRecipe()).add("SourcePipelineName", (Object)this.sourcePipelineName()).add("SourcePipelineArn", (Object)this.sourcePipelineArn()).add("InfrastructureConfiguration", (Object)this.infrastructureConfiguration()).add("DistributionConfiguration", (Object)this.distributionConfiguration()).add("ImageTestsConfiguration", (Object)this.imageTestsConfiguration()).add("DateCreated", (Object)this.dateCreated()).add("OutputResources", (Object)this.outputResources()).add("Tags", this.hasTags() ? this.tags() : null).add("BuildType", (Object)this.buildTypeAsString()).add("ImageSource", (Object)this.imageSourceAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "platform": {
                return Optional.ofNullable(clazz.cast(this.platformAsString()));
            }
            case "enhancedImageMetadataEnabled": {
                return Optional.ofNullable(clazz.cast(this.enhancedImageMetadataEnabled()));
            }
            case "osVersion": {
                return Optional.ofNullable(clazz.cast(this.osVersion()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "imageRecipe": {
                return Optional.ofNullable(clazz.cast(this.imageRecipe()));
            }
            case "containerRecipe": {
                return Optional.ofNullable(clazz.cast(this.containerRecipe()));
            }
            case "sourcePipelineName": {
                return Optional.ofNullable(clazz.cast(this.sourcePipelineName()));
            }
            case "sourcePipelineArn": {
                return Optional.ofNullable(clazz.cast(this.sourcePipelineArn()));
            }
            case "infrastructureConfiguration": {
                return Optional.ofNullable(clazz.cast(this.infrastructureConfiguration()));
            }
            case "distributionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.distributionConfiguration()));
            }
            case "imageTestsConfiguration": {
                return Optional.ofNullable(clazz.cast(this.imageTestsConfiguration()));
            }
            case "dateCreated": {
                return Optional.ofNullable(clazz.cast(this.dateCreated()));
            }
            case "outputResources": {
                return Optional.ofNullable(clazz.cast(this.outputResources()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "buildType": {
                return Optional.ofNullable(clazz.cast(this.buildTypeAsString()));
            }
            case "imageSource": {
                return Optional.ofNullable(clazz.cast(this.imageSourceAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Image, T> g) {
        return obj -> g.apply((Image)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String type;
        private String name;
        private String version;
        private String platform;
        private Boolean enhancedImageMetadataEnabled;
        private String osVersion;
        private ImageState state;
        private ImageRecipe imageRecipe;
        private ContainerRecipe containerRecipe;
        private String sourcePipelineName;
        private String sourcePipelineArn;
        private InfrastructureConfiguration infrastructureConfiguration;
        private DistributionConfiguration distributionConfiguration;
        private ImageTestsConfiguration imageTestsConfiguration;
        private String dateCreated;
        private OutputResources outputResources;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String buildType;
        private String imageSource;

        private BuilderImpl() {
        }

        private BuilderImpl(Image model) {
            this.arn(model.arn);
            this.type(model.type);
            this.name(model.name);
            this.version(model.version);
            this.platform(model.platform);
            this.enhancedImageMetadataEnabled(model.enhancedImageMetadataEnabled);
            this.osVersion(model.osVersion);
            this.state(model.state);
            this.imageRecipe(model.imageRecipe);
            this.containerRecipe(model.containerRecipe);
            this.sourcePipelineName(model.sourcePipelineName);
            this.sourcePipelineArn(model.sourcePipelineArn);
            this.infrastructureConfiguration(model.infrastructureConfiguration);
            this.distributionConfiguration(model.distributionConfiguration);
            this.imageTestsConfiguration(model.imageTestsConfiguration);
            this.dateCreated(model.dateCreated);
            this.outputResources(model.outputResources);
            this.tags(model.tags);
            this.buildType(model.buildType);
            this.imageSource(model.imageSource);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ImageType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getPlatform() {
            return this.platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(Platform platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final Boolean getEnhancedImageMetadataEnabled() {
            return this.enhancedImageMetadataEnabled;
        }

        public final void setEnhancedImageMetadataEnabled(Boolean enhancedImageMetadataEnabled) {
            this.enhancedImageMetadataEnabled = enhancedImageMetadataEnabled;
        }

        @Override
        public final Builder enhancedImageMetadataEnabled(Boolean enhancedImageMetadataEnabled) {
            this.enhancedImageMetadataEnabled = enhancedImageMetadataEnabled;
            return this;
        }

        public final String getOsVersion() {
            return this.osVersion;
        }

        public final void setOsVersion(String osVersion) {
            this.osVersion = osVersion;
        }

        @Override
        public final Builder osVersion(String osVersion) {
            this.osVersion = osVersion;
            return this;
        }

        public final ImageState.Builder getState() {
            return this.state != null ? this.state.toBuilder() : null;
        }

        public final void setState(ImageState.BuilderImpl state) {
            this.state = state != null ? state.build() : null;
        }

        @Override
        public final Builder state(ImageState state) {
            this.state = state;
            return this;
        }

        public final ImageRecipe.Builder getImageRecipe() {
            return this.imageRecipe != null ? this.imageRecipe.toBuilder() : null;
        }

        public final void setImageRecipe(ImageRecipe.BuilderImpl imageRecipe) {
            this.imageRecipe = imageRecipe != null ? imageRecipe.build() : null;
        }

        @Override
        public final Builder imageRecipe(ImageRecipe imageRecipe) {
            this.imageRecipe = imageRecipe;
            return this;
        }

        public final ContainerRecipe.Builder getContainerRecipe() {
            return this.containerRecipe != null ? this.containerRecipe.toBuilder() : null;
        }

        public final void setContainerRecipe(ContainerRecipe.BuilderImpl containerRecipe) {
            this.containerRecipe = containerRecipe != null ? containerRecipe.build() : null;
        }

        @Override
        public final Builder containerRecipe(ContainerRecipe containerRecipe) {
            this.containerRecipe = containerRecipe;
            return this;
        }

        public final String getSourcePipelineName() {
            return this.sourcePipelineName;
        }

        public final void setSourcePipelineName(String sourcePipelineName) {
            this.sourcePipelineName = sourcePipelineName;
        }

        @Override
        public final Builder sourcePipelineName(String sourcePipelineName) {
            this.sourcePipelineName = sourcePipelineName;
            return this;
        }

        public final String getSourcePipelineArn() {
            return this.sourcePipelineArn;
        }

        public final void setSourcePipelineArn(String sourcePipelineArn) {
            this.sourcePipelineArn = sourcePipelineArn;
        }

        @Override
        public final Builder sourcePipelineArn(String sourcePipelineArn) {
            this.sourcePipelineArn = sourcePipelineArn;
            return this;
        }

        public final InfrastructureConfiguration.Builder getInfrastructureConfiguration() {
            return this.infrastructureConfiguration != null ? this.infrastructureConfiguration.toBuilder() : null;
        }

        public final void setInfrastructureConfiguration(InfrastructureConfiguration.BuilderImpl infrastructureConfiguration) {
            this.infrastructureConfiguration = infrastructureConfiguration != null ? infrastructureConfiguration.build() : null;
        }

        @Override
        public final Builder infrastructureConfiguration(InfrastructureConfiguration infrastructureConfiguration) {
            this.infrastructureConfiguration = infrastructureConfiguration;
            return this;
        }

        public final DistributionConfiguration.Builder getDistributionConfiguration() {
            return this.distributionConfiguration != null ? this.distributionConfiguration.toBuilder() : null;
        }

        public final void setDistributionConfiguration(DistributionConfiguration.BuilderImpl distributionConfiguration) {
            this.distributionConfiguration = distributionConfiguration != null ? distributionConfiguration.build() : null;
        }

        @Override
        public final Builder distributionConfiguration(DistributionConfiguration distributionConfiguration) {
            this.distributionConfiguration = distributionConfiguration;
            return this;
        }

        public final ImageTestsConfiguration.Builder getImageTestsConfiguration() {
            return this.imageTestsConfiguration != null ? this.imageTestsConfiguration.toBuilder() : null;
        }

        public final void setImageTestsConfiguration(ImageTestsConfiguration.BuilderImpl imageTestsConfiguration) {
            this.imageTestsConfiguration = imageTestsConfiguration != null ? imageTestsConfiguration.build() : null;
        }

        @Override
        public final Builder imageTestsConfiguration(ImageTestsConfiguration imageTestsConfiguration) {
            this.imageTestsConfiguration = imageTestsConfiguration;
            return this;
        }

        public final String getDateCreated() {
            return this.dateCreated;
        }

        public final void setDateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
        }

        @Override
        public final Builder dateCreated(String dateCreated) {
            this.dateCreated = dateCreated;
            return this;
        }

        public final OutputResources.Builder getOutputResources() {
            return this.outputResources != null ? this.outputResources.toBuilder() : null;
        }

        public final void setOutputResources(OutputResources.BuilderImpl outputResources) {
            this.outputResources = outputResources != null ? outputResources.build() : null;
        }

        @Override
        public final Builder outputResources(OutputResources outputResources) {
            this.outputResources = outputResources;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getBuildType() {
            return this.buildType;
        }

        public final void setBuildType(String buildType) {
            this.buildType = buildType;
        }

        @Override
        public final Builder buildType(String buildType) {
            this.buildType = buildType;
            return this;
        }

        @Override
        public final Builder buildType(BuildType buildType) {
            this.buildType(buildType == null ? null : buildType.toString());
            return this;
        }

        public final String getImageSource() {
            return this.imageSource;
        }

        public final void setImageSource(String imageSource) {
            this.imageSource = imageSource;
        }

        @Override
        public final Builder imageSource(String imageSource) {
            this.imageSource = imageSource;
            return this;
        }

        @Override
        public final Builder imageSource(ImageSource imageSource) {
            this.imageSource(imageSource == null ? null : imageSource.toString());
            return this;
        }

        public Image build() {
            return new Image(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Image> {
        public Builder arn(String var1);

        public Builder type(String var1);

        public Builder type(ImageType var1);

        public Builder name(String var1);

        public Builder version(String var1);

        public Builder platform(String var1);

        public Builder platform(Platform var1);

        public Builder enhancedImageMetadataEnabled(Boolean var1);

        public Builder osVersion(String var1);

        public Builder state(ImageState var1);

        default public Builder state(Consumer<ImageState.Builder> state) {
            return this.state((ImageState)((ImageState.Builder)ImageState.builder().applyMutation(state)).build());
        }

        public Builder imageRecipe(ImageRecipe var1);

        default public Builder imageRecipe(Consumer<ImageRecipe.Builder> imageRecipe) {
            return this.imageRecipe((ImageRecipe)((ImageRecipe.Builder)ImageRecipe.builder().applyMutation(imageRecipe)).build());
        }

        public Builder containerRecipe(ContainerRecipe var1);

        default public Builder containerRecipe(Consumer<ContainerRecipe.Builder> containerRecipe) {
            return this.containerRecipe((ContainerRecipe)((ContainerRecipe.Builder)ContainerRecipe.builder().applyMutation(containerRecipe)).build());
        }

        public Builder sourcePipelineName(String var1);

        public Builder sourcePipelineArn(String var1);

        public Builder infrastructureConfiguration(InfrastructureConfiguration var1);

        default public Builder infrastructureConfiguration(Consumer<InfrastructureConfiguration.Builder> infrastructureConfiguration) {
            return this.infrastructureConfiguration((InfrastructureConfiguration)((InfrastructureConfiguration.Builder)InfrastructureConfiguration.builder().applyMutation(infrastructureConfiguration)).build());
        }

        public Builder distributionConfiguration(DistributionConfiguration var1);

        default public Builder distributionConfiguration(Consumer<DistributionConfiguration.Builder> distributionConfiguration) {
            return this.distributionConfiguration((DistributionConfiguration)((DistributionConfiguration.Builder)DistributionConfiguration.builder().applyMutation(distributionConfiguration)).build());
        }

        public Builder imageTestsConfiguration(ImageTestsConfiguration var1);

        default public Builder imageTestsConfiguration(Consumer<ImageTestsConfiguration.Builder> imageTestsConfiguration) {
            return this.imageTestsConfiguration((ImageTestsConfiguration)((ImageTestsConfiguration.Builder)ImageTestsConfiguration.builder().applyMutation(imageTestsConfiguration)).build());
        }

        public Builder dateCreated(String var1);

        public Builder outputResources(OutputResources var1);

        default public Builder outputResources(Consumer<OutputResources.Builder> outputResources) {
            return this.outputResources((OutputResources)((OutputResources.Builder)OutputResources.builder().applyMutation(outputResources)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder buildType(String var1);

        public Builder buildType(BuildType var1);

        public Builder imageSource(String var1);

        public Builder imageSource(ImageSource var1);
    }
}

