/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageTestsConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageTestsConfiguration> {
    private static final SdkField<Boolean> IMAGE_TESTS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("imageTestsEnabled").getter(ImageTestsConfiguration.getter(ImageTestsConfiguration::imageTestsEnabled)).setter(ImageTestsConfiguration.setter(Builder::imageTestsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTestsEnabled").build()}).build();
    private static final SdkField<Integer> TIMEOUT_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("timeoutMinutes").getter(ImageTestsConfiguration.getter(ImageTestsConfiguration::timeoutMinutes)).setter(ImageTestsConfiguration.setter(Builder::timeoutMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutMinutes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_TESTS_ENABLED_FIELD, TIMEOUT_MINUTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean imageTestsEnabled;
    private final Integer timeoutMinutes;

    private ImageTestsConfiguration(BuilderImpl builder) {
        this.imageTestsEnabled = builder.imageTestsEnabled;
        this.timeoutMinutes = builder.timeoutMinutes;
    }

    public final Boolean imageTestsEnabled() {
        return this.imageTestsEnabled;
    }

    public final Integer timeoutMinutes() {
        return this.timeoutMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageTestsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutMinutes());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageTestsConfiguration)) {
            return false;
        }
        ImageTestsConfiguration other = (ImageTestsConfiguration)obj;
        return Objects.equals(this.imageTestsEnabled(), other.imageTestsEnabled()) && Objects.equals(this.timeoutMinutes(), other.timeoutMinutes());
    }

    public final String toString() {
        return ToString.builder((String)"ImageTestsConfiguration").add("ImageTestsEnabled", (Object)this.imageTestsEnabled()).add("TimeoutMinutes", (Object)this.timeoutMinutes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "imageTestsEnabled": {
                return Optional.ofNullable(clazz.cast(this.imageTestsEnabled()));
            }
            case "timeoutMinutes": {
                return Optional.ofNullable(clazz.cast(this.timeoutMinutes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageTestsConfiguration, T> g) {
        return obj -> g.apply((ImageTestsConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean imageTestsEnabled;
        private Integer timeoutMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageTestsConfiguration model) {
            this.imageTestsEnabled(model.imageTestsEnabled);
            this.timeoutMinutes(model.timeoutMinutes);
        }

        public final Boolean getImageTestsEnabled() {
            return this.imageTestsEnabled;
        }

        public final void setImageTestsEnabled(Boolean imageTestsEnabled) {
            this.imageTestsEnabled = imageTestsEnabled;
        }

        @Override
        public final Builder imageTestsEnabled(Boolean imageTestsEnabled) {
            this.imageTestsEnabled = imageTestsEnabled;
            return this;
        }

        public final Integer getTimeoutMinutes() {
            return this.timeoutMinutes;
        }

        public final void setTimeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
        }

        @Override
        public final Builder timeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
            return this;
        }

        public ImageTestsConfiguration build() {
            return new ImageTestsConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageTestsConfiguration> {
        public Builder imageTestsEnabled(Boolean var1);

        public Builder timeoutMinutes(Integer var1);
    }
}

