/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.imagebuilder.model.AccountListCopier;
import software.amazon.awssdk.services.imagebuilder.model.OrganizationArnListCopier;
import software.amazon.awssdk.services.imagebuilder.model.OrganizationalUnitArnListCopier;
import software.amazon.awssdk.services.imagebuilder.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchPermissionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchPermissionConfiguration> {
    private static final SdkField<List<String>> USER_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("userIds").getter(LaunchPermissionConfiguration.getter(LaunchPermissionConfiguration::userIds)).setter(LaunchPermissionConfiguration.setter(Builder::userIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> USER_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("userGroups").getter(LaunchPermissionConfiguration.getter(LaunchPermissionConfiguration::userGroups)).setter(LaunchPermissionConfiguration.setter(Builder::userGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ORGANIZATION_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("organizationArns").getter(LaunchPermissionConfiguration.getter(LaunchPermissionConfiguration::organizationArns)).setter(LaunchPermissionConfiguration.setter(Builder::organizationArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ORGANIZATIONAL_UNIT_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("organizationalUnitArns").getter(LaunchPermissionConfiguration.getter(LaunchPermissionConfiguration::organizationalUnitArns)).setter(LaunchPermissionConfiguration.setter(Builder::organizationalUnitArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("organizationalUnitArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_IDS_FIELD, USER_GROUPS_FIELD, ORGANIZATION_ARNS_FIELD, ORGANIZATIONAL_UNIT_ARNS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> userIds;
    private final List<String> userGroups;
    private final List<String> organizationArns;
    private final List<String> organizationalUnitArns;

    private LaunchPermissionConfiguration(BuilderImpl builder) {
        this.userIds = builder.userIds;
        this.userGroups = builder.userGroups;
        this.organizationArns = builder.organizationArns;
        this.organizationalUnitArns = builder.organizationalUnitArns;
    }

    public final boolean hasUserIds() {
        return this.userIds != null && !(this.userIds instanceof SdkAutoConstructList);
    }

    public final List<String> userIds() {
        return this.userIds;
    }

    public final boolean hasUserGroups() {
        return this.userGroups != null && !(this.userGroups instanceof SdkAutoConstructList);
    }

    public final List<String> userGroups() {
        return this.userGroups;
    }

    public final boolean hasOrganizationArns() {
        return this.organizationArns != null && !(this.organizationArns instanceof SdkAutoConstructList);
    }

    public final List<String> organizationArns() {
        return this.organizationArns;
    }

    public final boolean hasOrganizationalUnitArns() {
        return this.organizationalUnitArns != null && !(this.organizationalUnitArns instanceof SdkAutoConstructList);
    }

    public final List<String> organizationalUnitArns() {
        return this.organizationalUnitArns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserIds() ? this.userIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserGroups() ? this.userGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrganizationArns() ? this.organizationArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrganizationalUnitArns() ? this.organizationalUnitArns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchPermissionConfiguration)) {
            return false;
        }
        LaunchPermissionConfiguration other = (LaunchPermissionConfiguration)obj;
        return this.hasUserIds() == other.hasUserIds() && Objects.equals(this.userIds(), other.userIds()) && this.hasUserGroups() == other.hasUserGroups() && Objects.equals(this.userGroups(), other.userGroups()) && this.hasOrganizationArns() == other.hasOrganizationArns() && Objects.equals(this.organizationArns(), other.organizationArns()) && this.hasOrganizationalUnitArns() == other.hasOrganizationalUnitArns() && Objects.equals(this.organizationalUnitArns(), other.organizationalUnitArns());
    }

    public final String toString() {
        return ToString.builder((String)"LaunchPermissionConfiguration").add("UserIds", this.hasUserIds() ? this.userIds() : null).add("UserGroups", this.hasUserGroups() ? this.userGroups() : null).add("OrganizationArns", this.hasOrganizationArns() ? this.organizationArns() : null).add("OrganizationalUnitArns", this.hasOrganizationalUnitArns() ? this.organizationalUnitArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "userIds": {
                return Optional.ofNullable(clazz.cast(this.userIds()));
            }
            case "userGroups": {
                return Optional.ofNullable(clazz.cast(this.userGroups()));
            }
            case "organizationArns": {
                return Optional.ofNullable(clazz.cast(this.organizationArns()));
            }
            case "organizationalUnitArns": {
                return Optional.ofNullable(clazz.cast(this.organizationalUnitArns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchPermissionConfiguration, T> g) {
        return obj -> g.apply((LaunchPermissionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> userIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> userGroups = DefaultSdkAutoConstructList.getInstance();
        private List<String> organizationArns = DefaultSdkAutoConstructList.getInstance();
        private List<String> organizationalUnitArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchPermissionConfiguration model) {
            this.userIds(model.userIds);
            this.userGroups(model.userGroups);
            this.organizationArns(model.organizationArns);
            this.organizationalUnitArns(model.organizationalUnitArns);
        }

        public final Collection<String> getUserIds() {
            if (this.userIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userIds;
        }

        public final void setUserIds(Collection<String> userIds) {
            this.userIds = AccountListCopier.copy(userIds);
        }

        @Override
        @Transient
        public final Builder userIds(Collection<String> userIds) {
            this.userIds = AccountListCopier.copy(userIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder userIds(String ... userIds) {
            this.userIds(Arrays.asList(userIds));
            return this;
        }

        public final Collection<String> getUserGroups() {
            if (this.userGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.userGroups;
        }

        public final void setUserGroups(Collection<String> userGroups) {
            this.userGroups = StringListCopier.copy(userGroups);
        }

        @Override
        @Transient
        public final Builder userGroups(Collection<String> userGroups) {
            this.userGroups = StringListCopier.copy(userGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder userGroups(String ... userGroups) {
            this.userGroups(Arrays.asList(userGroups));
            return this;
        }

        public final Collection<String> getOrganizationArns() {
            if (this.organizationArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.organizationArns;
        }

        public final void setOrganizationArns(Collection<String> organizationArns) {
            this.organizationArns = OrganizationArnListCopier.copy(organizationArns);
        }

        @Override
        @Transient
        public final Builder organizationArns(Collection<String> organizationArns) {
            this.organizationArns = OrganizationArnListCopier.copy(organizationArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder organizationArns(String ... organizationArns) {
            this.organizationArns(Arrays.asList(organizationArns));
            return this;
        }

        public final Collection<String> getOrganizationalUnitArns() {
            if (this.organizationalUnitArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.organizationalUnitArns;
        }

        public final void setOrganizationalUnitArns(Collection<String> organizationalUnitArns) {
            this.organizationalUnitArns = OrganizationalUnitArnListCopier.copy(organizationalUnitArns);
        }

        @Override
        @Transient
        public final Builder organizationalUnitArns(Collection<String> organizationalUnitArns) {
            this.organizationalUnitArns = OrganizationalUnitArnListCopier.copy(organizationalUnitArns);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder organizationalUnitArns(String ... organizationalUnitArns) {
            this.organizationalUnitArns(Arrays.asList(organizationalUnitArns));
            return this;
        }

        public LaunchPermissionConfiguration build() {
            return new LaunchPermissionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchPermissionConfiguration> {
        public Builder userIds(Collection<String> var1);

        public Builder userIds(String ... var1);

        public Builder userGroups(Collection<String> var1);

        public Builder userGroups(String ... var1);

        public Builder organizationArns(Collection<String> var1);

        public Builder organizationArns(String ... var1);

        public Builder organizationalUnitArns(Collection<String> var1);

        public Builder organizationalUnitArns(String ... var1);
    }
}

