/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteImageRecipeResponse
extends ImagebuilderResponse
implements ToCopyableBuilder<Builder, DeleteImageRecipeResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestId").getter(DeleteImageRecipeResponse.getter(DeleteImageRecipeResponse::requestId)).setter(DeleteImageRecipeResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()}).build();
    private static final SdkField<String> IMAGE_RECIPE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageRecipeArn").getter(DeleteImageRecipeResponse.getter(DeleteImageRecipeResponse::imageRecipeArn)).setter(DeleteImageRecipeResponse.setter(Builder::imageRecipeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageRecipeArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, IMAGE_RECIPE_ARN_FIELD));
    private final String requestIdValue;
    private final String imageRecipeArn;

    private DeleteImageRecipeResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.imageRecipeArn = builder.imageRecipeArn;
    }

    public final String requestId() {
        return this.requestIdValue;
    }

    public final String imageRecipeArn() {
        return this.imageRecipeArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageRecipeArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteImageRecipeResponse)) {
            return false;
        }
        DeleteImageRecipeResponse other = (DeleteImageRecipeResponse)((Object)obj);
        return Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.imageRecipeArn(), other.imageRecipeArn());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteImageRecipeResponse").add("RequestId", (Object)this.requestId()).add("ImageRecipeArn", (Object)this.imageRecipeArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "imageRecipeArn": {
                return Optional.ofNullable(clazz.cast(this.imageRecipeArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteImageRecipeResponse, T> g) {
        return obj -> g.apply((DeleteImageRecipeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderResponse.BuilderImpl
    implements Builder {
        private String requestIdValue;
        private String imageRecipeArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteImageRecipeResponse model) {
            super(model);
            this.requestId(model.requestIdValue);
            this.imageRecipeArn(model.imageRecipeArn);
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        public final String getImageRecipeArn() {
            return this.imageRecipeArn;
        }

        @Override
        public final Builder imageRecipeArn(String imageRecipeArn) {
            this.imageRecipeArn = imageRecipeArn;
            return this;
        }

        public final void setImageRecipeArn(String imageRecipeArn) {
            this.imageRecipeArn = imageRecipeArn;
        }

        @Override
        public DeleteImageRecipeResponse build() {
            return new DeleteImageRecipeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ImagebuilderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteImageRecipeResponse> {
        public Builder requestId(String var1);

        public Builder imageRecipeArn(String var1);
    }
}

