/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateComponentResponse
extends ImagebuilderResponse
implements ToCopyableBuilder<Builder, CreateComponentResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestId").getter(CreateComponentResponse.getter(CreateComponentResponse::requestId)).setter(CreateComponentResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateComponentResponse.getter(CreateComponentResponse::clientToken)).setter(CreateComponentResponse.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build()}).build();
    private static final SdkField<String> COMPONENT_BUILD_VERSION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("componentBuildVersionArn").getter(CreateComponentResponse.getter(CreateComponentResponse::componentBuildVersionArn)).setter(CreateComponentResponse.setter(Builder::componentBuildVersionArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentBuildVersionArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, CLIENT_TOKEN_FIELD, COMPONENT_BUILD_VERSION_ARN_FIELD));
    private final String requestIdValue;
    private final String clientToken;
    private final String componentBuildVersionArn;

    private CreateComponentResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.clientToken = builder.clientToken;
        this.componentBuildVersionArn = builder.componentBuildVersionArn;
    }

    public String requestId() {
        return this.requestIdValue;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public String componentBuildVersionArn() {
        return this.componentBuildVersionArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentBuildVersionArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateComponentResponse)) {
            return false;
        }
        CreateComponentResponse other = (CreateComponentResponse)((Object)obj);
        return Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.componentBuildVersionArn(), other.componentBuildVersionArn());
    }

    public String toString() {
        return ToString.builder((String)"CreateComponentResponse").add("RequestId", (Object)this.requestId()).add("ClientToken", (Object)this.clientToken()).add("ComponentBuildVersionArn", (Object)this.componentBuildVersionArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "componentBuildVersionArn": {
                return Optional.ofNullable(clazz.cast(this.componentBuildVersionArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateComponentResponse, T> g) {
        return obj -> g.apply((CreateComponentResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderResponse.BuilderImpl
    implements Builder {
        private String requestIdValue;
        private String clientToken;
        private String componentBuildVersionArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateComponentResponse model) {
            super(model);
            this.requestId(model.requestIdValue);
            this.clientToken(model.clientToken);
            this.componentBuildVersionArn(model.componentBuildVersionArn);
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final String getComponentBuildVersionArn() {
            return this.componentBuildVersionArn;
        }

        @Override
        public final Builder componentBuildVersionArn(String componentBuildVersionArn) {
            this.componentBuildVersionArn = componentBuildVersionArn;
            return this;
        }

        public final void setComponentBuildVersionArn(String componentBuildVersionArn) {
            this.componentBuildVersionArn = componentBuildVersionArn;
        }

        @Override
        public CreateComponentResponse build() {
            return new CreateComponentResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ImagebuilderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateComponentResponse> {
        public Builder requestId(String var1);

        public Builder clientToken(String var1);

        public Builder componentBuildVersionArn(String var1);
    }
}

