/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.imagebuilder.ImagebuilderAsyncClient;
import software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesRequest;
import software.amazon.awssdk.services.imagebuilder.model.ListImageRecipesResponse;

public class ListImageRecipesPublisher
implements SdkPublisher<ListImageRecipesResponse> {
    private final ImagebuilderAsyncClient client;
    private final ListImageRecipesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListImageRecipesPublisher(ImagebuilderAsyncClient client, ListImageRecipesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListImageRecipesPublisher(ImagebuilderAsyncClient client, ListImageRecipesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListImageRecipesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListImageRecipesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListImageRecipesResponseFetcher
    implements AsyncPageFetcher<ListImageRecipesResponse> {
        private ListImageRecipesResponseFetcher() {
        }

        public boolean hasNextPage(ListImageRecipesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListImageRecipesResponse> nextPage(ListImageRecipesResponse previousPage) {
            if (previousPage == null) {
                return ListImageRecipesPublisher.this.client.listImageRecipes(ListImageRecipesPublisher.this.firstRequest);
            }
            return ListImageRecipesPublisher.this.client.listImageRecipes((ListImageRecipesRequest)((Object)ListImageRecipesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

