/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.imagebuilder.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.imagebuilder.model.ComponentSummary;
import software.amazon.awssdk.services.imagebuilder.model.ComponentSummaryListCopier;
import software.amazon.awssdk.services.imagebuilder.model.ImagebuilderResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListComponentBuildVersionsResponse
extends ImagebuilderResponse
implements ToCopyableBuilder<Builder, ListComponentBuildVersionsResponse> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListComponentBuildVersionsResponse.getter(ListComponentBuildVersionsResponse::requestId)).setter(ListComponentBuildVersionsResponse.setter(Builder::requestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build()}).build();
    private static final SdkField<List<ComponentSummary>> COMPONENT_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListComponentBuildVersionsResponse.getter(ListComponentBuildVersionsResponse::componentSummaryList)).setter(ListComponentBuildVersionsResponse.setter(Builder::componentSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("componentSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ComponentSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListComponentBuildVersionsResponse.getter(ListComponentBuildVersionsResponse::nextToken)).setter(ListComponentBuildVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD, COMPONENT_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final String requestIdValue;
    private final List<ComponentSummary> componentSummaryList;
    private final String nextToken;

    private ListComponentBuildVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.requestIdValue = builder.requestIdValue;
        this.componentSummaryList = builder.componentSummaryList;
        this.nextToken = builder.nextToken;
    }

    public String requestId() {
        return this.requestIdValue;
    }

    public List<ComponentSummary> componentSummaryList() {
        return this.componentSummaryList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.requestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.componentSummaryList());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComponentBuildVersionsResponse)) {
            return false;
        }
        ListComponentBuildVersionsResponse other = (ListComponentBuildVersionsResponse)((Object)obj);
        return Objects.equals(this.requestId(), other.requestId()) && Objects.equals(this.componentSummaryList(), other.componentSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListComponentBuildVersionsResponse").add("RequestId", (Object)this.requestId()).add("ComponentSummaryList", this.componentSummaryList()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "requestId": {
                return Optional.ofNullable(clazz.cast(this.requestId()));
            }
            case "componentSummaryList": {
                return Optional.ofNullable(clazz.cast(this.componentSummaryList()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListComponentBuildVersionsResponse, T> g) {
        return obj -> g.apply((ListComponentBuildVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ImagebuilderResponse.BuilderImpl
    implements Builder {
        private String requestIdValue;
        private List<ComponentSummary> componentSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListComponentBuildVersionsResponse model) {
            super(model);
            this.requestId(model.requestIdValue);
            this.componentSummaryList(model.componentSummaryList);
            this.nextToken(model.nextToken);
        }

        public final String getRequestId() {
            return this.requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        public final Collection<ComponentSummary.Builder> getComponentSummaryList() {
            return this.componentSummaryList != null ? (Collection)this.componentSummaryList.stream().map(ComponentSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder componentSummaryList(Collection<ComponentSummary> componentSummaryList) {
            this.componentSummaryList = ComponentSummaryListCopier.copy(componentSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentSummaryList(ComponentSummary ... componentSummaryList) {
            this.componentSummaryList(Arrays.asList(componentSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder componentSummaryList(Consumer<ComponentSummary.Builder> ... componentSummaryList) {
            this.componentSummaryList(Stream.of(componentSummaryList).map(c -> (ComponentSummary)((ComponentSummary.Builder)ComponentSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setComponentSummaryList(Collection<ComponentSummary.BuilderImpl> componentSummaryList) {
            this.componentSummaryList = ComponentSummaryListCopier.copyFromBuilder(componentSummaryList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListComponentBuildVersionsResponse build() {
            return new ListComponentBuildVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ImagebuilderResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListComponentBuildVersionsResponse> {
        public Builder requestId(String var1);

        public Builder componentSummaryList(Collection<ComponentSummary> var1);

        public Builder componentSummaryList(ComponentSummary ... var1);

        public Builder componentSummaryList(Consumer<ComponentSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

