/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.identitystore.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates that the principal has crossed the throttling limits of the API operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThrottlingException extends IdentitystoreException implements
        ToCopyableBuilder<ThrottlingException.Builder, ThrottlingException> {
    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(ThrottlingException::requestIdValue)).setter(setter(Builder::requestIdValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Integer> RETRY_AFTER_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RetryAfterSeconds").getter(getter(ThrottlingException::retryAfterSeconds))
            .setter(setter(Builder::retryAfterSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryAfterSeconds").build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(ThrottlingException::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUEST_ID_FIELD,
            RETRY_AFTER_SECONDS_FIELD, REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String requestId;

    private final Integer retryAfterSeconds;

    private final String reason;

    private ThrottlingException(BuilderImpl builder) {
        super(builder);
        this.requestId = builder.requestId;
        this.retryAfterSeconds = builder.retryAfterSeconds;
        this.reason = builder.reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The identifier for each request. This value is a globally unique ID that is generated by the identity store
     * service for each sent request, and is then returned inside the exception if the request fails.
     * </p>
     * 
     * @return The identifier for each request. This value is a globally unique ID that is generated by the identity
     *         store service for each sent request, and is then returned inside the exception if the request fails.
     */
    public String requestIdValue() {
        return requestId;
    }

    /**
     * <p>
     * The number of seconds to wait before retrying the next request.
     * </p>
     * 
     * @return The number of seconds to wait before retrying the next request.
     */
    public Integer retryAfterSeconds() {
        return retryAfterSeconds;
    }

    /**
     * <p>
     * Indicates the reason for the throttling error when the service is unable to access a Customer Managed KMS key.
     * For non-KMS permission errors, this field is not included.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link ThrottlingExceptionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonAsString}.
     * </p>
     * 
     * @return Indicates the reason for the throttling error when the service is unable to access a Customer Managed KMS
     *         key. For non-KMS permission errors, this field is not included.
     * @see ThrottlingExceptionReason
     */
    public ThrottlingExceptionReason reason() {
        return ThrottlingExceptionReason.fromValue(reason);
    }

    /**
     * <p>
     * Indicates the reason for the throttling error when the service is unable to access a Customer Managed KMS key.
     * For non-KMS permission errors, this field is not included.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link ThrottlingExceptionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonAsString}.
     * </p>
     * 
     * @return Indicates the reason for the throttling error when the service is unable to access a Customer Managed KMS
     *         key. For non-KMS permission errors, this field is not included.
     * @see ThrottlingExceptionReason
     */
    public String reasonAsString() {
        return reason;
    }

    @Override
    public boolean isRetryableException() {
        return true;
    }

    @Override
    public boolean isThrottlingException() {
        return true;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RequestId", REQUEST_ID_FIELD);
        map.put("RetryAfterSeconds", RETRY_AFTER_SECONDS_FIELD);
        map.put("Reason", REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ThrottlingException, T> g) {
        return obj -> g.apply((ThrottlingException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThrottlingException>, IdentitystoreException.Builder {
        /**
         * <p>
         * The identifier for each request. This value is a globally unique ID that is generated by the identity store
         * service for each sent request, and is then returned inside the exception if the request fails.
         * </p>
         * 
         * @param requestId
         *        The identifier for each request. This value is a globally unique ID that is generated by the identity
         *        store service for each sent request, and is then returned inside the exception if the request fails.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestIdValue(String requestId);

        /**
         * <p>
         * The number of seconds to wait before retrying the next request.
         * </p>
         * 
         * @param retryAfterSeconds
         *        The number of seconds to wait before retrying the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retryAfterSeconds(Integer retryAfterSeconds);

        /**
         * <p>
         * Indicates the reason for the throttling error when the service is unable to access a Customer Managed KMS
         * key. For non-KMS permission errors, this field is not included.
         * </p>
         * 
         * @param reason
         *        Indicates the reason for the throttling error when the service is unable to access a Customer Managed
         *        KMS key. For non-KMS permission errors, this field is not included.
         * @see ThrottlingExceptionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThrottlingExceptionReason
         */
        Builder reason(String reason);

        /**
         * <p>
         * Indicates the reason for the throttling error when the service is unable to access a Customer Managed KMS
         * key. For non-KMS permission errors, this field is not included.
         * </p>
         * 
         * @param reason
         *        Indicates the reason for the throttling error when the service is unable to access a Customer Managed
         *        KMS key. For non-KMS permission errors, this field is not included.
         * @see ThrottlingExceptionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThrottlingExceptionReason
         */
        Builder reason(ThrottlingExceptionReason reason);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);

        @Override
        Builder numAttempts(Integer numAttempts);
    }

    static final class BuilderImpl extends IdentitystoreException.BuilderImpl implements Builder {
        private String requestId;

        private Integer retryAfterSeconds;

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(ThrottlingException model) {
            super(model);
            requestIdValue(model.requestId);
            retryAfterSeconds(model.retryAfterSeconds);
            reason(model.reason);
        }

        public final String getRequestIdValue() {
            return requestId;
        }

        public final void setRequestIdValue(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestIdValue(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getRetryAfterSeconds() {
            return retryAfterSeconds;
        }

        public final void setRetryAfterSeconds(Integer retryAfterSeconds) {
            this.retryAfterSeconds = retryAfterSeconds;
        }

        @Override
        public final Builder retryAfterSeconds(Integer retryAfterSeconds) {
            this.retryAfterSeconds = retryAfterSeconds;
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(ThrottlingExceptionReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public BuilderImpl numAttempts(Integer numAttempts) {
            this.numAttempts = numAttempts;
            return this;
        }

        @Override
        public ThrottlingException build() {
            return new ThrottlingException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
