/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.identitystore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a user's photo. Users can have up to 3 photos, with one designated as primary. Supports
 * common image formats, including jpg, jpeg, png, and gif.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Photo implements SdkPojo, Serializable, ToCopyableBuilder<Photo.Builder, Photo> {
    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(Photo::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Photo::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> DISPLAY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Display")
            .getter(getter(Photo::display)).setter(setter(Builder::display))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Display").build()).build();

    private static final SdkField<Boolean> PRIMARY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Primary").getter(getter(Photo::primary)).setter(setter(Builder::primary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Primary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, TYPE_FIELD,
            DISPLAY_FIELD, PRIMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String value;

    private final String type;

    private final String display;

    private final Boolean primary;

    private Photo(BuilderImpl builder) {
        this.value = builder.value;
        this.type = builder.type;
        this.display = builder.display;
        this.primary = builder.primary;
    }

    /**
     * <p>
     * The photo data or URL. Supported formats include jpg, jpeg, png, and gif. This field is required for all photo
     * entries.
     * </p>
     * 
     * @return The photo data or URL. Supported formats include jpg, jpeg, png, and gif. This field is required for all
     *         photo entries.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * The type of photo. This field is optional and can be used to categorize different types of photos.
     * </p>
     * 
     * @return The type of photo. This field is optional and can be used to categorize different types of photos.
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * A human-readable description of the photo for display purposes. This optional field provides context about the
     * photo.
     * </p>
     * 
     * @return A human-readable description of the photo for display purposes. This optional field provides context
     *         about the photo.
     */
    public final String display() {
        return display;
    }

    /**
     * <p>
     * Specifies whether this is the user's primary photo. Default value is <code>false</code>. Only one photo can be
     * designated as primary per user.
     * </p>
     * 
     * @return Specifies whether this is the user's primary photo. Default value is <code>false</code>. Only one photo
     *         can be designated as primary per user.
     */
    public final Boolean primary() {
        return primary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(display());
        hashCode = 31 * hashCode + Objects.hashCode(primary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Photo)) {
            return false;
        }
        Photo other = (Photo) obj;
        return Objects.equals(value(), other.value()) && Objects.equals(type(), other.type())
                && Objects.equals(display(), other.display()) && Objects.equals(primary(), other.primary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Photo").add("Value", value() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Type", type() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Display", display() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Primary", primary() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "Display":
            return Optional.ofNullable(clazz.cast(display()));
        case "Primary":
            return Optional.ofNullable(clazz.cast(primary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Value", VALUE_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Display", DISPLAY_FIELD);
        map.put("Primary", PRIMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Photo, T> g) {
        return obj -> g.apply((Photo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Photo> {
        /**
         * <p>
         * The photo data or URL. Supported formats include jpg, jpeg, png, and gif. This field is required for all
         * photo entries.
         * </p>
         * 
         * @param value
         *        The photo data or URL. Supported formats include jpg, jpeg, png, and gif. This field is required for
         *        all photo entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The type of photo. This field is optional and can be used to categorize different types of photos.
         * </p>
         * 
         * @param type
         *        The type of photo. This field is optional and can be used to categorize different types of photos.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * A human-readable description of the photo for display purposes. This optional field provides context about
         * the photo.
         * </p>
         * 
         * @param display
         *        A human-readable description of the photo for display purposes. This optional field provides context
         *        about the photo.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder display(String display);

        /**
         * <p>
         * Specifies whether this is the user's primary photo. Default value is <code>false</code>. Only one photo can
         * be designated as primary per user.
         * </p>
         * 
         * @param primary
         *        Specifies whether this is the user's primary photo. Default value is <code>false</code>. Only one
         *        photo can be designated as primary per user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primary(Boolean primary);
    }

    static final class BuilderImpl implements Builder {
        private String value;

        private String type;

        private String display;

        private Boolean primary;

        private BuilderImpl() {
        }

        private BuilderImpl(Photo model) {
            value(model.value);
            type(model.type);
            display(model.display);
            primary(model.primary);
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final String getDisplay() {
            return display;
        }

        public final void setDisplay(String display) {
            this.display = display;
        }

        @Override
        public final Builder display(String display) {
            this.display = display;
            return this;
        }

        public final Boolean getPrimary() {
            return primary;
        }

        public final void setPrimary(Boolean primary) {
            this.primary = primary;
        }

        @Override
        public final Builder primary(Boolean primary) {
            this.primary = primary;
            return this;
        }

        @Override
        public Photo build() {
            return new Photo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
