/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.identitystore.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The address associated with the specified user.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Address implements SdkPojo, Serializable, ToCopyableBuilder<Address.Builder, Address> {
    private static final SdkField<String> STREET_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreetAddress").getter(getter(Address::streetAddress)).setter(setter(Builder::streetAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreetAddress").build()).build();

    private static final SdkField<String> LOCALITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Locality").getter(getter(Address::locality)).setter(setter(Builder::locality))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locality").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(Address::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> POSTAL_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PostalCode").getter(getter(Address::postalCode)).setter(setter(Builder::postalCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostalCode").build()).build();

    private static final SdkField<String> COUNTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Country")
            .getter(getter(Address::country)).setter(setter(Builder::country))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Country").build()).build();

    private static final SdkField<String> FORMATTED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Formatted").getter(getter(Address::formatted)).setter(setter(Builder::formatted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Formatted").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(Address::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<Boolean> PRIMARY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Primary").getter(getter(Address::primary)).setter(setter(Builder::primary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Primary").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STREET_ADDRESS_FIELD,
            LOCALITY_FIELD, REGION_FIELD, POSTAL_CODE_FIELD, COUNTRY_FIELD, FORMATTED_FIELD, TYPE_FIELD, PRIMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String streetAddress;

    private final String locality;

    private final String region;

    private final String postalCode;

    private final String country;

    private final String formatted;

    private final String type;

    private final Boolean primary;

    private Address(BuilderImpl builder) {
        this.streetAddress = builder.streetAddress;
        this.locality = builder.locality;
        this.region = builder.region;
        this.postalCode = builder.postalCode;
        this.country = builder.country;
        this.formatted = builder.formatted;
        this.type = builder.type;
        this.primary = builder.primary;
    }

    /**
     * <p>
     * The street of the address.
     * </p>
     * 
     * @return The street of the address.
     */
    public final String streetAddress() {
        return streetAddress;
    }

    /**
     * <p>
     * A string of the address locality.
     * </p>
     * 
     * @return A string of the address locality.
     */
    public final String locality() {
        return locality;
    }

    /**
     * <p>
     * The region of the address.
     * </p>
     * 
     * @return The region of the address.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The postal code of the address.
     * </p>
     * 
     * @return The postal code of the address.
     */
    public final String postalCode() {
        return postalCode;
    }

    /**
     * <p>
     * The country of the address.
     * </p>
     * 
     * @return The country of the address.
     */
    public final String country() {
        return country;
    }

    /**
     * <p>
     * A string containing a formatted version of the address for display.
     * </p>
     * 
     * @return A string containing a formatted version of the address for display.
     */
    public final String formatted() {
        return formatted;
    }

    /**
     * <p>
     * A string representing the type of address. For example, "Home."
     * </p>
     * 
     * @return A string representing the type of address. For example, "Home."
     */
    public final String type() {
        return type;
    }

    /**
     * <p>
     * A Boolean value representing whether this is the primary address for the associated resource.
     * </p>
     * 
     * @return A Boolean value representing whether this is the primary address for the associated resource.
     */
    public final Boolean primary() {
        return primary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(streetAddress());
        hashCode = 31 * hashCode + Objects.hashCode(locality());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(postalCode());
        hashCode = 31 * hashCode + Objects.hashCode(country());
        hashCode = 31 * hashCode + Objects.hashCode(formatted());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(primary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Address)) {
            return false;
        }
        Address other = (Address) obj;
        return Objects.equals(streetAddress(), other.streetAddress()) && Objects.equals(locality(), other.locality())
                && Objects.equals(region(), other.region()) && Objects.equals(postalCode(), other.postalCode())
                && Objects.equals(country(), other.country()) && Objects.equals(formatted(), other.formatted())
                && Objects.equals(type(), other.type()) && Objects.equals(primary(), other.primary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Address")
                .add("StreetAddress", streetAddress() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Locality", locality() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Region", region() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PostalCode", postalCode() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Country", country() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Formatted", formatted() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Type", type() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Primary", primary() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StreetAddress":
            return Optional.ofNullable(clazz.cast(streetAddress()));
        case "Locality":
            return Optional.ofNullable(clazz.cast(locality()));
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "PostalCode":
            return Optional.ofNullable(clazz.cast(postalCode()));
        case "Country":
            return Optional.ofNullable(clazz.cast(country()));
        case "Formatted":
            return Optional.ofNullable(clazz.cast(formatted()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        case "Primary":
            return Optional.ofNullable(clazz.cast(primary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StreetAddress", STREET_ADDRESS_FIELD);
        map.put("Locality", LOCALITY_FIELD);
        map.put("Region", REGION_FIELD);
        map.put("PostalCode", POSTAL_CODE_FIELD);
        map.put("Country", COUNTRY_FIELD);
        map.put("Formatted", FORMATTED_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Primary", PRIMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Address, T> g) {
        return obj -> g.apply((Address) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Address> {
        /**
         * <p>
         * The street of the address.
         * </p>
         * 
         * @param streetAddress
         *        The street of the address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streetAddress(String streetAddress);

        /**
         * <p>
         * A string of the address locality.
         * </p>
         * 
         * @param locality
         *        A string of the address locality.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder locality(String locality);

        /**
         * <p>
         * The region of the address.
         * </p>
         * 
         * @param region
         *        The region of the address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The postal code of the address.
         * </p>
         * 
         * @param postalCode
         *        The postal code of the address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postalCode(String postalCode);

        /**
         * <p>
         * The country of the address.
         * </p>
         * 
         * @param country
         *        The country of the address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder country(String country);

        /**
         * <p>
         * A string containing a formatted version of the address for display.
         * </p>
         * 
         * @param formatted
         *        A string containing a formatted version of the address for display.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formatted(String formatted);

        /**
         * <p>
         * A string representing the type of address. For example, "Home."
         * </p>
         * 
         * @param type
         *        A string representing the type of address. For example, "Home."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * A Boolean value representing whether this is the primary address for the associated resource.
         * </p>
         * 
         * @param primary
         *        A Boolean value representing whether this is the primary address for the associated resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primary(Boolean primary);
    }

    static final class BuilderImpl implements Builder {
        private String streetAddress;

        private String locality;

        private String region;

        private String postalCode;

        private String country;

        private String formatted;

        private String type;

        private Boolean primary;

        private BuilderImpl() {
        }

        private BuilderImpl(Address model) {
            streetAddress(model.streetAddress);
            locality(model.locality);
            region(model.region);
            postalCode(model.postalCode);
            country(model.country);
            formatted(model.formatted);
            type(model.type);
            primary(model.primary);
        }

        public final String getStreetAddress() {
            return streetAddress;
        }

        public final void setStreetAddress(String streetAddress) {
            this.streetAddress = streetAddress;
        }

        @Override
        public final Builder streetAddress(String streetAddress) {
            this.streetAddress = streetAddress;
            return this;
        }

        public final String getLocality() {
            return locality;
        }

        public final void setLocality(String locality) {
            this.locality = locality;
        }

        @Override
        public final Builder locality(String locality) {
            this.locality = locality;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getPostalCode() {
            return postalCode;
        }

        public final void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        @Override
        public final Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public final String getCountry() {
            return country;
        }

        public final void setCountry(String country) {
            this.country = country;
        }

        @Override
        public final Builder country(String country) {
            this.country = country;
            return this;
        }

        public final String getFormatted() {
            return formatted;
        }

        public final void setFormatted(String formatted) {
            this.formatted = formatted;
        }

        @Override
        public final Builder formatted(String formatted) {
            this.formatted = formatted;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Boolean getPrimary() {
            return primary;
        }

        public final void setPrimary(Boolean primary) {
            this.primary = primary;
        }

        @Override
        public final Builder primary(Boolean primary) {
            this.primary = primary;
            return this;
        }

        @Override
        public Address build() {
            return new Address(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
