/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.services.iam.model._clientIDListTypeCopier;
import software.amazon.awssdk.services.iam.model._thumbprintListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetOpenIdConnectProviderResponse
extends IamResponse
implements ToCopyableBuilder<Builder, GetOpenIdConnectProviderResponse> {
    private static final SdkField<String> URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetOpenIdConnectProviderResponse.getter(GetOpenIdConnectProviderResponse::url)).setter(GetOpenIdConnectProviderResponse.setter(Builder::url)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()}).build();
    private static final SdkField<List<String>> CLIENT_ID_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetOpenIdConnectProviderResponse.getter(GetOpenIdConnectProviderResponse::clientIDList)).setter(GetOpenIdConnectProviderResponse.setter(Builder::clientIDList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientIDList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> THUMBPRINT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetOpenIdConnectProviderResponse.getter(GetOpenIdConnectProviderResponse::thumbprintList)).setter(GetOpenIdConnectProviderResponse.setter(Builder::thumbprintList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThumbprintList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(GetOpenIdConnectProviderResponse.getter(GetOpenIdConnectProviderResponse::createDate)).setter(GetOpenIdConnectProviderResponse.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD, CLIENT_ID_LIST_FIELD, THUMBPRINT_LIST_FIELD, CREATE_DATE_FIELD));
    private final String url;
    private final List<String> clientIDList;
    private final List<String> thumbprintList;
    private final Instant createDate;

    private GetOpenIdConnectProviderResponse(BuilderImpl builder) {
        super(builder);
        this.url = builder.url;
        this.clientIDList = builder.clientIDList;
        this.thumbprintList = builder.thumbprintList;
        this.createDate = builder.createDate;
    }

    public String url() {
        return this.url;
    }

    public List<String> clientIDList() {
        return this.clientIDList;
    }

    public List<String> thumbprintList() {
        return this.thumbprintList;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.url());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientIDList());
        hashCode = 31 * hashCode + Objects.hashCode(this.thumbprintList());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOpenIdConnectProviderResponse)) {
            return false;
        }
        GetOpenIdConnectProviderResponse other = (GetOpenIdConnectProviderResponse)((Object)obj);
        return Objects.equals(this.url(), other.url()) && Objects.equals(this.clientIDList(), other.clientIDList()) && Objects.equals(this.thumbprintList(), other.thumbprintList()) && Objects.equals(this.createDate(), other.createDate());
    }

    public String toString() {
        return ToString.builder((String)"GetOpenIdConnectProviderResponse").add("Url", (Object)this.url()).add("ClientIDList", this.clientIDList()).add("ThumbprintList", this.thumbprintList()).add("CreateDate", (Object)this.createDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Url": {
                return Optional.ofNullable(clazz.cast(this.url()));
            }
            case "ClientIDList": {
                return Optional.ofNullable(clazz.cast(this.clientIDList()));
            }
            case "ThumbprintList": {
                return Optional.ofNullable(clazz.cast(this.thumbprintList()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetOpenIdConnectProviderResponse, T> g) {
        return obj -> g.apply((GetOpenIdConnectProviderResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private String url;
        private List<String> clientIDList = DefaultSdkAutoConstructList.getInstance();
        private List<String> thumbprintList = DefaultSdkAutoConstructList.getInstance();
        private Instant createDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOpenIdConnectProviderResponse model) {
            super(model);
            this.url(model.url);
            this.clientIDList(model.clientIDList);
            this.thumbprintList(model.thumbprintList);
            this.createDate(model.createDate);
        }

        public final String getUrl() {
            return this.url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final Collection<String> getClientIDList() {
            return this.clientIDList;
        }

        @Override
        public final Builder clientIDList(Collection<String> clientIDList) {
            this.clientIDList = _clientIDListTypeCopier.copy(clientIDList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientIDList(String ... clientIDList) {
            this.clientIDList(Arrays.asList(clientIDList));
            return this;
        }

        public final void setClientIDList(Collection<String> clientIDList) {
            this.clientIDList = _clientIDListTypeCopier.copy(clientIDList);
        }

        public final Collection<String> getThumbprintList() {
            return this.thumbprintList;
        }

        @Override
        public final Builder thumbprintList(Collection<String> thumbprintList) {
            this.thumbprintList = _thumbprintListTypeCopier.copy(thumbprintList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thumbprintList(String ... thumbprintList) {
            this.thumbprintList(Arrays.asList(thumbprintList));
            return this;
        }

        public final void setThumbprintList(Collection<String> thumbprintList) {
            this.thumbprintList = _thumbprintListTypeCopier.copy(thumbprintList);
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        public GetOpenIdConnectProviderResponse build() {
            return new GetOpenIdConnectProviderResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetOpenIdConnectProviderResponse> {
        public Builder url(String var1);

        public Builder clientIDList(Collection<String> var1);

        public Builder clientIDList(String ... var1);

        public Builder thumbprintList(Collection<String> var1);

        public Builder thumbprintList(String ... var1);

        public Builder createDate(Instant var1);
    }
}

