/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.ListMfaDeviceTagsRequest;
import software.amazon.awssdk.services.iam.model.ListMfaDeviceTagsResponse;
import software.amazon.awssdk.services.iam.model.Tag;

public class ListMFADeviceTagsPublisher
implements SdkPublisher<ListMfaDeviceTagsResponse> {
    private final IamAsyncClient client;
    private final ListMfaDeviceTagsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMFADeviceTagsPublisher(IamAsyncClient client, ListMfaDeviceTagsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMFADeviceTagsPublisher(IamAsyncClient client, ListMfaDeviceTagsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMfaDeviceTagsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMfaDeviceTagsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Tag> tags() {
        return this.flatMapIterable(response -> response.tags());
    }

    private class ListMfaDeviceTagsResponseFetcher
    implements AsyncPageFetcher<ListMfaDeviceTagsResponse> {
        private ListMfaDeviceTagsResponseFetcher() {
        }

        public boolean hasNextPage(ListMfaDeviceTagsResponse previousPage) {
            return previousPage.isTruncated() != null && previousPage.isTruncated() != false;
        }

        public CompletableFuture<ListMfaDeviceTagsResponse> nextPage(ListMfaDeviceTagsResponse previousPage) {
            if (previousPage == null) {
                return ListMFADeviceTagsPublisher.this.client.listMFADeviceTags(ListMFADeviceTagsPublisher.this.firstRequest);
            }
            return ListMFADeviceTagsPublisher.this.client.listMFADeviceTags((ListMfaDeviceTagsRequest)((Object)ListMFADeviceTagsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

