/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.services.iam.model.SummaryStateType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetHumanReadableSummaryResponse
extends IamResponse
implements ToCopyableBuilder<Builder, GetHumanReadableSummaryResponse> {
    private static final SdkField<String> SUMMARY_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SummaryContent").getter(GetHumanReadableSummaryResponse.getter(GetHumanReadableSummaryResponse::summaryContent)).setter(GetHumanReadableSummaryResponse.setter(Builder::summaryContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SummaryContent").build()}).build();
    private static final SdkField<String> LOCALE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Locale").getter(GetHumanReadableSummaryResponse.getter(GetHumanReadableSummaryResponse::locale)).setter(GetHumanReadableSummaryResponse.setter(Builder::locale)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Locale").build()}).build();
    private static final SdkField<String> SUMMARY_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SummaryState").getter(GetHumanReadableSummaryResponse.getter(GetHumanReadableSummaryResponse::summaryStateAsString)).setter(GetHumanReadableSummaryResponse.setter(Builder::summaryState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SummaryState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUMMARY_CONTENT_FIELD, LOCALE_FIELD, SUMMARY_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetHumanReadableSummaryResponse.memberNameToFieldInitializer();
    private final String summaryContent;
    private final String locale;
    private final String summaryState;

    private GetHumanReadableSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.summaryContent = builder.summaryContent;
        this.locale = builder.locale;
        this.summaryState = builder.summaryState;
    }

    public final String summaryContent() {
        return this.summaryContent;
    }

    public final String locale() {
        return this.locale;
    }

    public final SummaryStateType summaryState() {
        return SummaryStateType.fromValue(this.summaryState);
    }

    public final String summaryStateAsString() {
        return this.summaryState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.summaryContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.locale());
        hashCode = 31 * hashCode + Objects.hashCode(this.summaryStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHumanReadableSummaryResponse)) {
            return false;
        }
        GetHumanReadableSummaryResponse other = (GetHumanReadableSummaryResponse)((Object)obj);
        return Objects.equals(this.summaryContent(), other.summaryContent()) && Objects.equals(this.locale(), other.locale()) && Objects.equals(this.summaryStateAsString(), other.summaryStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetHumanReadableSummaryResponse").add("SummaryContent", (Object)this.summaryContent()).add("Locale", (Object)this.locale()).add("SummaryState", (Object)this.summaryStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SummaryContent": {
                return Optional.ofNullable(clazz.cast(this.summaryContent()));
            }
            case "Locale": {
                return Optional.ofNullable(clazz.cast(this.locale()));
            }
            case "SummaryState": {
                return Optional.ofNullable(clazz.cast(this.summaryStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("SummaryContent", SUMMARY_CONTENT_FIELD);
        map.put("Locale", LOCALE_FIELD);
        map.put("SummaryState", SUMMARY_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetHumanReadableSummaryResponse, T> g) {
        return obj -> g.apply((GetHumanReadableSummaryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private String summaryContent;
        private String locale;
        private String summaryState;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHumanReadableSummaryResponse model) {
            super(model);
            this.summaryContent(model.summaryContent);
            this.locale(model.locale);
            this.summaryState(model.summaryState);
        }

        public final String getSummaryContent() {
            return this.summaryContent;
        }

        public final void setSummaryContent(String summaryContent) {
            this.summaryContent = summaryContent;
        }

        @Override
        public final Builder summaryContent(String summaryContent) {
            this.summaryContent = summaryContent;
            return this;
        }

        public final String getLocale() {
            return this.locale;
        }

        public final void setLocale(String locale) {
            this.locale = locale;
        }

        @Override
        public final Builder locale(String locale) {
            this.locale = locale;
            return this;
        }

        public final String getSummaryState() {
            return this.summaryState;
        }

        public final void setSummaryState(String summaryState) {
            this.summaryState = summaryState;
        }

        @Override
        public final Builder summaryState(String summaryState) {
            this.summaryState = summaryState;
            return this;
        }

        @Override
        public final Builder summaryState(SummaryStateType summaryState) {
            this.summaryState(summaryState == null ? null : summaryState.toString());
            return this;
        }

        @Override
        public GetHumanReadableSummaryResponse build() {
            return new GetHumanReadableSummaryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetHumanReadableSummaryResponse> {
        public Builder summaryContent(String var1);

        public Builder locale(String var1);

        public Builder summaryState(String var1);

        public Builder summaryState(SummaryStateType var1);
    }
}

