/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.ListMfaDevicesRequest;
import software.amazon.awssdk.services.iam.model.ListMfaDevicesResponse;
import software.amazon.awssdk.services.iam.model.MFADevice;

public class ListMFADevicesPublisher
implements SdkPublisher<ListMfaDevicesResponse> {
    private final IamAsyncClient client;
    private final ListMfaDevicesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMFADevicesPublisher(IamAsyncClient client, ListMfaDevicesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMFADevicesPublisher(IamAsyncClient client, ListMfaDevicesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMfaDevicesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMfaDevicesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MFADevice> mfaDevices() {
        return this.flatMapIterable(response -> response.mfaDevices());
    }

    private class ListMfaDevicesResponseFetcher
    implements AsyncPageFetcher<ListMfaDevicesResponse> {
        private ListMfaDevicesResponseFetcher() {
        }

        public boolean hasNextPage(ListMfaDevicesResponse previousPage) {
            return previousPage.isTruncated() != null && previousPage.isTruncated() != false;
        }

        public CompletableFuture<ListMfaDevicesResponse> nextPage(ListMfaDevicesResponse previousPage) {
            if (previousPage == null) {
                return ListMFADevicesPublisher.this.client.listMFADevices(ListMFADevicesPublisher.this.firstRequest);
            }
            return ListMFADevicesPublisher.this.client.listMFADevices((ListMfaDevicesRequest)((Object)ListMFADevicesPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

