/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.AccessKeyMetadata;
import software.amazon.awssdk.services.iam.model.ListAccessKeysRequest;
import software.amazon.awssdk.services.iam.model.ListAccessKeysResponse;

public class ListAccessKeysPublisher
implements SdkPublisher<ListAccessKeysResponse> {
    private final IamAsyncClient client;
    private final ListAccessKeysRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccessKeysPublisher(IamAsyncClient client, ListAccessKeysRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccessKeysPublisher(IamAsyncClient client, ListAccessKeysRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccessKeysResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAccessKeysResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AccessKeyMetadata> accessKeyMetadata() {
        return this.flatMapIterable(response -> response.accessKeyMetadata());
    }

    private class ListAccessKeysResponseFetcher
    implements AsyncPageFetcher<ListAccessKeysResponse> {
        private ListAccessKeysResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessKeysResponse previousPage) {
            return previousPage.isTruncated() != null && previousPage.isTruncated() != false;
        }

        public CompletableFuture<ListAccessKeysResponse> nextPage(ListAccessKeysResponse previousPage) {
            if (previousPage == null) {
                return ListAccessKeysPublisher.this.client.listAccessKeys(ListAccessKeysPublisher.this.firstRequest);
            }
            return ListAccessKeysPublisher.this.client.listAccessKeys((ListAccessKeysRequest)((Object)ListAccessKeysPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

