/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.auth.scheme;

import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeProvider;
import software.amazon.awssdk.services.iam.auth.scheme.IamAuthSchemeParams;
import software.amazon.awssdk.services.iam.auth.scheme.internal.DefaultIamAuthSchemeProvider;
import software.amazon.awssdk.services.iam.auth.scheme.internal.PreferredIamAuthSchemeProvider;

@SdkPublicApi
public interface IamAuthSchemeProvider
extends AuthSchemeProvider {
    public List<AuthSchemeOption> resolveAuthScheme(IamAuthSchemeParams var1);

    default public List<AuthSchemeOption> resolveAuthScheme(Consumer<IamAuthSchemeParams.Builder> consumer) {
        IamAuthSchemeParams.Builder builder = IamAuthSchemeParams.builder();
        consumer.accept(builder);
        return this.resolveAuthScheme(builder.build());
    }

    public static IamAuthSchemeProvider defaultProvider() {
        return DefaultIamAuthSchemeProvider.create();
    }

    public static IamAuthSchemeProvider defaultProvider(List<String> authSchemePreference) {
        return new PreferredIamAuthSchemeProvider(IamAuthSchemeProvider.defaultProvider(), authSchemePreference);
    }
}

