/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.iam.model.ContextKeyNamesResultListTypeCopier;
import software.amazon.awssdk.services.iam.model.EvalDecisionDetailsTypeCopier;
import software.amazon.awssdk.services.iam.model.PolicyEvaluationDecisionType;
import software.amazon.awssdk.services.iam.model.Statement;
import software.amazon.awssdk.services.iam.model.StatementListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceSpecificResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceSpecificResult> {
    private static final SdkField<String> EVAL_RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResourceSpecificResult.getter(ResourceSpecificResult::evalResourceName)).setter(ResourceSpecificResult.setter(Builder::evalResourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvalResourceName").build()}).build();
    private static final SdkField<String> EVAL_RESOURCE_DECISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ResourceSpecificResult.getter(ResourceSpecificResult::evalResourceDecisionAsString)).setter(ResourceSpecificResult.setter(Builder::evalResourceDecision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvalResourceDecision").build()}).build();
    private static final SdkField<List<Statement>> MATCHED_STATEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ResourceSpecificResult.getter(ResourceSpecificResult::matchedStatements)).setter(ResourceSpecificResult.setter(Builder::matchedStatements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MatchedStatements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Statement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> MISSING_CONTEXT_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ResourceSpecificResult.getter(ResourceSpecificResult::missingContextValues)).setter(ResourceSpecificResult.setter(Builder::missingContextValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MissingContextValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> EVAL_DECISION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(ResourceSpecificResult.getter(ResourceSpecificResult::evalDecisionDetailsAsStrings)).setter(ResourceSpecificResult.setter(Builder::evalDecisionDetailsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvalDecisionDetails").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVAL_RESOURCE_NAME_FIELD, EVAL_RESOURCE_DECISION_FIELD, MATCHED_STATEMENTS_FIELD, MISSING_CONTEXT_VALUES_FIELD, EVAL_DECISION_DETAILS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String evalResourceName;
    private final String evalResourceDecision;
    private final List<Statement> matchedStatements;
    private final List<String> missingContextValues;
    private final Map<String, String> evalDecisionDetails;

    private ResourceSpecificResult(BuilderImpl builder) {
        this.evalResourceName = builder.evalResourceName;
        this.evalResourceDecision = builder.evalResourceDecision;
        this.matchedStatements = builder.matchedStatements;
        this.missingContextValues = builder.missingContextValues;
        this.evalDecisionDetails = builder.evalDecisionDetails;
    }

    public String evalResourceName() {
        return this.evalResourceName;
    }

    public PolicyEvaluationDecisionType evalResourceDecision() {
        return PolicyEvaluationDecisionType.fromValue(this.evalResourceDecision);
    }

    public String evalResourceDecisionAsString() {
        return this.evalResourceDecision;
    }

    public List<Statement> matchedStatements() {
        return this.matchedStatements;
    }

    public List<String> missingContextValues() {
        return this.missingContextValues;
    }

    public Map<String, PolicyEvaluationDecisionType> evalDecisionDetails() {
        return TypeConverter.convert(this.evalDecisionDetails, Function.identity(), PolicyEvaluationDecisionType::fromValue, (k, v) -> true);
    }

    public Map<String, String> evalDecisionDetailsAsStrings() {
        return this.evalDecisionDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.evalResourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.evalResourceDecisionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchedStatements());
        hashCode = 31 * hashCode + Objects.hashCode(this.missingContextValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.evalDecisionDetailsAsStrings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceSpecificResult)) {
            return false;
        }
        ResourceSpecificResult other = (ResourceSpecificResult)obj;
        return Objects.equals(this.evalResourceName(), other.evalResourceName()) && Objects.equals(this.evalResourceDecisionAsString(), other.evalResourceDecisionAsString()) && Objects.equals(this.matchedStatements(), other.matchedStatements()) && Objects.equals(this.missingContextValues(), other.missingContextValues()) && Objects.equals(this.evalDecisionDetailsAsStrings(), other.evalDecisionDetailsAsStrings());
    }

    public String toString() {
        return ToString.builder((String)"ResourceSpecificResult").add("EvalResourceName", (Object)this.evalResourceName()).add("EvalResourceDecision", (Object)this.evalResourceDecisionAsString()).add("MatchedStatements", this.matchedStatements()).add("MissingContextValues", this.missingContextValues()).add("EvalDecisionDetails", this.evalDecisionDetailsAsStrings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EvalResourceName": {
                return Optional.ofNullable(clazz.cast(this.evalResourceName()));
            }
            case "EvalResourceDecision": {
                return Optional.ofNullable(clazz.cast(this.evalResourceDecisionAsString()));
            }
            case "MatchedStatements": {
                return Optional.ofNullable(clazz.cast(this.matchedStatements()));
            }
            case "MissingContextValues": {
                return Optional.ofNullable(clazz.cast(this.missingContextValues()));
            }
            case "EvalDecisionDetails": {
                return Optional.ofNullable(clazz.cast(this.evalDecisionDetailsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceSpecificResult, T> g) {
        return obj -> g.apply((ResourceSpecificResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String evalResourceName;
        private String evalResourceDecision;
        private List<Statement> matchedStatements = DefaultSdkAutoConstructList.getInstance();
        private List<String> missingContextValues = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> evalDecisionDetails = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceSpecificResult model) {
            this.evalResourceName(model.evalResourceName);
            this.evalResourceDecision(model.evalResourceDecision);
            this.matchedStatements(model.matchedStatements);
            this.missingContextValues(model.missingContextValues);
            this.evalDecisionDetailsWithStrings(model.evalDecisionDetails);
        }

        public final String getEvalResourceName() {
            return this.evalResourceName;
        }

        @Override
        public final Builder evalResourceName(String evalResourceName) {
            this.evalResourceName = evalResourceName;
            return this;
        }

        public final void setEvalResourceName(String evalResourceName) {
            this.evalResourceName = evalResourceName;
        }

        public final String getEvalResourceDecisionAsString() {
            return this.evalResourceDecision;
        }

        @Override
        public final Builder evalResourceDecision(String evalResourceDecision) {
            this.evalResourceDecision = evalResourceDecision;
            return this;
        }

        @Override
        public final Builder evalResourceDecision(PolicyEvaluationDecisionType evalResourceDecision) {
            this.evalResourceDecision(evalResourceDecision.toString());
            return this;
        }

        public final void setEvalResourceDecision(String evalResourceDecision) {
            this.evalResourceDecision = evalResourceDecision;
        }

        public final Collection<Statement.Builder> getMatchedStatements() {
            return this.matchedStatements != null ? (Collection)this.matchedStatements.stream().map(Statement::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder matchedStatements(Collection<Statement> matchedStatements) {
            this.matchedStatements = StatementListTypeCopier.copy(matchedStatements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchedStatements(Statement ... matchedStatements) {
            this.matchedStatements(Arrays.asList(matchedStatements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchedStatements(Consumer<Statement.Builder> ... matchedStatements) {
            this.matchedStatements(Stream.of(matchedStatements).map(c -> (Statement)((Statement.Builder)Statement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMatchedStatements(Collection<Statement.BuilderImpl> matchedStatements) {
            this.matchedStatements = StatementListTypeCopier.copyFromBuilder(matchedStatements);
        }

        public final Collection<String> getMissingContextValues() {
            return this.missingContextValues;
        }

        @Override
        public final Builder missingContextValues(Collection<String> missingContextValues) {
            this.missingContextValues = ContextKeyNamesResultListTypeCopier.copy(missingContextValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder missingContextValues(String ... missingContextValues) {
            this.missingContextValues(Arrays.asList(missingContextValues));
            return this;
        }

        public final void setMissingContextValues(Collection<String> missingContextValues) {
            this.missingContextValues = ContextKeyNamesResultListTypeCopier.copy(missingContextValues);
        }

        public final Map<String, String> getEvalDecisionDetailsAsStrings() {
            return this.evalDecisionDetails;
        }

        @Override
        public final Builder evalDecisionDetailsWithStrings(Map<String, String> evalDecisionDetails) {
            this.evalDecisionDetails = EvalDecisionDetailsTypeCopier.copy(evalDecisionDetails);
            return this;
        }

        @Override
        public final Builder evalDecisionDetails(Map<String, PolicyEvaluationDecisionType> evalDecisionDetails) {
            this.evalDecisionDetails = EvalDecisionDetailsTypeCopier.copyEnumToString(evalDecisionDetails);
            return this;
        }

        public final void setEvalDecisionDetailsWithStrings(Map<String, String> evalDecisionDetails) {
            this.evalDecisionDetails = EvalDecisionDetailsTypeCopier.copy(evalDecisionDetails);
        }

        public ResourceSpecificResult build() {
            return new ResourceSpecificResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceSpecificResult> {
        public Builder evalResourceName(String var1);

        public Builder evalResourceDecision(String var1);

        public Builder evalResourceDecision(PolicyEvaluationDecisionType var1);

        public Builder matchedStatements(Collection<Statement> var1);

        public Builder matchedStatements(Statement ... var1);

        public Builder matchedStatements(Consumer<Statement.Builder> ... var1);

        public Builder missingContextValues(Collection<String> var1);

        public Builder missingContextValues(String ... var1);

        public Builder evalDecisionDetailsWithStrings(Map<String, String> var1);

        public Builder evalDecisionDetails(Map<String, PolicyEvaluationDecisionType> var1);
    }
}

