/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.PolicyGrantingServiceAccess;
import software.amazon.awssdk.services.iam.model._policyGrantingServiceAccessListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPoliciesGrantingServiceAccessEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListPoliciesGrantingServiceAccessEntry> {
    private static final SdkField<String> SERVICE_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceNamespace").getter(ListPoliciesGrantingServiceAccessEntry.getter(ListPoliciesGrantingServiceAccessEntry::serviceNamespace)).setter(ListPoliciesGrantingServiceAccessEntry.setter(Builder::serviceNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceNamespace").build()}).build();
    private static final SdkField<List<PolicyGrantingServiceAccess>> POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Policies").getter(ListPoliciesGrantingServiceAccessEntry.getter(ListPoliciesGrantingServiceAccessEntry::policies)).setter(ListPoliciesGrantingServiceAccessEntry.setter(Builder::policies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PolicyGrantingServiceAccess::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_NAMESPACE_FIELD, POLICIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPoliciesGrantingServiceAccessEntry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String serviceNamespace;
    private final List<PolicyGrantingServiceAccess> policies;

    private ListPoliciesGrantingServiceAccessEntry(BuilderImpl builder) {
        this.serviceNamespace = builder.serviceNamespace;
        this.policies = builder.policies;
    }

    public final String serviceNamespace() {
        return this.serviceNamespace;
    }

    public final boolean hasPolicies() {
        return this.policies != null && !(this.policies instanceof SdkAutoConstructList);
    }

    public final List<PolicyGrantingServiceAccess> policies() {
        return this.policies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPolicies() ? this.policies() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPoliciesGrantingServiceAccessEntry)) {
            return false;
        }
        ListPoliciesGrantingServiceAccessEntry other = (ListPoliciesGrantingServiceAccessEntry)obj;
        return Objects.equals(this.serviceNamespace(), other.serviceNamespace()) && this.hasPolicies() == other.hasPolicies() && Objects.equals(this.policies(), other.policies());
    }

    public final String toString() {
        return ToString.builder((String)"ListPoliciesGrantingServiceAccessEntry").add("ServiceNamespace", (Object)this.serviceNamespace()).add("Policies", this.hasPolicies() ? this.policies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ServiceNamespace": {
                return Optional.ofNullable(clazz.cast(this.serviceNamespace()));
            }
            case "Policies": {
                return Optional.ofNullable(clazz.cast(this.policies()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ServiceNamespace", SERVICE_NAMESPACE_FIELD);
        map.put("Policies", POLICIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPoliciesGrantingServiceAccessEntry, T> g) {
        return obj -> g.apply((ListPoliciesGrantingServiceAccessEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceNamespace;
        private List<PolicyGrantingServiceAccess> policies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPoliciesGrantingServiceAccessEntry model) {
            this.serviceNamespace(model.serviceNamespace);
            this.policies(model.policies);
        }

        public final String getServiceNamespace() {
            return this.serviceNamespace;
        }

        public final void setServiceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
        }

        @Override
        public final Builder serviceNamespace(String serviceNamespace) {
            this.serviceNamespace = serviceNamespace;
            return this;
        }

        public final List<PolicyGrantingServiceAccess.Builder> getPolicies() {
            List<PolicyGrantingServiceAccess.Builder> result = _policyGrantingServiceAccessListTypeCopier.copyToBuilder(this.policies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPolicies(Collection<PolicyGrantingServiceAccess.BuilderImpl> policies) {
            this.policies = _policyGrantingServiceAccessListTypeCopier.copyFromBuilder(policies);
        }

        @Override
        public final Builder policies(Collection<PolicyGrantingServiceAccess> policies) {
            this.policies = _policyGrantingServiceAccessListTypeCopier.copy(policies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(PolicyGrantingServiceAccess ... policies) {
            this.policies(Arrays.asList(policies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policies(Consumer<PolicyGrantingServiceAccess.Builder> ... policies) {
            this.policies(Stream.of(policies).map(c -> (PolicyGrantingServiceAccess)((PolicyGrantingServiceAccess.Builder)PolicyGrantingServiceAccess.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ListPoliciesGrantingServiceAccessEntry build() {
            return new ListPoliciesGrantingServiceAccessEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListPoliciesGrantingServiceAccessEntry> {
        public Builder serviceNamespace(String var1);

        public Builder policies(Collection<PolicyGrantingServiceAccess> var1);

        public Builder policies(PolicyGrantingServiceAccess ... var1);

        public Builder policies(Consumer<PolicyGrantingServiceAccess.Builder> ... var1);
    }
}

