/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.services.iam.model.PolicyScopeType;
import software.amazon.awssdk.services.iam.model.PolicyUsageType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPoliciesRequest
extends IamRequest
implements ToCopyableBuilder<Builder, ListPoliciesRequest> {
    private static final SdkField<String> SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListPoliciesRequest.getter(ListPoliciesRequest::scopeAsString)).setter(ListPoliciesRequest.setter(Builder::scope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Scope").build()}).build();
    private static final SdkField<Boolean> ONLY_ATTACHED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(ListPoliciesRequest.getter(ListPoliciesRequest::onlyAttached)).setter(ListPoliciesRequest.setter(Builder::onlyAttached)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnlyAttached").build()}).build();
    private static final SdkField<String> PATH_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListPoliciesRequest.getter(ListPoliciesRequest::pathPrefix)).setter(ListPoliciesRequest.setter(Builder::pathPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathPrefix").build()}).build();
    private static final SdkField<String> POLICY_USAGE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListPoliciesRequest.getter(ListPoliciesRequest::policyUsageFilterAsString)).setter(ListPoliciesRequest.setter(Builder::policyUsageFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyUsageFilter").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListPoliciesRequest.getter(ListPoliciesRequest::marker)).setter(ListPoliciesRequest.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<Integer> MAX_ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(ListPoliciesRequest.getter(ListPoliciesRequest::maxItems)).setter(ListPoliciesRequest.setter(Builder::maxItems)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxItems").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCOPE_FIELD, ONLY_ATTACHED_FIELD, PATH_PREFIX_FIELD, POLICY_USAGE_FILTER_FIELD, MARKER_FIELD, MAX_ITEMS_FIELD));
    private final String scope;
    private final Boolean onlyAttached;
    private final String pathPrefix;
    private final String policyUsageFilter;
    private final String marker;
    private final Integer maxItems;

    private ListPoliciesRequest(BuilderImpl builder) {
        super(builder);
        this.scope = builder.scope;
        this.onlyAttached = builder.onlyAttached;
        this.pathPrefix = builder.pathPrefix;
        this.policyUsageFilter = builder.policyUsageFilter;
        this.marker = builder.marker;
        this.maxItems = builder.maxItems;
    }

    public PolicyScopeType scope() {
        return PolicyScopeType.fromValue(this.scope);
    }

    public String scopeAsString() {
        return this.scope;
    }

    public Boolean onlyAttached() {
        return this.onlyAttached;
    }

    public String pathPrefix() {
        return this.pathPrefix;
    }

    public PolicyUsageType policyUsageFilter() {
        return PolicyUsageType.fromValue(this.policyUsageFilter);
    }

    public String policyUsageFilterAsString() {
        return this.policyUsageFilter;
    }

    public String marker() {
        return this.marker;
    }

    public Integer maxItems() {
        return this.maxItems;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.scopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.onlyAttached());
        hashCode = 31 * hashCode + Objects.hashCode(this.pathPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.policyUsageFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxItems());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPoliciesRequest)) {
            return false;
        }
        ListPoliciesRequest other = (ListPoliciesRequest)((Object)obj);
        return Objects.equals(this.scopeAsString(), other.scopeAsString()) && Objects.equals(this.onlyAttached(), other.onlyAttached()) && Objects.equals(this.pathPrefix(), other.pathPrefix()) && Objects.equals(this.policyUsageFilterAsString(), other.policyUsageFilterAsString()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.maxItems(), other.maxItems());
    }

    public String toString() {
        return ToString.builder((String)"ListPoliciesRequest").add("Scope", (Object)this.scopeAsString()).add("OnlyAttached", (Object)this.onlyAttached()).add("PathPrefix", (Object)this.pathPrefix()).add("PolicyUsageFilter", (Object)this.policyUsageFilterAsString()).add("Marker", (Object)this.marker()).add("MaxItems", (Object)this.maxItems()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Scope": {
                return Optional.ofNullable(clazz.cast(this.scopeAsString()));
            }
            case "OnlyAttached": {
                return Optional.ofNullable(clazz.cast(this.onlyAttached()));
            }
            case "PathPrefix": {
                return Optional.ofNullable(clazz.cast(this.pathPrefix()));
            }
            case "PolicyUsageFilter": {
                return Optional.ofNullable(clazz.cast(this.policyUsageFilterAsString()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "MaxItems": {
                return Optional.ofNullable(clazz.cast(this.maxItems()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPoliciesRequest, T> g) {
        return obj -> g.apply((ListPoliciesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamRequest.BuilderImpl
    implements Builder {
        private String scope;
        private Boolean onlyAttached;
        private String pathPrefix;
        private String policyUsageFilter;
        private String marker;
        private Integer maxItems;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPoliciesRequest model) {
            super(model);
            this.scope(model.scope);
            this.onlyAttached(model.onlyAttached);
            this.pathPrefix(model.pathPrefix);
            this.policyUsageFilter(model.policyUsageFilter);
            this.marker(model.marker);
            this.maxItems(model.maxItems);
        }

        public final String getScopeAsString() {
            return this.scope;
        }

        @Override
        public final Builder scope(String scope) {
            this.scope = scope;
            return this;
        }

        @Override
        public final Builder scope(PolicyScopeType scope) {
            this.scope(scope.toString());
            return this;
        }

        public final void setScope(String scope) {
            this.scope = scope;
        }

        public final Boolean getOnlyAttached() {
            return this.onlyAttached;
        }

        @Override
        public final Builder onlyAttached(Boolean onlyAttached) {
            this.onlyAttached = onlyAttached;
            return this;
        }

        public final void setOnlyAttached(Boolean onlyAttached) {
            this.onlyAttached = onlyAttached;
        }

        public final String getPathPrefix() {
            return this.pathPrefix;
        }

        @Override
        public final Builder pathPrefix(String pathPrefix) {
            this.pathPrefix = pathPrefix;
            return this;
        }

        public final void setPathPrefix(String pathPrefix) {
            this.pathPrefix = pathPrefix;
        }

        public final String getPolicyUsageFilterAsString() {
            return this.policyUsageFilter;
        }

        @Override
        public final Builder policyUsageFilter(String policyUsageFilter) {
            this.policyUsageFilter = policyUsageFilter;
            return this;
        }

        @Override
        public final Builder policyUsageFilter(PolicyUsageType policyUsageFilter) {
            this.policyUsageFilter(policyUsageFilter.toString());
            return this;
        }

        public final void setPolicyUsageFilter(String policyUsageFilter) {
            this.policyUsageFilter = policyUsageFilter;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getMaxItems() {
            return this.maxItems;
        }

        @Override
        public final Builder maxItems(Integer maxItems) {
            this.maxItems = maxItems;
            return this;
        }

        public final void setMaxItems(Integer maxItems) {
            this.maxItems = maxItems;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPoliciesRequest build() {
            return new ListPoliciesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPoliciesRequest> {
        public Builder scope(String var1);

        public Builder scope(PolicyScopeType var1);

        public Builder onlyAttached(Boolean var1);

        public Builder pathPrefix(String var1);

        public Builder policyUsageFilter(String var1);

        public Builder policyUsageFilter(PolicyUsageType var1);

        public Builder marker(String var1);

        public Builder maxItems(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

