/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.model.ListServerCertificateTagsRequest;
import software.amazon.awssdk.services.iam.model.ListServerCertificateTagsResponse;
import software.amazon.awssdk.services.iam.model.Tag;

public class ListServerCertificateTagsPublisher
implements SdkPublisher<ListServerCertificateTagsResponse> {
    private final IamAsyncClient client;
    private final ListServerCertificateTagsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListServerCertificateTagsPublisher(IamAsyncClient client, ListServerCertificateTagsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListServerCertificateTagsPublisher(IamAsyncClient client, ListServerCertificateTagsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListServerCertificateTagsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListServerCertificateTagsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Tag> tags() {
        Function<ListServerCertificateTagsResponse, Iterator> getIterator = response -> {
            if (response != null && response.tags() != null) {
                return response.tags().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListServerCertificateTagsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListServerCertificateTagsResponseFetcher
    implements AsyncPageFetcher<ListServerCertificateTagsResponse> {
        private ListServerCertificateTagsResponseFetcher() {
        }

        public boolean hasNextPage(ListServerCertificateTagsResponse previousPage) {
            return previousPage.isTruncated();
        }

        public CompletableFuture<ListServerCertificateTagsResponse> nextPage(ListServerCertificateTagsResponse previousPage) {
            if (previousPage == null) {
                return ListServerCertificateTagsPublisher.this.client.listServerCertificateTags(ListServerCertificateTagsPublisher.this.firstRequest);
            }
            return ListServerCertificateTagsPublisher.this.client.listServerCertificateTags((ListServerCertificateTagsRequest)((Object)ListServerCertificateTagsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

