/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.services.iam.IamAsyncClient;
import software.amazon.awssdk.services.iam.internal.UserAgentUtils;
import software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyRequest;
import software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyResponse;
import software.amazon.awssdk.services.iam.model.PolicyGroup;
import software.amazon.awssdk.services.iam.model.PolicyRole;
import software.amazon.awssdk.services.iam.model.PolicyUser;

public class ListEntitiesForPolicyPublisher
implements SdkPublisher<ListEntitiesForPolicyResponse> {
    private final IamAsyncClient client;
    private final ListEntitiesForPolicyRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEntitiesForPolicyPublisher(IamAsyncClient client, ListEntitiesForPolicyRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEntitiesForPolicyPublisher(IamAsyncClient client, ListEntitiesForPolicyRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEntitiesForPolicyResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEntitiesForPolicyResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<PolicyGroup> policyGroups() {
        Function<ListEntitiesForPolicyResponse, Iterator> getIterator = response -> {
            if (response != null && response.policyGroups() != null) {
                return response.policyGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEntitiesForPolicyResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    public final SdkPublisher<PolicyUser> policyUsers() {
        Function<ListEntitiesForPolicyResponse, Iterator> getIterator = response -> {
            if (response != null && response.policyUsers() != null) {
                return response.policyUsers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEntitiesForPolicyResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    public final SdkPublisher<PolicyRole> policyRoles() {
        Function<ListEntitiesForPolicyResponse, Iterator> getIterator = response -> {
            if (response != null && response.policyRoles() != null) {
                return response.policyRoles().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEntitiesForPolicyResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEntitiesForPolicyResponseFetcher
    implements AsyncPageFetcher<ListEntitiesForPolicyResponse> {
        private ListEntitiesForPolicyResponseFetcher() {
        }

        public boolean hasNextPage(ListEntitiesForPolicyResponse previousPage) {
            return previousPage.isTruncated();
        }

        public CompletableFuture<ListEntitiesForPolicyResponse> nextPage(ListEntitiesForPolicyResponse previousPage) {
            if (previousPage == null) {
                return ListEntitiesForPolicyPublisher.this.client.listEntitiesForPolicy(ListEntitiesForPolicyPublisher.this.firstRequest);
            }
            return ListEntitiesForPolicyPublisher.this.client.listEntitiesForPolicy((ListEntitiesForPolicyRequest)((Object)ListEntitiesForPolicyPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

