/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iam.model.StatusType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceSpecificCredential
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceSpecificCredential> {
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ServiceSpecificCredential.getter(ServiceSpecificCredential::createDate)).setter(ServiceSpecificCredential.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ServiceSpecificCredential.getter(ServiceSpecificCredential::serviceName)).setter(ServiceSpecificCredential.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()}).build();
    private static final SdkField<String> SERVICE_USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ServiceSpecificCredential.getter(ServiceSpecificCredential::serviceUserName)).setter(ServiceSpecificCredential.setter(Builder::serviceUserName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceUserName").build()}).build();
    private static final SdkField<String> SERVICE_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ServiceSpecificCredential.getter(ServiceSpecificCredential::servicePassword)).setter(ServiceSpecificCredential.setter(Builder::servicePassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServicePassword").build()}).build();
    private static final SdkField<String> SERVICE_SPECIFIC_CREDENTIAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ServiceSpecificCredential.getter(ServiceSpecificCredential::serviceSpecificCredentialId)).setter(ServiceSpecificCredential.setter(Builder::serviceSpecificCredentialId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceSpecificCredentialId").build()}).build();
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ServiceSpecificCredential.getter(ServiceSpecificCredential::userName)).setter(ServiceSpecificCredential.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ServiceSpecificCredential.getter(ServiceSpecificCredential::statusAsString)).setter(ServiceSpecificCredential.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_DATE_FIELD, SERVICE_NAME_FIELD, SERVICE_USER_NAME_FIELD, SERVICE_PASSWORD_FIELD, SERVICE_SPECIFIC_CREDENTIAL_ID_FIELD, USER_NAME_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant createDate;
    private final String serviceName;
    private final String serviceUserName;
    private final String servicePassword;
    private final String serviceSpecificCredentialId;
    private final String userName;
    private final String status;

    private ServiceSpecificCredential(BuilderImpl builder) {
        this.createDate = builder.createDate;
        this.serviceName = builder.serviceName;
        this.serviceUserName = builder.serviceUserName;
        this.servicePassword = builder.servicePassword;
        this.serviceSpecificCredentialId = builder.serviceSpecificCredentialId;
        this.userName = builder.userName;
        this.status = builder.status;
    }

    public Instant createDate() {
        return this.createDate;
    }

    public String serviceName() {
        return this.serviceName;
    }

    public String serviceUserName() {
        return this.serviceUserName;
    }

    public String servicePassword() {
        return this.servicePassword;
    }

    public String serviceSpecificCredentialId() {
        return this.serviceSpecificCredentialId;
    }

    public String userName() {
        return this.userName;
    }

    public StatusType status() {
        return StatusType.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceUserName());
        hashCode = 31 * hashCode + Objects.hashCode(this.servicePassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceSpecificCredentialId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceSpecificCredential)) {
            return false;
        }
        ServiceSpecificCredential other = (ServiceSpecificCredential)obj;
        return Objects.equals(this.createDate(), other.createDate()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.serviceUserName(), other.serviceUserName()) && Objects.equals(this.servicePassword(), other.servicePassword()) && Objects.equals(this.serviceSpecificCredentialId(), other.serviceSpecificCredentialId()) && Objects.equals(this.userName(), other.userName()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"ServiceSpecificCredential").add("CreateDate", (Object)this.createDate()).add("ServiceName", (Object)this.serviceName()).add("ServiceUserName", (Object)this.serviceUserName()).add("ServicePassword", (Object)this.servicePassword()).add("ServiceSpecificCredentialId", (Object)this.serviceSpecificCredentialId()).add("UserName", (Object)this.userName()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "ServiceUserName": {
                return Optional.ofNullable(clazz.cast(this.serviceUserName()));
            }
            case "ServicePassword": {
                return Optional.ofNullable(clazz.cast(this.servicePassword()));
            }
            case "ServiceSpecificCredentialId": {
                return Optional.ofNullable(clazz.cast(this.serviceSpecificCredentialId()));
            }
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceSpecificCredential, T> g) {
        return obj -> g.apply((ServiceSpecificCredential)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createDate;
        private String serviceName;
        private String serviceUserName;
        private String servicePassword;
        private String serviceSpecificCredentialId;
        private String userName;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceSpecificCredential model) {
            this.createDate(model.createDate);
            this.serviceName(model.serviceName);
            this.serviceUserName(model.serviceUserName);
            this.servicePassword(model.servicePassword);
            this.serviceSpecificCredentialId(model.serviceSpecificCredentialId);
            this.userName(model.userName);
            this.status(model.status);
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getServiceUserName() {
            return this.serviceUserName;
        }

        @Override
        public final Builder serviceUserName(String serviceUserName) {
            this.serviceUserName = serviceUserName;
            return this;
        }

        public final void setServiceUserName(String serviceUserName) {
            this.serviceUserName = serviceUserName;
        }

        public final String getServicePassword() {
            return this.servicePassword;
        }

        @Override
        public final Builder servicePassword(String servicePassword) {
            this.servicePassword = servicePassword;
            return this;
        }

        public final void setServicePassword(String servicePassword) {
            this.servicePassword = servicePassword;
        }

        public final String getServiceSpecificCredentialId() {
            return this.serviceSpecificCredentialId;
        }

        @Override
        public final Builder serviceSpecificCredentialId(String serviceSpecificCredentialId) {
            this.serviceSpecificCredentialId = serviceSpecificCredentialId;
            return this;
        }

        public final void setServiceSpecificCredentialId(String serviceSpecificCredentialId) {
            this.serviceSpecificCredentialId = serviceSpecificCredentialId;
        }

        public final String getUserName() {
            return this.userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusType status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public ServiceSpecificCredential build() {
            return new ServiceSpecificCredential(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceSpecificCredential> {
        public Builder createDate(Instant var1);

        public Builder serviceName(String var1);

        public Builder serviceUserName(String var1);

        public Builder servicePassword(String var1);

        public Builder serviceSpecificCredentialId(String var1);

        public Builder userName(String var1);

        public Builder status(String var1);

        public Builder status(StatusType var1);
    }
}

