/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PolicyEvaluationDecisionType {
    ALLOWED("allowed"),
    EXPLICIT_DENY("explicitDeny"),
    IMPLICIT_DENY("implicitDeny"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PolicyEvaluationDecisionType> VALUE_MAP;
    private final String value;

    private PolicyEvaluationDecisionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PolicyEvaluationDecisionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PolicyEvaluationDecisionType> knownValues() {
        EnumSet<PolicyEvaluationDecisionType> knownValues = EnumSet.allOf(PolicyEvaluationDecisionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PolicyEvaluationDecisionType.class, PolicyEvaluationDecisionType::toString);
    }
}

