/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.AttachedPermissionsBoundary;
import software.amazon.awssdk.services.iam.model.AttachedPolicy;
import software.amazon.awssdk.services.iam.model.PolicyDetail;
import software.amazon.awssdk.services.iam.model.Tag;
import software.amazon.awssdk.services.iam.model._attachedPoliciesListTypeCopier;
import software.amazon.awssdk.services.iam.model._groupNameListTypeCopier;
import software.amazon.awssdk.services.iam.model._policyDetailListTypeCopier;
import software.amazon.awssdk.services.iam.model._tagListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UserDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, UserDetail> {
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Path").getter(UserDetail.getter(UserDetail::path)).setter(UserDetail.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()}).build();
    private static final SdkField<String> USER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserName").getter(UserDetail.getter(UserDetail::userName)).setter(UserDetail.setter(Builder::userName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()}).build();
    private static final SdkField<String> USER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserId").getter(UserDetail.getter(UserDetail::userId)).setter(UserDetail.setter(Builder::userId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(UserDetail.getter(UserDetail::arn)).setter(UserDetail.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreateDate").getter(UserDetail.getter(UserDetail::createDate)).setter(UserDetail.setter(Builder::createDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()}).build();
    private static final SdkField<List<PolicyDetail>> USER_POLICY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UserPolicyList").getter(UserDetail.getter(UserDetail::userPolicyList)).setter(UserDetail.setter(Builder::userPolicyList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserPolicyList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PolicyDetail::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> GROUP_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupList").getter(UserDetail.getter(UserDetail::groupList)).setter(UserDetail.setter(Builder::groupList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AttachedPolicy>> ATTACHED_MANAGED_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AttachedManagedPolicies").getter(UserDetail.getter(UserDetail::attachedManagedPolicies)).setter(UserDetail.setter(Builder::attachedManagedPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachedManagedPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttachedPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<AttachedPermissionsBoundary> PERMISSIONS_BOUNDARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PermissionsBoundary").getter(UserDetail.getter(UserDetail::permissionsBoundary)).setter(UserDetail.setter(Builder::permissionsBoundary)).constructor(AttachedPermissionsBoundary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsBoundary").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(UserDetail.getter(UserDetail::tags)).setter(UserDetail.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD, USER_NAME_FIELD, USER_ID_FIELD, ARN_FIELD, CREATE_DATE_FIELD, USER_POLICY_LIST_FIELD, GROUP_LIST_FIELD, ATTACHED_MANAGED_POLICIES_FIELD, PERMISSIONS_BOUNDARY_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String path;
    private final String userName;
    private final String userId;
    private final String arn;
    private final Instant createDate;
    private final List<PolicyDetail> userPolicyList;
    private final List<String> groupList;
    private final List<AttachedPolicy> attachedManagedPolicies;
    private final AttachedPermissionsBoundary permissionsBoundary;
    private final List<Tag> tags;

    private UserDetail(BuilderImpl builder) {
        this.path = builder.path;
        this.userName = builder.userName;
        this.userId = builder.userId;
        this.arn = builder.arn;
        this.createDate = builder.createDate;
        this.userPolicyList = builder.userPolicyList;
        this.groupList = builder.groupList;
        this.attachedManagedPolicies = builder.attachedManagedPolicies;
        this.permissionsBoundary = builder.permissionsBoundary;
        this.tags = builder.tags;
    }

    public final String path() {
        return this.path;
    }

    public final String userName() {
        return this.userName;
    }

    public final String userId() {
        return this.userId;
    }

    public final String arn() {
        return this.arn;
    }

    public final Instant createDate() {
        return this.createDate;
    }

    public final boolean hasUserPolicyList() {
        return this.userPolicyList != null && !(this.userPolicyList instanceof SdkAutoConstructList);
    }

    public final List<PolicyDetail> userPolicyList() {
        return this.userPolicyList;
    }

    public final boolean hasGroupList() {
        return this.groupList != null && !(this.groupList instanceof SdkAutoConstructList);
    }

    public final List<String> groupList() {
        return this.groupList;
    }

    public final boolean hasAttachedManagedPolicies() {
        return this.attachedManagedPolicies != null && !(this.attachedManagedPolicies instanceof SdkAutoConstructList);
    }

    public final List<AttachedPolicy> attachedManagedPolicies() {
        return this.attachedManagedPolicies;
    }

    public final AttachedPermissionsBoundary permissionsBoundary() {
        return this.permissionsBoundary;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.userName());
        hashCode = 31 * hashCode + Objects.hashCode(this.userId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserPolicyList() ? this.userPolicyList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupList() ? this.groupList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAttachedManagedPolicies() ? this.attachedManagedPolicies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionsBoundary());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserDetail)) {
            return false;
        }
        UserDetail other = (UserDetail)obj;
        return Objects.equals(this.path(), other.path()) && Objects.equals(this.userName(), other.userName()) && Objects.equals(this.userId(), other.userId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.createDate(), other.createDate()) && this.hasUserPolicyList() == other.hasUserPolicyList() && Objects.equals(this.userPolicyList(), other.userPolicyList()) && this.hasGroupList() == other.hasGroupList() && Objects.equals(this.groupList(), other.groupList()) && this.hasAttachedManagedPolicies() == other.hasAttachedManagedPolicies() && Objects.equals(this.attachedManagedPolicies(), other.attachedManagedPolicies()) && Objects.equals(this.permissionsBoundary(), other.permissionsBoundary()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"UserDetail").add("Path", (Object)this.path()).add("UserName", (Object)this.userName()).add("UserId", (Object)this.userId()).add("Arn", (Object)this.arn()).add("CreateDate", (Object)this.createDate()).add("UserPolicyList", this.hasUserPolicyList() ? this.userPolicyList() : null).add("GroupList", this.hasGroupList() ? this.groupList() : null).add("AttachedManagedPolicies", this.hasAttachedManagedPolicies() ? this.attachedManagedPolicies() : null).add("PermissionsBoundary", (Object)this.permissionsBoundary()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "UserName": {
                return Optional.ofNullable(clazz.cast(this.userName()));
            }
            case "UserId": {
                return Optional.ofNullable(clazz.cast(this.userId()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "CreateDate": {
                return Optional.ofNullable(clazz.cast(this.createDate()));
            }
            case "UserPolicyList": {
                return Optional.ofNullable(clazz.cast(this.userPolicyList()));
            }
            case "GroupList": {
                return Optional.ofNullable(clazz.cast(this.groupList()));
            }
            case "AttachedManagedPolicies": {
                return Optional.ofNullable(clazz.cast(this.attachedManagedPolicies()));
            }
            case "PermissionsBoundary": {
                return Optional.ofNullable(clazz.cast(this.permissionsBoundary()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UserDetail, T> g) {
        return obj -> g.apply((UserDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String path;
        private String userName;
        private String userId;
        private String arn;
        private Instant createDate;
        private List<PolicyDetail> userPolicyList = DefaultSdkAutoConstructList.getInstance();
        private List<String> groupList = DefaultSdkAutoConstructList.getInstance();
        private List<AttachedPolicy> attachedManagedPolicies = DefaultSdkAutoConstructList.getInstance();
        private AttachedPermissionsBoundary permissionsBoundary;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UserDetail model) {
            this.path(model.path);
            this.userName(model.userName);
            this.userId(model.userId);
            this.arn(model.arn);
            this.createDate(model.createDate);
            this.userPolicyList(model.userPolicyList);
            this.groupList(model.groupList);
            this.attachedManagedPolicies(model.attachedManagedPolicies);
            this.permissionsBoundary(model.permissionsBoundary);
            this.tags(model.tags);
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        @Transient
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final String getUserName() {
            return this.userName;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        @Override
        @Transient
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final String getUserId() {
            return this.userId;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        @Transient
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Instant getCreateDate() {
            return this.createDate;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        @Transient
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final List<PolicyDetail.Builder> getUserPolicyList() {
            List<PolicyDetail.Builder> result = _policyDetailListTypeCopier.copyToBuilder(this.userPolicyList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserPolicyList(Collection<PolicyDetail.BuilderImpl> userPolicyList) {
            this.userPolicyList = _policyDetailListTypeCopier.copyFromBuilder(userPolicyList);
        }

        @Override
        @Transient
        public final Builder userPolicyList(Collection<PolicyDetail> userPolicyList) {
            this.userPolicyList = _policyDetailListTypeCopier.copy(userPolicyList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder userPolicyList(PolicyDetail ... userPolicyList) {
            this.userPolicyList(Arrays.asList(userPolicyList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder userPolicyList(Consumer<PolicyDetail.Builder> ... userPolicyList) {
            this.userPolicyList(Stream.of(userPolicyList).map(c -> (PolicyDetail)((PolicyDetail.Builder)PolicyDetail.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getGroupList() {
            if (this.groupList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.groupList;
        }

        public final void setGroupList(Collection<String> groupList) {
            this.groupList = _groupNameListTypeCopier.copy(groupList);
        }

        @Override
        @Transient
        public final Builder groupList(Collection<String> groupList) {
            this.groupList = _groupNameListTypeCopier.copy(groupList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder groupList(String ... groupList) {
            this.groupList(Arrays.asList(groupList));
            return this;
        }

        public final List<AttachedPolicy.Builder> getAttachedManagedPolicies() {
            List<AttachedPolicy.Builder> result = _attachedPoliciesListTypeCopier.copyToBuilder(this.attachedManagedPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttachedManagedPolicies(Collection<AttachedPolicy.BuilderImpl> attachedManagedPolicies) {
            this.attachedManagedPolicies = _attachedPoliciesListTypeCopier.copyFromBuilder(attachedManagedPolicies);
        }

        @Override
        @Transient
        public final Builder attachedManagedPolicies(Collection<AttachedPolicy> attachedManagedPolicies) {
            this.attachedManagedPolicies = _attachedPoliciesListTypeCopier.copy(attachedManagedPolicies);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attachedManagedPolicies(AttachedPolicy ... attachedManagedPolicies) {
            this.attachedManagedPolicies(Arrays.asList(attachedManagedPolicies));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder attachedManagedPolicies(Consumer<AttachedPolicy.Builder> ... attachedManagedPolicies) {
            this.attachedManagedPolicies(Stream.of(attachedManagedPolicies).map(c -> (AttachedPolicy)((AttachedPolicy.Builder)AttachedPolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final AttachedPermissionsBoundary.Builder getPermissionsBoundary() {
            return this.permissionsBoundary != null ? this.permissionsBoundary.toBuilder() : null;
        }

        public final void setPermissionsBoundary(AttachedPermissionsBoundary.BuilderImpl permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary != null ? permissionsBoundary.build() : null;
        }

        @Override
        @Transient
        public final Builder permissionsBoundary(AttachedPermissionsBoundary permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = _tagListTypeCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = _tagListTypeCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = _tagListTypeCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public UserDetail build() {
            return new UserDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, UserDetail> {
        public Builder path(String var1);

        public Builder userName(String var1);

        public Builder userId(String var1);

        public Builder arn(String var1);

        public Builder createDate(Instant var1);

        public Builder userPolicyList(Collection<PolicyDetail> var1);

        public Builder userPolicyList(PolicyDetail ... var1);

        public Builder userPolicyList(Consumer<PolicyDetail.Builder> ... var1);

        public Builder groupList(Collection<String> var1);

        public Builder groupList(String ... var1);

        public Builder attachedManagedPolicies(Collection<AttachedPolicy> var1);

        public Builder attachedManagedPolicies(AttachedPolicy ... var1);

        public Builder attachedManagedPolicies(Consumer<AttachedPolicy.Builder> ... var1);

        public Builder permissionsBoundary(AttachedPermissionsBoundary var1);

        default public Builder permissionsBoundary(Consumer<AttachedPermissionsBoundary.Builder> permissionsBoundary) {
            return this.permissionsBoundary((AttachedPermissionsBoundary)((AttachedPermissionsBoundary.Builder)AttachedPermissionsBoundary.builder().applyMutation(permissionsBoundary)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

