/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;

@Generated("software.amazon.awssdk:codegen")
public enum SummaryKeyType {
    USERS("Users"),

    USERS_QUOTA("UsersQuota"),

    GROUPS("Groups"),

    GROUPS_QUOTA("GroupsQuota"),

    SERVER_CERTIFICATES("ServerCertificates"),

    SERVER_CERTIFICATES_QUOTA("ServerCertificatesQuota"),

    USER_POLICY_SIZE_QUOTA("UserPolicySizeQuota"),

    GROUP_POLICY_SIZE_QUOTA("GroupPolicySizeQuota"),

    GROUPS_PER_USER_QUOTA("GroupsPerUserQuota"),

    SIGNING_CERTIFICATES_PER_USER_QUOTA("SigningCertificatesPerUserQuota"),

    ACCESS_KEYS_PER_USER_QUOTA("AccessKeysPerUserQuota"),

    MFA_DEVICES("MFADevices"),

    MFA_DEVICES_IN_USE("MFADevicesInUse"),

    ACCOUNT_MFA_ENABLED("AccountMFAEnabled"),

    ACCOUNT_ACCESS_KEYS_PRESENT("AccountAccessKeysPresent"),

    ACCOUNT_SIGNING_CERTIFICATES_PRESENT("AccountSigningCertificatesPresent"),

    ATTACHED_POLICIES_PER_GROUP_QUOTA("AttachedPoliciesPerGroupQuota"),

    ATTACHED_POLICIES_PER_ROLE_QUOTA("AttachedPoliciesPerRoleQuota"),

    ATTACHED_POLICIES_PER_USER_QUOTA("AttachedPoliciesPerUserQuota"),

    POLICIES("Policies"),

    POLICIES_QUOTA("PoliciesQuota"),

    POLICY_SIZE_QUOTA("PolicySizeQuota"),

    POLICY_VERSIONS_IN_USE("PolicyVersionsInUse"),

    POLICY_VERSIONS_IN_USE_QUOTA("PolicyVersionsInUseQuota"),

    VERSIONS_PER_POLICY_QUOTA("VersionsPerPolicyQuota"),

    GLOBAL_ENDPOINT_TOKEN_VERSION("GlobalEndpointTokenVersion"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private SummaryKeyType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return SummaryKeyType corresponding to the value
     */
    public static SummaryKeyType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(SummaryKeyType.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link SummaryKeyType}s
     */
    public static Set<SummaryKeyType> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}
