/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an X.509 signing certificate.
 * </p>
 * <p>
 * This data type is used as a response element in the <a>UploadSigningCertificate</a> and
 * <a>ListSigningCertificates</a> operations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SigningCertificate implements SdkPojo, Serializable,
        ToCopyableBuilder<SigningCertificate.Builder, SigningCertificate> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(SigningCertificate::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateId").getter(getter(SigningCertificate::certificateId)).setter(setter(Builder::certificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateId").build()).build();

    private static final SdkField<String> CERTIFICATE_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CertificateBody").getter(getter(SigningCertificate::certificateBody))
            .setter(setter(Builder::certificateBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateBody").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(SigningCertificate::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> UPLOAD_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("UploadDate").getter(getter(SigningCertificate::uploadDate)).setter(setter(Builder::uploadDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD,
            CERTIFICATE_ID_FIELD, CERTIFICATE_BODY_FIELD, STATUS_FIELD, UPLOAD_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userName;

    private final String certificateId;

    private final String certificateBody;

    private final String status;

    private final Instant uploadDate;

    private SigningCertificate(BuilderImpl builder) {
        this.userName = builder.userName;
        this.certificateId = builder.certificateId;
        this.certificateBody = builder.certificateBody;
        this.status = builder.status;
        this.uploadDate = builder.uploadDate;
    }

    /**
     * <p>
     * The name of the user the signing certificate is associated with.
     * </p>
     * 
     * @return The name of the user the signing certificate is associated with.
     */
    public final String userName() {
        return userName;
    }

    /**
     * <p>
     * The ID for the signing certificate.
     * </p>
     * 
     * @return The ID for the signing certificate.
     */
    public final String certificateId() {
        return certificateId;
    }

    /**
     * <p>
     * The contents of the signing certificate.
     * </p>
     * 
     * @return The contents of the signing certificate.
     */
    public final String certificateBody() {
        return certificateBody;
    }

    /**
     * <p>
     * The status of the signing certificate. <code>Active</code> means that the key is valid for API calls, while
     * <code>Inactive</code> means it is not.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the signing certificate. <code>Active</code> means that the key is valid for API calls,
     *         while <code>Inactive</code> means it is not.
     * @see StatusType
     */
    public final StatusType status() {
        return StatusType.fromValue(status);
    }

    /**
     * <p>
     * The status of the signing certificate. <code>Active</code> means that the key is valid for API calls, while
     * <code>Inactive</code> means it is not.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the signing certificate. <code>Active</code> means that the key is valid for API calls,
     *         while <code>Inactive</code> means it is not.
     * @see StatusType
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date when the signing certificate was uploaded.
     * </p>
     * 
     * @return The date when the signing certificate was uploaded.
     */
    public final Instant uploadDate() {
        return uploadDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(certificateBody());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(uploadDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SigningCertificate)) {
            return false;
        }
        SigningCertificate other = (SigningCertificate) obj;
        return Objects.equals(userName(), other.userName()) && Objects.equals(certificateId(), other.certificateId())
                && Objects.equals(certificateBody(), other.certificateBody())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(uploadDate(), other.uploadDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SigningCertificate").add("UserName", userName()).add("CertificateId", certificateId())
                .add("CertificateBody", certificateBody()).add("Status", statusAsString()).add("UploadDate", uploadDate())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "CertificateId":
            return Optional.ofNullable(clazz.cast(certificateId()));
        case "CertificateBody":
            return Optional.ofNullable(clazz.cast(certificateBody()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "UploadDate":
            return Optional.ofNullable(clazz.cast(uploadDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SigningCertificate, T> g) {
        return obj -> g.apply((SigningCertificate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SigningCertificate> {
        /**
         * <p>
         * The name of the user the signing certificate is associated with.
         * </p>
         * 
         * @param userName
         *        The name of the user the signing certificate is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * The ID for the signing certificate.
         * </p>
         * 
         * @param certificateId
         *        The ID for the signing certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateId(String certificateId);

        /**
         * <p>
         * The contents of the signing certificate.
         * </p>
         * 
         * @param certificateBody
         *        The contents of the signing certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateBody(String certificateBody);

        /**
         * <p>
         * The status of the signing certificate. <code>Active</code> means that the key is valid for API calls, while
         * <code>Inactive</code> means it is not.
         * </p>
         * 
         * @param status
         *        The status of the signing certificate. <code>Active</code> means that the key is valid for API calls,
         *        while <code>Inactive</code> means it is not.
         * @see StatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the signing certificate. <code>Active</code> means that the key is valid for API calls, while
         * <code>Inactive</code> means it is not.
         * </p>
         * 
         * @param status
         *        The status of the signing certificate. <code>Active</code> means that the key is valid for API calls,
         *        while <code>Inactive</code> means it is not.
         * @see StatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusType
         */
        Builder status(StatusType status);

        /**
         * <p>
         * The date when the signing certificate was uploaded.
         * </p>
         * 
         * @param uploadDate
         *        The date when the signing certificate was uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadDate(Instant uploadDate);
    }

    static final class BuilderImpl implements Builder {
        private String userName;

        private String certificateId;

        private String certificateBody;

        private String status;

        private Instant uploadDate;

        private BuilderImpl() {
        }

        private BuilderImpl(SigningCertificate model) {
            userName(model.userName);
            certificateId(model.certificateId);
            certificateBody(model.certificateBody);
            status(model.status);
            uploadDate(model.uploadDate);
        }

        public final String getUserName() {
            return userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getCertificateId() {
            return certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getCertificateBody() {
            return certificateBody;
        }

        @Override
        public final Builder certificateBody(String certificateBody) {
            this.certificateBody = certificateBody;
            return this;
        }

        public final void setCertificateBody(String certificateBody) {
            this.certificateBody = certificateBody;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getUploadDate() {
            return uploadDate;
        }

        @Override
        public final Builder uploadDate(Instant uploadDate) {
            this.uploadDate = uploadDate;
            return this;
        }

        public final void setUploadDate(Instant uploadDate) {
            this.uploadDate = uploadDate;
        }

        @Override
        public SigningCertificate build() {
            return new SigningCertificate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
