/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.services.iam.model.SSHPublicKeyListTypeCopier;
import software.amazon.awssdk.services.iam.model.SSHPublicKeyMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSshPublicKeysResponse
extends IamResponse
implements ToCopyableBuilder<Builder, ListSshPublicKeysResponse> {
    private static final SdkField<List<SSHPublicKeyMetadata>> SSH_PUBLIC_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SSHPublicKeys").getter(ListSshPublicKeysResponse.getter(ListSshPublicKeysResponse::sshPublicKeys)).setter(ListSshPublicKeysResponse.setter(Builder::sshPublicKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSHPublicKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SSHPublicKeyMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_TRUNCATED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsTruncated").getter(ListSshPublicKeysResponse.getter(ListSshPublicKeysResponse::isTruncated)).setter(ListSshPublicKeysResponse.setter(Builder::isTruncated)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsTruncated").build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(ListSshPublicKeysResponse.getter(ListSshPublicKeysResponse::marker)).setter(ListSshPublicKeysResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SSH_PUBLIC_KEYS_FIELD, IS_TRUNCATED_FIELD, MARKER_FIELD));
    private final List<SSHPublicKeyMetadata> sshPublicKeys;
    private final Boolean isTruncated;
    private final String marker;

    private ListSshPublicKeysResponse(BuilderImpl builder) {
        super(builder);
        this.sshPublicKeys = builder.sshPublicKeys;
        this.isTruncated = builder.isTruncated;
        this.marker = builder.marker;
    }

    public boolean hasSshPublicKeys() {
        return this.sshPublicKeys != null && !(this.sshPublicKeys instanceof SdkAutoConstructList);
    }

    public List<SSHPublicKeyMetadata> sshPublicKeys() {
        return this.sshPublicKeys;
    }

    public Boolean isTruncated() {
        return this.isTruncated;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.sshPublicKeys());
        hashCode = 31 * hashCode + Objects.hashCode(this.isTruncated());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSshPublicKeysResponse)) {
            return false;
        }
        ListSshPublicKeysResponse other = (ListSshPublicKeysResponse)((Object)obj);
        return Objects.equals(this.sshPublicKeys(), other.sshPublicKeys()) && Objects.equals(this.isTruncated(), other.isTruncated()) && Objects.equals(this.marker(), other.marker());
    }

    public String toString() {
        return ToString.builder((String)"ListSshPublicKeysResponse").add("SSHPublicKeys", this.sshPublicKeys()).add("IsTruncated", (Object)this.isTruncated()).add("Marker", (Object)this.marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SSHPublicKeys": {
                return Optional.ofNullable(clazz.cast(this.sshPublicKeys()));
            }
            case "IsTruncated": {
                return Optional.ofNullable(clazz.cast(this.isTruncated()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSshPublicKeysResponse, T> g) {
        return obj -> g.apply((ListSshPublicKeysResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private List<SSHPublicKeyMetadata> sshPublicKeys = DefaultSdkAutoConstructList.getInstance();
        private Boolean isTruncated;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSshPublicKeysResponse model) {
            super(model);
            this.sshPublicKeys(model.sshPublicKeys);
            this.isTruncated(model.isTruncated);
            this.marker(model.marker);
        }

        public final Collection<SSHPublicKeyMetadata.Builder> getSshPublicKeys() {
            return this.sshPublicKeys != null ? (Collection)this.sshPublicKeys.stream().map(SSHPublicKeyMetadata::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sshPublicKeys(Collection<SSHPublicKeyMetadata> sshPublicKeys) {
            this.sshPublicKeys = SSHPublicKeyListTypeCopier.copy(sshPublicKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sshPublicKeys(SSHPublicKeyMetadata ... sshPublicKeys) {
            this.sshPublicKeys(Arrays.asList(sshPublicKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sshPublicKeys(Consumer<SSHPublicKeyMetadata.Builder> ... sshPublicKeys) {
            this.sshPublicKeys(Stream.of(sshPublicKeys).map(c -> (SSHPublicKeyMetadata)((SSHPublicKeyMetadata.Builder)SSHPublicKeyMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSshPublicKeys(Collection<SSHPublicKeyMetadata.BuilderImpl> sshPublicKeys) {
            this.sshPublicKeys = SSHPublicKeyListTypeCopier.copyFromBuilder(sshPublicKeys);
        }

        public final Boolean getIsTruncated() {
            return this.isTruncated;
        }

        @Override
        public final Builder isTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
            return this;
        }

        public final void setIsTruncated(Boolean isTruncated) {
            this.isTruncated = isTruncated;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public ListSshPublicKeysResponse build() {
            return new ListSshPublicKeysResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSshPublicKeysResponse> {
        public Builder sshPublicKeys(Collection<SSHPublicKeyMetadata> var1);

        public Builder sshPublicKeys(SSHPublicKeyMetadata ... var1);

        public Builder sshPublicKeys(Consumer<SSHPublicKeyMetadata.Builder> ... var1);

        public Builder isTruncated(Boolean var1);

        public Builder marker(String var1);
    }
}

