/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iam.model.IamResponse;
import software.amazon.awssdk.services.iam.model.SAMLProviderListEntry;
import software.amazon.awssdk.services.iam.model.SAMLProviderListTypeCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSamlProvidersResponse
extends IamResponse
implements ToCopyableBuilder<Builder, ListSamlProvidersResponse> {
    private static final SdkField<List<SAMLProviderListEntry>> SAML_PROVIDER_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SAMLProviderList").getter(ListSamlProvidersResponse.getter(ListSamlProvidersResponse::samlProviderList)).setter(ListSamlProvidersResponse.setter(Builder::samlProviderList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMLProviderList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SAMLProviderListEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAML_PROVIDER_LIST_FIELD));
    private final List<SAMLProviderListEntry> samlProviderList;

    private ListSamlProvidersResponse(BuilderImpl builder) {
        super(builder);
        this.samlProviderList = builder.samlProviderList;
    }

    public boolean hasSamlProviderList() {
        return this.samlProviderList != null && !(this.samlProviderList instanceof SdkAutoConstructList);
    }

    public List<SAMLProviderListEntry> samlProviderList() {
        return this.samlProviderList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSamlProviderList() ? this.samlProviderList() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSamlProvidersResponse)) {
            return false;
        }
        ListSamlProvidersResponse other = (ListSamlProvidersResponse)((Object)obj);
        return this.hasSamlProviderList() == other.hasSamlProviderList() && Objects.equals(this.samlProviderList(), other.samlProviderList());
    }

    public String toString() {
        return ToString.builder((String)"ListSamlProvidersResponse").add("SAMLProviderList", this.hasSamlProviderList() ? this.samlProviderList() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SAMLProviderList": {
                return Optional.ofNullable(clazz.cast(this.samlProviderList()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListSamlProvidersResponse, T> g) {
        return obj -> g.apply((ListSamlProvidersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IamResponse.BuilderImpl
    implements Builder {
        private List<SAMLProviderListEntry> samlProviderList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSamlProvidersResponse model) {
            super(model);
            this.samlProviderList(model.samlProviderList);
        }

        public final Collection<SAMLProviderListEntry.Builder> getSamlProviderList() {
            if (this.samlProviderList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.samlProviderList != null ? (Collection)this.samlProviderList.stream().map(SAMLProviderListEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder samlProviderList(Collection<SAMLProviderListEntry> samlProviderList) {
            this.samlProviderList = SAMLProviderListTypeCopier.copy(samlProviderList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder samlProviderList(SAMLProviderListEntry ... samlProviderList) {
            this.samlProviderList(Arrays.asList(samlProviderList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder samlProviderList(Consumer<SAMLProviderListEntry.Builder> ... samlProviderList) {
            this.samlProviderList(Stream.of(samlProviderList).map(c -> (SAMLProviderListEntry)((SAMLProviderListEntry.Builder)SAMLProviderListEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSamlProviderList(Collection<SAMLProviderListEntry.BuilderImpl> samlProviderList) {
            this.samlProviderList = SAMLProviderListTypeCopier.copyFromBuilder(samlProviderList);
        }

        @Override
        public ListSamlProvidersResponse build() {
            return new ListSamlProvidersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IamResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSamlProvidersResponse> {
        public Builder samlProviderList(Collection<SAMLProviderListEntry> var1);

        public Builder samlProviderList(SAMLProviderListEntry ... var1);

        public Builder samlProviderList(Consumer<SAMLProviderListEntry.Builder> ... var1);
    }
}

