/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an IAM role, including all of the role's policies.
 * </p>
 * <p>
 * This data type is used as a response element in the <a>GetAccountAuthorizationDetails</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RoleDetail implements SdkPojo, Serializable, ToCopyableBuilder<RoleDetail.Builder, RoleDetail> {
    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Path")
            .getter(getter(RoleDetail::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final SdkField<String> ROLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RoleName").getter(getter(RoleDetail::roleName)).setter(setter(Builder::roleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleName").build()).build();

    private static final SdkField<String> ROLE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("RoleId")
            .getter(getter(RoleDetail::roleId)).setter(setter(Builder::roleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(RoleDetail::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateDate").getter(getter(RoleDetail::createDate)).setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()).build();

    private static final SdkField<String> ASSUME_ROLE_POLICY_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssumeRolePolicyDocument").getter(getter(RoleDetail::assumeRolePolicyDocument))
            .setter(setter(Builder::assumeRolePolicyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssumeRolePolicyDocument").build())
            .build();

    private static final SdkField<List<InstanceProfile>> INSTANCE_PROFILE_LIST_FIELD = SdkField
            .<List<InstanceProfile>> builder(MarshallingType.LIST)
            .memberName("InstanceProfileList")
            .getter(getter(RoleDetail::instanceProfileList))
            .setter(setter(Builder::instanceProfileList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceProfileList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceProfile> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceProfile::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PolicyDetail>> ROLE_POLICY_LIST_FIELD = SdkField
            .<List<PolicyDetail>> builder(MarshallingType.LIST)
            .memberName("RolePolicyList")
            .getter(getter(RoleDetail::rolePolicyList))
            .setter(setter(Builder::rolePolicyList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RolePolicyList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PolicyDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(PolicyDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AttachedPolicy>> ATTACHED_MANAGED_POLICIES_FIELD = SdkField
            .<List<AttachedPolicy>> builder(MarshallingType.LIST)
            .memberName("AttachedManagedPolicies")
            .getter(getter(RoleDetail::attachedManagedPolicies))
            .setter(setter(Builder::attachedManagedPolicies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachedManagedPolicies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttachedPolicy> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttachedPolicy::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AttachedPermissionsBoundary> PERMISSIONS_BOUNDARY_FIELD = SdkField
            .<AttachedPermissionsBoundary> builder(MarshallingType.SDK_POJO).memberName("PermissionsBoundary")
            .getter(getter(RoleDetail::permissionsBoundary)).setter(setter(Builder::permissionsBoundary))
            .constructor(AttachedPermissionsBoundary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsBoundary").build())
            .build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(RoleDetail::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RoleLastUsed> ROLE_LAST_USED_FIELD = SdkField.<RoleLastUsed> builder(MarshallingType.SDK_POJO)
            .memberName("RoleLastUsed").getter(getter(RoleDetail::roleLastUsed)).setter(setter(Builder::roleLastUsed))
            .constructor(RoleLastUsed::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleLastUsed").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(PATH_FIELD, ROLE_NAME_FIELD, ROLE_ID_FIELD, ARN_FIELD, CREATE_DATE_FIELD, ASSUME_ROLE_POLICY_DOCUMENT_FIELD,
                    INSTANCE_PROFILE_LIST_FIELD, ROLE_POLICY_LIST_FIELD, ATTACHED_MANAGED_POLICIES_FIELD,
                    PERMISSIONS_BOUNDARY_FIELD, TAGS_FIELD, ROLE_LAST_USED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String path;

    private final String roleName;

    private final String roleId;

    private final String arn;

    private final Instant createDate;

    private final String assumeRolePolicyDocument;

    private final List<InstanceProfile> instanceProfileList;

    private final List<PolicyDetail> rolePolicyList;

    private final List<AttachedPolicy> attachedManagedPolicies;

    private final AttachedPermissionsBoundary permissionsBoundary;

    private final List<Tag> tags;

    private final RoleLastUsed roleLastUsed;

    private RoleDetail(BuilderImpl builder) {
        this.path = builder.path;
        this.roleName = builder.roleName;
        this.roleId = builder.roleId;
        this.arn = builder.arn;
        this.createDate = builder.createDate;
        this.assumeRolePolicyDocument = builder.assumeRolePolicyDocument;
        this.instanceProfileList = builder.instanceProfileList;
        this.rolePolicyList = builder.rolePolicyList;
        this.attachedManagedPolicies = builder.attachedManagedPolicies;
        this.permissionsBoundary = builder.permissionsBoundary;
        this.tags = builder.tags;
        this.roleLastUsed = builder.roleLastUsed;
    }

    /**
     * <p>
     * The path to the role. For more information about paths, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>IAM
     * User Guide</i>.
     * </p>
     * 
     * @return The path to the role. For more information about paths, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the
     *         <i>IAM User Guide</i>.
     */
    public String path() {
        return path;
    }

    /**
     * <p>
     * The friendly name that identifies the role.
     * </p>
     * 
     * @return The friendly name that identifies the role.
     */
    public String roleName() {
        return roleName;
    }

    /**
     * <p>
     * The stable and unique string identifying the role. For more information about IDs, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>IAM
     * User Guide</i>.
     * </p>
     * 
     * @return The stable and unique string identifying the role. For more information about IDs, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the
     *         <i>IAM User Guide</i>.
     */
    public String roleId() {
        return roleId;
    }

    /**
     * Returns the value of the Arn property for this object.
     * 
     * @return The value of the Arn property for this object.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the role was
     * created.
     * </p>
     * 
     * @return The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
     *         role was created.
     */
    public Instant createDate() {
        return createDate;
    }

    /**
     * <p>
     * The trust policy that grants permission to assume the role.
     * </p>
     * 
     * @return The trust policy that grants permission to assume the role.
     */
    public String assumeRolePolicyDocument() {
        return assumeRolePolicyDocument;
    }

    /**
     * Returns true if the InstanceProfileList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasInstanceProfileList() {
        return instanceProfileList != null && !(instanceProfileList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of instance profiles that contain this role.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstanceProfileList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of instance profiles that contain this role.
     */
    public List<InstanceProfile> instanceProfileList() {
        return instanceProfileList;
    }

    /**
     * Returns true if the RolePolicyList property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRolePolicyList() {
        return rolePolicyList != null && !(rolePolicyList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of inline policies embedded in the role. These policies are the role's access (permissions) policies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRolePolicyList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of inline policies embedded in the role. These policies are the role's access (permissions)
     *         policies.
     */
    public List<PolicyDetail> rolePolicyList() {
        return rolePolicyList;
    }

    /**
     * Returns true if the AttachedManagedPolicies property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAttachedManagedPolicies() {
        return attachedManagedPolicies != null && !(attachedManagedPolicies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of managed policies attached to the role. These policies are the role's access (permissions) policies.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttachedManagedPolicies()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of managed policies attached to the role. These policies are the role's access (permissions)
     *         policies.
     */
    public List<AttachedPolicy> attachedManagedPolicies() {
        return attachedManagedPolicies;
    }

    /**
     * <p>
     * The ARN of the policy used to set the permissions boundary for the role.
     * </p>
     * <p>
     * For more information about permissions boundaries, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions Boundaries
     * for IAM Identities </a> in the <i>IAM User Guide</i>.
     * </p>
     * 
     * @return The ARN of the policy used to set the permissions boundary for the role.</p>
     *         <p>
     *         For more information about permissions boundaries, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions
     *         Boundaries for IAM Identities </a> in the <i>IAM User Guide</i>.
     */
    public AttachedPermissionsBoundary permissionsBoundary() {
        return permissionsBoundary;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of tags that are attached to the specified role. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM Identities</a> in the <i>IAM
     * User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of tags that are attached to the specified role. For more information about tagging, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM Identities</a> in the
     *         <i>IAM User Guide</i>.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * Contains information about the last time that an IAM role was used. This includes the date and time and the
     * Region in which the role was last used. Activity is only reported for the trailing 400 days. This period can be
     * shorter if your Region began supporting these features within the last year. The role might have been used more
     * than 400 days ago. For more information, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period"
     * >Regions Where Data Is Tracked</a> in the <i>IAM User Guide</i>.
     * </p>
     * 
     * @return Contains information about the last time that an IAM role was used. This includes the date and time and
     *         the Region in which the role was last used. Activity is only reported for the trailing 400 days. This
     *         period can be shorter if your Region began supporting these features within the last year. The role might
     *         have been used more than 400 days ago. For more information, see <a href=
     *         "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period"
     *         >Regions Where Data Is Tracked</a> in the <i>IAM User Guide</i>.
     */
    public RoleLastUsed roleLastUsed() {
        return roleLastUsed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(roleName());
        hashCode = 31 * hashCode + Objects.hashCode(roleId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(assumeRolePolicyDocument());
        hashCode = 31 * hashCode + Objects.hashCode(instanceProfileList());
        hashCode = 31 * hashCode + Objects.hashCode(rolePolicyList());
        hashCode = 31 * hashCode + Objects.hashCode(attachedManagedPolicies());
        hashCode = 31 * hashCode + Objects.hashCode(permissionsBoundary());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(roleLastUsed());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RoleDetail)) {
            return false;
        }
        RoleDetail other = (RoleDetail) obj;
        return Objects.equals(path(), other.path()) && Objects.equals(roleName(), other.roleName())
                && Objects.equals(roleId(), other.roleId()) && Objects.equals(arn(), other.arn())
                && Objects.equals(createDate(), other.createDate())
                && Objects.equals(assumeRolePolicyDocument(), other.assumeRolePolicyDocument())
                && Objects.equals(instanceProfileList(), other.instanceProfileList())
                && Objects.equals(rolePolicyList(), other.rolePolicyList())
                && Objects.equals(attachedManagedPolicies(), other.attachedManagedPolicies())
                && Objects.equals(permissionsBoundary(), other.permissionsBoundary()) && Objects.equals(tags(), other.tags())
                && Objects.equals(roleLastUsed(), other.roleLastUsed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RoleDetail").add("Path", path()).add("RoleName", roleName()).add("RoleId", roleId())
                .add("Arn", arn()).add("CreateDate", createDate()).add("AssumeRolePolicyDocument", assumeRolePolicyDocument())
                .add("InstanceProfileList", instanceProfileList()).add("RolePolicyList", rolePolicyList())
                .add("AttachedManagedPolicies", attachedManagedPolicies()).add("PermissionsBoundary", permissionsBoundary())
                .add("Tags", tags()).add("RoleLastUsed", roleLastUsed()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "RoleName":
            return Optional.ofNullable(clazz.cast(roleName()));
        case "RoleId":
            return Optional.ofNullable(clazz.cast(roleId()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "AssumeRolePolicyDocument":
            return Optional.ofNullable(clazz.cast(assumeRolePolicyDocument()));
        case "InstanceProfileList":
            return Optional.ofNullable(clazz.cast(instanceProfileList()));
        case "RolePolicyList":
            return Optional.ofNullable(clazz.cast(rolePolicyList()));
        case "AttachedManagedPolicies":
            return Optional.ofNullable(clazz.cast(attachedManagedPolicies()));
        case "PermissionsBoundary":
            return Optional.ofNullable(clazz.cast(permissionsBoundary()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "RoleLastUsed":
            return Optional.ofNullable(clazz.cast(roleLastUsed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RoleDetail, T> g) {
        return obj -> g.apply((RoleDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RoleDetail> {
        /**
         * <p>
         * The path to the role. For more information about paths, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the
         * <i>IAM User Guide</i>.
         * </p>
         * 
         * @param path
         *        The path to the role. For more information about paths, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in
         *        the <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The friendly name that identifies the role.
         * </p>
         * 
         * @param roleName
         *        The friendly name that identifies the role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleName(String roleName);

        /**
         * <p>
         * The stable and unique string identifying the role. For more information about IDs, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the
         * <i>IAM User Guide</i>.
         * </p>
         * 
         * @param roleId
         *        The stable and unique string identifying the role. For more information about IDs, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in
         *        the <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleId(String roleId);

        /**
         * Sets the value of the Arn property for this object.
         *
         * @param arn
         *        The new value for the Arn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the role
         * was created.
         * </p>
         * 
         * @param createDate
         *        The date and time, in <a href="http://www.iso.org/iso/iso8601">ISO 8601 date-time format</a>, when the
         *        role was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);

        /**
         * <p>
         * The trust policy that grants permission to assume the role.
         * </p>
         * 
         * @param assumeRolePolicyDocument
         *        The trust policy that grants permission to assume the role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assumeRolePolicyDocument(String assumeRolePolicyDocument);

        /**
         * <p>
         * A list of instance profiles that contain this role.
         * </p>
         * 
         * @param instanceProfileList
         *        A list of instance profiles that contain this role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceProfileList(Collection<InstanceProfile> instanceProfileList);

        /**
         * <p>
         * A list of instance profiles that contain this role.
         * </p>
         * 
         * @param instanceProfileList
         *        A list of instance profiles that contain this role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceProfileList(InstanceProfile... instanceProfileList);

        /**
         * <p>
         * A list of instance profiles that contain this role.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceProfile>.Builder} avoiding the need
         * to create one manually via {@link List<InstanceProfile>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceProfile>.Builder#build()} is called immediately and
         * its result is passed to {@link #instanceProfileList(List<InstanceProfile>)}.
         * 
         * @param instanceProfileList
         *        a consumer that will call methods on {@link List<InstanceProfile>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceProfileList(List<InstanceProfile>)
         */
        Builder instanceProfileList(Consumer<InstanceProfile.Builder>... instanceProfileList);

        /**
         * <p>
         * A list of inline policies embedded in the role. These policies are the role's access (permissions) policies.
         * </p>
         * 
         * @param rolePolicyList
         *        A list of inline policies embedded in the role. These policies are the role's access (permissions)
         *        policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rolePolicyList(Collection<PolicyDetail> rolePolicyList);

        /**
         * <p>
         * A list of inline policies embedded in the role. These policies are the role's access (permissions) policies.
         * </p>
         * 
         * @param rolePolicyList
         *        A list of inline policies embedded in the role. These policies are the role's access (permissions)
         *        policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rolePolicyList(PolicyDetail... rolePolicyList);

        /**
         * <p>
         * A list of inline policies embedded in the role. These policies are the role's access (permissions) policies.
         * </p>
         * This is a convenience that creates an instance of the {@link List<PolicyDetail>.Builder} avoiding the need to
         * create one manually via {@link List<PolicyDetail>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PolicyDetail>.Builder#build()} is called immediately and its
         * result is passed to {@link #rolePolicyList(List<PolicyDetail>)}.
         * 
         * @param rolePolicyList
         *        a consumer that will call methods on {@link List<PolicyDetail>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rolePolicyList(List<PolicyDetail>)
         */
        Builder rolePolicyList(Consumer<PolicyDetail.Builder>... rolePolicyList);

        /**
         * <p>
         * A list of managed policies attached to the role. These policies are the role's access (permissions) policies.
         * </p>
         * 
         * @param attachedManagedPolicies
         *        A list of managed policies attached to the role. These policies are the role's access (permissions)
         *        policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachedManagedPolicies(Collection<AttachedPolicy> attachedManagedPolicies);

        /**
         * <p>
         * A list of managed policies attached to the role. These policies are the role's access (permissions) policies.
         * </p>
         * 
         * @param attachedManagedPolicies
         *        A list of managed policies attached to the role. These policies are the role's access (permissions)
         *        policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachedManagedPolicies(AttachedPolicy... attachedManagedPolicies);

        /**
         * <p>
         * A list of managed policies attached to the role. These policies are the role's access (permissions) policies.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AttachedPolicy>.Builder} avoiding the need
         * to create one manually via {@link List<AttachedPolicy>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttachedPolicy>.Builder#build()} is called immediately and
         * its result is passed to {@link #attachedManagedPolicies(List<AttachedPolicy>)}.
         * 
         * @param attachedManagedPolicies
         *        a consumer that will call methods on {@link List<AttachedPolicy>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachedManagedPolicies(List<AttachedPolicy>)
         */
        Builder attachedManagedPolicies(Consumer<AttachedPolicy.Builder>... attachedManagedPolicies);

        /**
         * <p>
         * The ARN of the policy used to set the permissions boundary for the role.
         * </p>
         * <p>
         * For more information about permissions boundaries, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions
         * Boundaries for IAM Identities </a> in the <i>IAM User Guide</i>.
         * </p>
         * 
         * @param permissionsBoundary
         *        The ARN of the policy used to set the permissions boundary for the role.</p>
         *        <p>
         *        For more information about permissions boundaries, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions
         *        Boundaries for IAM Identities </a> in the <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsBoundary(AttachedPermissionsBoundary permissionsBoundary);

        /**
         * <p>
         * The ARN of the policy used to set the permissions boundary for the role.
         * </p>
         * <p>
         * For more information about permissions boundaries, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html">Permissions
         * Boundaries for IAM Identities </a> in the <i>IAM User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link AttachedPermissionsBoundary.Builder} avoiding
         * the need to create one manually via {@link AttachedPermissionsBoundary#builder()}.
         *
         * When the {@link Consumer} completes, {@link AttachedPermissionsBoundary.Builder#build()} is called
         * immediately and its result is passed to {@link #permissionsBoundary(AttachedPermissionsBoundary)}.
         * 
         * @param permissionsBoundary
         *        a consumer that will call methods on {@link AttachedPermissionsBoundary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissionsBoundary(AttachedPermissionsBoundary)
         */
        default Builder permissionsBoundary(Consumer<AttachedPermissionsBoundary.Builder> permissionsBoundary) {
            return permissionsBoundary(AttachedPermissionsBoundary.builder().applyMutation(permissionsBoundary).build());
        }

        /**
         * <p>
         * A list of tags that are attached to the specified role. For more information about tagging, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM Identities</a> in the <i>IAM
         * User Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of tags that are attached to the specified role. For more information about tagging, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM Identities</a> in the
         *        <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of tags that are attached to the specified role. For more information about tagging, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM Identities</a> in the <i>IAM
         * User Guide</i>.
         * </p>
         * 
         * @param tags
         *        A list of tags that are attached to the specified role. For more information about tagging, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM Identities</a> in the
         *        <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of tags that are attached to the specified role. For more information about tagging, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM Identities</a> in the <i>IAM
         * User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * Contains information about the last time that an IAM role was used. This includes the date and time and the
         * Region in which the role was last used. Activity is only reported for the trailing 400 days. This period can
         * be shorter if your Region began supporting these features within the last year. The role might have been used
         * more than 400 days ago. For more information, see <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period"
         * >Regions Where Data Is Tracked</a> in the <i>IAM User Guide</i>.
         * </p>
         * 
         * @param roleLastUsed
         *        Contains information about the last time that an IAM role was used. This includes the date and time
         *        and the Region in which the role was last used. Activity is only reported for the trailing 400 days.
         *        This period can be shorter if your Region began supporting these features within the last year. The
         *        role might have been used more than 400 days ago. For more information, see <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period"
         *        >Regions Where Data Is Tracked</a> in the <i>IAM User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleLastUsed(RoleLastUsed roleLastUsed);

        /**
         * <p>
         * Contains information about the last time that an IAM role was used. This includes the date and time and the
         * Region in which the role was last used. Activity is only reported for the trailing 400 days. This period can
         * be shorter if your Region began supporting these features within the last year. The role might have been used
         * more than 400 days ago. For more information, see <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period"
         * >Regions Where Data Is Tracked</a> in the <i>IAM User Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link RoleLastUsed.Builder} avoiding the need to
         * create one manually via {@link RoleLastUsed#builder()}.
         *
         * When the {@link Consumer} completes, {@link RoleLastUsed.Builder#build()} is called immediately and its
         * result is passed to {@link #roleLastUsed(RoleLastUsed)}.
         * 
         * @param roleLastUsed
         *        a consumer that will call methods on {@link RoleLastUsed.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #roleLastUsed(RoleLastUsed)
         */
        default Builder roleLastUsed(Consumer<RoleLastUsed.Builder> roleLastUsed) {
            return roleLastUsed(RoleLastUsed.builder().applyMutation(roleLastUsed).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String path;

        private String roleName;

        private String roleId;

        private String arn;

        private Instant createDate;

        private String assumeRolePolicyDocument;

        private List<InstanceProfile> instanceProfileList = DefaultSdkAutoConstructList.getInstance();

        private List<PolicyDetail> rolePolicyList = DefaultSdkAutoConstructList.getInstance();

        private List<AttachedPolicy> attachedManagedPolicies = DefaultSdkAutoConstructList.getInstance();

        private AttachedPermissionsBoundary permissionsBoundary;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private RoleLastUsed roleLastUsed;

        private BuilderImpl() {
        }

        private BuilderImpl(RoleDetail model) {
            path(model.path);
            roleName(model.roleName);
            roleId(model.roleId);
            arn(model.arn);
            createDate(model.createDate);
            assumeRolePolicyDocument(model.assumeRolePolicyDocument);
            instanceProfileList(model.instanceProfileList);
            rolePolicyList(model.rolePolicyList);
            attachedManagedPolicies(model.attachedManagedPolicies);
            permissionsBoundary(model.permissionsBoundary);
            tags(model.tags);
            roleLastUsed(model.roleLastUsed);
        }

        public final String getPath() {
            return path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getRoleName() {
            return roleName;
        }

        @Override
        public final Builder roleName(String roleName) {
            this.roleName = roleName;
            return this;
        }

        public final void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public final String getRoleId() {
            return roleId;
        }

        @Override
        public final Builder roleId(String roleId) {
            this.roleId = roleId;
            return this;
        }

        public final void setRoleId(String roleId) {
            this.roleId = roleId;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final String getAssumeRolePolicyDocument() {
            return assumeRolePolicyDocument;
        }

        @Override
        public final Builder assumeRolePolicyDocument(String assumeRolePolicyDocument) {
            this.assumeRolePolicyDocument = assumeRolePolicyDocument;
            return this;
        }

        public final void setAssumeRolePolicyDocument(String assumeRolePolicyDocument) {
            this.assumeRolePolicyDocument = assumeRolePolicyDocument;
        }

        public final Collection<InstanceProfile.Builder> getInstanceProfileList() {
            return instanceProfileList != null ? instanceProfileList.stream().map(InstanceProfile::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceProfileList(Collection<InstanceProfile> instanceProfileList) {
            this.instanceProfileList = _instanceProfileListTypeCopier.copy(instanceProfileList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceProfileList(InstanceProfile... instanceProfileList) {
            instanceProfileList(Arrays.asList(instanceProfileList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceProfileList(Consumer<InstanceProfile.Builder>... instanceProfileList) {
            instanceProfileList(Stream.of(instanceProfileList).map(c -> InstanceProfile.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceProfileList(Collection<InstanceProfile.BuilderImpl> instanceProfileList) {
            this.instanceProfileList = _instanceProfileListTypeCopier.copyFromBuilder(instanceProfileList);
        }

        public final Collection<PolicyDetail.Builder> getRolePolicyList() {
            return rolePolicyList != null ? rolePolicyList.stream().map(PolicyDetail::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder rolePolicyList(Collection<PolicyDetail> rolePolicyList) {
            this.rolePolicyList = _policyDetailListTypeCopier.copy(rolePolicyList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rolePolicyList(PolicyDetail... rolePolicyList) {
            rolePolicyList(Arrays.asList(rolePolicyList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rolePolicyList(Consumer<PolicyDetail.Builder>... rolePolicyList) {
            rolePolicyList(Stream.of(rolePolicyList).map(c -> PolicyDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRolePolicyList(Collection<PolicyDetail.BuilderImpl> rolePolicyList) {
            this.rolePolicyList = _policyDetailListTypeCopier.copyFromBuilder(rolePolicyList);
        }

        public final Collection<AttachedPolicy.Builder> getAttachedManagedPolicies() {
            return attachedManagedPolicies != null ? attachedManagedPolicies.stream().map(AttachedPolicy::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attachedManagedPolicies(Collection<AttachedPolicy> attachedManagedPolicies) {
            this.attachedManagedPolicies = _attachedPoliciesListTypeCopier.copy(attachedManagedPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedManagedPolicies(AttachedPolicy... attachedManagedPolicies) {
            attachedManagedPolicies(Arrays.asList(attachedManagedPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachedManagedPolicies(Consumer<AttachedPolicy.Builder>... attachedManagedPolicies) {
            attachedManagedPolicies(Stream.of(attachedManagedPolicies)
                    .map(c -> AttachedPolicy.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttachedManagedPolicies(Collection<AttachedPolicy.BuilderImpl> attachedManagedPolicies) {
            this.attachedManagedPolicies = _attachedPoliciesListTypeCopier.copyFromBuilder(attachedManagedPolicies);
        }

        public final AttachedPermissionsBoundary.Builder getPermissionsBoundary() {
            return permissionsBoundary != null ? permissionsBoundary.toBuilder() : null;
        }

        @Override
        public final Builder permissionsBoundary(AttachedPermissionsBoundary permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary;
            return this;
        }

        public final void setPermissionsBoundary(AttachedPermissionsBoundary.BuilderImpl permissionsBoundary) {
            this.permissionsBoundary = permissionsBoundary != null ? permissionsBoundary.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = _tagListTypeCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = _tagListTypeCopier.copyFromBuilder(tags);
        }

        public final RoleLastUsed.Builder getRoleLastUsed() {
            return roleLastUsed != null ? roleLastUsed.toBuilder() : null;
        }

        @Override
        public final Builder roleLastUsed(RoleLastUsed roleLastUsed) {
            this.roleLastUsed = roleLastUsed;
            return this;
        }

        public final void setRoleLastUsed(RoleLastUsed.BuilderImpl roleLastUsed) {
            this.roleLastUsed = roleLastUsed != null ? roleLastUsed.build() : null;
        }

        @Override
        public RoleDetail build() {
            return new RoleDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
