/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a successful <a>GetServerCertificate</a> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetServerCertificateResponse extends IamResponse implements
        ToCopyableBuilder<GetServerCertificateResponse.Builder, GetServerCertificateResponse> {
    private static final SdkField<ServerCertificate> SERVER_CERTIFICATE_FIELD = SdkField
            .<ServerCertificate> builder(MarshallingType.SDK_POJO).memberName("ServerCertificate")
            .getter(getter(GetServerCertificateResponse::serverCertificate)).setter(setter(Builder::serverCertificate))
            .constructor(ServerCertificate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerCertificate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVER_CERTIFICATE_FIELD));

    private final ServerCertificate serverCertificate;

    private GetServerCertificateResponse(BuilderImpl builder) {
        super(builder);
        this.serverCertificate = builder.serverCertificate;
    }

    /**
     * <p>
     * A structure containing details about the server certificate.
     * </p>
     * 
     * @return A structure containing details about the server certificate.
     */
    public ServerCertificate serverCertificate() {
        return serverCertificate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serverCertificate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServerCertificateResponse)) {
            return false;
        }
        GetServerCertificateResponse other = (GetServerCertificateResponse) obj;
        return Objects.equals(serverCertificate(), other.serverCertificate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetServerCertificateResponse").add("ServerCertificate", serverCertificate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServerCertificate":
            return Optional.ofNullable(clazz.cast(serverCertificate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetServerCertificateResponse, T> g) {
        return obj -> g.apply((GetServerCertificateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetServerCertificateResponse> {
        /**
         * <p>
         * A structure containing details about the server certificate.
         * </p>
         * 
         * @param serverCertificate
         *        A structure containing details about the server certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverCertificate(ServerCertificate serverCertificate);

        /**
         * <p>
         * A structure containing details about the server certificate.
         * </p>
         * This is a convenience that creates an instance of the {@link ServerCertificate.Builder} avoiding the need to
         * create one manually via {@link ServerCertificate#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServerCertificate.Builder#build()} is called immediately and its
         * result is passed to {@link #serverCertificate(ServerCertificate)}.
         * 
         * @param serverCertificate
         *        a consumer that will call methods on {@link ServerCertificate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serverCertificate(ServerCertificate)
         */
        default Builder serverCertificate(Consumer<ServerCertificate.Builder> serverCertificate) {
            return serverCertificate(ServerCertificate.builder().applyMutation(serverCertificate).build());
        }
    }

    static final class BuilderImpl extends IamResponse.BuilderImpl implements Builder {
        private ServerCertificate serverCertificate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServerCertificateResponse model) {
            super(model);
            serverCertificate(model.serverCertificate);
        }

        public final ServerCertificate.Builder getServerCertificate() {
            return serverCertificate != null ? serverCertificate.toBuilder() : null;
        }

        @Override
        public final Builder serverCertificate(ServerCertificate serverCertificate) {
            this.serverCertificate = serverCertificate;
            return this;
        }

        public final void setServerCertificate(ServerCertificate.BuilderImpl serverCertificate) {
            this.serverCertificate = serverCertificate != null ? serverCertificate.build() : null;
        }

        @Override
        public GetServerCertificateResponse build() {
            return new GetServerCertificateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
