/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a successful <a>GetSAMLProvider</a> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSamlProviderResponse extends IamResponse implements
        ToCopyableBuilder<GetSamlProviderResponse.Builder, GetSamlProviderResponse> {
    private static final SdkField<String> SAML_METADATA_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SAMLMetadataDocument").getter(getter(GetSamlProviderResponse::samlMetadataDocument))
            .setter(setter(Builder::samlMetadataDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMLMetadataDocument").build())
            .build();

    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreateDate").getter(getter(GetSamlProviderResponse::createDate)).setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()).build();

    private static final SdkField<Instant> VALID_UNTIL_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ValidUntil").getter(getter(GetSamlProviderResponse::validUntil)).setter(setter(Builder::validUntil))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidUntil").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SAML_METADATA_DOCUMENT_FIELD,
            CREATE_DATE_FIELD, VALID_UNTIL_FIELD));

    private final String samlMetadataDocument;

    private final Instant createDate;

    private final Instant validUntil;

    private GetSamlProviderResponse(BuilderImpl builder) {
        super(builder);
        this.samlMetadataDocument = builder.samlMetadataDocument;
        this.createDate = builder.createDate;
        this.validUntil = builder.validUntil;
    }

    /**
     * <p>
     * The XML metadata document that includes information about an identity provider.
     * </p>
     * 
     * @return The XML metadata document that includes information about an identity provider.
     */
    public String samlMetadataDocument() {
        return samlMetadataDocument;
    }

    /**
     * <p>
     * The date and time when the SAML provider was created.
     * </p>
     * 
     * @return The date and time when the SAML provider was created.
     */
    public Instant createDate() {
        return createDate;
    }

    /**
     * <p>
     * The expiration date and time for the SAML provider.
     * </p>
     * 
     * @return The expiration date and time for the SAML provider.
     */
    public Instant validUntil() {
        return validUntil;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(samlMetadataDocument());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        hashCode = 31 * hashCode + Objects.hashCode(validUntil());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSamlProviderResponse)) {
            return false;
        }
        GetSamlProviderResponse other = (GetSamlProviderResponse) obj;
        return Objects.equals(samlMetadataDocument(), other.samlMetadataDocument())
                && Objects.equals(createDate(), other.createDate()) && Objects.equals(validUntil(), other.validUntil());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetSamlProviderResponse").add("SAMLMetadataDocument", samlMetadataDocument())
                .add("CreateDate", createDate()).add("ValidUntil", validUntil()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SAMLMetadataDocument":
            return Optional.ofNullable(clazz.cast(samlMetadataDocument()));
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        case "ValidUntil":
            return Optional.ofNullable(clazz.cast(validUntil()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetSamlProviderResponse, T> g) {
        return obj -> g.apply((GetSamlProviderResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSamlProviderResponse> {
        /**
         * <p>
         * The XML metadata document that includes information about an identity provider.
         * </p>
         * 
         * @param samlMetadataDocument
         *        The XML metadata document that includes information about an identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samlMetadataDocument(String samlMetadataDocument);

        /**
         * <p>
         * The date and time when the SAML provider was created.
         * </p>
         * 
         * @param createDate
         *        The date and time when the SAML provider was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);

        /**
         * <p>
         * The expiration date and time for the SAML provider.
         * </p>
         * 
         * @param validUntil
         *        The expiration date and time for the SAML provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validUntil(Instant validUntil);
    }

    static final class BuilderImpl extends IamResponse.BuilderImpl implements Builder {
        private String samlMetadataDocument;

        private Instant createDate;

        private Instant validUntil;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSamlProviderResponse model) {
            super(model);
            samlMetadataDocument(model.samlMetadataDocument);
            createDate(model.createDate);
            validUntil(model.validUntil);
        }

        public final String getSamlMetadataDocument() {
            return samlMetadataDocument;
        }

        @Override
        public final Builder samlMetadataDocument(String samlMetadataDocument) {
            this.samlMetadataDocument = samlMetadataDocument;
            return this;
        }

        public final void setSamlMetadataDocument(String samlMetadataDocument) {
            this.samlMetadataDocument = samlMetadataDocument;
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        public final Instant getValidUntil() {
            return validUntil;
        }

        @Override
        public final Builder validUntil(Instant validUntil) {
            this.validUntil = validUntil;
            return this;
        }

        public final void setValidUntil(Instant validUntil) {
            this.validUntil = validUntil;
        }

        @Override
        public GetSamlProviderResponse build() {
            return new GetSamlProviderResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
