/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a successful <a>GetPolicyVersion</a> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPolicyVersionResponse extends IamResponse implements
        ToCopyableBuilder<GetPolicyVersionResponse.Builder, GetPolicyVersionResponse> {
    private static final SdkField<PolicyVersion> POLICY_VERSION_FIELD = SdkField
            .<PolicyVersion> builder(MarshallingType.SDK_POJO).memberName("PolicyVersion")
            .getter(getter(GetPolicyVersionResponse::policyVersion)).setter(setter(Builder::policyVersion))
            .constructor(PolicyVersion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_VERSION_FIELD));

    private final PolicyVersion policyVersion;

    private GetPolicyVersionResponse(BuilderImpl builder) {
        super(builder);
        this.policyVersion = builder.policyVersion;
    }

    /**
     * <p>
     * A structure containing details about the policy version.
     * </p>
     * 
     * @return A structure containing details about the policy version.
     */
    public PolicyVersion policyVersion() {
        return policyVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(policyVersion());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPolicyVersionResponse)) {
            return false;
        }
        GetPolicyVersionResponse other = (GetPolicyVersionResponse) obj;
        return Objects.equals(policyVersion(), other.policyVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetPolicyVersionResponse").add("PolicyVersion", policyVersion()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PolicyVersion":
            return Optional.ofNullable(clazz.cast(policyVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetPolicyVersionResponse, T> g) {
        return obj -> g.apply((GetPolicyVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetPolicyVersionResponse> {
        /**
         * <p>
         * A structure containing details about the policy version.
         * </p>
         * 
         * @param policyVersion
         *        A structure containing details about the policy version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyVersion(PolicyVersion policyVersion);

        /**
         * <p>
         * A structure containing details about the policy version.
         * </p>
         * This is a convenience that creates an instance of the {@link PolicyVersion.Builder} avoiding the need to
         * create one manually via {@link PolicyVersion#builder()}.
         *
         * When the {@link Consumer} completes, {@link PolicyVersion.Builder#build()} is called immediately and its
         * result is passed to {@link #policyVersion(PolicyVersion)}.
         * 
         * @param policyVersion
         *        a consumer that will call methods on {@link PolicyVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #policyVersion(PolicyVersion)
         */
        default Builder policyVersion(Consumer<PolicyVersion.Builder> policyVersion) {
            return policyVersion(PolicyVersion.builder().applyMutation(policyVersion).build());
        }
    }

    static final class BuilderImpl extends IamResponse.BuilderImpl implements Builder {
        private PolicyVersion policyVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPolicyVersionResponse model) {
            super(model);
            policyVersion(model.policyVersion);
        }

        public final PolicyVersion.Builder getPolicyVersion() {
            return policyVersion != null ? policyVersion.toBuilder() : null;
        }

        @Override
        public final Builder policyVersion(PolicyVersion policyVersion) {
            this.policyVersion = policyVersion;
            return this;
        }

        public final void setPolicyVersion(PolicyVersion.BuilderImpl policyVersion) {
            this.policyVersion = policyVersion != null ? policyVersion.build() : null;
        }

        @Override
        public GetPolicyVersionResponse build() {
            return new GetPolicyVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
