/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a successful <a>GetLoginProfile</a> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLoginProfileResponse extends IamResponse implements
        ToCopyableBuilder<GetLoginProfileResponse.Builder, GetLoginProfileResponse> {
    private static final SdkField<LoginProfile> LOGIN_PROFILE_FIELD = SdkField.<LoginProfile> builder(MarshallingType.SDK_POJO)
            .memberName("LoginProfile").getter(getter(GetLoginProfileResponse::loginProfile))
            .setter(setter(Builder::loginProfile)).constructor(LoginProfile::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoginProfile").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGIN_PROFILE_FIELD));

    private final LoginProfile loginProfile;

    private GetLoginProfileResponse(BuilderImpl builder) {
        super(builder);
        this.loginProfile = builder.loginProfile;
    }

    /**
     * <p>
     * A structure containing the user name and password create date for the user.
     * </p>
     * 
     * @return A structure containing the user name and password create date for the user.
     */
    public LoginProfile loginProfile() {
        return loginProfile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(loginProfile());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLoginProfileResponse)) {
            return false;
        }
        GetLoginProfileResponse other = (GetLoginProfileResponse) obj;
        return Objects.equals(loginProfile(), other.loginProfile());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetLoginProfileResponse").add("LoginProfile", loginProfile()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LoginProfile":
            return Optional.ofNullable(clazz.cast(loginProfile()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLoginProfileResponse, T> g) {
        return obj -> g.apply((GetLoginProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetLoginProfileResponse> {
        /**
         * <p>
         * A structure containing the user name and password create date for the user.
         * </p>
         * 
         * @param loginProfile
         *        A structure containing the user name and password create date for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loginProfile(LoginProfile loginProfile);

        /**
         * <p>
         * A structure containing the user name and password create date for the user.
         * </p>
         * This is a convenience that creates an instance of the {@link LoginProfile.Builder} avoiding the need to
         * create one manually via {@link LoginProfile#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoginProfile.Builder#build()} is called immediately and its
         * result is passed to {@link #loginProfile(LoginProfile)}.
         * 
         * @param loginProfile
         *        a consumer that will call methods on {@link LoginProfile.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loginProfile(LoginProfile)
         */
        default Builder loginProfile(Consumer<LoginProfile.Builder> loginProfile) {
            return loginProfile(LoginProfile.builder().applyMutation(loginProfile).build());
        }
    }

    static final class BuilderImpl extends IamResponse.BuilderImpl implements Builder {
        private LoginProfile loginProfile;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLoginProfileResponse model) {
            super(model);
            loginProfile(model.loginProfile);
        }

        public final LoginProfile.Builder getLoginProfile() {
            return loginProfile != null ? loginProfile.toBuilder() : null;
        }

        @Override
        public final Builder loginProfile(LoginProfile loginProfile) {
            this.loginProfile = loginProfile;
            return this;
        }

        public final void setLoginProfile(LoginProfile.BuilderImpl loginProfile) {
            this.loginProfile = loginProfile != null ? loginProfile.build() : null;
        }

        @Override
        public GetLoginProfileResponse build() {
            return new GetLoginProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
