/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The reason that the service-linked role deletion failed.
 * </p>
 * <p>
 * This data type is used as a response element in the <a>GetServiceLinkedRoleDeletionStatus</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeletionTaskFailureReasonType implements SdkPojo, Serializable,
        ToCopyableBuilder<DeletionTaskFailureReasonType.Builder, DeletionTaskFailureReasonType> {
    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(DeletionTaskFailureReasonType::reason)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final SdkField<List<RoleUsageType>> ROLE_USAGE_LIST_FIELD = SdkField
            .<List<RoleUsageType>> builder(MarshallingType.LIST)
            .memberName("RoleUsageList")
            .getter(getter(DeletionTaskFailureReasonType::roleUsageList))
            .setter(setter(Builder::roleUsageList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleUsageList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RoleUsageType> builder(MarshallingType.SDK_POJO)
                                            .constructor(RoleUsageType::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASON_FIELD,
            ROLE_USAGE_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String reason;

    private final List<RoleUsageType> roleUsageList;

    private DeletionTaskFailureReasonType(BuilderImpl builder) {
        this.reason = builder.reason;
        this.roleUsageList = builder.roleUsageList;
    }

    /**
     * <p>
     * A short description of the reason that the service-linked role deletion failed.
     * </p>
     * 
     * @return A short description of the reason that the service-linked role deletion failed.
     */
    public String reason() {
        return reason;
    }

    /**
     * Returns true if the RoleUsageList property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRoleUsageList() {
        return roleUsageList != null && !(roleUsageList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects that contains details about the service-linked role deletion failure, if that information is
     * returned by the service. If the service-linked role has active sessions or if any resources that were used by the
     * role have not been deleted from the linked service, the role can't be deleted. This parameter includes a list of
     * the resources that are associated with the role and the Region in which the resources are being used.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRoleUsageList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of objects that contains details about the service-linked role deletion failure, if that
     *         information is returned by the service. If the service-linked role has active sessions or if any
     *         resources that were used by the role have not been deleted from the linked service, the role can't be
     *         deleted. This parameter includes a list of the resources that are associated with the role and the Region
     *         in which the resources are being used.
     */
    public List<RoleUsageType> roleUsageList() {
        return roleUsageList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reason());
        hashCode = 31 * hashCode + Objects.hashCode(roleUsageList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeletionTaskFailureReasonType)) {
            return false;
        }
        DeletionTaskFailureReasonType other = (DeletionTaskFailureReasonType) obj;
        return Objects.equals(reason(), other.reason()) && Objects.equals(roleUsageList(), other.roleUsageList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeletionTaskFailureReasonType").add("Reason", reason()).add("RoleUsageList", roleUsageList())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Reason":
            return Optional.ofNullable(clazz.cast(reason()));
        case "RoleUsageList":
            return Optional.ofNullable(clazz.cast(roleUsageList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeletionTaskFailureReasonType, T> g) {
        return obj -> g.apply((DeletionTaskFailureReasonType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeletionTaskFailureReasonType> {
        /**
         * <p>
         * A short description of the reason that the service-linked role deletion failed.
         * </p>
         * 
         * @param reason
         *        A short description of the reason that the service-linked role deletion failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reason(String reason);

        /**
         * <p>
         * A list of objects that contains details about the service-linked role deletion failure, if that information
         * is returned by the service. If the service-linked role has active sessions or if any resources that were used
         * by the role have not been deleted from the linked service, the role can't be deleted. This parameter includes
         * a list of the resources that are associated with the role and the Region in which the resources are being
         * used.
         * </p>
         * 
         * @param roleUsageList
         *        A list of objects that contains details about the service-linked role deletion failure, if that
         *        information is returned by the service. If the service-linked role has active sessions or if any
         *        resources that were used by the role have not been deleted from the linked service, the role can't be
         *        deleted. This parameter includes a list of the resources that are associated with the role and the
         *        Region in which the resources are being used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleUsageList(Collection<RoleUsageType> roleUsageList);

        /**
         * <p>
         * A list of objects that contains details about the service-linked role deletion failure, if that information
         * is returned by the service. If the service-linked role has active sessions or if any resources that were used
         * by the role have not been deleted from the linked service, the role can't be deleted. This parameter includes
         * a list of the resources that are associated with the role and the Region in which the resources are being
         * used.
         * </p>
         * 
         * @param roleUsageList
         *        A list of objects that contains details about the service-linked role deletion failure, if that
         *        information is returned by the service. If the service-linked role has active sessions or if any
         *        resources that were used by the role have not been deleted from the linked service, the role can't be
         *        deleted. This parameter includes a list of the resources that are associated with the role and the
         *        Region in which the resources are being used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleUsageList(RoleUsageType... roleUsageList);

        /**
         * <p>
         * A list of objects that contains details about the service-linked role deletion failure, if that information
         * is returned by the service. If the service-linked role has active sessions or if any resources that were used
         * by the role have not been deleted from the linked service, the role can't be deleted. This parameter includes
         * a list of the resources that are associated with the role and the Region in which the resources are being
         * used.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RoleUsageType>.Builder} avoiding the need
         * to create one manually via {@link List<RoleUsageType>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RoleUsageType>.Builder#build()} is called immediately and
         * its result is passed to {@link #roleUsageList(List<RoleUsageType>)}.
         * 
         * @param roleUsageList
         *        a consumer that will call methods on {@link List<RoleUsageType>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #roleUsageList(List<RoleUsageType>)
         */
        Builder roleUsageList(Consumer<RoleUsageType.Builder>... roleUsageList);
    }

    static final class BuilderImpl implements Builder {
        private String reason;

        private List<RoleUsageType> roleUsageList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeletionTaskFailureReasonType model) {
            reason(model.reason);
            roleUsageList(model.roleUsageList);
        }

        public final String getReason() {
            return reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        public final Collection<RoleUsageType.Builder> getRoleUsageList() {
            return roleUsageList != null ? roleUsageList.stream().map(RoleUsageType::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder roleUsageList(Collection<RoleUsageType> roleUsageList) {
            this.roleUsageList = RoleUsageListTypeCopier.copy(roleUsageList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roleUsageList(RoleUsageType... roleUsageList) {
            roleUsageList(Arrays.asList(roleUsageList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder roleUsageList(Consumer<RoleUsageType.Builder>... roleUsageList) {
            roleUsageList(Stream.of(roleUsageList).map(c -> RoleUsageType.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRoleUsageList(Collection<RoleUsageType.BuilderImpl> roleUsageList) {
            this.roleUsageList = RoleUsageListTypeCopier.copyFromBuilder(roleUsageList);
        }

        @Override
        public DeletionTaskFailureReasonType build() {
            return new DeletionTaskFailureReasonType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
