/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteServiceSpecificCredentialRequest extends IamRequest implements
        ToCopyableBuilder<DeleteServiceSpecificCredentialRequest.Builder, DeleteServiceSpecificCredentialRequest> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(DeleteServiceSpecificCredentialRequest::userName))
            .setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> SERVICE_SPECIFIC_CREDENTIAL_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ServiceSpecificCredentialId")
            .getter(getter(DeleteServiceSpecificCredentialRequest::serviceSpecificCredentialId))
            .setter(setter(Builder::serviceSpecificCredentialId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceSpecificCredentialId")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD,
            SERVICE_SPECIFIC_CREDENTIAL_ID_FIELD));

    private final String userName;

    private final String serviceSpecificCredentialId;

    private DeleteServiceSpecificCredentialRequest(BuilderImpl builder) {
        super(builder);
        this.userName = builder.userName;
        this.serviceSpecificCredentialId = builder.serviceSpecificCredentialId;
    }

    /**
     * <p>
     * The name of the IAM user associated with the service-specific credential. If this value is not specified, then
     * the operation assumes the user whose credentials are used to call the operation.
     * </p>
     * <p>
     * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
     * characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of
     * the following characters: _+=,.@-
     * </p>
     * 
     * @return The name of the IAM user associated with the service-specific credential. If this value is not specified,
     *         then the operation assumes the user whose credentials are used to call the operation.</p>
     *         <p>
     *         This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string
     *         of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also
     *         include any of the following characters: _+=,.@-
     */
    public String userName() {
        return userName;
    }

    /**
     * <p>
     * The unique identifier of the service-specific credential. You can get this value by calling
     * <a>ListServiceSpecificCredentials</a>.
     * </p>
     * <p>
     * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
     * characters that can consist of any upper or lowercased letter or digit.
     * </p>
     * 
     * @return The unique identifier of the service-specific credential. You can get this value by calling
     *         <a>ListServiceSpecificCredentials</a>.</p>
     *         <p>
     *         This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string
     *         of characters that can consist of any upper or lowercased letter or digit.
     */
    public String serviceSpecificCredentialId() {
        return serviceSpecificCredentialId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(serviceSpecificCredentialId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteServiceSpecificCredentialRequest)) {
            return false;
        }
        DeleteServiceSpecificCredentialRequest other = (DeleteServiceSpecificCredentialRequest) obj;
        return Objects.equals(userName(), other.userName())
                && Objects.equals(serviceSpecificCredentialId(), other.serviceSpecificCredentialId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteServiceSpecificCredentialRequest").add("UserName", userName())
                .add("ServiceSpecificCredentialId", serviceSpecificCredentialId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "ServiceSpecificCredentialId":
            return Optional.ofNullable(clazz.cast(serviceSpecificCredentialId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteServiceSpecificCredentialRequest, T> g) {
        return obj -> g.apply((DeleteServiceSpecificCredentialRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteServiceSpecificCredentialRequest> {
        /**
         * <p>
         * The name of the IAM user associated with the service-specific credential. If this value is not specified,
         * then the operation assumes the user whose credentials are used to call the operation.
         * </p>
         * <p>
         * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
         * characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any
         * of the following characters: _+=,.@-
         * </p>
         * 
         * @param userName
         *        The name of the IAM user associated with the service-specific credential. If this value is not
         *        specified, then the operation assumes the user whose credentials are used to call the operation.</p>
         *        <p>
         *        This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a
         *        string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can
         *        also include any of the following characters: _+=,.@-
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * The unique identifier of the service-specific credential. You can get this value by calling
         * <a>ListServiceSpecificCredentials</a>.
         * </p>
         * <p>
         * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
         * characters that can consist of any upper or lowercased letter or digit.
         * </p>
         * 
         * @param serviceSpecificCredentialId
         *        The unique identifier of the service-specific credential. You can get this value by calling
         *        <a>ListServiceSpecificCredentials</a>.</p>
         *        <p>
         *        This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a
         *        string of characters that can consist of any upper or lowercased letter or digit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceSpecificCredentialId(String serviceSpecificCredentialId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private String userName;

        private String serviceSpecificCredentialId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteServiceSpecificCredentialRequest model) {
            super(model);
            userName(model.userName);
            serviceSpecificCredentialId(model.serviceSpecificCredentialId);
        }

        public final String getUserName() {
            return userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getServiceSpecificCredentialId() {
            return serviceSpecificCredentialId;
        }

        @Override
        public final Builder serviceSpecificCredentialId(String serviceSpecificCredentialId) {
            this.serviceSpecificCredentialId = serviceSpecificCredentialId;
            return this;
        }

        public final void setServiceSpecificCredentialId(String serviceSpecificCredentialId) {
            this.serviceSpecificCredentialId = serviceSpecificCredentialId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteServiceSpecificCredentialRequest build() {
            return new DeleteServiceSpecificCredentialRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
