/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLoginProfileRequest extends IamRequest implements
        ToCopyableBuilder<CreateLoginProfileRequest.Builder, CreateLoginProfileRequest> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserName").getter(getter(CreateLoginProfileRequest::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Password").getter(getter(CreateLoginProfileRequest::password)).setter(setter(Builder::password))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Password").build()).build();

    private static final SdkField<Boolean> PASSWORD_RESET_REQUIRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PasswordResetRequired").getter(getter(CreateLoginProfileRequest::passwordResetRequired))
            .setter(setter(Builder::passwordResetRequired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PasswordResetRequired").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD,
            PASSWORD_FIELD, PASSWORD_RESET_REQUIRED_FIELD));

    private final String userName;

    private final String password;

    private final Boolean passwordResetRequired;

    private CreateLoginProfileRequest(BuilderImpl builder) {
        super(builder);
        this.userName = builder.userName;
        this.password = builder.password;
        this.passwordResetRequired = builder.passwordResetRequired;
    }

    /**
     * <p>
     * The name of the IAM user to create a password for. The user must already exist.
     * </p>
     * <p>
     * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
     * characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of
     * the following characters: _+=,.@-
     * </p>
     * 
     * @return The name of the IAM user to create a password for. The user must already exist.</p>
     *         <p>
     *         This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string
     *         of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also
     *         include any of the following characters: _+=,.@-
     */
    public String userName() {
        return userName;
    }

    /**
     * <p>
     * The new password for the user.
     * </p>
     * <p>
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a
     * string of characters. That string can include almost any printable ASCII character from the space (<code>\u0020</code>
     * ) through the end of the ASCII character range (<code>\u00FF</code>). You can also include the tab (
     * <code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>) characters. Any
     * of these characters are valid in a password. However, many tools, such as the AWS Management Console, might
     * restrict the ability to type certain characters because they have special meaning within that tool.
     * </p>
     * 
     * @return The new password for the user.</p>
     *         <p>
     *         The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter
     *         is a string of characters. That string can include almost any printable ASCII character from the space (
     *         <code>\u0020</code>) through the end of the ASCII character range (<code>\u00FF</code>). You can also
     *         include the tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>
     *         ) characters. Any of these characters are valid in a password. However, many tools, such as the AWS
     *         Management Console, might restrict the ability to type certain characters because they have special
     *         meaning within that tool.
     */
    public String password() {
        return password;
    }

    /**
     * <p>
     * Specifies whether the user is required to set a new password on next sign-in.
     * </p>
     * 
     * @return Specifies whether the user is required to set a new password on next sign-in.
     */
    public Boolean passwordResetRequired() {
        return passwordResetRequired;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(password());
        hashCode = 31 * hashCode + Objects.hashCode(passwordResetRequired());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLoginProfileRequest)) {
            return false;
        }
        CreateLoginProfileRequest other = (CreateLoginProfileRequest) obj;
        return Objects.equals(userName(), other.userName()) && Objects.equals(password(), other.password())
                && Objects.equals(passwordResetRequired(), other.passwordResetRequired());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateLoginProfileRequest").add("UserName", userName())
                .add("Password", password() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PasswordResetRequired", passwordResetRequired()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "Password":
            return Optional.ofNullable(clazz.cast(password()));
        case "PasswordResetRequired":
            return Optional.ofNullable(clazz.cast(passwordResetRequired()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateLoginProfileRequest, T> g) {
        return obj -> g.apply((CreateLoginProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateLoginProfileRequest> {
        /**
         * <p>
         * The name of the IAM user to create a password for. The user must already exist.
         * </p>
         * <p>
         * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
         * characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any
         * of the following characters: _+=,.@-
         * </p>
         * 
         * @param userName
         *        The name of the IAM user to create a password for. The user must already exist.</p>
         *        <p>
         *        This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a
         *        string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can
         *        also include any of the following characters: _+=,.@-
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * The new password for the user.
         * </p>
         * <p>
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this parameter is a
         * string of characters. That string can include almost any printable ASCII character from the space (
         * <code>\u0020</code>) through the end of the ASCII character range (<code>\u00FF</code>). You can also include
         * the tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>)
         * characters. Any of these characters are valid in a password. However, many tools, such as the AWS Management
         * Console, might restrict the ability to type certain characters because they have special meaning within that
         * tool.
         * </p>
         * 
         * @param password
         *        The new password for the user.</p>
         *        <p>
         *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> that is used to validate this
         *        parameter is a string of characters. That string can include almost any printable ASCII character from
         *        the space (<code>\u0020</code>) through the end of the ASCII character range (<code>\u00FF</code>).
         *        You can also include the tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage
         *        return (<code>\u000D</code>) characters. Any of these characters are valid in a password. However,
         *        many tools, such as the AWS Management Console, might restrict the ability to type certain characters
         *        because they have special meaning within that tool.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder password(String password);

        /**
         * <p>
         * Specifies whether the user is required to set a new password on next sign-in.
         * </p>
         * 
         * @param passwordResetRequired
         *        Specifies whether the user is required to set a new password on next sign-in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder passwordResetRequired(Boolean passwordResetRequired);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private String userName;

        private String password;

        private Boolean passwordResetRequired;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLoginProfileRequest model) {
            super(model);
            userName(model.userName);
            password(model.password);
            passwordResetRequired(model.passwordResetRequired);
        }

        public final String getUserName() {
            return userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getPassword() {
            return password;
        }

        @Override
        public final Builder password(String password) {
            this.password = password;
            return this;
        }

        public final void setPassword(String password) {
            this.password = password;
        }

        public final Boolean getPasswordResetRequired() {
            return passwordResetRequired;
        }

        @Override
        public final Builder passwordResetRequired(Boolean passwordResetRequired) {
            this.passwordResetRequired = passwordResetRequired;
            return this;
        }

        public final void setPasswordResetRequired(Boolean passwordResetRequired) {
            this.passwordResetRequired = passwordResetRequired;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLoginProfileRequest build() {
            return new CreateLoginProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
