/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.iam.model.AddClientIdToOpenIdConnectProviderRequest;
import software.amazon.awssdk.services.iam.model.AddClientIdToOpenIdConnectProviderResponse;
import software.amazon.awssdk.services.iam.model.AddRoleToInstanceProfileRequest;
import software.amazon.awssdk.services.iam.model.AddRoleToInstanceProfileResponse;
import software.amazon.awssdk.services.iam.model.AddUserToGroupRequest;
import software.amazon.awssdk.services.iam.model.AddUserToGroupResponse;
import software.amazon.awssdk.services.iam.model.AttachGroupPolicyRequest;
import software.amazon.awssdk.services.iam.model.AttachGroupPolicyResponse;
import software.amazon.awssdk.services.iam.model.AttachRolePolicyRequest;
import software.amazon.awssdk.services.iam.model.AttachRolePolicyResponse;
import software.amazon.awssdk.services.iam.model.AttachUserPolicyRequest;
import software.amazon.awssdk.services.iam.model.AttachUserPolicyResponse;
import software.amazon.awssdk.services.iam.model.ChangePasswordRequest;
import software.amazon.awssdk.services.iam.model.ChangePasswordResponse;
import software.amazon.awssdk.services.iam.model.ConcurrentModificationException;
import software.amazon.awssdk.services.iam.model.CreateAccessKeyRequest;
import software.amazon.awssdk.services.iam.model.CreateAccessKeyResponse;
import software.amazon.awssdk.services.iam.model.CreateAccountAliasRequest;
import software.amazon.awssdk.services.iam.model.CreateAccountAliasResponse;
import software.amazon.awssdk.services.iam.model.CreateGroupRequest;
import software.amazon.awssdk.services.iam.model.CreateGroupResponse;
import software.amazon.awssdk.services.iam.model.CreateInstanceProfileRequest;
import software.amazon.awssdk.services.iam.model.CreateInstanceProfileResponse;
import software.amazon.awssdk.services.iam.model.CreateLoginProfileRequest;
import software.amazon.awssdk.services.iam.model.CreateLoginProfileResponse;
import software.amazon.awssdk.services.iam.model.CreateOpenIdConnectProviderRequest;
import software.amazon.awssdk.services.iam.model.CreateOpenIdConnectProviderResponse;
import software.amazon.awssdk.services.iam.model.CreatePolicyRequest;
import software.amazon.awssdk.services.iam.model.CreatePolicyResponse;
import software.amazon.awssdk.services.iam.model.CreatePolicyVersionRequest;
import software.amazon.awssdk.services.iam.model.CreatePolicyVersionResponse;
import software.amazon.awssdk.services.iam.model.CreateRoleRequest;
import software.amazon.awssdk.services.iam.model.CreateRoleResponse;
import software.amazon.awssdk.services.iam.model.CreateSamlProviderRequest;
import software.amazon.awssdk.services.iam.model.CreateSamlProviderResponse;
import software.amazon.awssdk.services.iam.model.CreateServiceLinkedRoleRequest;
import software.amazon.awssdk.services.iam.model.CreateServiceLinkedRoleResponse;
import software.amazon.awssdk.services.iam.model.CreateServiceSpecificCredentialRequest;
import software.amazon.awssdk.services.iam.model.CreateServiceSpecificCredentialResponse;
import software.amazon.awssdk.services.iam.model.CreateUserRequest;
import software.amazon.awssdk.services.iam.model.CreateUserResponse;
import software.amazon.awssdk.services.iam.model.CreateVirtualMfaDeviceRequest;
import software.amazon.awssdk.services.iam.model.CreateVirtualMfaDeviceResponse;
import software.amazon.awssdk.services.iam.model.CredentialReportExpiredException;
import software.amazon.awssdk.services.iam.model.CredentialReportNotPresentException;
import software.amazon.awssdk.services.iam.model.CredentialReportNotReadyException;
import software.amazon.awssdk.services.iam.model.DeactivateMfaDeviceRequest;
import software.amazon.awssdk.services.iam.model.DeactivateMfaDeviceResponse;
import software.amazon.awssdk.services.iam.model.DeleteAccessKeyRequest;
import software.amazon.awssdk.services.iam.model.DeleteAccessKeyResponse;
import software.amazon.awssdk.services.iam.model.DeleteAccountAliasRequest;
import software.amazon.awssdk.services.iam.model.DeleteAccountAliasResponse;
import software.amazon.awssdk.services.iam.model.DeleteAccountPasswordPolicyRequest;
import software.amazon.awssdk.services.iam.model.DeleteAccountPasswordPolicyResponse;
import software.amazon.awssdk.services.iam.model.DeleteConflictException;
import software.amazon.awssdk.services.iam.model.DeleteGroupPolicyRequest;
import software.amazon.awssdk.services.iam.model.DeleteGroupPolicyResponse;
import software.amazon.awssdk.services.iam.model.DeleteGroupRequest;
import software.amazon.awssdk.services.iam.model.DeleteGroupResponse;
import software.amazon.awssdk.services.iam.model.DeleteInstanceProfileRequest;
import software.amazon.awssdk.services.iam.model.DeleteInstanceProfileResponse;
import software.amazon.awssdk.services.iam.model.DeleteLoginProfileRequest;
import software.amazon.awssdk.services.iam.model.DeleteLoginProfileResponse;
import software.amazon.awssdk.services.iam.model.DeleteOpenIdConnectProviderRequest;
import software.amazon.awssdk.services.iam.model.DeleteOpenIdConnectProviderResponse;
import software.amazon.awssdk.services.iam.model.DeletePolicyRequest;
import software.amazon.awssdk.services.iam.model.DeletePolicyResponse;
import software.amazon.awssdk.services.iam.model.DeletePolicyVersionRequest;
import software.amazon.awssdk.services.iam.model.DeletePolicyVersionResponse;
import software.amazon.awssdk.services.iam.model.DeleteRolePermissionsBoundaryRequest;
import software.amazon.awssdk.services.iam.model.DeleteRolePermissionsBoundaryResponse;
import software.amazon.awssdk.services.iam.model.DeleteRolePolicyRequest;
import software.amazon.awssdk.services.iam.model.DeleteRolePolicyResponse;
import software.amazon.awssdk.services.iam.model.DeleteRoleRequest;
import software.amazon.awssdk.services.iam.model.DeleteRoleResponse;
import software.amazon.awssdk.services.iam.model.DeleteSamlProviderRequest;
import software.amazon.awssdk.services.iam.model.DeleteSamlProviderResponse;
import software.amazon.awssdk.services.iam.model.DeleteServerCertificateRequest;
import software.amazon.awssdk.services.iam.model.DeleteServerCertificateResponse;
import software.amazon.awssdk.services.iam.model.DeleteServiceLinkedRoleRequest;
import software.amazon.awssdk.services.iam.model.DeleteServiceLinkedRoleResponse;
import software.amazon.awssdk.services.iam.model.DeleteServiceSpecificCredentialRequest;
import software.amazon.awssdk.services.iam.model.DeleteServiceSpecificCredentialResponse;
import software.amazon.awssdk.services.iam.model.DeleteSigningCertificateRequest;
import software.amazon.awssdk.services.iam.model.DeleteSigningCertificateResponse;
import software.amazon.awssdk.services.iam.model.DeleteSshPublicKeyRequest;
import software.amazon.awssdk.services.iam.model.DeleteSshPublicKeyResponse;
import software.amazon.awssdk.services.iam.model.DeleteUserPermissionsBoundaryRequest;
import software.amazon.awssdk.services.iam.model.DeleteUserPermissionsBoundaryResponse;
import software.amazon.awssdk.services.iam.model.DeleteUserPolicyRequest;
import software.amazon.awssdk.services.iam.model.DeleteUserPolicyResponse;
import software.amazon.awssdk.services.iam.model.DeleteUserRequest;
import software.amazon.awssdk.services.iam.model.DeleteUserResponse;
import software.amazon.awssdk.services.iam.model.DeleteVirtualMfaDeviceRequest;
import software.amazon.awssdk.services.iam.model.DeleteVirtualMfaDeviceResponse;
import software.amazon.awssdk.services.iam.model.DetachGroupPolicyRequest;
import software.amazon.awssdk.services.iam.model.DetachGroupPolicyResponse;
import software.amazon.awssdk.services.iam.model.DetachRolePolicyRequest;
import software.amazon.awssdk.services.iam.model.DetachRolePolicyResponse;
import software.amazon.awssdk.services.iam.model.DetachUserPolicyRequest;
import software.amazon.awssdk.services.iam.model.DetachUserPolicyResponse;
import software.amazon.awssdk.services.iam.model.DuplicateCertificateException;
import software.amazon.awssdk.services.iam.model.DuplicateSshPublicKeyException;
import software.amazon.awssdk.services.iam.model.EnableMfaDeviceRequest;
import software.amazon.awssdk.services.iam.model.EnableMfaDeviceResponse;
import software.amazon.awssdk.services.iam.model.EntityAlreadyExistsException;
import software.amazon.awssdk.services.iam.model.EntityTemporarilyUnmodifiableException;
import software.amazon.awssdk.services.iam.model.GenerateCredentialReportRequest;
import software.amazon.awssdk.services.iam.model.GenerateCredentialReportResponse;
import software.amazon.awssdk.services.iam.model.GenerateOrganizationsAccessReportRequest;
import software.amazon.awssdk.services.iam.model.GenerateOrganizationsAccessReportResponse;
import software.amazon.awssdk.services.iam.model.GenerateServiceLastAccessedDetailsRequest;
import software.amazon.awssdk.services.iam.model.GenerateServiceLastAccessedDetailsResponse;
import software.amazon.awssdk.services.iam.model.GetAccessKeyLastUsedRequest;
import software.amazon.awssdk.services.iam.model.GetAccessKeyLastUsedResponse;
import software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest;
import software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsResponse;
import software.amazon.awssdk.services.iam.model.GetAccountPasswordPolicyRequest;
import software.amazon.awssdk.services.iam.model.GetAccountPasswordPolicyResponse;
import software.amazon.awssdk.services.iam.model.GetAccountSummaryRequest;
import software.amazon.awssdk.services.iam.model.GetAccountSummaryResponse;
import software.amazon.awssdk.services.iam.model.GetContextKeysForCustomPolicyRequest;
import software.amazon.awssdk.services.iam.model.GetContextKeysForCustomPolicyResponse;
import software.amazon.awssdk.services.iam.model.GetContextKeysForPrincipalPolicyRequest;
import software.amazon.awssdk.services.iam.model.GetContextKeysForPrincipalPolicyResponse;
import software.amazon.awssdk.services.iam.model.GetCredentialReportRequest;
import software.amazon.awssdk.services.iam.model.GetCredentialReportResponse;
import software.amazon.awssdk.services.iam.model.GetGroupPolicyRequest;
import software.amazon.awssdk.services.iam.model.GetGroupPolicyResponse;
import software.amazon.awssdk.services.iam.model.GetGroupRequest;
import software.amazon.awssdk.services.iam.model.GetGroupResponse;
import software.amazon.awssdk.services.iam.model.GetInstanceProfileRequest;
import software.amazon.awssdk.services.iam.model.GetInstanceProfileResponse;
import software.amazon.awssdk.services.iam.model.GetLoginProfileRequest;
import software.amazon.awssdk.services.iam.model.GetLoginProfileResponse;
import software.amazon.awssdk.services.iam.model.GetOpenIdConnectProviderRequest;
import software.amazon.awssdk.services.iam.model.GetOpenIdConnectProviderResponse;
import software.amazon.awssdk.services.iam.model.GetOrganizationsAccessReportRequest;
import software.amazon.awssdk.services.iam.model.GetOrganizationsAccessReportResponse;
import software.amazon.awssdk.services.iam.model.GetPolicyRequest;
import software.amazon.awssdk.services.iam.model.GetPolicyResponse;
import software.amazon.awssdk.services.iam.model.GetPolicyVersionRequest;
import software.amazon.awssdk.services.iam.model.GetPolicyVersionResponse;
import software.amazon.awssdk.services.iam.model.GetRolePolicyRequest;
import software.amazon.awssdk.services.iam.model.GetRolePolicyResponse;
import software.amazon.awssdk.services.iam.model.GetRoleRequest;
import software.amazon.awssdk.services.iam.model.GetRoleResponse;
import software.amazon.awssdk.services.iam.model.GetSamlProviderRequest;
import software.amazon.awssdk.services.iam.model.GetSamlProviderResponse;
import software.amazon.awssdk.services.iam.model.GetServerCertificateRequest;
import software.amazon.awssdk.services.iam.model.GetServerCertificateResponse;
import software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsRequest;
import software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsResponse;
import software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsWithEntitiesRequest;
import software.amazon.awssdk.services.iam.model.GetServiceLastAccessedDetailsWithEntitiesResponse;
import software.amazon.awssdk.services.iam.model.GetServiceLinkedRoleDeletionStatusRequest;
import software.amazon.awssdk.services.iam.model.GetServiceLinkedRoleDeletionStatusResponse;
import software.amazon.awssdk.services.iam.model.GetSshPublicKeyRequest;
import software.amazon.awssdk.services.iam.model.GetSshPublicKeyResponse;
import software.amazon.awssdk.services.iam.model.GetUserPolicyRequest;
import software.amazon.awssdk.services.iam.model.GetUserPolicyResponse;
import software.amazon.awssdk.services.iam.model.GetUserRequest;
import software.amazon.awssdk.services.iam.model.GetUserResponse;
import software.amazon.awssdk.services.iam.model.IamException;
import software.amazon.awssdk.services.iam.model.IamRequest;
import software.amazon.awssdk.services.iam.model.InvalidAuthenticationCodeException;
import software.amazon.awssdk.services.iam.model.InvalidCertificateException;
import software.amazon.awssdk.services.iam.model.InvalidInputException;
import software.amazon.awssdk.services.iam.model.InvalidPublicKeyException;
import software.amazon.awssdk.services.iam.model.InvalidUserTypeException;
import software.amazon.awssdk.services.iam.model.KeyPairMismatchException;
import software.amazon.awssdk.services.iam.model.LimitExceededException;
import software.amazon.awssdk.services.iam.model.ListAccessKeysRequest;
import software.amazon.awssdk.services.iam.model.ListAccessKeysResponse;
import software.amazon.awssdk.services.iam.model.ListAccountAliasesRequest;
import software.amazon.awssdk.services.iam.model.ListAccountAliasesResponse;
import software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesResponse;
import software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesResponse;
import software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesResponse;
import software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyRequest;
import software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyResponse;
import software.amazon.awssdk.services.iam.model.ListGroupPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListGroupPoliciesResponse;
import software.amazon.awssdk.services.iam.model.ListGroupsForUserRequest;
import software.amazon.awssdk.services.iam.model.ListGroupsForUserResponse;
import software.amazon.awssdk.services.iam.model.ListGroupsRequest;
import software.amazon.awssdk.services.iam.model.ListGroupsResponse;
import software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleRequest;
import software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleResponse;
import software.amazon.awssdk.services.iam.model.ListInstanceProfilesRequest;
import software.amazon.awssdk.services.iam.model.ListInstanceProfilesResponse;
import software.amazon.awssdk.services.iam.model.ListMfaDevicesRequest;
import software.amazon.awssdk.services.iam.model.ListMfaDevicesResponse;
import software.amazon.awssdk.services.iam.model.ListOpenIdConnectProvidersRequest;
import software.amazon.awssdk.services.iam.model.ListOpenIdConnectProvidersResponse;
import software.amazon.awssdk.services.iam.model.ListPoliciesGrantingServiceAccessRequest;
import software.amazon.awssdk.services.iam.model.ListPoliciesGrantingServiceAccessResponse;
import software.amazon.awssdk.services.iam.model.ListPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListPoliciesResponse;
import software.amazon.awssdk.services.iam.model.ListPolicyVersionsRequest;
import software.amazon.awssdk.services.iam.model.ListPolicyVersionsResponse;
import software.amazon.awssdk.services.iam.model.ListRolePoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListRolePoliciesResponse;
import software.amazon.awssdk.services.iam.model.ListRoleTagsRequest;
import software.amazon.awssdk.services.iam.model.ListRoleTagsResponse;
import software.amazon.awssdk.services.iam.model.ListRolesRequest;
import software.amazon.awssdk.services.iam.model.ListRolesResponse;
import software.amazon.awssdk.services.iam.model.ListSamlProvidersRequest;
import software.amazon.awssdk.services.iam.model.ListSamlProvidersResponse;
import software.amazon.awssdk.services.iam.model.ListServerCertificatesRequest;
import software.amazon.awssdk.services.iam.model.ListServerCertificatesResponse;
import software.amazon.awssdk.services.iam.model.ListServiceSpecificCredentialsRequest;
import software.amazon.awssdk.services.iam.model.ListServiceSpecificCredentialsResponse;
import software.amazon.awssdk.services.iam.model.ListSigningCertificatesRequest;
import software.amazon.awssdk.services.iam.model.ListSigningCertificatesResponse;
import software.amazon.awssdk.services.iam.model.ListSshPublicKeysRequest;
import software.amazon.awssdk.services.iam.model.ListSshPublicKeysResponse;
import software.amazon.awssdk.services.iam.model.ListUserPoliciesRequest;
import software.amazon.awssdk.services.iam.model.ListUserPoliciesResponse;
import software.amazon.awssdk.services.iam.model.ListUserTagsRequest;
import software.amazon.awssdk.services.iam.model.ListUserTagsResponse;
import software.amazon.awssdk.services.iam.model.ListUsersRequest;
import software.amazon.awssdk.services.iam.model.ListUsersResponse;
import software.amazon.awssdk.services.iam.model.ListVirtualMfaDevicesRequest;
import software.amazon.awssdk.services.iam.model.ListVirtualMfaDevicesResponse;
import software.amazon.awssdk.services.iam.model.MalformedCertificateException;
import software.amazon.awssdk.services.iam.model.MalformedPolicyDocumentException;
import software.amazon.awssdk.services.iam.model.NoSuchEntityException;
import software.amazon.awssdk.services.iam.model.PasswordPolicyViolationException;
import software.amazon.awssdk.services.iam.model.PolicyEvaluationException;
import software.amazon.awssdk.services.iam.model.PolicyNotAttachableException;
import software.amazon.awssdk.services.iam.model.PutGroupPolicyRequest;
import software.amazon.awssdk.services.iam.model.PutGroupPolicyResponse;
import software.amazon.awssdk.services.iam.model.PutRolePermissionsBoundaryRequest;
import software.amazon.awssdk.services.iam.model.PutRolePermissionsBoundaryResponse;
import software.amazon.awssdk.services.iam.model.PutRolePolicyRequest;
import software.amazon.awssdk.services.iam.model.PutRolePolicyResponse;
import software.amazon.awssdk.services.iam.model.PutUserPermissionsBoundaryRequest;
import software.amazon.awssdk.services.iam.model.PutUserPermissionsBoundaryResponse;
import software.amazon.awssdk.services.iam.model.PutUserPolicyRequest;
import software.amazon.awssdk.services.iam.model.PutUserPolicyResponse;
import software.amazon.awssdk.services.iam.model.RemoveClientIdFromOpenIdConnectProviderRequest;
import software.amazon.awssdk.services.iam.model.RemoveClientIdFromOpenIdConnectProviderResponse;
import software.amazon.awssdk.services.iam.model.RemoveRoleFromInstanceProfileRequest;
import software.amazon.awssdk.services.iam.model.RemoveRoleFromInstanceProfileResponse;
import software.amazon.awssdk.services.iam.model.RemoveUserFromGroupRequest;
import software.amazon.awssdk.services.iam.model.RemoveUserFromGroupResponse;
import software.amazon.awssdk.services.iam.model.ReportGenerationLimitExceededException;
import software.amazon.awssdk.services.iam.model.ResetServiceSpecificCredentialRequest;
import software.amazon.awssdk.services.iam.model.ResetServiceSpecificCredentialResponse;
import software.amazon.awssdk.services.iam.model.ResyncMfaDeviceRequest;
import software.amazon.awssdk.services.iam.model.ResyncMfaDeviceResponse;
import software.amazon.awssdk.services.iam.model.ServiceFailureException;
import software.amazon.awssdk.services.iam.model.ServiceNotSupportedException;
import software.amazon.awssdk.services.iam.model.SetDefaultPolicyVersionRequest;
import software.amazon.awssdk.services.iam.model.SetDefaultPolicyVersionResponse;
import software.amazon.awssdk.services.iam.model.SetSecurityTokenServicePreferencesRequest;
import software.amazon.awssdk.services.iam.model.SetSecurityTokenServicePreferencesResponse;
import software.amazon.awssdk.services.iam.model.SimulateCustomPolicyRequest;
import software.amazon.awssdk.services.iam.model.SimulateCustomPolicyResponse;
import software.amazon.awssdk.services.iam.model.SimulatePrincipalPolicyRequest;
import software.amazon.awssdk.services.iam.model.SimulatePrincipalPolicyResponse;
import software.amazon.awssdk.services.iam.model.TagRoleRequest;
import software.amazon.awssdk.services.iam.model.TagRoleResponse;
import software.amazon.awssdk.services.iam.model.TagUserRequest;
import software.amazon.awssdk.services.iam.model.TagUserResponse;
import software.amazon.awssdk.services.iam.model.UnmodifiableEntityException;
import software.amazon.awssdk.services.iam.model.UnrecognizedPublicKeyEncodingException;
import software.amazon.awssdk.services.iam.model.UntagRoleRequest;
import software.amazon.awssdk.services.iam.model.UntagRoleResponse;
import software.amazon.awssdk.services.iam.model.UntagUserRequest;
import software.amazon.awssdk.services.iam.model.UntagUserResponse;
import software.amazon.awssdk.services.iam.model.UpdateAccessKeyRequest;
import software.amazon.awssdk.services.iam.model.UpdateAccessKeyResponse;
import software.amazon.awssdk.services.iam.model.UpdateAccountPasswordPolicyRequest;
import software.amazon.awssdk.services.iam.model.UpdateAccountPasswordPolicyResponse;
import software.amazon.awssdk.services.iam.model.UpdateAssumeRolePolicyRequest;
import software.amazon.awssdk.services.iam.model.UpdateAssumeRolePolicyResponse;
import software.amazon.awssdk.services.iam.model.UpdateGroupRequest;
import software.amazon.awssdk.services.iam.model.UpdateGroupResponse;
import software.amazon.awssdk.services.iam.model.UpdateLoginProfileRequest;
import software.amazon.awssdk.services.iam.model.UpdateLoginProfileResponse;
import software.amazon.awssdk.services.iam.model.UpdateOpenIdConnectProviderThumbprintRequest;
import software.amazon.awssdk.services.iam.model.UpdateOpenIdConnectProviderThumbprintResponse;
import software.amazon.awssdk.services.iam.model.UpdateRoleDescriptionRequest;
import software.amazon.awssdk.services.iam.model.UpdateRoleDescriptionResponse;
import software.amazon.awssdk.services.iam.model.UpdateRoleRequest;
import software.amazon.awssdk.services.iam.model.UpdateRoleResponse;
import software.amazon.awssdk.services.iam.model.UpdateSamlProviderRequest;
import software.amazon.awssdk.services.iam.model.UpdateSamlProviderResponse;
import software.amazon.awssdk.services.iam.model.UpdateServerCertificateRequest;
import software.amazon.awssdk.services.iam.model.UpdateServerCertificateResponse;
import software.amazon.awssdk.services.iam.model.UpdateServiceSpecificCredentialRequest;
import software.amazon.awssdk.services.iam.model.UpdateServiceSpecificCredentialResponse;
import software.amazon.awssdk.services.iam.model.UpdateSigningCertificateRequest;
import software.amazon.awssdk.services.iam.model.UpdateSigningCertificateResponse;
import software.amazon.awssdk.services.iam.model.UpdateSshPublicKeyRequest;
import software.amazon.awssdk.services.iam.model.UpdateSshPublicKeyResponse;
import software.amazon.awssdk.services.iam.model.UpdateUserRequest;
import software.amazon.awssdk.services.iam.model.UpdateUserResponse;
import software.amazon.awssdk.services.iam.model.UploadServerCertificateRequest;
import software.amazon.awssdk.services.iam.model.UploadServerCertificateResponse;
import software.amazon.awssdk.services.iam.model.UploadSigningCertificateRequest;
import software.amazon.awssdk.services.iam.model.UploadSigningCertificateResponse;
import software.amazon.awssdk.services.iam.model.UploadSshPublicKeyRequest;
import software.amazon.awssdk.services.iam.model.UploadSshPublicKeyResponse;
import software.amazon.awssdk.services.iam.paginators.GetAccountAuthorizationDetailsIterable;
import software.amazon.awssdk.services.iam.paginators.GetGroupIterable;
import software.amazon.awssdk.services.iam.paginators.ListAccessKeysIterable;
import software.amazon.awssdk.services.iam.paginators.ListAccountAliasesIterable;
import software.amazon.awssdk.services.iam.paginators.ListAttachedGroupPoliciesIterable;
import software.amazon.awssdk.services.iam.paginators.ListAttachedRolePoliciesIterable;
import software.amazon.awssdk.services.iam.paginators.ListAttachedUserPoliciesIterable;
import software.amazon.awssdk.services.iam.paginators.ListEntitiesForPolicyIterable;
import software.amazon.awssdk.services.iam.paginators.ListGroupPoliciesIterable;
import software.amazon.awssdk.services.iam.paginators.ListGroupsForUserIterable;
import software.amazon.awssdk.services.iam.paginators.ListGroupsIterable;
import software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesForRoleIterable;
import software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesIterable;
import software.amazon.awssdk.services.iam.paginators.ListMFADevicesIterable;
import software.amazon.awssdk.services.iam.paginators.ListPoliciesIterable;
import software.amazon.awssdk.services.iam.paginators.ListPolicyVersionsIterable;
import software.amazon.awssdk.services.iam.paginators.ListRolePoliciesIterable;
import software.amazon.awssdk.services.iam.paginators.ListRolesIterable;
import software.amazon.awssdk.services.iam.paginators.ListSSHPublicKeysIterable;
import software.amazon.awssdk.services.iam.paginators.ListServerCertificatesIterable;
import software.amazon.awssdk.services.iam.paginators.ListSigningCertificatesIterable;
import software.amazon.awssdk.services.iam.paginators.ListUserPoliciesIterable;
import software.amazon.awssdk.services.iam.paginators.ListUsersIterable;
import software.amazon.awssdk.services.iam.paginators.ListVirtualMFADevicesIterable;
import software.amazon.awssdk.services.iam.paginators.SimulateCustomPolicyIterable;
import software.amazon.awssdk.services.iam.paginators.SimulatePrincipalPolicyIterable;
import software.amazon.awssdk.services.iam.transform.AddClientIdToOpenIdConnectProviderRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.AddRoleToInstanceProfileRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.AddUserToGroupRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.AttachGroupPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.AttachRolePolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.AttachUserPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ChangePasswordRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.CreateAccessKeyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.CreateAccountAliasRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.CreateGroupRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.CreateInstanceProfileRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.CreateLoginProfileRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.CreateOpenIdConnectProviderRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.CreatePolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.CreatePolicyVersionRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.CreateRoleRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.CreateSamlProviderRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.CreateServiceLinkedRoleRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.CreateServiceSpecificCredentialRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.CreateUserRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.CreateVirtualMfaDeviceRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeactivateMfaDeviceRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteAccessKeyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteAccountAliasRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteAccountPasswordPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteGroupPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteGroupRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteInstanceProfileRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteLoginProfileRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteOpenIdConnectProviderRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeletePolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeletePolicyVersionRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteRolePermissionsBoundaryRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteRolePolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteRoleRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteSamlProviderRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteServerCertificateRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteServiceLinkedRoleRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteServiceSpecificCredentialRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteSigningCertificateRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteSshPublicKeyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteUserPermissionsBoundaryRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteUserPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DeleteVirtualMfaDeviceRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DetachGroupPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DetachRolePolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.DetachUserPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.EnableMfaDeviceRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GenerateCredentialReportRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GenerateOrganizationsAccessReportRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GenerateServiceLastAccessedDetailsRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetAccessKeyLastUsedRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetAccountAuthorizationDetailsRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetAccountPasswordPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetAccountSummaryRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetContextKeysForCustomPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetContextKeysForPrincipalPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetCredentialReportRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetGroupPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetGroupRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetInstanceProfileRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetLoginProfileRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetOpenIdConnectProviderRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetOrganizationsAccessReportRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetPolicyVersionRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetRolePolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetRoleRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetSamlProviderRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetServerCertificateRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetServiceLastAccessedDetailsRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetServiceLastAccessedDetailsWithEntitiesRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetServiceLinkedRoleDeletionStatusRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetSshPublicKeyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetUserPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.GetUserRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListAccessKeysRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListAccountAliasesRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListAttachedGroupPoliciesRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListAttachedRolePoliciesRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListAttachedUserPoliciesRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListEntitiesForPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListGroupPoliciesRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListGroupsForUserRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListGroupsRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListInstanceProfilesForRoleRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListInstanceProfilesRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListMfaDevicesRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListOpenIdConnectProvidersRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListPoliciesGrantingServiceAccessRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListPoliciesRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListPolicyVersionsRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListRolePoliciesRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListRoleTagsRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListRolesRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListSamlProvidersRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListServerCertificatesRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListServiceSpecificCredentialsRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListSigningCertificatesRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListSshPublicKeysRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListUserPoliciesRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListUserTagsRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListUsersRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ListVirtualMfaDevicesRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.PutGroupPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.PutRolePermissionsBoundaryRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.PutRolePolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.PutUserPermissionsBoundaryRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.PutUserPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.RemoveClientIdFromOpenIdConnectProviderRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.RemoveRoleFromInstanceProfileRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.RemoveUserFromGroupRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ResetServiceSpecificCredentialRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.ResyncMfaDeviceRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.SetDefaultPolicyVersionRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.SetSecurityTokenServicePreferencesRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.SimulateCustomPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.SimulatePrincipalPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.TagRoleRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.TagUserRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UntagRoleRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UntagUserRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UpdateAccessKeyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UpdateAccountPasswordPolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UpdateAssumeRolePolicyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UpdateGroupRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UpdateLoginProfileRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UpdateOpenIdConnectProviderThumbprintRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UpdateRoleDescriptionRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UpdateRoleRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UpdateSamlProviderRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UpdateServerCertificateRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UpdateServiceSpecificCredentialRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UpdateSigningCertificateRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UpdateSshPublicKeyRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UpdateUserRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UploadServerCertificateRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UploadSigningCertificateRequestMarshaller;
import software.amazon.awssdk.services.iam.transform.UploadSshPublicKeyRequestMarshaller;
import software.amazon.awssdk.services.iam.waiters.IamWaiter;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link IamClient}.
 *
 * @see IamClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultIamClient implements IamClient {
    private static final Logger log = Logger.loggerFor(DefaultIamClient.class);

    private final SyncClientHandler clientHandler;

    private final AwsQueryProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultIamClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Adds a new client ID (also known as audience) to the list of client IDs already registered for the specified IAM
     * OpenID Connect (OIDC) provider resource.
     * </p>
     * <p>
     * This operation is idempotent; it does not fail or return an error if you add an existing client ID to the
     * provider.
     * </p>
     *
     * @param addClientIdToOpenIdConnectProviderRequest
     * @return Result of the AddClientIDToOpenIDConnectProvider operation returned by the service.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.AddClientIDToOpenIDConnectProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AddClientIDToOpenIDConnectProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AddClientIdToOpenIdConnectProviderResponse addClientIDToOpenIDConnectProvider(
            AddClientIdToOpenIdConnectProviderRequest addClientIdToOpenIdConnectProviderRequest) throws InvalidInputException,
            NoSuchEntityException, LimitExceededException, ServiceFailureException, AwsServiceException, SdkClientException,
            IamException {

        HttpResponseHandler<AddClientIdToOpenIdConnectProviderResponse> responseHandler = protocolFactory
                .createResponseHandler(AddClientIdToOpenIdConnectProviderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                addClientIdToOpenIdConnectProviderRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddClientIDToOpenIDConnectProvider");

            return clientHandler
                    .execute(new ClientExecutionParams<AddClientIdToOpenIdConnectProviderRequest, AddClientIdToOpenIdConnectProviderResponse>()
                            .withOperationName("AddClientIDToOpenIDConnectProvider").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(addClientIdToOpenIdConnectProviderRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AddClientIdToOpenIdConnectProviderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds the specified IAM role to the specified instance profile. An instance profile can contain only one role.
     * (The number and size of IAM resources in an AWS account are limited. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS Quotas</a> in the
     * <i>IAM User Guide</i>.) You can remove the existing role and then add a different role to an instance profile.
     * You must then wait for the change to appear across all of AWS because of <a
     * href="https://en.wikipedia.org/wiki/Eventual_consistency">eventual consistency</a>. To force the change, you must
     * <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateIamInstanceProfile.html">
     * disassociate the instance profile</a> and then <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateIamInstanceProfile.html">associate the
     * instance profile</a>, or you can stop your instance and then restart it.
     * </p>
     * <note>
     * <p>
     * The caller of this API must be granted the <code>PassRole</code> permission on the IAM role by a permissions
     * policy.
     * </p>
     * </note>
     * <p>
     * For more information about roles, go to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with Roles</a>. For more
     * information about instance profiles, go to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About Instance Profiles</a>.
     * </p>
     *
     * @param addRoleToInstanceProfileRequest
     * @return Result of the AddRoleToInstanceProfile operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws UnmodifiableEntityException
     *         The request was rejected because only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.AddRoleToInstanceProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AddRoleToInstanceProfile" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public AddRoleToInstanceProfileResponse addRoleToInstanceProfile(
            AddRoleToInstanceProfileRequest addRoleToInstanceProfileRequest) throws NoSuchEntityException,
            EntityAlreadyExistsException, LimitExceededException, UnmodifiableEntityException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<AddRoleToInstanceProfileResponse> responseHandler = protocolFactory
                .createResponseHandler(AddRoleToInstanceProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addRoleToInstanceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddRoleToInstanceProfile");

            return clientHandler
                    .execute(new ClientExecutionParams<AddRoleToInstanceProfileRequest, AddRoleToInstanceProfileResponse>()
                            .withOperationName("AddRoleToInstanceProfile").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(addRoleToInstanceProfileRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AddRoleToInstanceProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds the specified user to the specified group.
     * </p>
     *
     * @param addUserToGroupRequest
     * @return Result of the AddUserToGroup operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.AddUserToGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AddUserToGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AddUserToGroupResponse addUserToGroup(AddUserToGroupRequest addUserToGroupRequest) throws NoSuchEntityException,
            LimitExceededException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<AddUserToGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(AddUserToGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addUserToGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddUserToGroup");

            return clientHandler.execute(new ClientExecutionParams<AddUserToGroupRequest, AddUserToGroupResponse>()
                    .withOperationName("AddUserToGroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(addUserToGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AddUserToGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Attaches the specified managed policy to the specified IAM group.
     * </p>
     * <p>
     * You use this API to attach a managed policy to a group. To embed an inline policy in a group, use
     * <a>PutGroupPolicy</a>.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and
     * Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param attachGroupPolicyRequest
     * @return Result of the AttachGroupPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws PolicyNotAttachableException
     *         The request failed because AWS service role policies can only be attached to the service-linked role for
     *         that service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.AttachGroupPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AttachGroupPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AttachGroupPolicyResponse attachGroupPolicy(AttachGroupPolicyRequest attachGroupPolicyRequest)
            throws NoSuchEntityException, LimitExceededException, InvalidInputException, PolicyNotAttachableException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<AttachGroupPolicyResponse> responseHandler = protocolFactory
                .createResponseHandler(AttachGroupPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, attachGroupPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachGroupPolicy");

            return clientHandler.execute(new ClientExecutionParams<AttachGroupPolicyRequest, AttachGroupPolicyResponse>()
                    .withOperationName("AttachGroupPolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(attachGroupPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AttachGroupPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Attaches the specified managed policy to the specified IAM role. When you attach a managed policy to a role, the
     * managed policy becomes part of the role's permission (access) policy.
     * </p>
     * <note>
     * <p>
     * You cannot use a managed policy as the role's trust policy. The role's trust policy is created at the same time
     * as the role, using <a>CreateRole</a>. You can update a role's trust policy using <a>UpdateAssumeRolePolicy</a>.
     * </p>
     * </note>
     * <p>
     * Use this API to attach a <i>managed</i> policy to a role. To embed an inline policy in a role, use
     * <a>PutRolePolicy</a>. For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and
     * Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param attachRolePolicyRequest
     * @return Result of the AttachRolePolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws UnmodifiableEntityException
     *         The request was rejected because only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.
     * @throws PolicyNotAttachableException
     *         The request failed because AWS service role policies can only be attached to the service-linked role for
     *         that service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.AttachRolePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AttachRolePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AttachRolePolicyResponse attachRolePolicy(AttachRolePolicyRequest attachRolePolicyRequest)
            throws NoSuchEntityException, LimitExceededException, InvalidInputException, UnmodifiableEntityException,
            PolicyNotAttachableException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<AttachRolePolicyResponse> responseHandler = protocolFactory
                .createResponseHandler(AttachRolePolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, attachRolePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachRolePolicy");

            return clientHandler.execute(new ClientExecutionParams<AttachRolePolicyRequest, AttachRolePolicyResponse>()
                    .withOperationName("AttachRolePolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(attachRolePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AttachRolePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Attaches the specified managed policy to the specified user.
     * </p>
     * <p>
     * You use this API to attach a <i>managed</i> policy to a user. To embed an inline policy in a user, use
     * <a>PutUserPolicy</a>.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and
     * Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param attachUserPolicyRequest
     * @return Result of the AttachUserPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws PolicyNotAttachableException
     *         The request failed because AWS service role policies can only be attached to the service-linked role for
     *         that service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.AttachUserPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/AttachUserPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AttachUserPolicyResponse attachUserPolicy(AttachUserPolicyRequest attachUserPolicyRequest)
            throws NoSuchEntityException, LimitExceededException, InvalidInputException, PolicyNotAttachableException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<AttachUserPolicyResponse> responseHandler = protocolFactory
                .createResponseHandler(AttachUserPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, attachUserPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AttachUserPolicy");

            return clientHandler.execute(new ClientExecutionParams<AttachUserPolicyRequest, AttachUserPolicyResponse>()
                    .withOperationName("AttachUserPolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(attachUserPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AttachUserPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Changes the password of the IAM user who is calling this operation. The AWS account root user password is not
     * affected by this operation.
     * </p>
     * <p>
     * To change the password for a different user, see <a>UpdateLoginProfile</a>. For more information about modifying
     * passwords, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html">Managing
     * Passwords</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param changePasswordRequest
     * @return Result of the ChangePassword operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidUserTypeException
     *         The request was rejected because the type of user for the transaction was incorrect.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws EntityTemporarilyUnmodifiableException
     *         The request was rejected because it referenced an entity that is temporarily unmodifiable, such as a user
     *         name that was deleted and then recreated. The error indicates that the request is likely to succeed if
     *         you try again after waiting several minutes. The error message describes the entity.
     * @throws PasswordPolicyViolationException
     *         The request was rejected because the provided password did not meet the requirements imposed by the
     *         account password policy.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ChangePassword
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ChangePassword" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ChangePasswordResponse changePassword(ChangePasswordRequest changePasswordRequest) throws NoSuchEntityException,
            InvalidUserTypeException, LimitExceededException, EntityTemporarilyUnmodifiableException,
            PasswordPolicyViolationException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<ChangePasswordResponse> responseHandler = protocolFactory
                .createResponseHandler(ChangePasswordResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, changePasswordRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ChangePassword");

            return clientHandler.execute(new ClientExecutionParams<ChangePasswordRequest, ChangePasswordResponse>()
                    .withOperationName("ChangePassword").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(changePasswordRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ChangePasswordRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new AWS secret access key and corresponding AWS access key ID for the specified user. The default
     * status for new keys is <code>Active</code>.
     * </p>
     * <p>
     * If you do not specify a user name, IAM determines the user name implicitly based on the AWS access key ID signing
     * the request. This operation works for access keys under the AWS account. Consequently, you can use this operation
     * to manage AWS account root user credentials. This is true even if the AWS account has no associated users.
     * </p>
     * <p>
     * The number and size of IAM resources in an AWS account are limited. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS Quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <important>
     * <p>
     * To ensure the security of your AWS account, the secret access key is accessible only during key and user
     * creation. You must save the key (for example, in a text file) if you want to be able to access it again. If a
     * secret key is lost, you can delete the access keys for the associated user and then create new keys.
     * </p>
     * </important>
     *
     * @param createAccessKeyRequest
     * @return Result of the CreateAccessKey operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateAccessKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateAccessKey" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateAccessKeyResponse createAccessKey(CreateAccessKeyRequest createAccessKeyRequest) throws NoSuchEntityException,
            LimitExceededException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<CreateAccessKeyResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateAccessKeyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAccessKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAccessKey");

            return clientHandler.execute(new ClientExecutionParams<CreateAccessKeyRequest, CreateAccessKeyResponse>()
                    .withOperationName("CreateAccessKey").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createAccessKeyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAccessKeyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an alias for your AWS account. For information about using an AWS account alias, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html">Using an Alias for Your AWS Account
     * ID</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param createAccountAliasRequest
     * @return Result of the CreateAccountAlias operation returned by the service.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateAccountAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateAccountAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateAccountAliasResponse createAccountAlias(CreateAccountAliasRequest createAccountAliasRequest)
            throws EntityAlreadyExistsException, LimitExceededException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {

        HttpResponseHandler<CreateAccountAliasResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateAccountAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAccountAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAccountAlias");

            return clientHandler.execute(new ClientExecutionParams<CreateAccountAliasRequest, CreateAccountAliasResponse>()
                    .withOperationName("CreateAccountAlias").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createAccountAliasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAccountAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new group.
     * </p>
     * <p>
     * The number and size of IAM resources in an AWS account are limited. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS Quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     *
     * @param createGroupRequest
     * @return Result of the CreateGroup operation returned by the service.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateGroupResponse createGroup(CreateGroupRequest createGroupRequest) throws LimitExceededException,
            EntityAlreadyExistsException, NoSuchEntityException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {

        HttpResponseHandler<CreateGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGroup");

            return clientHandler.execute(new ClientExecutionParams<CreateGroupRequest, CreateGroupResponse>()
                    .withOperationName("CreateGroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new instance profile. For information about instance profiles, go to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About Instance Profiles</a>.
     * </p>
     * <p>
     * The number and size of IAM resources in an AWS account are limited. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS Quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     *
     * @param createInstanceProfileRequest
     * @return Result of the CreateInstanceProfile operation returned by the service.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateInstanceProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateInstanceProfile" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateInstanceProfileResponse createInstanceProfile(CreateInstanceProfileRequest createInstanceProfileRequest)
            throws EntityAlreadyExistsException, LimitExceededException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {

        HttpResponseHandler<CreateInstanceProfileResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateInstanceProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createInstanceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateInstanceProfile");

            return clientHandler.execute(new ClientExecutionParams<CreateInstanceProfileRequest, CreateInstanceProfileResponse>()
                    .withOperationName("CreateInstanceProfile").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createInstanceProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateInstanceProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a password for the specified user, giving the user the ability to access AWS services through the AWS
     * Management Console. For more information about managing passwords, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html">Managing Passwords</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     *
     * @param createLoginProfileRequest
     * @return Result of the CreateLoginProfile operation returned by the service.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws PasswordPolicyViolationException
     *         The request was rejected because the provided password did not meet the requirements imposed by the
     *         account password policy.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateLoginProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateLoginProfile" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateLoginProfileResponse createLoginProfile(CreateLoginProfileRequest createLoginProfileRequest)
            throws EntityAlreadyExistsException, NoSuchEntityException, PasswordPolicyViolationException, LimitExceededException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<CreateLoginProfileResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateLoginProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createLoginProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateLoginProfile");

            return clientHandler.execute(new ClientExecutionParams<CreateLoginProfileRequest, CreateLoginProfileResponse>()
                    .withOperationName("CreateLoginProfile").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createLoginProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateLoginProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an IAM entity to describe an identity provider (IdP) that supports <a
     * href="http://openid.net/connect/">OpenID Connect (OIDC)</a>.
     * </p>
     * <p>
     * The OIDC provider that you create with this operation can be used as a principal in a role's trust policy. Such a
     * policy establishes a trust relationship between AWS and the OIDC provider.
     * </p>
     * <p>
     * When you create the IAM OIDC provider, you specify the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The URL of the OIDC identity provider (IdP) to trust
     * </p>
     * </li>
     * <li>
     * <p>
     * A list of client IDs (also known as audiences) that identify the application or applications that are allowed to
     * authenticate using the OIDC provider
     * </p>
     * </li>
     * <li>
     * <p>
     * A list of thumbprints of one or more server certificates that the IdP uses
     * </p>
     * </li>
     * </ul>
     * <p>
     * You get all of this information from the OIDC IdP that you want to use to access AWS.
     * </p>
     * <note>
     * <p>
     * The trust for the OIDC provider is derived from the IAM provider that this operation creates. Therefore, it is
     * best to limit access to the <a>CreateOpenIDConnectProvider</a> operation to highly privileged users.
     * </p>
     * </note>
     *
     * @param createOpenIdConnectProviderRequest
     * @return Result of the CreateOpenIDConnectProvider operation returned by the service.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateOpenIDConnectProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateOpenIDConnectProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateOpenIdConnectProviderResponse createOpenIDConnectProvider(
            CreateOpenIdConnectProviderRequest createOpenIdConnectProviderRequest) throws InvalidInputException,
            EntityAlreadyExistsException, LimitExceededException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {

        HttpResponseHandler<CreateOpenIdConnectProviderResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateOpenIdConnectProviderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createOpenIdConnectProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateOpenIDConnectProvider");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateOpenIdConnectProviderRequest, CreateOpenIdConnectProviderResponse>()
                            .withOperationName("CreateOpenIDConnectProvider").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createOpenIdConnectProviderRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateOpenIdConnectProviderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new managed policy for your AWS account.
     * </p>
     * <p>
     * This operation creates a policy version with a version identifier of <code>v1</code> and sets v1 as the policy's
     * default version. For more information about policy versions, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for Managed
     * Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For more information about managed policies in general, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and
     * Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param createPolicyRequest
     * @return Result of the CreatePolicy operation returned by the service.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws MalformedPolicyDocumentException
     *         The request was rejected because the policy document was malformed. The error message describes the
     *         specific error.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreatePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreatePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreatePolicyResponse createPolicy(CreatePolicyRequest createPolicyRequest) throws InvalidInputException,
            LimitExceededException, EntityAlreadyExistsException, MalformedPolicyDocumentException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<CreatePolicyResponse> responseHandler = protocolFactory
                .createResponseHandler(CreatePolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePolicy");

            return clientHandler.execute(new ClientExecutionParams<CreatePolicyRequest, CreatePolicyResponse>()
                    .withOperationName("CreatePolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreatePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new version of the specified managed policy. To update a managed policy, you create a new policy
     * version. A managed policy can have up to five versions. If the policy has five versions, you must delete an
     * existing version using <a>DeletePolicyVersion</a> before you create a new version.
     * </p>
     * <p>
     * Optionally, you can set the new version as the policy's default version. The default version is the version that
     * is in effect for the IAM users, groups, and roles to which the policy is attached.
     * </p>
     * <p>
     * For more information about managed policy versions, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for Managed
     * Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param createPolicyVersionRequest
     * @return Result of the CreatePolicyVersion operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws MalformedPolicyDocumentException
     *         The request was rejected because the policy document was malformed. The error message describes the
     *         specific error.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreatePolicyVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreatePolicyVersion" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreatePolicyVersionResponse createPolicyVersion(CreatePolicyVersionRequest createPolicyVersionRequest)
            throws NoSuchEntityException, MalformedPolicyDocumentException, InvalidInputException, LimitExceededException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<CreatePolicyVersionResponse> responseHandler = protocolFactory
                .createResponseHandler(CreatePolicyVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPolicyVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePolicyVersion");

            return clientHandler.execute(new ClientExecutionParams<CreatePolicyVersionRequest, CreatePolicyVersionResponse>()
                    .withOperationName("CreatePolicyVersion").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createPolicyVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreatePolicyVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new role for your AWS account. For more information about roles, go to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">IAM Roles</a>. The number and size
     * of IAM resources in an AWS account are limited. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS Quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     *
     * @param createRoleRequest
     * @return Result of the CreateRole operation returned by the service.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws MalformedPolicyDocumentException
     *         The request was rejected because the policy document was malformed. The error message describes the
     *         specific error.
     * @throws ConcurrentModificationException
     *         The request was rejected because multiple requests to change this object were submitted simultaneously.
     *         Wait a few minutes and submit your request again.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateRole
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateRole" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateRoleResponse createRole(CreateRoleRequest createRoleRequest) throws LimitExceededException,
            InvalidInputException, EntityAlreadyExistsException, MalformedPolicyDocumentException,
            ConcurrentModificationException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<CreateRoleResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateRoleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRoleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRole");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateRoleRequest, CreateRoleResponse>().withOperationName("CreateRole")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createRoleRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateRoleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an IAM resource that describes an identity provider (IdP) that supports SAML 2.0.
     * </p>
     * <p>
     * The SAML provider resource that you create with this operation can be used as a principal in an IAM role's trust
     * policy. Such a policy can enable federated users who sign in using the SAML IdP to assume the role. You can
     * create an IAM role that supports Web-based single sign-on (SSO) to the AWS Management Console or one that
     * supports API access to AWS.
     * </p>
     * <p>
     * When you create the SAML provider resource, you upload a SAML metadata document that you get from your IdP. That
     * document includes the issuer's name, expiration information, and keys that can be used to validate the SAML
     * authentication response (assertions) that the IdP sends. You must generate the metadata document using the
     * identity management software that is used as your organization's IdP.
     * </p>
     * <note>
     * <p>
     * This operation requires <a
     * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.
     * </p>
     * </note>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-saml.html">Enabling SAML
     * 2.0 Federated Users to Access the AWS Management Console</a> and <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html">About SAML 2.0-based
     * Federation</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param createSamlProviderRequest
     * @return Result of the CreateSAMLProvider operation returned by the service.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateSAMLProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateSAMLProvider" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateSamlProviderResponse createSAMLProvider(CreateSamlProviderRequest createSamlProviderRequest)
            throws InvalidInputException, EntityAlreadyExistsException, LimitExceededException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<CreateSamlProviderResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateSamlProviderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSamlProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSAMLProvider");

            return clientHandler.execute(new ClientExecutionParams<CreateSamlProviderRequest, CreateSamlProviderResponse>()
                    .withOperationName("CreateSAMLProvider").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createSamlProviderRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateSamlProviderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an IAM role that is linked to a specific AWS service. The service controls the attached policies and when
     * the role can be deleted. This helps ensure that the service is not broken by an unexpectedly changed or deleted
     * role, which could put your AWS resources into an unknown state. Allowing the service to control the role helps
     * improve service stability and proper cleanup when a service and its role are no longer needed. For more
     * information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/using-service-linked-roles.html">Using
     * Service-Linked Roles</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * To attach a policy to this service-linked role, you must make the request using the AWS service that depends on
     * this role.
     * </p>
     *
     * @param createServiceLinkedRoleRequest
     * @return Result of the CreateServiceLinkedRole operation returned by the service.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateServiceLinkedRole
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateServiceLinkedRole" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateServiceLinkedRoleResponse createServiceLinkedRole(CreateServiceLinkedRoleRequest createServiceLinkedRoleRequest)
            throws InvalidInputException, LimitExceededException, NoSuchEntityException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<CreateServiceLinkedRoleResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateServiceLinkedRoleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createServiceLinkedRoleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateServiceLinkedRole");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateServiceLinkedRoleRequest, CreateServiceLinkedRoleResponse>()
                            .withOperationName("CreateServiceLinkedRole").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createServiceLinkedRoleRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateServiceLinkedRoleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Generates a set of credentials consisting of a user name and password that can be used to access the service
     * specified in the request. These credentials are generated by IAM, and can be used only for the specified service.
     * </p>
     * <p>
     * You can have a maximum of two sets of service-specific credentials for each supported service per user.
     * </p>
     * <p>
     * The only supported service at this time is AWS CodeCommit.
     * </p>
     * <p>
     * You can reset the password to a new service-generated value by calling <a>ResetServiceSpecificCredential</a>.
     * </p>
     * <p>
     * For more information about service-specific credentials, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_ssh-keys.html">Using IAM with AWS
     * CodeCommit: Git Credentials, SSH Keys, and AWS Access Keys</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param createServiceSpecificCredentialRequest
     * @return Result of the CreateServiceSpecificCredential operation returned by the service.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceNotSupportedException
     *         The specified service does not support service-specific credentials.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateServiceSpecificCredential
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateServiceSpecificCredential"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateServiceSpecificCredentialResponse createServiceSpecificCredential(
            CreateServiceSpecificCredentialRequest createServiceSpecificCredentialRequest) throws LimitExceededException,
            NoSuchEntityException, ServiceNotSupportedException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<CreateServiceSpecificCredentialResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateServiceSpecificCredentialResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                createServiceSpecificCredentialRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateServiceSpecificCredential");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateServiceSpecificCredentialRequest, CreateServiceSpecificCredentialResponse>()
                            .withOperationName("CreateServiceSpecificCredential").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createServiceSpecificCredentialRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateServiceSpecificCredentialRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new IAM user for your AWS account.
     * </p>
     * <p>
     * The number and size of IAM resources in an AWS account are limited. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS Quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     *
     * @param createUserRequest
     * @return Result of the CreateUser operation returned by the service.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ConcurrentModificationException
     *         The request was rejected because multiple requests to change this object were submitted simultaneously.
     *         Wait a few minutes and submit your request again.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateUserResponse createUser(CreateUserRequest createUserRequest) throws LimitExceededException,
            EntityAlreadyExistsException, NoSuchEntityException, InvalidInputException, ConcurrentModificationException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<CreateUserResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateUser");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateUserRequest, CreateUserResponse>().withOperationName("CreateUser")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createUserRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new virtual MFA device for the AWS account. After creating the virtual MFA, use <a>EnableMFADevice</a>
     * to attach the MFA device to an IAM user. For more information about creating and working with virtual MFA
     * devices, go to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html">Using a Virtual
     * MFA Device</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * The number and size of IAM resources in an AWS account are limited. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS Quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * <important>
     * <p>
     * The seed information contained in the QR code and the Base32 string should be treated like any other secret
     * access information. In other words, protect the seed information as you would your AWS access keys or your
     * passwords. After you provision your virtual device, you should ensure that the information is destroyed following
     * secure procedures.
     * </p>
     * </important>
     *
     * @param createVirtualMfaDeviceRequest
     * @return Result of the CreateVirtualMFADevice operation returned by the service.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.CreateVirtualMFADevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateVirtualMFADevice" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateVirtualMfaDeviceResponse createVirtualMFADevice(CreateVirtualMfaDeviceRequest createVirtualMfaDeviceRequest)
            throws LimitExceededException, EntityAlreadyExistsException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {

        HttpResponseHandler<CreateVirtualMfaDeviceResponse> responseHandler = protocolFactory
                .createResponseHandler(CreateVirtualMfaDeviceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVirtualMfaDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVirtualMFADevice");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateVirtualMfaDeviceRequest, CreateVirtualMfaDeviceResponse>()
                            .withOperationName("CreateVirtualMFADevice").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createVirtualMfaDeviceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateVirtualMfaDeviceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deactivates the specified MFA device and removes it from association with the user name for which it was
     * originally enabled.
     * </p>
     * <p>
     * For more information about creating and working with virtual MFA devices, go to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html">Enabling a Virtual Multi-factor
     * Authentication (MFA) Device</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param deactivateMfaDeviceRequest
     * @return Result of the DeactivateMFADevice operation returned by the service.
     * @throws EntityTemporarilyUnmodifiableException
     *         The request was rejected because it referenced an entity that is temporarily unmodifiable, such as a user
     *         name that was deleted and then recreated. The error indicates that the request is likely to succeed if
     *         you try again after waiting several minutes. The error message describes the entity.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeactivateMFADevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeactivateMFADevice" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeactivateMfaDeviceResponse deactivateMFADevice(DeactivateMfaDeviceRequest deactivateMfaDeviceRequest)
            throws EntityTemporarilyUnmodifiableException, NoSuchEntityException, LimitExceededException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<DeactivateMfaDeviceResponse> responseHandler = protocolFactory
                .createResponseHandler(DeactivateMfaDeviceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deactivateMfaDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeactivateMFADevice");

            return clientHandler.execute(new ClientExecutionParams<DeactivateMfaDeviceRequest, DeactivateMfaDeviceResponse>()
                    .withOperationName("DeactivateMFADevice").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deactivateMfaDeviceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeactivateMfaDeviceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the access key pair associated with the specified IAM user.
     * </p>
     * <p>
     * If you do not specify a user name, IAM determines the user name implicitly based on the AWS access key ID signing
     * the request. This operation works for access keys under the AWS account. Consequently, you can use this operation
     * to manage AWS account root user credentials even if the AWS account has no associated users.
     * </p>
     *
     * @param deleteAccessKeyRequest
     * @return Result of the DeleteAccessKey operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteAccessKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteAccessKey" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteAccessKeyResponse deleteAccessKey(DeleteAccessKeyRequest deleteAccessKeyRequest) throws NoSuchEntityException,
            LimitExceededException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<DeleteAccessKeyResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteAccessKeyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAccessKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccessKey");

            return clientHandler.execute(new ClientExecutionParams<DeleteAccessKeyRequest, DeleteAccessKeyResponse>()
                    .withOperationName("DeleteAccessKey").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteAccessKeyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAccessKeyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified AWS account alias. For information about using an AWS account alias, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html">Using an Alias for Your AWS Account
     * ID</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param deleteAccountAliasRequest
     * @return Result of the DeleteAccountAlias operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteAccountAlias
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteAccountAlias" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteAccountAliasResponse deleteAccountAlias(DeleteAccountAliasRequest deleteAccountAliasRequest)
            throws NoSuchEntityException, LimitExceededException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {

        HttpResponseHandler<DeleteAccountAliasResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteAccountAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAccountAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccountAlias");

            return clientHandler.execute(new ClientExecutionParams<DeleteAccountAliasRequest, DeleteAccountAliasResponse>()
                    .withOperationName("DeleteAccountAlias").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteAccountAliasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAccountAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the password policy for the AWS account. There are no parameters.
     * </p>
     *
     * @param deleteAccountPasswordPolicyRequest
     * @return Result of the DeleteAccountPasswordPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteAccountPasswordPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteAccountPasswordPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAccountPasswordPolicyResponse deleteAccountPasswordPolicy(
            DeleteAccountPasswordPolicyRequest deleteAccountPasswordPolicyRequest) throws NoSuchEntityException,
            LimitExceededException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<DeleteAccountPasswordPolicyResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteAccountPasswordPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAccountPasswordPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccountPasswordPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteAccountPasswordPolicyRequest, DeleteAccountPasswordPolicyResponse>()
                            .withOperationName("DeleteAccountPasswordPolicy").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteAccountPasswordPolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteAccountPasswordPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified IAM group. The group must not contain any users or have any attached policies.
     * </p>
     *
     * @param deleteGroupRequest
     * @return Result of the DeleteGroup operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws DeleteConflictException
     *         The request was rejected because it attempted to delete a resource that has attached subordinate
     *         entities. The error message describes these entities.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteGroupResponse deleteGroup(DeleteGroupRequest deleteGroupRequest) throws NoSuchEntityException,
            DeleteConflictException, LimitExceededException, ServiceFailureException, AwsServiceException, SdkClientException,
            IamException {

        HttpResponseHandler<DeleteGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGroup");

            return clientHandler.execute(new ClientExecutionParams<DeleteGroupRequest, DeleteGroupResponse>()
                    .withOperationName("DeleteGroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified inline policy that is embedded in the specified IAM group.
     * </p>
     * <p>
     * A group can also have managed policies attached to it. To detach a managed policy from a group, use
     * <a>DetachGroupPolicy</a>. For more information about policies, refer to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and
     * Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param deleteGroupPolicyRequest
     * @return Result of the DeleteGroupPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteGroupPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteGroupPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteGroupPolicyResponse deleteGroupPolicy(DeleteGroupPolicyRequest deleteGroupPolicyRequest)
            throws NoSuchEntityException, LimitExceededException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {

        HttpResponseHandler<DeleteGroupPolicyResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteGroupPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGroupPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGroupPolicy");

            return clientHandler.execute(new ClientExecutionParams<DeleteGroupPolicyRequest, DeleteGroupPolicyResponse>()
                    .withOperationName("DeleteGroupPolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteGroupPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteGroupPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified instance profile. The instance profile must not have an associated role.
     * </p>
     * <important>
     * <p>
     * Make sure that you do not have any Amazon EC2 instances running with the instance profile you are about to
     * delete. Deleting a role or instance profile that is associated with a running instance will break any
     * applications running on the instance.
     * </p>
     * </important>
     * <p>
     * For more information about instance profiles, go to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About Instance Profiles</a>.
     * </p>
     *
     * @param deleteInstanceProfileRequest
     * @return Result of the DeleteInstanceProfile operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws DeleteConflictException
     *         The request was rejected because it attempted to delete a resource that has attached subordinate
     *         entities. The error message describes these entities.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteInstanceProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteInstanceProfile" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteInstanceProfileResponse deleteInstanceProfile(DeleteInstanceProfileRequest deleteInstanceProfileRequest)
            throws NoSuchEntityException, DeleteConflictException, LimitExceededException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<DeleteInstanceProfileResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteInstanceProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteInstanceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInstanceProfile");

            return clientHandler.execute(new ClientExecutionParams<DeleteInstanceProfileRequest, DeleteInstanceProfileResponse>()
                    .withOperationName("DeleteInstanceProfile").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteInstanceProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteInstanceProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the password for the specified IAM user, which terminates the user's ability to access AWS services
     * through the AWS Management Console.
     * </p>
     * <important>
     * <p>
     * Deleting a user's password does not prevent a user from accessing AWS through the command line interface or the
     * API. To prevent all user access, you must also either make any access keys inactive or delete them. For more
     * information about making keys inactive or deleting them, see <a>UpdateAccessKey</a> and <a>DeleteAccessKey</a>.
     * </p>
     * </important>
     *
     * @param deleteLoginProfileRequest
     * @return Result of the DeleteLoginProfile operation returned by the service.
     * @throws EntityTemporarilyUnmodifiableException
     *         The request was rejected because it referenced an entity that is temporarily unmodifiable, such as a user
     *         name that was deleted and then recreated. The error indicates that the request is likely to succeed if
     *         you try again after waiting several minutes. The error message describes the entity.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteLoginProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteLoginProfile" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteLoginProfileResponse deleteLoginProfile(DeleteLoginProfileRequest deleteLoginProfileRequest)
            throws EntityTemporarilyUnmodifiableException, NoSuchEntityException, LimitExceededException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<DeleteLoginProfileResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteLoginProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteLoginProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteLoginProfile");

            return clientHandler.execute(new ClientExecutionParams<DeleteLoginProfileRequest, DeleteLoginProfileResponse>()
                    .withOperationName("DeleteLoginProfile").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteLoginProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteLoginProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an OpenID Connect identity provider (IdP) resource object in IAM.
     * </p>
     * <p>
     * Deleting an IAM OIDC provider resource does not update any roles that reference the provider as a principal in
     * their trust policies. Any attempt to assume a role that references a deleted provider fails.
     * </p>
     * <p>
     * This operation is idempotent; it does not fail or return an error if you call the operation for a provider that
     * does not exist.
     * </p>
     *
     * @param deleteOpenIdConnectProviderRequest
     * @return Result of the DeleteOpenIDConnectProvider operation returned by the service.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteOpenIDConnectProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteOpenIDConnectProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteOpenIdConnectProviderResponse deleteOpenIDConnectProvider(
            DeleteOpenIdConnectProviderRequest deleteOpenIdConnectProviderRequest) throws InvalidInputException,
            NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<DeleteOpenIdConnectProviderResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteOpenIdConnectProviderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteOpenIdConnectProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOpenIDConnectProvider");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteOpenIdConnectProviderRequest, DeleteOpenIdConnectProviderResponse>()
                            .withOperationName("DeleteOpenIDConnectProvider").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteOpenIdConnectProviderRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteOpenIdConnectProviderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified managed policy.
     * </p>
     * <p>
     * Before you can delete a managed policy, you must first detach the policy from all users, groups, and roles that
     * it is attached to. In addition, you must delete all the policy's versions. The following steps describe the
     * process for deleting a managed policy:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Detach the policy from all users, groups, and roles that the policy is attached to, using the
     * <a>DetachUserPolicy</a>, <a>DetachGroupPolicy</a>, or <a>DetachRolePolicy</a> API operations. To list all the
     * users, groups, and roles that a policy is attached to, use <a>ListEntitiesForPolicy</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Delete all versions of the policy using <a>DeletePolicyVersion</a>. To list the policy's versions, use
     * <a>ListPolicyVersions</a>. You cannot use <a>DeletePolicyVersion</a> to delete the version that is marked as the
     * default version. You delete the policy's default version in the next step of the process.
     * </p>
     * </li>
     * <li>
     * <p>
     * Delete the policy (this automatically deletes the policy's default version) using this API.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For information about managed policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and
     * Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param deletePolicyRequest
     * @return Result of the DeletePolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws DeleteConflictException
     *         The request was rejected because it attempted to delete a resource that has attached subordinate
     *         entities. The error message describes these entities.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeletePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeletePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeletePolicyResponse deletePolicy(DeletePolicyRequest deletePolicyRequest) throws NoSuchEntityException,
            LimitExceededException, InvalidInputException, DeleteConflictException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {

        HttpResponseHandler<DeletePolicyResponse> responseHandler = protocolFactory
                .createResponseHandler(DeletePolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePolicy");

            return clientHandler.execute(new ClientExecutionParams<DeletePolicyRequest, DeletePolicyResponse>()
                    .withOperationName("DeletePolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deletePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeletePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified version from the specified managed policy.
     * </p>
     * <p>
     * You cannot delete the default version from a policy using this API. To delete the default version from a policy,
     * use <a>DeletePolicy</a>. To find out which version of a policy is marked as the default version, use
     * <a>ListPolicyVersions</a>.
     * </p>
     * <p>
     * For information about versions for managed policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for Managed
     * Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param deletePolicyVersionRequest
     * @return Result of the DeletePolicyVersion operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws DeleteConflictException
     *         The request was rejected because it attempted to delete a resource that has attached subordinate
     *         entities. The error message describes these entities.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeletePolicyVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeletePolicyVersion" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeletePolicyVersionResponse deletePolicyVersion(DeletePolicyVersionRequest deletePolicyVersionRequest)
            throws NoSuchEntityException, LimitExceededException, InvalidInputException, DeleteConflictException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<DeletePolicyVersionResponse> responseHandler = protocolFactory
                .createResponseHandler(DeletePolicyVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePolicyVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePolicyVersion");

            return clientHandler.execute(new ClientExecutionParams<DeletePolicyVersionRequest, DeletePolicyVersionResponse>()
                    .withOperationName("DeletePolicyVersion").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deletePolicyVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeletePolicyVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified role. The role must not have any policies attached. For more information about roles, go to
     * <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with Roles</a>.
     * </p>
     * <important>
     * <p>
     * Make sure that you do not have any Amazon EC2 instances running with the role you are about to delete. Deleting a
     * role or instance profile that is associated with a running instance will break any applications running on the
     * instance.
     * </p>
     * </important>
     *
     * @param deleteRoleRequest
     * @return Result of the DeleteRole operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws DeleteConflictException
     *         The request was rejected because it attempted to delete a resource that has attached subordinate
     *         entities. The error message describes these entities.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws UnmodifiableEntityException
     *         The request was rejected because only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.
     * @throws ConcurrentModificationException
     *         The request was rejected because multiple requests to change this object were submitted simultaneously.
     *         Wait a few minutes and submit your request again.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteRole
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteRole" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteRoleResponse deleteRole(DeleteRoleRequest deleteRoleRequest) throws NoSuchEntityException,
            DeleteConflictException, LimitExceededException, UnmodifiableEntityException, ConcurrentModificationException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<DeleteRoleResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteRoleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRoleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRole");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteRoleRequest, DeleteRoleResponse>().withOperationName("DeleteRole")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteRoleRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteRoleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the permissions boundary for the specified IAM role.
     * </p>
     * <important>
     * <p>
     * Deleting the permissions boundary for a role might increase its permissions. For example, it might allow anyone
     * who assumes the role to perform all the actions granted in its permissions policies.
     * </p>
     * </important>
     *
     * @param deleteRolePermissionsBoundaryRequest
     * @return Result of the DeleteRolePermissionsBoundary operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws UnmodifiableEntityException
     *         The request was rejected because only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteRolePermissionsBoundary
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteRolePermissionsBoundary"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteRolePermissionsBoundaryResponse deleteRolePermissionsBoundary(
            DeleteRolePermissionsBoundaryRequest deleteRolePermissionsBoundaryRequest) throws NoSuchEntityException,
            UnmodifiableEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<DeleteRolePermissionsBoundaryResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteRolePermissionsBoundaryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteRolePermissionsBoundaryRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRolePermissionsBoundary");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteRolePermissionsBoundaryRequest, DeleteRolePermissionsBoundaryResponse>()
                            .withOperationName("DeleteRolePermissionsBoundary").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteRolePermissionsBoundaryRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteRolePermissionsBoundaryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified inline policy that is embedded in the specified IAM role.
     * </p>
     * <p>
     * A role can also have managed policies attached to it. To detach a managed policy from a role, use
     * <a>DetachRolePolicy</a>. For more information about policies, refer to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and
     * Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param deleteRolePolicyRequest
     * @return Result of the DeleteRolePolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws UnmodifiableEntityException
     *         The request was rejected because only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteRolePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteRolePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteRolePolicyResponse deleteRolePolicy(DeleteRolePolicyRequest deleteRolePolicyRequest)
            throws NoSuchEntityException, LimitExceededException, UnmodifiableEntityException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<DeleteRolePolicyResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteRolePolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRolePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRolePolicy");

            return clientHandler.execute(new ClientExecutionParams<DeleteRolePolicyRequest, DeleteRolePolicyResponse>()
                    .withOperationName("DeleteRolePolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteRolePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteRolePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a SAML provider resource in IAM.
     * </p>
     * <p>
     * Deleting the provider resource from IAM does not update any roles that reference the SAML provider resource's ARN
     * as a principal in their trust policies. Any attempt to assume a role that references a non-existent provider
     * resource ARN fails.
     * </p>
     * <note>
     * <p>
     * This operation requires <a
     * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.
     * </p>
     * </note>
     *
     * @param deleteSamlProviderRequest
     * @return Result of the DeleteSAMLProvider operation returned by the service.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteSAMLProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteSAMLProvider" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteSamlProviderResponse deleteSAMLProvider(DeleteSamlProviderRequest deleteSamlProviderRequest)
            throws InvalidInputException, LimitExceededException, NoSuchEntityException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<DeleteSamlProviderResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteSamlProviderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSamlProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSAMLProvider");

            return clientHandler.execute(new ClientExecutionParams<DeleteSamlProviderRequest, DeleteSamlProviderResponse>()
                    .withOperationName("DeleteSAMLProvider").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteSamlProviderRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteSamlProviderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified SSH public key.
     * </p>
     * <p>
     * The SSH public key deleted by this operation is used only for authenticating the associated IAM user to an AWS
     * CodeCommit repository. For more information about using SSH keys to authenticate to an AWS CodeCommit repository,
     * see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up AWS
     * CodeCommit for SSH Connections</a> in the <i>AWS CodeCommit User Guide</i>.
     * </p>
     *
     * @param deleteSshPublicKeyRequest
     * @return Result of the DeleteSSHPublicKey operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteSSHPublicKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteSSHPublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteSshPublicKeyResponse deleteSSHPublicKey(DeleteSshPublicKeyRequest deleteSshPublicKeyRequest)
            throws NoSuchEntityException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<DeleteSshPublicKeyResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteSshPublicKeyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSshPublicKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSSHPublicKey");

            return clientHandler.execute(new ClientExecutionParams<DeleteSshPublicKeyRequest, DeleteSshPublicKeyResponse>()
                    .withOperationName("DeleteSSHPublicKey").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteSshPublicKeyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteSshPublicKeyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified server certificate.
     * </p>
     * <p>
     * For more information about working with server certificates, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with Server
     * Certificates</a> in the <i>IAM User Guide</i>. This topic also includes a list of AWS services that can use the
     * server certificates that you manage with IAM.
     * </p>
     * <important>
     * <p>
     * If you are using a server certificate with Elastic Load Balancing, deleting the certificate could have
     * implications for your application. If Elastic Load Balancing doesn't detect the deletion of bound certificates,
     * it may continue to use the certificates. This could cause Elastic Load Balancing to stop accepting traffic. We
     * recommend that you remove the reference to the certificate from Elastic Load Balancing before using this command
     * to delete the certificate. For more information, go to <a href=
     * "https://docs.aws.amazon.com/ElasticLoadBalancing/latest/APIReference/API_DeleteLoadBalancerListeners.html"
     * >DeleteLoadBalancerListeners</a> in the <i>Elastic Load Balancing API Reference</i>.
     * </p>
     * </important>
     *
     * @param deleteServerCertificateRequest
     * @return Result of the DeleteServerCertificate operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws DeleteConflictException
     *         The request was rejected because it attempted to delete a resource that has attached subordinate
     *         entities. The error message describes these entities.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteServerCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteServerCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteServerCertificateResponse deleteServerCertificate(DeleteServerCertificateRequest deleteServerCertificateRequest)
            throws NoSuchEntityException, DeleteConflictException, LimitExceededException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<DeleteServerCertificateResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteServerCertificateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteServerCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteServerCertificate");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteServerCertificateRequest, DeleteServerCertificateResponse>()
                            .withOperationName("DeleteServerCertificate").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteServerCertificateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteServerCertificateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Submits a service-linked role deletion request and returns a <code>DeletionTaskId</code>, which you can use to
     * check the status of the deletion. Before you call this operation, confirm that the role has no active sessions
     * and that any resources used by the role in the linked service are deleted. If you call this operation more than
     * once for the same service-linked role and an earlier deletion task is not complete, then the
     * <code>DeletionTaskId</code> of the earlier request is returned.
     * </p>
     * <p>
     * If you submit a deletion request for a service-linked role whose linked service is still accessing a resource,
     * then the deletion task fails. If it fails, the <a>GetServiceLinkedRoleDeletionStatus</a> API operation returns
     * the reason for the failure, usually including the resources that must be deleted. To delete the service-linked
     * role, you must first remove those resources from the linked service and then submit the deletion request again.
     * Resources are specific to the service that is linked to the role. For more information about removing resources
     * from a service, see the <a href="http://docs.aws.amazon.com/">AWS documentation</a> for your service.
     * </p>
     * <p>
     * For more information about service-linked roles, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_terms-and-concepts.html#iam-term-service-linked-role"
     * >Roles Terms and Concepts: AWS Service-Linked Role</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param deleteServiceLinkedRoleRequest
     * @return Result of the DeleteServiceLinkedRole operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteServiceLinkedRole
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteServiceLinkedRole" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteServiceLinkedRoleResponse deleteServiceLinkedRole(DeleteServiceLinkedRoleRequest deleteServiceLinkedRoleRequest)
            throws NoSuchEntityException, LimitExceededException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {

        HttpResponseHandler<DeleteServiceLinkedRoleResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteServiceLinkedRoleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteServiceLinkedRoleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteServiceLinkedRole");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteServiceLinkedRoleRequest, DeleteServiceLinkedRoleResponse>()
                            .withOperationName("DeleteServiceLinkedRole").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteServiceLinkedRoleRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteServiceLinkedRoleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified service-specific credential.
     * </p>
     *
     * @param deleteServiceSpecificCredentialRequest
     * @return Result of the DeleteServiceSpecificCredential operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteServiceSpecificCredential
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteServiceSpecificCredential"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteServiceSpecificCredentialResponse deleteServiceSpecificCredential(
            DeleteServiceSpecificCredentialRequest deleteServiceSpecificCredentialRequest) throws NoSuchEntityException,
            AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<DeleteServiceSpecificCredentialResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteServiceSpecificCredentialResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteServiceSpecificCredentialRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteServiceSpecificCredential");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteServiceSpecificCredentialRequest, DeleteServiceSpecificCredentialResponse>()
                            .withOperationName("DeleteServiceSpecificCredential").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteServiceSpecificCredentialRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteServiceSpecificCredentialRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a signing certificate associated with the specified IAM user.
     * </p>
     * <p>
     * If you do not specify a user name, IAM determines the user name implicitly based on the AWS access key ID signing
     * the request. This operation works for access keys under the AWS account. Consequently, you can use this operation
     * to manage AWS account root user credentials even if the AWS account has no associated IAM users.
     * </p>
     *
     * @param deleteSigningCertificateRequest
     * @return Result of the DeleteSigningCertificate operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteSigningCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteSigningCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteSigningCertificateResponse deleteSigningCertificate(
            DeleteSigningCertificateRequest deleteSigningCertificateRequest) throws NoSuchEntityException,
            LimitExceededException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<DeleteSigningCertificateResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteSigningCertificateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSigningCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSigningCertificate");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteSigningCertificateRequest, DeleteSigningCertificateResponse>()
                            .withOperationName("DeleteSigningCertificate").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteSigningCertificateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteSigningCertificateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified IAM user. Unlike the AWS Management Console, when you delete a user programmatically, you
     * must delete the items attached to the user manually, or the deletion fails. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_manage.html#id_users_deleting_cli">Deleting an
     * IAM User</a>. Before attempting to delete a user, remove the following items:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Password (<a>DeleteLoginProfile</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Access keys (<a>DeleteAccessKey</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Signing certificate (<a>DeleteSigningCertificate</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * SSH public key (<a>DeleteSSHPublicKey</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Git credentials (<a>DeleteServiceSpecificCredential</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Multi-factor authentication (MFA) device (<a>DeactivateMFADevice</a>, <a>DeleteVirtualMFADevice</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Inline policies (<a>DeleteUserPolicy</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Attached managed policies (<a>DetachUserPolicy</a>)
     * </p>
     * </li>
     * <li>
     * <p>
     * Group memberships (<a>RemoveUserFromGroup</a>)
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteUserRequest
     * @return Result of the DeleteUser operation returned by the service.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws DeleteConflictException
     *         The request was rejected because it attempted to delete a resource that has attached subordinate
     *         entities. The error message describes these entities.
     * @throws ConcurrentModificationException
     *         The request was rejected because multiple requests to change this object were submitted simultaneously.
     *         Wait a few minutes and submit your request again.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws LimitExceededException,
            NoSuchEntityException, DeleteConflictException, ConcurrentModificationException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<DeleteUserResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUser");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteUserRequest, DeleteUserResponse>().withOperationName("DeleteUser")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteUserRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the permissions boundary for the specified IAM user.
     * </p>
     * <important>
     * <p>
     * Deleting the permissions boundary for a user might increase its permissions by allowing the user to perform all
     * the actions granted in its permissions policies.
     * </p>
     * </important>
     *
     * @param deleteUserPermissionsBoundaryRequest
     * @return Result of the DeleteUserPermissionsBoundary operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteUserPermissionsBoundary
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteUserPermissionsBoundary"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteUserPermissionsBoundaryResponse deleteUserPermissionsBoundary(
            DeleteUserPermissionsBoundaryRequest deleteUserPermissionsBoundaryRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<DeleteUserPermissionsBoundaryResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteUserPermissionsBoundaryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteUserPermissionsBoundaryRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUserPermissionsBoundary");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteUserPermissionsBoundaryRequest, DeleteUserPermissionsBoundaryResponse>()
                            .withOperationName("DeleteUserPermissionsBoundary").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteUserPermissionsBoundaryRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteUserPermissionsBoundaryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the specified inline policy that is embedded in the specified IAM user.
     * </p>
     * <p>
     * A user can also have managed policies attached to it. To detach a managed policy from a user, use
     * <a>DetachUserPolicy</a>. For more information about policies, refer to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and
     * Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param deleteUserPolicyRequest
     * @return Result of the DeleteUserPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteUserPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteUserPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteUserPolicyResponse deleteUserPolicy(DeleteUserPolicyRequest deleteUserPolicyRequest)
            throws NoSuchEntityException, LimitExceededException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {

        HttpResponseHandler<DeleteUserPolicyResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteUserPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUserPolicy");

            return clientHandler.execute(new ClientExecutionParams<DeleteUserPolicyRequest, DeleteUserPolicyResponse>()
                    .withOperationName("DeleteUserPolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteUserPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteUserPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a virtual MFA device.
     * </p>
     * <note>
     * <p>
     * You must deactivate a user's virtual MFA device before you can delete it. For information about deactivating MFA
     * devices, see <a>DeactivateMFADevice</a>.
     * </p>
     * </note>
     *
     * @param deleteVirtualMfaDeviceRequest
     * @return Result of the DeleteVirtualMFADevice operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws DeleteConflictException
     *         The request was rejected because it attempted to delete a resource that has attached subordinate
     *         entities. The error message describes these entities.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DeleteVirtualMFADevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DeleteVirtualMFADevice" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteVirtualMfaDeviceResponse deleteVirtualMFADevice(DeleteVirtualMfaDeviceRequest deleteVirtualMfaDeviceRequest)
            throws NoSuchEntityException, DeleteConflictException, LimitExceededException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<DeleteVirtualMfaDeviceResponse> responseHandler = protocolFactory
                .createResponseHandler(DeleteVirtualMfaDeviceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVirtualMfaDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVirtualMFADevice");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteVirtualMfaDeviceRequest, DeleteVirtualMfaDeviceResponse>()
                            .withOperationName("DeleteVirtualMFADevice").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteVirtualMfaDeviceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteVirtualMfaDeviceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the specified managed policy from the specified IAM group.
     * </p>
     * <p>
     * A group can also have inline policies embedded with it. To delete an inline policy, use the
     * <a>DeleteGroupPolicy</a> API. For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and
     * Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param detachGroupPolicyRequest
     * @return Result of the DetachGroupPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DetachGroupPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DetachGroupPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DetachGroupPolicyResponse detachGroupPolicy(DetachGroupPolicyRequest detachGroupPolicyRequest)
            throws NoSuchEntityException, LimitExceededException, InvalidInputException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<DetachGroupPolicyResponse> responseHandler = protocolFactory
                .createResponseHandler(DetachGroupPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detachGroupPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetachGroupPolicy");

            return clientHandler.execute(new ClientExecutionParams<DetachGroupPolicyRequest, DetachGroupPolicyResponse>()
                    .withOperationName("DetachGroupPolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(detachGroupPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DetachGroupPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the specified managed policy from the specified role.
     * </p>
     * <p>
     * A role can also have inline policies embedded with it. To delete an inline policy, use the
     * <a>DeleteRolePolicy</a> API. For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and
     * Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param detachRolePolicyRequest
     * @return Result of the DetachRolePolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws UnmodifiableEntityException
     *         The request was rejected because only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DetachRolePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DetachRolePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DetachRolePolicyResponse detachRolePolicy(DetachRolePolicyRequest detachRolePolicyRequest)
            throws NoSuchEntityException, LimitExceededException, InvalidInputException, UnmodifiableEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<DetachRolePolicyResponse> responseHandler = protocolFactory
                .createResponseHandler(DetachRolePolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detachRolePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetachRolePolicy");

            return clientHandler.execute(new ClientExecutionParams<DetachRolePolicyRequest, DetachRolePolicyResponse>()
                    .withOperationName("DetachRolePolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(detachRolePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DetachRolePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the specified managed policy from the specified user.
     * </p>
     * <p>
     * A user can also have inline policies embedded with it. To delete an inline policy, use the
     * <a>DeleteUserPolicy</a> API. For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and
     * Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param detachUserPolicyRequest
     * @return Result of the DetachUserPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.DetachUserPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/DetachUserPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DetachUserPolicyResponse detachUserPolicy(DetachUserPolicyRequest detachUserPolicyRequest)
            throws NoSuchEntityException, LimitExceededException, InvalidInputException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<DetachUserPolicyResponse> responseHandler = protocolFactory
                .createResponseHandler(DetachUserPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, detachUserPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DetachUserPolicy");

            return clientHandler.execute(new ClientExecutionParams<DetachUserPolicyRequest, DetachUserPolicyResponse>()
                    .withOperationName("DetachUserPolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(detachUserPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DetachUserPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enables the specified MFA device and associates it with the specified IAM user. When enabled, the MFA device is
     * required for every subsequent login by the IAM user associated with the device.
     * </p>
     *
     * @param enableMfaDeviceRequest
     * @return Result of the EnableMFADevice operation returned by the service.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws EntityTemporarilyUnmodifiableException
     *         The request was rejected because it referenced an entity that is temporarily unmodifiable, such as a user
     *         name that was deleted and then recreated. The error indicates that the request is likely to succeed if
     *         you try again after waiting several minutes. The error message describes the entity.
     * @throws InvalidAuthenticationCodeException
     *         The request was rejected because the authentication code was not recognized. The error message describes
     *         the specific error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.EnableMFADevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/EnableMFADevice" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public EnableMfaDeviceResponse enableMFADevice(EnableMfaDeviceRequest enableMfaDeviceRequest)
            throws EntityAlreadyExistsException, EntityTemporarilyUnmodifiableException, InvalidAuthenticationCodeException,
            LimitExceededException, NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException,
            IamException {

        HttpResponseHandler<EnableMfaDeviceResponse> responseHandler = protocolFactory
                .createResponseHandler(EnableMfaDeviceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, enableMfaDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EnableMFADevice");

            return clientHandler.execute(new ClientExecutionParams<EnableMfaDeviceRequest, EnableMfaDeviceResponse>()
                    .withOperationName("EnableMFADevice").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(enableMfaDeviceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new EnableMfaDeviceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Generates a credential report for the AWS account. For more information about the credential report, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting Credential Reports</a> in
     * the <i>IAM User Guide</i>.
     * </p>
     *
     * @param generateCredentialReportRequest
     * @return Result of the GenerateCredentialReport operation returned by the service.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GenerateCredentialReport
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GenerateCredentialReport" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GenerateCredentialReportResponse generateCredentialReport(
            GenerateCredentialReportRequest generateCredentialReportRequest) throws LimitExceededException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<GenerateCredentialReportResponse> responseHandler = protocolFactory
                .createResponseHandler(GenerateCredentialReportResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, generateCredentialReportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GenerateCredentialReport");

            return clientHandler
                    .execute(new ClientExecutionParams<GenerateCredentialReportRequest, GenerateCredentialReportResponse>()
                            .withOperationName("GenerateCredentialReport").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(generateCredentialReportRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GenerateCredentialReportRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Generates a report for service last accessed data for AWS Organizations. You can generate a report for any
     * entities (organization root, organizational unit, or account) or policies in your organization.
     * </p>
     * <p>
     * To call this operation, you must be signed in using your AWS Organizations master account credentials. You can
     * use your long-term IAM user or root user credentials, or temporary credentials from assuming an IAM role. SCPs
     * must be enabled for your organization root. You must have the required IAM and AWS Organizations permissions. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Refining Permissions
     * Using Service Last Accessed Data</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can generate a service last accessed data report for entities by specifying only the entity's path. This data
     * includes a list of services that are allowed by any service control policies (SCPs) that apply to the entity.
     * </p>
     * <p>
     * You can generate a service last accessed data report for a policy by specifying an entity's path and an optional
     * AWS Organizations policy ID. This data includes a list of services that are allowed by the specified SCP.
     * </p>
     * <p>
     * For each service in both report types, the data includes the most recent account activity that the policy allows
     * to account principals in the entity or the entity's children. For important information about the data, reporting
     * period, permissions required, troubleshooting, and supported Regions see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing Permissions
     * Using Service Last Accessed Data</a> in the <i>IAM User Guide</i>.
     * </p>
     * <important>
     * <p>
     * The data includes all attempts to access AWS, not just the successful ones. This includes all attempts that were
     * made using the AWS Management Console, the AWS API through any of the SDKs, or any of the command line tools. An
     * unexpected entry in the service last accessed data does not mean that an account has been compromised, because
     * the request might have been denied. Refer to your CloudTrail logs as the authoritative source for information
     * about all API calls and whether they were successful or denied access. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/cloudtrail-integration.html">Logging IAM Events with
     * CloudTrail</a> in the <i>IAM User Guide</i>.
     * </p>
     * </important>
     * <p>
     * This operation returns a <code>JobId</code>. Use this parameter in the
     * <code> <a>GetOrganizationsAccessReport</a> </code> operation to check the status of the report generation. To
     * check the status of this request, use the <code>JobId</code> parameter in the
     * <code> <a>GetOrganizationsAccessReport</a> </code> operation and test the <code>JobStatus</code> response
     * parameter. When the job is complete, you can retrieve the report.
     * </p>
     * <p>
     * To generate a service last accessed data report for entities, specify an entity path without specifying the
     * optional AWS Organizations policy ID. The type of entity that you specify determines the data returned in the
     * report.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Root</b> – When you specify the organizations root as the entity, the resulting report lists all of the
     * services allowed by SCPs that are attached to your root. For each service, the report includes data for all
     * accounts in your organization except the master account, because the master account is not limited by SCPs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>OU</b> – When you specify an organizational unit (OU) as the entity, the resulting report lists all of the
     * services allowed by SCPs that are attached to the OU and its parents. For each service, the report includes data
     * for all accounts in the OU or its children. This data excludes the master account, because the master account is
     * not limited by SCPs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Master account</b> – When you specify the master account, the resulting report lists all AWS services, because
     * the master account is not limited by SCPs. For each service, the report includes data for only the master
     * account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Account</b> – When you specify another account as the entity, the resulting report lists all of the services
     * allowed by SCPs that are attached to the account and its parents. For each service, the report includes data for
     * only the specified account.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To generate a service last accessed data report for policies, specify an entity path and the optional AWS
     * Organizations policy ID. The type of entity that you specify determines the data returned for each service.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Root</b> – When you specify the root entity and a policy ID, the resulting report lists all of the services
     * that are allowed by the specified SCP. For each service, the report includes data for all accounts in your
     * organization to which the SCP applies. This data excludes the master account, because the master account is not
     * limited by SCPs. If the SCP is not attached to any entities in the organization, then the report will return a
     * list of services with no data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>OU</b> – When you specify an OU entity and a policy ID, the resulting report lists all of the services that
     * are allowed by the specified SCP. For each service, the report includes data for all accounts in the OU or its
     * children to which the SCP applies. This means that other accounts outside the OU that are affected by the SCP
     * might not be included in the data. This data excludes the master account, because the master account is not
     * limited by SCPs. If the SCP is not attached to the OU or one of its children, the report will return a list of
     * services with no data.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Master account</b> – When you specify the master account, the resulting report lists all AWS services, because
     * the master account is not limited by SCPs. If you specify a policy ID in the CLI or API, the policy is ignored.
     * For each service, the report includes data for only the master account.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Account</b> – When you specify another account entity and a policy ID, the resulting report lists all of the
     * services that are allowed by the specified SCP. For each service, the report includes data for only the specified
     * account. This means that other accounts in the organization that are affected by the SCP might not be included in
     * the data. If the SCP is not attached to the account, the report will return a list of services with no data.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * Service last accessed data does not use other policy types when determining whether a principal could access a
     * service. These other policy types include identity-based policies, resource-based policies, access control lists,
     * IAM permissions boundaries, and STS assume role policies. It only applies SCP logic. For more about the
     * evaluation of policy types, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics"
     * >Evaluating Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     * <p>
     * For more information about service last accessed data, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing Policy Scope
     * by Viewing User Activity</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param generateOrganizationsAccessReportRequest
     * @return Result of the GenerateOrganizationsAccessReport operation returned by the service.
     * @throws ReportGenerationLimitExceededException
     *         The request failed because the maximum number of concurrent requests for this account are already
     *         running.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GenerateOrganizationsAccessReport
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GenerateOrganizationsAccessReport"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GenerateOrganizationsAccessReportResponse generateOrganizationsAccessReport(
            GenerateOrganizationsAccessReportRequest generateOrganizationsAccessReportRequest)
            throws ReportGenerationLimitExceededException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<GenerateOrganizationsAccessReportResponse> responseHandler = protocolFactory
                .createResponseHandler(GenerateOrganizationsAccessReportResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                generateOrganizationsAccessReportRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GenerateOrganizationsAccessReport");

            return clientHandler
                    .execute(new ClientExecutionParams<GenerateOrganizationsAccessReportRequest, GenerateOrganizationsAccessReportResponse>()
                            .withOperationName("GenerateOrganizationsAccessReport").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(generateOrganizationsAccessReportRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GenerateOrganizationsAccessReportRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Generates a report that includes details about when an IAM resource (user, group, role, or policy) was last used
     * in an attempt to access AWS services. Recent activity usually appears within four hours. IAM reports activity for
     * the last 365 days, or less if your Region began supporting this feature within the last year. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period"
     * >Regions Where Data Is Tracked</a>.
     * </p>
     * <important>
     * <p>
     * The service last accessed data includes all attempts to access an AWS API, not just the successful ones. This
     * includes all attempts that were made using the AWS Management Console, the AWS API through any of the SDKs, or
     * any of the command line tools. An unexpected entry in the service last accessed data does not mean that your
     * account has been compromised, because the request might have been denied. Refer to your CloudTrail logs as the
     * authoritative source for information about all API calls and whether they were successful or denied access. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/cloudtrail-integration.html">Logging IAM Events with
     * CloudTrail</a> in the <i>IAM User Guide</i>.
     * </p>
     * </important>
     * <p>
     * The <code>GenerateServiceLastAccessedDetails</code> operation returns a <code>JobId</code>. Use this parameter in
     * the following operations to retrieve the following details from your report:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a>GetServiceLastAccessedDetails</a> – Use this operation for users, groups, roles, or policies to list every AWS
     * service that the resource could access using permissions policies. For each service, the response includes
     * information about the most recent access attempt.
     * </p>
     * <p>
     * The <code>JobId</code> returned by <code>GenerateServiceLastAccessedDetail</code> must be used by the same role
     * within a session, or by the same user when used to call <code>GetServiceLastAccessedDetail</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <a>GetServiceLastAccessedDetailsWithEntities</a> – Use this operation for groups and policies to list information
     * about the associated entities (users or roles) that attempted to access a specific AWS service.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To check the status of the <code>GenerateServiceLastAccessedDetails</code> request, use the <code>JobId</code>
     * parameter in the same operations and test the <code>JobStatus</code> response parameter.
     * </p>
     * <p>
     * For additional information about the permissions policies that allow an identity (user, group, or role) to access
     * specific services, use the <a>ListPoliciesGrantingServiceAccess</a> operation.
     * </p>
     * <note>
     * <p>
     * Service last accessed data does not use other policy types when determining whether a resource could access a
     * service. These other policy types include resource-based policies, access control lists, AWS Organizations
     * policies, IAM permissions boundaries, and AWS STS assume role policies. It only applies permissions policy logic.
     * For more about the evaluation of policy types, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics"
     * >Evaluating Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     * <p>
     * For more information about service and action last accessed data, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing Permissions
     * Using Service Last Accessed Data</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param generateServiceLastAccessedDetailsRequest
     * @return Result of the GenerateServiceLastAccessedDetails operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GenerateServiceLastAccessedDetails
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GenerateServiceLastAccessedDetails"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GenerateServiceLastAccessedDetailsResponse generateServiceLastAccessedDetails(
            GenerateServiceLastAccessedDetailsRequest generateServiceLastAccessedDetailsRequest) throws NoSuchEntityException,
            InvalidInputException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<GenerateServiceLastAccessedDetailsResponse> responseHandler = protocolFactory
                .createResponseHandler(GenerateServiceLastAccessedDetailsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                generateServiceLastAccessedDetailsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GenerateServiceLastAccessedDetails");

            return clientHandler
                    .execute(new ClientExecutionParams<GenerateServiceLastAccessedDetailsRequest, GenerateServiceLastAccessedDetailsResponse>()
                            .withOperationName("GenerateServiceLastAccessedDetails").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(generateServiceLastAccessedDetailsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GenerateServiceLastAccessedDetailsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about when the specified access key was last used. The information includes the date and
     * time of last use, along with the AWS service and Region that were specified in the last request made with that
     * key.
     * </p>
     *
     * @param getAccessKeyLastUsedRequest
     * @return Result of the GetAccessKeyLastUsed operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetAccessKeyLastUsed
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccessKeyLastUsed" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetAccessKeyLastUsedResponse getAccessKeyLastUsed(GetAccessKeyLastUsedRequest getAccessKeyLastUsedRequest)
            throws AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<GetAccessKeyLastUsedResponse> responseHandler = protocolFactory
                .createResponseHandler(GetAccessKeyLastUsedResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAccessKeyLastUsedRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccessKeyLastUsed");

            return clientHandler.execute(new ClientExecutionParams<GetAccessKeyLastUsedRequest, GetAccessKeyLastUsedResponse>()
                    .withOperationName("GetAccessKeyLastUsed").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getAccessKeyLastUsedRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetAccessKeyLastUsedRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about all IAM users, groups, roles, and policies in your AWS account, including their
     * relationships to one another. Use this API to obtain a snapshot of the configuration of IAM permissions (users,
     * groups, roles, and policies) in your account.
     * </p>
     * <note>
     * <p>
     * Policies returned by this API are URL-encoded compliant with <a href="https://tools.ietf.org/html/rfc3986">RFC
     * 3986</a>. You can use a URL decoding method to convert the policy back to plain JSON text. For example, if you
     * use Java, you can use the <code>decode</code> method of the <code>java.net.URLDecoder</code> utility class in the
     * Java SDK. Other languages and SDKs provide similar functionality.
     * </p>
     * </note>
     * <p>
     * You can optionally filter the results using the <code>Filter</code> parameter. You can paginate the results using
     * the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param getAccountAuthorizationDetailsRequest
     * @return Result of the GetAccountAuthorizationDetails operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetAccountAuthorizationDetails
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountAuthorizationDetails"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetAccountAuthorizationDetailsResponse getAccountAuthorizationDetails(
            GetAccountAuthorizationDetailsRequest getAccountAuthorizationDetailsRequest) throws ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<GetAccountAuthorizationDetailsResponse> responseHandler = protocolFactory
                .createResponseHandler(GetAccountAuthorizationDetailsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getAccountAuthorizationDetailsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccountAuthorizationDetails");

            return clientHandler
                    .execute(new ClientExecutionParams<GetAccountAuthorizationDetailsRequest, GetAccountAuthorizationDetailsResponse>()
                            .withOperationName("GetAccountAuthorizationDetails").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getAccountAuthorizationDetailsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetAccountAuthorizationDetailsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about all IAM users, groups, roles, and policies in your AWS account, including their
     * relationships to one another. Use this API to obtain a snapshot of the configuration of IAM permissions (users,
     * groups, roles, and policies) in your account.
     * </p>
     * <note>
     * <p>
     * Policies returned by this API are URL-encoded compliant with <a href="https://tools.ietf.org/html/rfc3986">RFC
     * 3986</a>. You can use a URL decoding method to convert the policy back to plain JSON text. For example, if you
     * use Java, you can use the <code>decode</code> method of the <code>java.net.URLDecoder</code> utility class in the
     * Java SDK. Other languages and SDKs provide similar functionality.
     * </p>
     * </note>
     * <p>
     * You can optionally filter the results using the <code>Filter</code> parameter. You can paginate the results using
     * the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getAccountAuthorizationDetails(software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.GetAccountAuthorizationDetailsIterable responses = client.getAccountAuthorizationDetailsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.GetAccountAuthorizationDetailsIterable responses = client
     *             .getAccountAuthorizationDetailsPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.GetAccountAuthorizationDetailsIterable responses = client.getAccountAuthorizationDetailsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getAccountAuthorizationDetails(software.amazon.awssdk.services.iam.model.GetAccountAuthorizationDetailsRequest)}
     * operation.</b>
     * </p>
     *
     * @param getAccountAuthorizationDetailsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetAccountAuthorizationDetails
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountAuthorizationDetails"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetAccountAuthorizationDetailsIterable getAccountAuthorizationDetailsPaginator(
            GetAccountAuthorizationDetailsRequest getAccountAuthorizationDetailsRequest) throws ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return new GetAccountAuthorizationDetailsIterable(this, applyPaginatorUserAgent(getAccountAuthorizationDetailsRequest));
    }

    /**
     * <p>
     * Retrieves the password policy for the AWS account. For more information about using a password policy, go to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingPasswordPolicies.html">Managing an IAM
     * Password Policy</a>.
     * </p>
     *
     * @param getAccountPasswordPolicyRequest
     * @return Result of the GetAccountPasswordPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetAccountPasswordPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountPasswordPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetAccountPasswordPolicyResponse getAccountPasswordPolicy(
            GetAccountPasswordPolicyRequest getAccountPasswordPolicyRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<GetAccountPasswordPolicyResponse> responseHandler = protocolFactory
                .createResponseHandler(GetAccountPasswordPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAccountPasswordPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccountPasswordPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<GetAccountPasswordPolicyRequest, GetAccountPasswordPolicyResponse>()
                            .withOperationName("GetAccountPasswordPolicy").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getAccountPasswordPolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetAccountPasswordPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about IAM entity usage and IAM quotas in the AWS account.
     * </p>
     * <p>
     * The number and size of IAM resources in an AWS account are limited. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html">IAM and STS Quotas</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     *
     * @param getAccountSummaryRequest
     * @return Result of the GetAccountSummary operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetAccountSummary
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetAccountSummary" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetAccountSummaryResponse getAccountSummary(GetAccountSummaryRequest getAccountSummaryRequest)
            throws ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<GetAccountSummaryResponse> responseHandler = protocolFactory
                .createResponseHandler(GetAccountSummaryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAccountSummaryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAccountSummary");

            return clientHandler.execute(new ClientExecutionParams<GetAccountSummaryRequest, GetAccountSummaryResponse>()
                    .withOperationName("GetAccountSummary").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getAccountSummaryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetAccountSummaryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of all of the context keys referenced in the input policies. The policies are supplied as a list of
     * one or more strings. To get the context keys from policies associated with an IAM user, group, or role, use
     * <a>GetContextKeysForPrincipalPolicy</a>.
     * </p>
     * <p>
     * Context keys are variables maintained by AWS and its services that provide details about the context of an API
     * query request. Context keys can be evaluated by testing against a value specified in an IAM policy. Use
     * <code>GetContextKeysForCustomPolicy</code> to understand what key names and values you must supply when you call
     * <a>SimulateCustomPolicy</a>. Note that all parameters are shown in unencoded form here for clarity but must be
     * URL encoded to be included as a part of a real HTML request.
     * </p>
     *
     * @param getContextKeysForCustomPolicyRequest
     * @return Result of the GetContextKeysForCustomPolicy operation returned by the service.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetContextKeysForCustomPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetContextKeysForCustomPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetContextKeysForCustomPolicyResponse getContextKeysForCustomPolicy(
            GetContextKeysForCustomPolicyRequest getContextKeysForCustomPolicyRequest) throws InvalidInputException,
            AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<GetContextKeysForCustomPolicyResponse> responseHandler = protocolFactory
                .createResponseHandler(GetContextKeysForCustomPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getContextKeysForCustomPolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetContextKeysForCustomPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<GetContextKeysForCustomPolicyRequest, GetContextKeysForCustomPolicyResponse>()
                            .withOperationName("GetContextKeysForCustomPolicy").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getContextKeysForCustomPolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetContextKeysForCustomPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets a list of all of the context keys referenced in all the IAM policies that are attached to the specified IAM
     * entity. The entity can be an IAM user, group, or role. If you specify a user, then the request also includes all
     * of the policies attached to groups that the user is a member of.
     * </p>
     * <p>
     * You can optionally include a list of one or more additional policies, specified as strings. If you want to
     * include <i>only</i> a list of policies by string, use <a>GetContextKeysForCustomPolicy</a> instead.
     * </p>
     * <p>
     * <b>Note:</b> This API discloses information about the permissions granted to other users. If you do not want
     * users to see other user's permissions, then consider allowing them to use <a>GetContextKeysForCustomPolicy</a>
     * instead.
     * </p>
     * <p>
     * Context keys are variables maintained by AWS and its services that provide details about the context of an API
     * query request. Context keys can be evaluated by testing against a value in an IAM policy. Use
     * <a>GetContextKeysForPrincipalPolicy</a> to understand what key names and values you must supply when you call
     * <a>SimulatePrincipalPolicy</a>.
     * </p>
     *
     * @param getContextKeysForPrincipalPolicyRequest
     * @return Result of the GetContextKeysForPrincipalPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetContextKeysForPrincipalPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetContextKeysForPrincipalPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetContextKeysForPrincipalPolicyResponse getContextKeysForPrincipalPolicy(
            GetContextKeysForPrincipalPolicyRequest getContextKeysForPrincipalPolicyRequest) throws NoSuchEntityException,
            InvalidInputException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<GetContextKeysForPrincipalPolicyResponse> responseHandler = protocolFactory
                .createResponseHandler(GetContextKeysForPrincipalPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getContextKeysForPrincipalPolicyRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetContextKeysForPrincipalPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<GetContextKeysForPrincipalPolicyRequest, GetContextKeysForPrincipalPolicyResponse>()
                            .withOperationName("GetContextKeysForPrincipalPolicy").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getContextKeysForPrincipalPolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetContextKeysForPrincipalPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a credential report for the AWS account. For more information about the credential report, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting Credential Reports</a> in
     * the <i>IAM User Guide</i>.
     * </p>
     *
     * @param getCredentialReportRequest
     * @return Result of the GetCredentialReport operation returned by the service.
     * @throws CredentialReportNotPresentException
     *         The request was rejected because the credential report does not exist. To generate a credential report,
     *         use <a>GenerateCredentialReport</a>.
     * @throws CredentialReportExpiredException
     *         The request was rejected because the most recent credential report has expired. To generate a new
     *         credential report, use <a>GenerateCredentialReport</a>. For more information about credential report
     *         expiration, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/credential-reports.html">Getting Credential
     *         Reports</a> in the <i>IAM User Guide</i>.
     * @throws CredentialReportNotReadyException
     *         The request was rejected because the credential report is still being generated.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetCredentialReport
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetCredentialReport" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetCredentialReportResponse getCredentialReport(GetCredentialReportRequest getCredentialReportRequest)
            throws CredentialReportNotPresentException, CredentialReportExpiredException, CredentialReportNotReadyException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<GetCredentialReportResponse> responseHandler = protocolFactory
                .createResponseHandler(GetCredentialReportResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCredentialReportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCredentialReport");

            return clientHandler.execute(new ClientExecutionParams<GetCredentialReportRequest, GetCredentialReportResponse>()
                    .withOperationName("GetCredentialReport").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getCredentialReportRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetCredentialReportRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of IAM users that are in the specified IAM group. You can paginate the results using the
     * <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param getGroupRequest
     * @return Result of the GetGroup operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetGroupResponse getGroup(GetGroupRequest getGroupRequest) throws NoSuchEntityException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<GetGroupResponse> responseHandler = protocolFactory.createResponseHandler(GetGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetGroup");

            return clientHandler.execute(new ClientExecutionParams<GetGroupRequest, GetGroupResponse>()
                    .withOperationName("GetGroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getGroupRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of IAM users that are in the specified IAM group. You can paginate the results using the
     * <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getGroup(software.amazon.awssdk.services.iam.model.GetGroupRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.GetGroupIterable responses = client.getGroupPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.GetGroupIterable responses = client.getGroupPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.GetGroupResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.GetGroupIterable responses = client.getGroupPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getGroup(software.amazon.awssdk.services.iam.model.GetGroupRequest)} operation.</b>
     * </p>
     *
     * @param getGroupRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetGroupIterable getGroupPaginator(GetGroupRequest getGroupRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return new GetGroupIterable(this, applyPaginatorUserAgent(getGroupRequest));
    }

    /**
     * <p>
     * Retrieves the specified inline policy document that is embedded in the specified IAM group.
     * </p>
     * <note>
     * <p>
     * Policies returned by this API are URL-encoded compliant with <a href="https://tools.ietf.org/html/rfc3986">RFC
     * 3986</a>. You can use a URL decoding method to convert the policy back to plain JSON text. For example, if you
     * use Java, you can use the <code>decode</code> method of the <code>java.net.URLDecoder</code> utility class in the
     * Java SDK. Other languages and SDKs provide similar functionality.
     * </p>
     * </note>
     * <p>
     * An IAM group can also have managed policies attached to it. To retrieve a managed policy document that is
     * attached to a group, use <a>GetPolicy</a> to determine the policy's default version, then use
     * <a>GetPolicyVersion</a> to retrieve the policy document.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and
     * Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param getGroupPolicyRequest
     * @return Result of the GetGroupPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetGroupPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetGroupPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetGroupPolicyResponse getGroupPolicy(GetGroupPolicyRequest getGroupPolicyRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<GetGroupPolicyResponse> responseHandler = protocolFactory
                .createResponseHandler(GetGroupPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getGroupPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetGroupPolicy");

            return clientHandler.execute(new ClientExecutionParams<GetGroupPolicyRequest, GetGroupPolicyResponse>()
                    .withOperationName("GetGroupPolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getGroupPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetGroupPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the specified instance profile, including the instance profile's path, GUID, ARN, and
     * role. For more information about instance profiles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About Instance Profiles</a> in
     * the <i>IAM User Guide</i>.
     * </p>
     *
     * @param getInstanceProfileRequest
     * @return Result of the GetInstanceProfile operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetInstanceProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetInstanceProfile" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetInstanceProfileResponse getInstanceProfile(GetInstanceProfileRequest getInstanceProfileRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<GetInstanceProfileResponse> responseHandler = protocolFactory
                .createResponseHandler(GetInstanceProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getInstanceProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInstanceProfile");

            return clientHandler.execute(new ClientExecutionParams<GetInstanceProfileRequest, GetInstanceProfileResponse>()
                    .withOperationName("GetInstanceProfile").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getInstanceProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetInstanceProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the user name and password-creation date for the specified IAM user. If the user has not been assigned
     * a password, the operation returns a 404 (<code>NoSuchEntity</code>) error.
     * </p>
     *
     * @param getLoginProfileRequest
     * @return Result of the GetLoginProfile operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetLoginProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetLoginProfile" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetLoginProfileResponse getLoginProfile(GetLoginProfileRequest getLoginProfileRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<GetLoginProfileResponse> responseHandler = protocolFactory
                .createResponseHandler(GetLoginProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getLoginProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetLoginProfile");

            return clientHandler.execute(new ClientExecutionParams<GetLoginProfileRequest, GetLoginProfileResponse>()
                    .withOperationName("GetLoginProfile").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getLoginProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetLoginProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the specified OpenID Connect (OIDC) provider resource object in IAM.
     * </p>
     *
     * @param getOpenIdConnectProviderRequest
     * @return Result of the GetOpenIDConnectProvider operation returned by the service.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetOpenIDConnectProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetOpenIDConnectProvider" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetOpenIdConnectProviderResponse getOpenIDConnectProvider(
            GetOpenIdConnectProviderRequest getOpenIdConnectProviderRequest) throws InvalidInputException, NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<GetOpenIdConnectProviderResponse> responseHandler = protocolFactory
                .createResponseHandler(GetOpenIdConnectProviderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOpenIdConnectProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOpenIDConnectProvider");

            return clientHandler
                    .execute(new ClientExecutionParams<GetOpenIdConnectProviderRequest, GetOpenIdConnectProviderResponse>()
                            .withOperationName("GetOpenIDConnectProvider").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getOpenIdConnectProviderRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetOpenIdConnectProviderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the service last accessed data report for AWS Organizations that was previously generated using the
     * <code> <a>GenerateOrganizationsAccessReport</a> </code> operation. This operation retrieves the status of your
     * report job and the report contents.
     * </p>
     * <p>
     * Depending on the parameters that you passed when you generated the report, the data returned could include
     * different information. For details, see <a>GenerateOrganizationsAccessReport</a>.
     * </p>
     * <p>
     * To call this operation, you must be signed in to the master account in your organization. SCPs must be enabled
     * for your organization root. You must have permissions to perform this operation. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Refining Permissions
     * Using Service Last Accessed Data</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For each service that principals in an account (root users, IAM users, or IAM roles) could access using SCPs, the
     * operation returns details about the most recent access attempt. If there was no attempt, the service is listed
     * without details about the most recent attempt to access the service. If the operation fails, it returns the
     * reason that it failed.
     * </p>
     * <p>
     * By default, the list is sorted by service namespace.
     * </p>
     *
     * @param getOrganizationsAccessReportRequest
     * @return Result of the GetOrganizationsAccessReport operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetOrganizationsAccessReport
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetOrganizationsAccessReport"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetOrganizationsAccessReportResponse getOrganizationsAccessReport(
            GetOrganizationsAccessReportRequest getOrganizationsAccessReportRequest) throws NoSuchEntityException,
            AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<GetOrganizationsAccessReportResponse> responseHandler = protocolFactory
                .createResponseHandler(GetOrganizationsAccessReportResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOrganizationsAccessReportRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOrganizationsAccessReport");

            return clientHandler
                    .execute(new ClientExecutionParams<GetOrganizationsAccessReportRequest, GetOrganizationsAccessReportResponse>()
                            .withOperationName("GetOrganizationsAccessReport").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getOrganizationsAccessReportRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetOrganizationsAccessReportRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the specified managed policy, including the policy's default version and the total
     * number of IAM users, groups, and roles to which the policy is attached. To retrieve the list of the specific
     * users, groups, and roles that the policy is attached to, use the <a>ListEntitiesForPolicy</a> API. This API
     * returns metadata about the policy. To retrieve the actual policy document for a specific version of the policy,
     * use <a>GetPolicyVersion</a>.
     * </p>
     * <p>
     * This API retrieves information about managed policies. To retrieve information about an inline policy that is
     * embedded with an IAM user, group, or role, use the <a>GetUserPolicy</a>, <a>GetGroupPolicy</a>, or
     * <a>GetRolePolicy</a> API.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and
     * Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param getPolicyRequest
     * @return Result of the GetPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetPolicyResponse getPolicy(GetPolicyRequest getPolicyRequest) throws NoSuchEntityException, InvalidInputException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<GetPolicyResponse> responseHandler = protocolFactory
                .createResponseHandler(GetPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPolicy");

            return clientHandler.execute(new ClientExecutionParams<GetPolicyRequest, GetPolicyResponse>()
                    .withOperationName("GetPolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the specified version of the specified managed policy, including the policy document.
     * </p>
     * <note>
     * <p>
     * Policies returned by this API are URL-encoded compliant with <a href="https://tools.ietf.org/html/rfc3986">RFC
     * 3986</a>. You can use a URL decoding method to convert the policy back to plain JSON text. For example, if you
     * use Java, you can use the <code>decode</code> method of the <code>java.net.URLDecoder</code> utility class in the
     * Java SDK. Other languages and SDKs provide similar functionality.
     * </p>
     * </note>
     * <p>
     * To list the available versions for a policy, use <a>ListPolicyVersions</a>.
     * </p>
     * <p>
     * This API retrieves information about managed policies. To retrieve information about an inline policy that is
     * embedded in a user, group, or role, use the <a>GetUserPolicy</a>, <a>GetGroupPolicy</a>, or <a>GetRolePolicy</a>
     * API.
     * </p>
     * <p>
     * For more information about the types of policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and
     * Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For more information about managed policy versions, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html">Versioning for Managed
     * Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param getPolicyVersionRequest
     * @return Result of the GetPolicyVersion operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetPolicyVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetPolicyVersion" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetPolicyVersionResponse getPolicyVersion(GetPolicyVersionRequest getPolicyVersionRequest)
            throws NoSuchEntityException, InvalidInputException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {

        HttpResponseHandler<GetPolicyVersionResponse> responseHandler = protocolFactory
                .createResponseHandler(GetPolicyVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPolicyVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPolicyVersion");

            return clientHandler.execute(new ClientExecutionParams<GetPolicyVersionRequest, GetPolicyVersionResponse>()
                    .withOperationName("GetPolicyVersion").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getPolicyVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetPolicyVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the specified role, including the role's path, GUID, ARN, and the role's trust policy
     * that grants permission to assume the role. For more information about roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with Roles</a>.
     * </p>
     * <note>
     * <p>
     * Policies returned by this API are URL-encoded compliant with <a href="https://tools.ietf.org/html/rfc3986">RFC
     * 3986</a>. You can use a URL decoding method to convert the policy back to plain JSON text. For example, if you
     * use Java, you can use the <code>decode</code> method of the <code>java.net.URLDecoder</code> utility class in the
     * Java SDK. Other languages and SDKs provide similar functionality.
     * </p>
     * </note>
     *
     * @param getRoleRequest
     * @return Result of the GetRole operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetRole
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetRole" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetRoleResponse getRole(GetRoleRequest getRoleRequest) throws NoSuchEntityException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<GetRoleResponse> responseHandler = protocolFactory.createResponseHandler(GetRoleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRoleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRole");

            return clientHandler.execute(new ClientExecutionParams<GetRoleRequest, GetRoleResponse>()
                    .withOperationName("GetRole").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getRoleRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetRoleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the specified inline policy document that is embedded with the specified IAM role.
     * </p>
     * <note>
     * <p>
     * Policies returned by this API are URL-encoded compliant with <a href="https://tools.ietf.org/html/rfc3986">RFC
     * 3986</a>. You can use a URL decoding method to convert the policy back to plain JSON text. For example, if you
     * use Java, you can use the <code>decode</code> method of the <code>java.net.URLDecoder</code> utility class in the
     * Java SDK. Other languages and SDKs provide similar functionality.
     * </p>
     * </note>
     * <p>
     * An IAM role can also have managed policies attached to it. To retrieve a managed policy document that is attached
     * to a role, use <a>GetPolicy</a> to determine the policy's default version, then use <a>GetPolicyVersion</a> to
     * retrieve the policy document.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and
     * Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For more information about roles, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html">Using Roles to Delegate Permissions
     * and Federate Identities</a>.
     * </p>
     *
     * @param getRolePolicyRequest
     * @return Result of the GetRolePolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetRolePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetRolePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetRolePolicyResponse getRolePolicy(GetRolePolicyRequest getRolePolicyRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<GetRolePolicyResponse> responseHandler = protocolFactory
                .createResponseHandler(GetRolePolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRolePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRolePolicy");

            return clientHandler.execute(new ClientExecutionParams<GetRolePolicyRequest, GetRolePolicyResponse>()
                    .withOperationName("GetRolePolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getRolePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetRolePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns the SAML provider metadocument that was uploaded when the IAM SAML provider resource object was created
     * or updated.
     * </p>
     * <note>
     * <p>
     * This operation requires <a
     * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.
     * </p>
     * </note>
     *
     * @param getSamlProviderRequest
     * @return Result of the GetSAMLProvider operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetSAMLProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetSAMLProvider" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetSamlProviderResponse getSAMLProvider(GetSamlProviderRequest getSamlProviderRequest) throws NoSuchEntityException,
            InvalidInputException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<GetSamlProviderResponse> responseHandler = protocolFactory
                .createResponseHandler(GetSamlProviderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSamlProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSAMLProvider");

            return clientHandler.execute(new ClientExecutionParams<GetSamlProviderRequest, GetSamlProviderResponse>()
                    .withOperationName("GetSAMLProvider").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getSamlProviderRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetSamlProviderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the specified SSH public key, including metadata about the key.
     * </p>
     * <p>
     * The SSH public key retrieved by this operation is used only for authenticating the associated IAM user to an AWS
     * CodeCommit repository. For more information about using SSH keys to authenticate to an AWS CodeCommit repository,
     * see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up AWS
     * CodeCommit for SSH Connections</a> in the <i>AWS CodeCommit User Guide</i>.
     * </p>
     *
     * @param getSshPublicKeyRequest
     * @return Result of the GetSSHPublicKey operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws UnrecognizedPublicKeyEncodingException
     *         The request was rejected because the public key encoding format is unsupported or unrecognized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetSSHPublicKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetSSHPublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetSshPublicKeyResponse getSSHPublicKey(GetSshPublicKeyRequest getSshPublicKeyRequest) throws NoSuchEntityException,
            UnrecognizedPublicKeyEncodingException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<GetSshPublicKeyResponse> responseHandler = protocolFactory
                .createResponseHandler(GetSshPublicKeyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSshPublicKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSSHPublicKey");

            return clientHandler.execute(new ClientExecutionParams<GetSshPublicKeyRequest, GetSshPublicKeyResponse>()
                    .withOperationName("GetSSHPublicKey").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getSshPublicKeyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetSshPublicKeyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the specified server certificate stored in IAM.
     * </p>
     * <p>
     * For more information about working with server certificates, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with Server
     * Certificates</a> in the <i>IAM User Guide</i>. This topic includes a list of AWS services that can use the server
     * certificates that you manage with IAM.
     * </p>
     *
     * @param getServerCertificateRequest
     * @return Result of the GetServerCertificate operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetServerCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetServerCertificate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetServerCertificateResponse getServerCertificate(GetServerCertificateRequest getServerCertificateRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<GetServerCertificateResponse> responseHandler = protocolFactory
                .createResponseHandler(GetServerCertificateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getServerCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetServerCertificate");

            return clientHandler.execute(new ClientExecutionParams<GetServerCertificateRequest, GetServerCertificateResponse>()
                    .withOperationName("GetServerCertificate").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getServerCertificateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetServerCertificateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a service last accessed report that was created using the
     * <code>GenerateServiceLastAccessedDetails</code> operation. You can use the <code>JobId</code> parameter in
     * <code>GetServiceLastAccessedDetails</code> to retrieve the status of your report job. When the report is
     * complete, you can retrieve the generated report. The report includes a list of AWS services that the resource
     * (user, group, role, or managed policy) can access.
     * </p>
     * <note>
     * <p>
     * Service last accessed data does not use other policy types when determining whether a resource could access a
     * service. These other policy types include resource-based policies, access control lists, AWS Organizations
     * policies, IAM permissions boundaries, and AWS STS assume role policies. It only applies permissions policy logic.
     * For more about the evaluation of policy types, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics"
     * >Evaluating Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     * <p>
     * For each service that the resource could access using permissions policies, the operation returns details about
     * the most recent access attempt. If there was no attempt, the service is listed without details about the most
     * recent attempt to access the service. If the operation fails, the <code>GetServiceLastAccessedDetails</code>
     * operation returns the reason that it failed.
     * </p>
     * <p>
     * The <code>GetServiceLastAccessedDetails</code> operation returns a list of services. This list includes the
     * number of entities that have attempted to access the service and the date and time of the last attempt. It also
     * returns the ARN of the following entity, depending on the resource ARN that you used to generate the report:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>User</b> – Returns the user ARN that you used to generate the report
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Group</b> – Returns the ARN of the group member (user) that last attempted to access the service
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Role</b> – Returns the role ARN that you used to generate the report
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Policy</b> – Returns the ARN of the user or role that last used the policy to attempt to access the service
     * </p>
     * </li>
     * </ul>
     * <p>
     * By default, the list is sorted by service namespace.
     * </p>
     * <p>
     * If you specified <code>ACTION_LEVEL</code> granularity when you generated the report, this operation returns
     * service and action last accessed data. This includes the most recent access attempt for each tracked action
     * within a service. Otherwise, this operation returns only service data.
     * </p>
     * <p>
     * For more information about service and action last accessed data, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html">Reducing Permissions
     * Using Service Last Accessed Data</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param getServiceLastAccessedDetailsRequest
     * @return Result of the GetServiceLastAccessedDetails operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetServiceLastAccessedDetails
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetServiceLastAccessedDetails"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetServiceLastAccessedDetailsResponse getServiceLastAccessedDetails(
            GetServiceLastAccessedDetailsRequest getServiceLastAccessedDetailsRequest) throws NoSuchEntityException,
            InvalidInputException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<GetServiceLastAccessedDetailsResponse> responseHandler = protocolFactory
                .createResponseHandler(GetServiceLastAccessedDetailsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getServiceLastAccessedDetailsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetServiceLastAccessedDetails");

            return clientHandler
                    .execute(new ClientExecutionParams<GetServiceLastAccessedDetailsRequest, GetServiceLastAccessedDetailsResponse>()
                            .withOperationName("GetServiceLastAccessedDetails").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getServiceLastAccessedDetailsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetServiceLastAccessedDetailsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * After you generate a group or policy report using the <code>GenerateServiceLastAccessedDetails</code> operation,
     * you can use the <code>JobId</code> parameter in <code>GetServiceLastAccessedDetailsWithEntities</code>. This
     * operation retrieves the status of your report job and a list of entities that could have used group or policy
     * permissions to access the specified service.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Group</b> – For a group report, this operation returns a list of users in the group that could have used the
     * group’s policies in an attempt to access the service.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Policy</b> – For a policy report, this operation returns a list of entities (users or roles) that could have
     * used the policy in an attempt to access the service.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can also use this operation for user or role reports to retrieve details about those entities.
     * </p>
     * <p>
     * If the operation fails, the <code>GetServiceLastAccessedDetailsWithEntities</code> operation returns the reason
     * that it failed.
     * </p>
     * <p>
     * By default, the list of associated entities is sorted by date, with the most recent access listed first.
     * </p>
     *
     * @param getServiceLastAccessedDetailsWithEntitiesRequest
     * @return Result of the GetServiceLastAccessedDetailsWithEntities operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetServiceLastAccessedDetailsWithEntities
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetServiceLastAccessedDetailsWithEntities"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetServiceLastAccessedDetailsWithEntitiesResponse getServiceLastAccessedDetailsWithEntities(
            GetServiceLastAccessedDetailsWithEntitiesRequest getServiceLastAccessedDetailsWithEntitiesRequest)
            throws NoSuchEntityException, InvalidInputException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<GetServiceLastAccessedDetailsWithEntitiesResponse> responseHandler = protocolFactory
                .createResponseHandler(GetServiceLastAccessedDetailsWithEntitiesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getServiceLastAccessedDetailsWithEntitiesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetServiceLastAccessedDetailsWithEntities");

            return clientHandler
                    .execute(new ClientExecutionParams<GetServiceLastAccessedDetailsWithEntitiesRequest, GetServiceLastAccessedDetailsWithEntitiesResponse>()
                            .withOperationName("GetServiceLastAccessedDetailsWithEntities").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(getServiceLastAccessedDetailsWithEntitiesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetServiceLastAccessedDetailsWithEntitiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the status of your service-linked role deletion. After you use the <a>DeleteServiceLinkedRole</a> API
     * operation to submit a service-linked role for deletion, you can use the <code>DeletionTaskId</code> parameter in
     * <code>GetServiceLinkedRoleDeletionStatus</code> to check the status of the deletion. If the deletion fails, this
     * operation returns the reason that it failed, if that information is returned by the service.
     * </p>
     *
     * @param getServiceLinkedRoleDeletionStatusRequest
     * @return Result of the GetServiceLinkedRoleDeletionStatus operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetServiceLinkedRoleDeletionStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetServiceLinkedRoleDeletionStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetServiceLinkedRoleDeletionStatusResponse getServiceLinkedRoleDeletionStatus(
            GetServiceLinkedRoleDeletionStatusRequest getServiceLinkedRoleDeletionStatusRequest) throws NoSuchEntityException,
            InvalidInputException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<GetServiceLinkedRoleDeletionStatusResponse> responseHandler = protocolFactory
                .createResponseHandler(GetServiceLinkedRoleDeletionStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getServiceLinkedRoleDeletionStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetServiceLinkedRoleDeletionStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<GetServiceLinkedRoleDeletionStatusRequest, GetServiceLinkedRoleDeletionStatusResponse>()
                            .withOperationName("GetServiceLinkedRoleDeletionStatus").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getServiceLinkedRoleDeletionStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetServiceLinkedRoleDeletionStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the specified IAM user, including the user's creation date, path, unique ID, and ARN.
     * </p>
     * <p>
     * If you do not specify a user name, IAM determines the user name implicitly based on the AWS access key ID used to
     * sign the request to this API.
     * </p>
     *
     * @param getUserRequest
     * @return Result of the GetUser operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetUserResponse getUser(GetUserRequest getUserRequest) throws NoSuchEntityException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<GetUserResponse> responseHandler = protocolFactory.createResponseHandler(GetUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUser");

            return clientHandler.execute(new ClientExecutionParams<GetUserRequest, GetUserResponse>()
                    .withOperationName("GetUser").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getUserRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the specified inline policy document that is embedded in the specified IAM user.
     * </p>
     * <note>
     * <p>
     * Policies returned by this API are URL-encoded compliant with <a href="https://tools.ietf.org/html/rfc3986">RFC
     * 3986</a>. You can use a URL decoding method to convert the policy back to plain JSON text. For example, if you
     * use Java, you can use the <code>decode</code> method of the <code>java.net.URLDecoder</code> utility class in the
     * Java SDK. Other languages and SDKs provide similar functionality.
     * </p>
     * </note>
     * <p>
     * An IAM user can also have managed policies attached to it. To retrieve a managed policy document that is attached
     * to a user, use <a>GetPolicy</a> to determine the policy's default version. Then use <a>GetPolicyVersion</a> to
     * retrieve the policy document.
     * </p>
     * <p>
     * For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and
     * Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param getUserPolicyRequest
     * @return Result of the GetUserPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.GetUserPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/GetUserPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetUserPolicyResponse getUserPolicy(GetUserPolicyRequest getUserPolicyRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<GetUserPolicyResponse> responseHandler = protocolFactory
                .createResponseHandler(GetUserPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getUserPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetUserPolicy");

            return clientHandler.execute(new ClientExecutionParams<GetUserPolicyRequest, GetUserPolicyResponse>()
                    .withOperationName("GetUserPolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getUserPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetUserPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the access key IDs associated with the specified IAM user. If there is none, the
     * operation returns an empty list.
     * </p>
     * <p>
     * Although each user is limited to a small number of keys, you can still paginate the results using the
     * <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * If the <code>UserName</code> field is not specified, the user name is determined implicitly based on the AWS
     * access key ID used to sign the request. This operation works for access keys under the AWS account. Consequently,
     * you can use this operation to manage AWS account root user credentials even if the AWS account has no associated
     * users.
     * </p>
     * <note>
     * <p>
     * To ensure the security of your AWS account, the secret access key is accessible only during key and user
     * creation.
     * </p>
     * </note>
     *
     * @param listAccessKeysRequest
     * @return Result of the ListAccessKeys operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListAccessKeys
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccessKeys" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListAccessKeysResponse listAccessKeys(ListAccessKeysRequest listAccessKeysRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<ListAccessKeysResponse> responseHandler = protocolFactory
                .createResponseHandler(ListAccessKeysResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAccessKeysRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccessKeys");

            return clientHandler.execute(new ClientExecutionParams<ListAccessKeysRequest, ListAccessKeysResponse>()
                    .withOperationName("ListAccessKeys").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listAccessKeysRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAccessKeysRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the access key IDs associated with the specified IAM user. If there is none, the
     * operation returns an empty list.
     * </p>
     * <p>
     * Although each user is limited to a small number of keys, you can still paginate the results using the
     * <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * If the <code>UserName</code> field is not specified, the user name is determined implicitly based on the AWS
     * access key ID used to sign the request. This operation works for access keys under the AWS account. Consequently,
     * you can use this operation to manage AWS account root user credentials even if the AWS account has no associated
     * users.
     * </p>
     * <note>
     * <p>
     * To ensure the security of your AWS account, the secret access key is accessible only during key and user
     * creation.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of {@link #listAccessKeys(software.amazon.awssdk.services.iam.model.ListAccessKeysRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAccessKeysIterable responses = client.listAccessKeysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListAccessKeysIterable responses = client.listAccessKeysPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListAccessKeysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAccessKeysIterable responses = client.listAccessKeysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccessKeys(software.amazon.awssdk.services.iam.model.ListAccessKeysRequest)} operation.</b>
     * </p>
     *
     * @param listAccessKeysRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListAccessKeys
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccessKeys" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListAccessKeysIterable listAccessKeysPaginator(ListAccessKeysRequest listAccessKeysRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return new ListAccessKeysIterable(this, applyPaginatorUserAgent(listAccessKeysRequest));
    }

    /**
     * <p>
     * Lists the account alias associated with the AWS account (Note: you can have only one). For information about
     * using an AWS account alias, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html">Using an Alias for Your AWS Account
     * ID</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param listAccountAliasesRequest
     * @return Result of the ListAccountAliases operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListAccountAliases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccountAliases" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListAccountAliasesResponse listAccountAliases(ListAccountAliasesRequest listAccountAliasesRequest)
            throws ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<ListAccountAliasesResponse> responseHandler = protocolFactory
                .createResponseHandler(ListAccountAliasesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAccountAliasesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAccountAliases");

            return clientHandler.execute(new ClientExecutionParams<ListAccountAliasesRequest, ListAccountAliasesResponse>()
                    .withOperationName("ListAccountAliases").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listAccountAliasesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAccountAliasesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the account alias associated with the AWS account (Note: you can have only one). For information about
     * using an AWS account alias, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AccountAlias.html">Using an Alias for Your AWS Account
     * ID</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAccountAliases(software.amazon.awssdk.services.iam.model.ListAccountAliasesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAccountAliasesIterable responses = client.listAccountAliasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListAccountAliasesIterable responses = client
     *             .listAccountAliasesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListAccountAliasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAccountAliasesIterable responses = client.listAccountAliasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccountAliases(software.amazon.awssdk.services.iam.model.ListAccountAliasesRequest)} operation.</b>
     * </p>
     *
     * @param listAccountAliasesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListAccountAliases
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccountAliases" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListAccountAliasesIterable listAccountAliasesPaginator(ListAccountAliasesRequest listAccountAliasesRequest)
            throws ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return new ListAccountAliasesIterable(this, applyPaginatorUserAgent(listAccountAliasesRequest));
    }

    /**
     * <p>
     * Lists all managed policies that are attached to the specified IAM group.
     * </p>
     * <p>
     * An IAM group can also have inline policies embedded with it. To list the inline policies for a group, use the
     * <a>ListGroupPolicies</a> API. For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and
     * Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. You can use the
     * <code>PathPrefix</code> parameter to limit the list of policies to only those matching the specified path prefix.
     * If there are no policies attached to the specified group (or none that match the specified path prefix), the
     * operation returns an empty list.
     * </p>
     *
     * @param listAttachedGroupPoliciesRequest
     * @return Result of the ListAttachedGroupPolicies operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListAttachedGroupPolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedGroupPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListAttachedGroupPoliciesResponse listAttachedGroupPolicies(
            ListAttachedGroupPoliciesRequest listAttachedGroupPoliciesRequest) throws NoSuchEntityException,
            InvalidInputException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<ListAttachedGroupPoliciesResponse> responseHandler = protocolFactory
                .createResponseHandler(ListAttachedGroupPoliciesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAttachedGroupPoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAttachedGroupPolicies");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAttachedGroupPoliciesRequest, ListAttachedGroupPoliciesResponse>()
                            .withOperationName("ListAttachedGroupPolicies").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listAttachedGroupPoliciesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAttachedGroupPoliciesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all managed policies that are attached to the specified IAM group.
     * </p>
     * <p>
     * An IAM group can also have inline policies embedded with it. To list the inline policies for a group, use the
     * <a>ListGroupPolicies</a> API. For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and
     * Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. You can use the
     * <code>PathPrefix</code> parameter to limit the list of policies to only those matching the specified path prefix.
     * If there are no policies attached to the specified group (or none that match the specified path prefix), the
     * operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAttachedGroupPolicies(software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAttachedGroupPoliciesIterable responses = client.listAttachedGroupPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListAttachedGroupPoliciesIterable responses = client
     *             .listAttachedGroupPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAttachedGroupPoliciesIterable responses = client.listAttachedGroupPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttachedGroupPolicies(software.amazon.awssdk.services.iam.model.ListAttachedGroupPoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAttachedGroupPoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListAttachedGroupPolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedGroupPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListAttachedGroupPoliciesIterable listAttachedGroupPoliciesPaginator(
            ListAttachedGroupPoliciesRequest listAttachedGroupPoliciesRequest) throws NoSuchEntityException,
            InvalidInputException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return new ListAttachedGroupPoliciesIterable(this, applyPaginatorUserAgent(listAttachedGroupPoliciesRequest));
    }

    /**
     * <p>
     * Lists all managed policies that are attached to the specified IAM role.
     * </p>
     * <p>
     * An IAM role can also have inline policies embedded with it. To list the inline policies for a role, use the
     * <a>ListRolePolicies</a> API. For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and
     * Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. You can use the
     * <code>PathPrefix</code> parameter to limit the list of policies to only those matching the specified path prefix.
     * If there are no policies attached to the specified role (or none that match the specified path prefix), the
     * operation returns an empty list.
     * </p>
     *
     * @param listAttachedRolePoliciesRequest
     * @return Result of the ListAttachedRolePolicies operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListAttachedRolePolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedRolePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListAttachedRolePoliciesResponse listAttachedRolePolicies(
            ListAttachedRolePoliciesRequest listAttachedRolePoliciesRequest) throws NoSuchEntityException, InvalidInputException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<ListAttachedRolePoliciesResponse> responseHandler = protocolFactory
                .createResponseHandler(ListAttachedRolePoliciesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAttachedRolePoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAttachedRolePolicies");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAttachedRolePoliciesRequest, ListAttachedRolePoliciesResponse>()
                            .withOperationName("ListAttachedRolePolicies").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listAttachedRolePoliciesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAttachedRolePoliciesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all managed policies that are attached to the specified IAM role.
     * </p>
     * <p>
     * An IAM role can also have inline policies embedded with it. To list the inline policies for a role, use the
     * <a>ListRolePolicies</a> API. For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and
     * Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. You can use the
     * <code>PathPrefix</code> parameter to limit the list of policies to only those matching the specified path prefix.
     * If there are no policies attached to the specified role (or none that match the specified path prefix), the
     * operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAttachedRolePolicies(software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAttachedRolePoliciesIterable responses = client.listAttachedRolePoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListAttachedRolePoliciesIterable responses = client
     *             .listAttachedRolePoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAttachedRolePoliciesIterable responses = client.listAttachedRolePoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttachedRolePolicies(software.amazon.awssdk.services.iam.model.ListAttachedRolePoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAttachedRolePoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListAttachedRolePolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedRolePolicies" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListAttachedRolePoliciesIterable listAttachedRolePoliciesPaginator(
            ListAttachedRolePoliciesRequest listAttachedRolePoliciesRequest) throws NoSuchEntityException, InvalidInputException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return new ListAttachedRolePoliciesIterable(this, applyPaginatorUserAgent(listAttachedRolePoliciesRequest));
    }

    /**
     * <p>
     * Lists all managed policies that are attached to the specified IAM user.
     * </p>
     * <p>
     * An IAM user can also have inline policies embedded with it. To list the inline policies for a user, use the
     * <a>ListUserPolicies</a> API. For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and
     * Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. You can use the
     * <code>PathPrefix</code> parameter to limit the list of policies to only those matching the specified path prefix.
     * If there are no policies attached to the specified group (or none that match the specified path prefix), the
     * operation returns an empty list.
     * </p>
     *
     * @param listAttachedUserPoliciesRequest
     * @return Result of the ListAttachedUserPolicies operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListAttachedUserPolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedUserPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListAttachedUserPoliciesResponse listAttachedUserPolicies(
            ListAttachedUserPoliciesRequest listAttachedUserPoliciesRequest) throws NoSuchEntityException, InvalidInputException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<ListAttachedUserPoliciesResponse> responseHandler = protocolFactory
                .createResponseHandler(ListAttachedUserPoliciesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAttachedUserPoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAttachedUserPolicies");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAttachedUserPoliciesRequest, ListAttachedUserPoliciesResponse>()
                            .withOperationName("ListAttachedUserPolicies").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listAttachedUserPoliciesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAttachedUserPoliciesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all managed policies that are attached to the specified IAM user.
     * </p>
     * <p>
     * An IAM user can also have inline policies embedded with it. To list the inline policies for a user, use the
     * <a>ListUserPolicies</a> API. For information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and
     * Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. You can use the
     * <code>PathPrefix</code> parameter to limit the list of policies to only those matching the specified path prefix.
     * If there are no policies attached to the specified group (or none that match the specified path prefix), the
     * operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAttachedUserPolicies(software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAttachedUserPoliciesIterable responses = client.listAttachedUserPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListAttachedUserPoliciesIterable responses = client
     *             .listAttachedUserPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListAttachedUserPoliciesIterable responses = client.listAttachedUserPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAttachedUserPolicies(software.amazon.awssdk.services.iam.model.ListAttachedUserPoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAttachedUserPoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListAttachedUserPolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAttachedUserPolicies" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListAttachedUserPoliciesIterable listAttachedUserPoliciesPaginator(
            ListAttachedUserPoliciesRequest listAttachedUserPoliciesRequest) throws NoSuchEntityException, InvalidInputException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return new ListAttachedUserPoliciesIterable(this, applyPaginatorUserAgent(listAttachedUserPoliciesRequest));
    }

    /**
     * <p>
     * Lists all IAM users, groups, and roles that the specified managed policy is attached to.
     * </p>
     * <p>
     * You can use the optional <code>EntityFilter</code> parameter to limit the results to a particular type of entity
     * (users, groups, or roles). For example, to list only the roles that are attached to the specified policy, set
     * <code>EntityFilter</code> to <code>Role</code>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listEntitiesForPolicyRequest
     * @return Result of the ListEntitiesForPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListEntitiesForPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListEntitiesForPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListEntitiesForPolicyResponse listEntitiesForPolicy(ListEntitiesForPolicyRequest listEntitiesForPolicyRequest)
            throws NoSuchEntityException, InvalidInputException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {

        HttpResponseHandler<ListEntitiesForPolicyResponse> responseHandler = protocolFactory
                .createResponseHandler(ListEntitiesForPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEntitiesForPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEntitiesForPolicy");

            return clientHandler.execute(new ClientExecutionParams<ListEntitiesForPolicyRequest, ListEntitiesForPolicyResponse>()
                    .withOperationName("ListEntitiesForPolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listEntitiesForPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListEntitiesForPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all IAM users, groups, and roles that the specified managed policy is attached to.
     * </p>
     * <p>
     * You can use the optional <code>EntityFilter</code> parameter to limit the results to a particular type of entity
     * (users, groups, or roles). For example, to list only the roles that are attached to the specified policy, set
     * <code>EntityFilter</code> to <code>Role</code>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listEntitiesForPolicy(software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListEntitiesForPolicyIterable responses = client.listEntitiesForPolicyPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListEntitiesForPolicyIterable responses = client
     *             .listEntitiesForPolicyPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListEntitiesForPolicyIterable responses = client.listEntitiesForPolicyPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEntitiesForPolicy(software.amazon.awssdk.services.iam.model.ListEntitiesForPolicyRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEntitiesForPolicyRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListEntitiesForPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListEntitiesForPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListEntitiesForPolicyIterable listEntitiesForPolicyPaginator(ListEntitiesForPolicyRequest listEntitiesForPolicyRequest)
            throws NoSuchEntityException, InvalidInputException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        return new ListEntitiesForPolicyIterable(this, applyPaginatorUserAgent(listEntitiesForPolicyRequest));
    }

    /**
     * <p>
     * Lists the names of the inline policies that are embedded in the specified IAM group.
     * </p>
     * <p>
     * An IAM group can also have managed policies attached to it. To list the managed policies that are attached to a
     * group, use <a>ListAttachedGroupPolicies</a>. For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and
     * Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. If there are no
     * inline policies embedded with the specified group, the operation returns an empty list.
     * </p>
     *
     * @param listGroupPoliciesRequest
     * @return Result of the ListGroupPolicies operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListGroupPolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroupPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListGroupPoliciesResponse listGroupPolicies(ListGroupPoliciesRequest listGroupPoliciesRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<ListGroupPoliciesResponse> responseHandler = protocolFactory
                .createResponseHandler(ListGroupPoliciesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGroupPoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGroupPolicies");

            return clientHandler.execute(new ClientExecutionParams<ListGroupPoliciesRequest, ListGroupPoliciesResponse>()
                    .withOperationName("ListGroupPolicies").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listGroupPoliciesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListGroupPoliciesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the names of the inline policies that are embedded in the specified IAM group.
     * </p>
     * <p>
     * An IAM group can also have managed policies attached to it. To list the managed policies that are attached to a
     * group, use <a>ListAttachedGroupPolicies</a>. For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and
     * Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. If there are no
     * inline policies embedded with the specified group, the operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGroupPolicies(software.amazon.awssdk.services.iam.model.ListGroupPoliciesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListGroupPoliciesIterable responses = client.listGroupPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListGroupPoliciesIterable responses = client
     *             .listGroupPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListGroupPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListGroupPoliciesIterable responses = client.listGroupPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroupPolicies(software.amazon.awssdk.services.iam.model.ListGroupPoliciesRequest)} operation.</b>
     * </p>
     *
     * @param listGroupPoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListGroupPolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroupPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListGroupPoliciesIterable listGroupPoliciesPaginator(ListGroupPoliciesRequest listGroupPoliciesRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return new ListGroupPoliciesIterable(this, applyPaginatorUserAgent(listGroupPoliciesRequest));
    }

    /**
     * <p>
     * Lists the IAM groups that have the specified path prefix.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listGroupsRequest
     * @return Result of the ListGroups operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListGroupsResponse listGroups(ListGroupsRequest listGroupsRequest) throws ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<ListGroupsResponse> responseHandler = protocolFactory
                .createResponseHandler(ListGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGroups");

            return clientHandler
                    .execute(new ClientExecutionParams<ListGroupsRequest, ListGroupsResponse>().withOperationName("ListGroups")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listGroupsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the IAM groups that have the specified path prefix.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listGroups(software.amazon.awssdk.services.iam.model.ListGroupsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListGroupsIterable responses = client.listGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListGroupsIterable responses = client.listGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListGroupsIterable responses = client.listGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroups(software.amazon.awssdk.services.iam.model.ListGroupsRequest)} operation.</b>
     * </p>
     *
     * @param listGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListGroups
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListGroupsIterable listGroupsPaginator(ListGroupsRequest listGroupsRequest) throws ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return new ListGroupsIterable(this, applyPaginatorUserAgent(listGroupsRequest));
    }

    /**
     * <p>
     * Lists the IAM groups that the specified IAM user belongs to.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listGroupsForUserRequest
     * @return Result of the ListGroupsForUser operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListGroupsForUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroupsForUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListGroupsForUserResponse listGroupsForUser(ListGroupsForUserRequest listGroupsForUserRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<ListGroupsForUserResponse> responseHandler = protocolFactory
                .createResponseHandler(ListGroupsForUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGroupsForUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGroupsForUser");

            return clientHandler.execute(new ClientExecutionParams<ListGroupsForUserRequest, ListGroupsForUserResponse>()
                    .withOperationName("ListGroupsForUser").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listGroupsForUserRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListGroupsForUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the IAM groups that the specified IAM user belongs to.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listGroupsForUser(software.amazon.awssdk.services.iam.model.ListGroupsForUserRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListGroupsForUserIterable responses = client.listGroupsForUserPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListGroupsForUserIterable responses = client
     *             .listGroupsForUserPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListGroupsForUserResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListGroupsForUserIterable responses = client.listGroupsForUserPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGroupsForUser(software.amazon.awssdk.services.iam.model.ListGroupsForUserRequest)} operation.</b>
     * </p>
     *
     * @param listGroupsForUserRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListGroupsForUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListGroupsForUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListGroupsForUserIterable listGroupsForUserPaginator(ListGroupsForUserRequest listGroupsForUserRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return new ListGroupsForUserIterable(this, applyPaginatorUserAgent(listGroupsForUserRequest));
    }

    /**
     * <p>
     * Lists the instance profiles that have the specified path prefix. If there are none, the operation returns an
     * empty list. For more information about instance profiles, go to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About Instance Profiles</a>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listInstanceProfilesRequest
     * @return Result of the ListInstanceProfiles operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListInstanceProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListInstanceProfilesResponse listInstanceProfiles(ListInstanceProfilesRequest listInstanceProfilesRequest)
            throws ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<ListInstanceProfilesResponse> responseHandler = protocolFactory
                .createResponseHandler(ListInstanceProfilesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listInstanceProfilesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListInstanceProfiles");

            return clientHandler.execute(new ClientExecutionParams<ListInstanceProfilesRequest, ListInstanceProfilesResponse>()
                    .withOperationName("ListInstanceProfiles").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listInstanceProfilesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListInstanceProfilesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the instance profiles that have the specified path prefix. If there are none, the operation returns an
     * empty list. For more information about instance profiles, go to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About Instance Profiles</a>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInstanceProfiles(software.amazon.awssdk.services.iam.model.ListInstanceProfilesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesIterable responses = client.listInstanceProfilesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesIterable responses = client
     *             .listInstanceProfilesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListInstanceProfilesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesIterable responses = client.listInstanceProfilesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceProfiles(software.amazon.awssdk.services.iam.model.ListInstanceProfilesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInstanceProfilesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListInstanceProfiles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfiles" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListInstanceProfilesIterable listInstanceProfilesPaginator(ListInstanceProfilesRequest listInstanceProfilesRequest)
            throws ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return new ListInstanceProfilesIterable(this, applyPaginatorUserAgent(listInstanceProfilesRequest));
    }

    /**
     * <p>
     * Lists the instance profiles that have the specified associated IAM role. If there are none, the operation returns
     * an empty list. For more information about instance profiles, go to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About Instance Profiles</a>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listInstanceProfilesForRoleRequest
     * @return Result of the ListInstanceProfilesForRole operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListInstanceProfilesForRole
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfilesForRole"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListInstanceProfilesForRoleResponse listInstanceProfilesForRole(
            ListInstanceProfilesForRoleRequest listInstanceProfilesForRoleRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<ListInstanceProfilesForRoleResponse> responseHandler = protocolFactory
                .createResponseHandler(ListInstanceProfilesForRoleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listInstanceProfilesForRoleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListInstanceProfilesForRole");

            return clientHandler
                    .execute(new ClientExecutionParams<ListInstanceProfilesForRoleRequest, ListInstanceProfilesForRoleResponse>()
                            .withOperationName("ListInstanceProfilesForRole").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listInstanceProfilesForRoleRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListInstanceProfilesForRoleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the instance profiles that have the specified associated IAM role. If there are none, the operation returns
     * an empty list. For more information about instance profiles, go to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About Instance Profiles</a>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInstanceProfilesForRole(software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesForRoleIterable responses = client.listInstanceProfilesForRolePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesForRoleIterable responses = client
     *             .listInstanceProfilesForRolePaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListInstanceProfilesForRoleIterable responses = client.listInstanceProfilesForRolePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstanceProfilesForRole(software.amazon.awssdk.services.iam.model.ListInstanceProfilesForRoleRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInstanceProfilesForRoleRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListInstanceProfilesForRole
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListInstanceProfilesForRole"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListInstanceProfilesForRoleIterable listInstanceProfilesForRolePaginator(
            ListInstanceProfilesForRoleRequest listInstanceProfilesForRoleRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return new ListInstanceProfilesForRoleIterable(this, applyPaginatorUserAgent(listInstanceProfilesForRoleRequest));
    }

    /**
     * <p>
     * Lists the MFA devices for an IAM user. If the request includes a IAM user name, then this operation lists all the
     * MFA devices associated with the specified user. If you do not specify a user name, IAM determines the user name
     * implicitly based on the AWS access key ID signing the request for this API.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listMfaDevicesRequest
     * @return Result of the ListMFADevices operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListMFADevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListMFADevices" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListMfaDevicesResponse listMFADevices(ListMfaDevicesRequest listMfaDevicesRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<ListMfaDevicesResponse> responseHandler = protocolFactory
                .createResponseHandler(ListMfaDevicesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMfaDevicesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMFADevices");

            return clientHandler.execute(new ClientExecutionParams<ListMfaDevicesRequest, ListMfaDevicesResponse>()
                    .withOperationName("ListMFADevices").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listMfaDevicesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListMfaDevicesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the MFA devices for an IAM user. If the request includes a IAM user name, then this operation lists all the
     * MFA devices associated with the specified user. If you do not specify a user name, IAM determines the user name
     * implicitly based on the AWS access key ID signing the request for this API.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listMFADevices(software.amazon.awssdk.services.iam.model.ListMfaDevicesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListMFADevicesIterable responses = client.listMFADevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListMFADevicesIterable responses = client.listMFADevicesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListMfaDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListMFADevicesIterable responses = client.listMFADevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMFADevices(software.amazon.awssdk.services.iam.model.ListMfaDevicesRequest)} operation.</b>
     * </p>
     *
     * @param listMfaDevicesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListMFADevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListMFADevices" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListMFADevicesIterable listMFADevicesPaginator(ListMfaDevicesRequest listMfaDevicesRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return new ListMFADevicesIterable(this, applyPaginatorUserAgent(listMfaDevicesRequest));
    }

    /**
     * <p>
     * Lists information about the IAM OpenID Connect (OIDC) provider resource objects defined in the AWS account.
     * </p>
     *
     * @param listOpenIdConnectProvidersRequest
     * @return Result of the ListOpenIDConnectProviders operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListOpenIDConnectProviders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListOpenIDConnectProviders" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListOpenIdConnectProvidersResponse listOpenIDConnectProviders(
            ListOpenIdConnectProvidersRequest listOpenIdConnectProvidersRequest) throws ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<ListOpenIdConnectProvidersResponse> responseHandler = protocolFactory
                .createResponseHandler(ListOpenIdConnectProvidersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOpenIdConnectProvidersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOpenIDConnectProviders");

            return clientHandler
                    .execute(new ClientExecutionParams<ListOpenIdConnectProvidersRequest, ListOpenIdConnectProvidersResponse>()
                            .withOperationName("ListOpenIDConnectProviders").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listOpenIdConnectProvidersRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListOpenIdConnectProvidersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all the managed policies that are available in your AWS account, including your own customer-defined
     * managed policies and all AWS managed policies.
     * </p>
     * <p>
     * You can filter the list of policies that is returned using the optional <code>OnlyAttached</code>,
     * <code>Scope</code>, and <code>PathPrefix</code> parameters. For example, to list only the customer managed
     * policies in your AWS account, set <code>Scope</code> to <code>Local</code>. To list only AWS managed policies,
     * set <code>Scope</code> to <code>AWS</code>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * For more information about managed policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and
     * Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param listPoliciesRequest
     * @return Result of the ListPolicies operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListPolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListPoliciesResponse listPolicies(ListPoliciesRequest listPoliciesRequest) throws ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<ListPoliciesResponse> responseHandler = protocolFactory
                .createResponseHandler(ListPoliciesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPolicies");

            return clientHandler.execute(new ClientExecutionParams<ListPoliciesRequest, ListPoliciesResponse>()
                    .withOperationName("ListPolicies").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listPoliciesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListPoliciesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all the managed policies that are available in your AWS account, including your own customer-defined
     * managed policies and all AWS managed policies.
     * </p>
     * <p>
     * You can filter the list of policies that is returned using the optional <code>OnlyAttached</code>,
     * <code>Scope</code>, and <code>PathPrefix</code> parameters. For example, to list only the customer managed
     * policies in your AWS account, set <code>Scope</code> to <code>Local</code>. To list only AWS managed policies,
     * set <code>Scope</code> to <code>AWS</code>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * For more information about managed policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and
     * Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listPolicies(software.amazon.awssdk.services.iam.model.ListPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListPoliciesIterable responses = client.listPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListPoliciesIterable responses = client.listPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListPoliciesIterable responses = client.listPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPolicies(software.amazon.awssdk.services.iam.model.ListPoliciesRequest)} operation.</b>
     * </p>
     *
     * @param listPoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListPolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListPoliciesIterable listPoliciesPaginator(ListPoliciesRequest listPoliciesRequest) throws ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return new ListPoliciesIterable(this, applyPaginatorUserAgent(listPoliciesRequest));
    }

    /**
     * <p>
     * Retrieves a list of policies that the IAM identity (user, group, or role) can use to access each specified
     * service.
     * </p>
     * <note>
     * <p>
     * This operation does not use other policy types when determining whether a resource could access a service. These
     * other policy types include resource-based policies, access control lists, AWS Organizations policies, IAM
     * permissions boundaries, and AWS STS assume role policies. It only applies permissions policy logic. For more
     * about the evaluation of policy types, see <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics"
     * >Evaluating Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     * <p>
     * The list of policies returned by the operation depends on the ARN of the identity that you provide.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>User</b> – The list of policies includes the managed and inline policies that are attached to the user
     * directly. The list also includes any additional managed and inline policies that are attached to the group to
     * which the user belongs.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Group</b> – The list of policies includes only the managed and inline policies that are attached to the group
     * directly. Policies that are attached to the group’s user are not included.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Role</b> – The list of policies includes only the managed and inline policies that are attached to the role.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For each managed policy, this operation returns the ARN and policy name. For each inline policy, it returns the
     * policy name and the entity to which it is attached. Inline policies do not have an ARN. For more information
     * about these policy types, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-vs-inline.html">Managed Policies
     * and Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * Policies that are attached to users and roles as permissions boundaries are not returned. To view which managed
     * policy is currently used to set the permissions boundary for a user or role, use the <a>GetUser</a> or
     * <a>GetRole</a> operations.
     * </p>
     *
     * @param listPoliciesGrantingServiceAccessRequest
     * @return Result of the ListPoliciesGrantingServiceAccess operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListPoliciesGrantingServiceAccess
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPoliciesGrantingServiceAccess"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListPoliciesGrantingServiceAccessResponse listPoliciesGrantingServiceAccess(
            ListPoliciesGrantingServiceAccessRequest listPoliciesGrantingServiceAccessRequest) throws NoSuchEntityException,
            InvalidInputException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<ListPoliciesGrantingServiceAccessResponse> responseHandler = protocolFactory
                .createResponseHandler(ListPoliciesGrantingServiceAccessResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listPoliciesGrantingServiceAccessRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPoliciesGrantingServiceAccess");

            return clientHandler
                    .execute(new ClientExecutionParams<ListPoliciesGrantingServiceAccessRequest, ListPoliciesGrantingServiceAccessResponse>()
                            .withOperationName("ListPoliciesGrantingServiceAccess").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listPoliciesGrantingServiceAccessRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListPoliciesGrantingServiceAccessRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists information about the versions of the specified managed policy, including the version that is currently set
     * as the policy's default version.
     * </p>
     * <p>
     * For more information about managed policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and
     * Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param listPolicyVersionsRequest
     * @return Result of the ListPolicyVersions operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListPolicyVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicyVersions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListPolicyVersionsResponse listPolicyVersions(ListPolicyVersionsRequest listPolicyVersionsRequest)
            throws NoSuchEntityException, InvalidInputException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {

        HttpResponseHandler<ListPolicyVersionsResponse> responseHandler = protocolFactory
                .createResponseHandler(ListPolicyVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listPolicyVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListPolicyVersions");

            return clientHandler.execute(new ClientExecutionParams<ListPolicyVersionsRequest, ListPolicyVersionsResponse>()
                    .withOperationName("ListPolicyVersions").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listPolicyVersionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListPolicyVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists information about the versions of the specified managed policy, including the version that is currently set
     * as the policy's default version.
     * </p>
     * <p>
     * For more information about managed policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and
     * Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listPolicyVersions(software.amazon.awssdk.services.iam.model.ListPolicyVersionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListPolicyVersionsIterable responses = client.listPolicyVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListPolicyVersionsIterable responses = client
     *             .listPolicyVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListPolicyVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListPolicyVersionsIterable responses = client.listPolicyVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listPolicyVersions(software.amazon.awssdk.services.iam.model.ListPolicyVersionsRequest)} operation.</b>
     * </p>
     *
     * @param listPolicyVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListPolicyVersions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListPolicyVersions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListPolicyVersionsIterable listPolicyVersionsPaginator(ListPolicyVersionsRequest listPolicyVersionsRequest)
            throws NoSuchEntityException, InvalidInputException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        return new ListPolicyVersionsIterable(this, applyPaginatorUserAgent(listPolicyVersionsRequest));
    }

    /**
     * <p>
     * Lists the names of the inline policies that are embedded in the specified IAM role.
     * </p>
     * <p>
     * An IAM role can also have managed policies attached to it. To list the managed policies that are attached to a
     * role, use <a>ListAttachedRolePolicies</a>. For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and
     * Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. If there are no
     * inline policies embedded with the specified role, the operation returns an empty list.
     * </p>
     *
     * @param listRolePoliciesRequest
     * @return Result of the ListRolePolicies operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListRolePolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRolePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListRolePoliciesResponse listRolePolicies(ListRolePoliciesRequest listRolePoliciesRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<ListRolePoliciesResponse> responseHandler = protocolFactory
                .createResponseHandler(ListRolePoliciesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRolePoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRolePolicies");

            return clientHandler.execute(new ClientExecutionParams<ListRolePoliciesRequest, ListRolePoliciesResponse>()
                    .withOperationName("ListRolePolicies").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listRolePoliciesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListRolePoliciesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the names of the inline policies that are embedded in the specified IAM role.
     * </p>
     * <p>
     * An IAM role can also have managed policies attached to it. To list the managed policies that are attached to a
     * role, use <a>ListAttachedRolePolicies</a>. For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and
     * Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. If there are no
     * inline policies embedded with the specified role, the operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRolePolicies(software.amazon.awssdk.services.iam.model.ListRolePoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListRolePoliciesIterable responses = client.listRolePoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListRolePoliciesIterable responses = client.listRolePoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListRolePoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListRolePoliciesIterable responses = client.listRolePoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRolePolicies(software.amazon.awssdk.services.iam.model.ListRolePoliciesRequest)} operation.</b>
     * </p>
     *
     * @param listRolePoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListRolePolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRolePolicies" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListRolePoliciesIterable listRolePoliciesPaginator(ListRolePoliciesRequest listRolePoliciesRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return new ListRolePoliciesIterable(this, applyPaginatorUserAgent(listRolePoliciesRequest));
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified role. The returned list of tags is sorted by tag key. For more
     * information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging
     * IAM Identities</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param listRoleTagsRequest
     * @return Result of the ListRoleTags operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListRoleTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRoleTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListRoleTagsResponse listRoleTags(ListRoleTagsRequest listRoleTagsRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<ListRoleTagsResponse> responseHandler = protocolFactory
                .createResponseHandler(ListRoleTagsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRoleTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRoleTags");

            return clientHandler.execute(new ClientExecutionParams<ListRoleTagsRequest, ListRoleTagsResponse>()
                    .withOperationName("ListRoleTags").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listRoleTagsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListRoleTagsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the IAM roles that have the specified path prefix. If there are none, the operation returns an empty list.
     * For more information about roles, go to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with Roles</a>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listRolesRequest
     * @return Result of the ListRoles operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListRoles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRoles" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListRolesResponse listRoles(ListRolesRequest listRolesRequest) throws ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {

        HttpResponseHandler<ListRolesResponse> responseHandler = protocolFactory
                .createResponseHandler(ListRolesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRolesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRoles");

            return clientHandler.execute(new ClientExecutionParams<ListRolesRequest, ListRolesResponse>()
                    .withOperationName("ListRoles").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listRolesRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new ListRolesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the IAM roles that have the specified path prefix. If there are none, the operation returns an empty list.
     * For more information about roles, go to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with Roles</a>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listRoles(software.amazon.awssdk.services.iam.model.ListRolesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListRolesIterable responses = client.listRolesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListRolesIterable responses = client.listRolesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListRolesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListRolesIterable responses = client.listRolesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRoles(software.amazon.awssdk.services.iam.model.ListRolesRequest)} operation.</b>
     * </p>
     *
     * @param listRolesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListRoles
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListRoles" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListRolesIterable listRolesPaginator(ListRolesRequest listRolesRequest) throws ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return new ListRolesIterable(this, applyPaginatorUserAgent(listRolesRequest));
    }

    /**
     * <p>
     * Lists the SAML provider resource objects defined in IAM in the account.
     * </p>
     * <note>
     * <p>
     * This operation requires <a
     * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.
     * </p>
     * </note>
     *
     * @param listSamlProvidersRequest
     * @return Result of the ListSAMLProviders operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListSAMLProviders
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSAMLProviders" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListSamlProvidersResponse listSAMLProviders(ListSamlProvidersRequest listSamlProvidersRequest)
            throws ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<ListSamlProvidersResponse> responseHandler = protocolFactory
                .createResponseHandler(ListSamlProvidersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSamlProvidersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSAMLProviders");

            return clientHandler.execute(new ClientExecutionParams<ListSamlProvidersRequest, ListSamlProvidersResponse>()
                    .withOperationName("ListSAMLProviders").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listSamlProvidersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListSamlProvidersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the SSH public keys associated with the specified IAM user. If none exists, the
     * operation returns an empty list.
     * </p>
     * <p>
     * The SSH public keys returned by this operation are used only for authenticating the IAM user to an AWS CodeCommit
     * repository. For more information about using SSH keys to authenticate to an AWS CodeCommit repository, see <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up AWS
     * CodeCommit for SSH Connections</a> in the <i>AWS CodeCommit User Guide</i>.
     * </p>
     * <p>
     * Although each user is limited to a small number of keys, you can still paginate the results using the
     * <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listSshPublicKeysRequest
     * @return Result of the ListSSHPublicKeys operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListSSHPublicKeys
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSSHPublicKeys" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListSshPublicKeysResponse listSSHPublicKeys(ListSshPublicKeysRequest listSshPublicKeysRequest)
            throws NoSuchEntityException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<ListSshPublicKeysResponse> responseHandler = protocolFactory
                .createResponseHandler(ListSshPublicKeysResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSshPublicKeysRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSSHPublicKeys");

            return clientHandler.execute(new ClientExecutionParams<ListSshPublicKeysRequest, ListSshPublicKeysResponse>()
                    .withOperationName("ListSSHPublicKeys").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listSshPublicKeysRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListSshPublicKeysRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the SSH public keys associated with the specified IAM user. If none exists, the
     * operation returns an empty list.
     * </p>
     * <p>
     * The SSH public keys returned by this operation are used only for authenticating the IAM user to an AWS CodeCommit
     * repository. For more information about using SSH keys to authenticate to an AWS CodeCommit repository, see <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up AWS
     * CodeCommit for SSH Connections</a> in the <i>AWS CodeCommit User Guide</i>.
     * </p>
     * <p>
     * Although each user is limited to a small number of keys, you can still paginate the results using the
     * <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSSHPublicKeys(software.amazon.awssdk.services.iam.model.ListSshPublicKeysRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListSSHPublicKeysIterable responses = client.listSSHPublicKeysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListSSHPublicKeysIterable responses = client
     *             .listSSHPublicKeysPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListSshPublicKeysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListSSHPublicKeysIterable responses = client.listSSHPublicKeysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSSHPublicKeys(software.amazon.awssdk.services.iam.model.ListSshPublicKeysRequest)} operation.</b>
     * </p>
     *
     * @param listSshPublicKeysRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListSSHPublicKeys
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSSHPublicKeys" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListSSHPublicKeysIterable listSSHPublicKeysPaginator(ListSshPublicKeysRequest listSshPublicKeysRequest)
            throws NoSuchEntityException, AwsServiceException, SdkClientException, IamException {
        return new ListSSHPublicKeysIterable(this, applyPaginatorUserAgent(listSshPublicKeysRequest));
    }

    /**
     * <p>
     * Lists the server certificates stored in IAM that have the specified path prefix. If none exist, the operation
     * returns an empty list.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * For more information about working with server certificates, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with Server
     * Certificates</a> in the <i>IAM User Guide</i>. This topic also includes a list of AWS services that can use the
     * server certificates that you manage with IAM.
     * </p>
     *
     * @param listServerCertificatesRequest
     * @return Result of the ListServerCertificates operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListServerCertificates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListServerCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListServerCertificatesResponse listServerCertificates(ListServerCertificatesRequest listServerCertificatesRequest)
            throws ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<ListServerCertificatesResponse> responseHandler = protocolFactory
                .createResponseHandler(ListServerCertificatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listServerCertificatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListServerCertificates");

            return clientHandler
                    .execute(new ClientExecutionParams<ListServerCertificatesRequest, ListServerCertificatesResponse>()
                            .withOperationName("ListServerCertificates").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listServerCertificatesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListServerCertificatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the server certificates stored in IAM that have the specified path prefix. If none exist, the operation
     * returns an empty list.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * For more information about working with server certificates, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with Server
     * Certificates</a> in the <i>IAM User Guide</i>. This topic also includes a list of AWS services that can use the
     * server certificates that you manage with IAM.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServerCertificates(software.amazon.awssdk.services.iam.model.ListServerCertificatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListServerCertificatesIterable responses = client.listServerCertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListServerCertificatesIterable responses = client
     *             .listServerCertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListServerCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListServerCertificatesIterable responses = client.listServerCertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServerCertificates(software.amazon.awssdk.services.iam.model.ListServerCertificatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServerCertificatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListServerCertificates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListServerCertificates" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListServerCertificatesIterable listServerCertificatesPaginator(
            ListServerCertificatesRequest listServerCertificatesRequest) throws ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {
        return new ListServerCertificatesIterable(this, applyPaginatorUserAgent(listServerCertificatesRequest));
    }

    /**
     * <p>
     * Returns information about the service-specific credentials associated with the specified IAM user. If none
     * exists, the operation returns an empty list. The service-specific credentials returned by this operation are used
     * only for authenticating the IAM user to a specific service. For more information about using service-specific
     * credentials to authenticate to an AWS service, see <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-gc.html">Set Up service-specific
     * credentials</a> in the AWS CodeCommit User Guide.
     * </p>
     *
     * @param listServiceSpecificCredentialsRequest
     * @return Result of the ListServiceSpecificCredentials operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceNotSupportedException
     *         The specified service does not support service-specific credentials.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListServiceSpecificCredentials
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListServiceSpecificCredentials"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListServiceSpecificCredentialsResponse listServiceSpecificCredentials(
            ListServiceSpecificCredentialsRequest listServiceSpecificCredentialsRequest) throws NoSuchEntityException,
            ServiceNotSupportedException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<ListServiceSpecificCredentialsResponse> responseHandler = protocolFactory
                .createResponseHandler(ListServiceSpecificCredentialsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listServiceSpecificCredentialsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListServiceSpecificCredentials");

            return clientHandler
                    .execute(new ClientExecutionParams<ListServiceSpecificCredentialsRequest, ListServiceSpecificCredentialsResponse>()
                            .withOperationName("ListServiceSpecificCredentials").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listServiceSpecificCredentialsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListServiceSpecificCredentialsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the signing certificates associated with the specified IAM user. If none exists, the
     * operation returns an empty list.
     * </p>
     * <p>
     * Although each user is limited to a small number of signing certificates, you can still paginate the results using
     * the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * If the <code>UserName</code> field is not specified, the user name is determined implicitly based on the AWS
     * access key ID used to sign the request for this API. This operation works for access keys under the AWS account.
     * Consequently, you can use this operation to manage AWS account root user credentials even if the AWS account has
     * no associated users.
     * </p>
     *
     * @param listSigningCertificatesRequest
     * @return Result of the ListSigningCertificates operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListSigningCertificates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSigningCertificates" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListSigningCertificatesResponse listSigningCertificates(ListSigningCertificatesRequest listSigningCertificatesRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<ListSigningCertificatesResponse> responseHandler = protocolFactory
                .createResponseHandler(ListSigningCertificatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSigningCertificatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSigningCertificates");

            return clientHandler
                    .execute(new ClientExecutionParams<ListSigningCertificatesRequest, ListSigningCertificatesResponse>()
                            .withOperationName("ListSigningCertificates").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listSigningCertificatesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListSigningCertificatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about the signing certificates associated with the specified IAM user. If none exists, the
     * operation returns an empty list.
     * </p>
     * <p>
     * Although each user is limited to a small number of signing certificates, you can still paginate the results using
     * the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <p>
     * If the <code>UserName</code> field is not specified, the user name is determined implicitly based on the AWS
     * access key ID used to sign the request for this API. This operation works for access keys under the AWS account.
     * Consequently, you can use this operation to manage AWS account root user credentials even if the AWS account has
     * no associated users.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSigningCertificates(software.amazon.awssdk.services.iam.model.ListSigningCertificatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListSigningCertificatesIterable responses = client.listSigningCertificatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListSigningCertificatesIterable responses = client
     *             .listSigningCertificatesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListSigningCertificatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListSigningCertificatesIterable responses = client.listSigningCertificatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSigningCertificates(software.amazon.awssdk.services.iam.model.ListSigningCertificatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSigningCertificatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListSigningCertificates
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListSigningCertificates" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListSigningCertificatesIterable listSigningCertificatesPaginator(
            ListSigningCertificatesRequest listSigningCertificatesRequest) throws NoSuchEntityException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return new ListSigningCertificatesIterable(this, applyPaginatorUserAgent(listSigningCertificatesRequest));
    }

    /**
     * <p>
     * Lists the names of the inline policies embedded in the specified IAM user.
     * </p>
     * <p>
     * An IAM user can also have managed policies attached to it. To list the managed policies that are attached to a
     * user, use <a>ListAttachedUserPolicies</a>. For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and
     * Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. If there are no
     * inline policies embedded with the specified user, the operation returns an empty list.
     * </p>
     *
     * @param listUserPoliciesRequest
     * @return Result of the ListUserPolicies operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListUserPolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListUserPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListUserPoliciesResponse listUserPolicies(ListUserPoliciesRequest listUserPoliciesRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<ListUserPoliciesResponse> responseHandler = protocolFactory
                .createResponseHandler(ListUserPoliciesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUserPoliciesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUserPolicies");

            return clientHandler.execute(new ClientExecutionParams<ListUserPoliciesRequest, ListUserPoliciesResponse>()
                    .withOperationName("ListUserPolicies").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listUserPoliciesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListUserPoliciesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the names of the inline policies embedded in the specified IAM user.
     * </p>
     * <p>
     * An IAM user can also have managed policies attached to it. To list the managed policies that are attached to a
     * user, use <a>ListAttachedUserPolicies</a>. For more information about policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and
     * Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters. If there are no
     * inline policies embedded with the specified user, the operation returns an empty list.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listUserPolicies(software.amazon.awssdk.services.iam.model.ListUserPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListUserPoliciesIterable responses = client.listUserPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListUserPoliciesIterable responses = client.listUserPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListUserPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListUserPoliciesIterable responses = client.listUserPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUserPolicies(software.amazon.awssdk.services.iam.model.ListUserPoliciesRequest)} operation.</b>
     * </p>
     *
     * @param listUserPoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListUserPolicies
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListUserPolicies" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListUserPoliciesIterable listUserPoliciesPaginator(ListUserPoliciesRequest listUserPoliciesRequest)
            throws NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {
        return new ListUserPoliciesIterable(this, applyPaginatorUserAgent(listUserPoliciesRequest));
    }

    /**
     * <p>
     * Lists the tags that are attached to the specified user. The returned list of tags is sorted by tag key. For more
     * information about tagging, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging
     * IAM Identities</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param listUserTagsRequest
     * @return Result of the ListUserTags operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListUserTags
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListUserTags" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListUserTagsResponse listUserTags(ListUserTagsRequest listUserTagsRequest) throws NoSuchEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<ListUserTagsResponse> responseHandler = protocolFactory
                .createResponseHandler(ListUserTagsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUserTagsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUserTags");

            return clientHandler.execute(new ClientExecutionParams<ListUserTagsRequest, ListUserTagsResponse>()
                    .withOperationName("ListUserTags").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listUserTagsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListUserTagsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the IAM users that have the specified path prefix. If no path prefix is specified, the operation returns
     * all users in the AWS account. If there are none, the operation returns an empty list.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listUsersRequest
     * @return Result of the ListUsers operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListUsersResponse listUsers(ListUsersRequest listUsersRequest) throws ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {

        HttpResponseHandler<ListUsersResponse> responseHandler = protocolFactory
                .createResponseHandler(ListUsersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUsersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUsers");

            return clientHandler.execute(new ClientExecutionParams<ListUsersRequest, ListUsersResponse>()
                    .withOperationName("ListUsers").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listUsersRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new ListUsersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the IAM users that have the specified path prefix. If no path prefix is specified, the operation returns
     * all users in the AWS account. If there are none, the operation returns an empty list.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listUsers(software.amazon.awssdk.services.iam.model.ListUsersRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListUsersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListUsersIterable responses = client.listUsersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listUsers(software.amazon.awssdk.services.iam.model.ListUsersRequest)} operation.</b>
     * </p>
     *
     * @param listUsersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListUsers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListUsersIterable listUsersPaginator(ListUsersRequest listUsersRequest) throws ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {
        return new ListUsersIterable(this, applyPaginatorUserAgent(listUsersRequest));
    }

    /**
     * <p>
     * Lists the virtual MFA devices defined in the AWS account by assignment status. If you do not specify an
     * assignment status, the operation returns a list of all virtual MFA devices. Assignment status can be
     * <code>Assigned</code>, <code>Unassigned</code>, or <code>Any</code>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     *
     * @param listVirtualMfaDevicesRequest
     * @return Result of the ListVirtualMFADevices operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListVirtualMFADevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListVirtualMFADevices" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListVirtualMfaDevicesResponse listVirtualMFADevices(ListVirtualMfaDevicesRequest listVirtualMfaDevicesRequest)
            throws AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<ListVirtualMfaDevicesResponse> responseHandler = protocolFactory
                .createResponseHandler(ListVirtualMfaDevicesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listVirtualMfaDevicesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVirtualMFADevices");

            return clientHandler.execute(new ClientExecutionParams<ListVirtualMfaDevicesRequest, ListVirtualMfaDevicesResponse>()
                    .withOperationName("ListVirtualMFADevices").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listVirtualMfaDevicesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListVirtualMfaDevicesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the virtual MFA devices defined in the AWS account by assignment status. If you do not specify an
     * assignment status, the operation returns a list of all virtual MFA devices. Assignment status can be
     * <code>Assigned</code>, <code>Unassigned</code>, or <code>Any</code>.
     * </p>
     * <p>
     * You can paginate the results using the <code>MaxItems</code> and <code>Marker</code> parameters.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listVirtualMFADevices(software.amazon.awssdk.services.iam.model.ListVirtualMfaDevicesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListVirtualMFADevicesIterable responses = client.listVirtualMFADevicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.ListVirtualMFADevicesIterable responses = client
     *             .listVirtualMFADevicesPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.ListVirtualMfaDevicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.ListVirtualMFADevicesIterable responses = client.listVirtualMFADevicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVirtualMFADevices(software.amazon.awssdk.services.iam.model.ListVirtualMfaDevicesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVirtualMfaDevicesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ListVirtualMFADevices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListVirtualMFADevices" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListVirtualMFADevicesIterable listVirtualMFADevicesPaginator(ListVirtualMfaDevicesRequest listVirtualMfaDevicesRequest)
            throws AwsServiceException, SdkClientException, IamException {
        return new ListVirtualMFADevicesIterable(this, applyPaginatorUserAgent(listVirtualMfaDevicesRequest));
    }

    /**
     * <p>
     * Adds or updates an inline policy document that is embedded in the specified IAM group.
     * </p>
     * <p>
     * A user can also have managed policies attached to it. To attach a managed policy to a group, use
     * <a>AttachGroupPolicy</a>. To create a new managed policy, use <a>CreatePolicy</a>. For information about
     * policies, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed
     * Policies and Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For information about limits on the number of inline policies that you can embed in a group, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html">Limitations on IAM
     * Entities</a> in the <i>IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * Because policy documents can be large, you should use POST rather than GET when calling
     * <code>PutGroupPolicy</code>. For general information about using the Query API with IAM, go to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html">Making Query Requests</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * </note>
     *
     * @param putGroupPolicyRequest
     * @return Result of the PutGroupPolicy operation returned by the service.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws MalformedPolicyDocumentException
     *         The request was rejected because the policy document was malformed. The error message describes the
     *         specific error.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.PutGroupPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PutGroupPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutGroupPolicyResponse putGroupPolicy(PutGroupPolicyRequest putGroupPolicyRequest) throws LimitExceededException,
            MalformedPolicyDocumentException, NoSuchEntityException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {

        HttpResponseHandler<PutGroupPolicyResponse> responseHandler = protocolFactory
                .createResponseHandler(PutGroupPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putGroupPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutGroupPolicy");

            return clientHandler.execute(new ClientExecutionParams<PutGroupPolicyRequest, PutGroupPolicyResponse>()
                    .withOperationName("PutGroupPolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putGroupPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutGroupPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds or updates the policy that is specified as the IAM role's permissions boundary. You can use an AWS managed
     * policy or a customer managed policy to set the boundary for a role. Use the boundary to control the maximum
     * permissions that the role can have. Setting a permissions boundary is an advanced feature that can affect the
     * permissions for the role.
     * </p>
     * <p>
     * You cannot set the boundary for a service-linked role.
     * </p>
     * <important>
     * <p>
     * Policies used as permissions boundaries do not provide permissions. You must also attach a permissions policy to
     * the role. To learn how the effective permissions for a role are evaluated, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html">IAM JSON Policy
     * Evaluation Logic</a> in the IAM User Guide.
     * </p>
     * </important>
     *
     * @param putRolePermissionsBoundaryRequest
     * @return Result of the PutRolePermissionsBoundary operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws UnmodifiableEntityException
     *         The request was rejected because only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.
     * @throws PolicyNotAttachableException
     *         The request failed because AWS service role policies can only be attached to the service-linked role for
     *         that service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.PutRolePermissionsBoundary
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PutRolePermissionsBoundary" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public PutRolePermissionsBoundaryResponse putRolePermissionsBoundary(
            PutRolePermissionsBoundaryRequest putRolePermissionsBoundaryRequest) throws NoSuchEntityException,
            InvalidInputException, UnmodifiableEntityException, PolicyNotAttachableException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<PutRolePermissionsBoundaryResponse> responseHandler = protocolFactory
                .createResponseHandler(PutRolePermissionsBoundaryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putRolePermissionsBoundaryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutRolePermissionsBoundary");

            return clientHandler
                    .execute(new ClientExecutionParams<PutRolePermissionsBoundaryRequest, PutRolePermissionsBoundaryResponse>()
                            .withOperationName("PutRolePermissionsBoundary").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(putRolePermissionsBoundaryRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutRolePermissionsBoundaryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds or updates an inline policy document that is embedded in the specified IAM role.
     * </p>
     * <p>
     * When you embed an inline policy in a role, the inline policy is used as part of the role's access (permissions)
     * policy. The role's trust policy is created at the same time as the role, using <a>CreateRole</a>. You can update
     * a role's trust policy using <a>UpdateAssumeRolePolicy</a>. For more information about IAM roles, go to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html">Using Roles to Delegate Permissions
     * and Federate Identities</a>.
     * </p>
     * <p>
     * A role can also have a managed policy attached to it. To attach a managed policy to a role, use
     * <a>AttachRolePolicy</a>. To create a new managed policy, use <a>CreatePolicy</a>. For information about policies,
     * see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies
     * and Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For information about limits on the number of inline policies that you can embed with a role, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html">Limitations on IAM
     * Entities</a> in the <i>IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * Because policy documents can be large, you should use POST rather than GET when calling
     * <code>PutRolePolicy</code>. For general information about using the Query API with IAM, go to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html">Making Query Requests</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * </note>
     *
     * @param putRolePolicyRequest
     * @return Result of the PutRolePolicy operation returned by the service.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws MalformedPolicyDocumentException
     *         The request was rejected because the policy document was malformed. The error message describes the
     *         specific error.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws UnmodifiableEntityException
     *         The request was rejected because only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.PutRolePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PutRolePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutRolePolicyResponse putRolePolicy(PutRolePolicyRequest putRolePolicyRequest) throws LimitExceededException,
            MalformedPolicyDocumentException, NoSuchEntityException, UnmodifiableEntityException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<PutRolePolicyResponse> responseHandler = protocolFactory
                .createResponseHandler(PutRolePolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putRolePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutRolePolicy");

            return clientHandler.execute(new ClientExecutionParams<PutRolePolicyRequest, PutRolePolicyResponse>()
                    .withOperationName("PutRolePolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putRolePolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutRolePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds or updates the policy that is specified as the IAM user's permissions boundary. You can use an AWS managed
     * policy or a customer managed policy to set the boundary for a user. Use the boundary to control the maximum
     * permissions that the user can have. Setting a permissions boundary is an advanced feature that can affect the
     * permissions for the user.
     * </p>
     * <important>
     * <p>
     * Policies that are used as permissions boundaries do not provide permissions. You must also attach a permissions
     * policy to the user. To learn how the effective permissions for a user are evaluated, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html">IAM JSON Policy
     * Evaluation Logic</a> in the IAM User Guide.
     * </p>
     * </important>
     *
     * @param putUserPermissionsBoundaryRequest
     * @return Result of the PutUserPermissionsBoundary operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws PolicyNotAttachableException
     *         The request failed because AWS service role policies can only be attached to the service-linked role for
     *         that service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.PutUserPermissionsBoundary
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PutUserPermissionsBoundary" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public PutUserPermissionsBoundaryResponse putUserPermissionsBoundary(
            PutUserPermissionsBoundaryRequest putUserPermissionsBoundaryRequest) throws NoSuchEntityException,
            InvalidInputException, PolicyNotAttachableException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {

        HttpResponseHandler<PutUserPermissionsBoundaryResponse> responseHandler = protocolFactory
                .createResponseHandler(PutUserPermissionsBoundaryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putUserPermissionsBoundaryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutUserPermissionsBoundary");

            return clientHandler
                    .execute(new ClientExecutionParams<PutUserPermissionsBoundaryRequest, PutUserPermissionsBoundaryResponse>()
                            .withOperationName("PutUserPermissionsBoundary").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(putUserPermissionsBoundaryRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutUserPermissionsBoundaryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds or updates an inline policy document that is embedded in the specified IAM user.
     * </p>
     * <p>
     * An IAM user can also have a managed policy attached to it. To attach a managed policy to a user, use
     * <a>AttachUserPolicy</a>. To create a new managed policy, use <a>CreatePolicy</a>. For information about policies,
     * see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies
     * and Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * For information about limits on the number of inline policies that you can embed in a user, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/LimitationsOnEntities.html">Limitations on IAM
     * Entities</a> in the <i>IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * Because policy documents can be large, you should use POST rather than GET when calling
     * <code>PutUserPolicy</code>. For general information about using the Query API with IAM, go to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html">Making Query Requests</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * </note>
     *
     * @param putUserPolicyRequest
     * @return Result of the PutUserPolicy operation returned by the service.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws MalformedPolicyDocumentException
     *         The request was rejected because the policy document was malformed. The error message describes the
     *         specific error.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.PutUserPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/PutUserPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutUserPolicyResponse putUserPolicy(PutUserPolicyRequest putUserPolicyRequest) throws LimitExceededException,
            MalformedPolicyDocumentException, NoSuchEntityException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {

        HttpResponseHandler<PutUserPolicyResponse> responseHandler = protocolFactory
                .createResponseHandler(PutUserPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putUserPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutUserPolicy");

            return clientHandler.execute(new ClientExecutionParams<PutUserPolicyRequest, PutUserPolicyResponse>()
                    .withOperationName("PutUserPolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putUserPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutUserPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the specified client ID (also known as audience) from the list of client IDs registered for the specified
     * IAM OpenID Connect (OIDC) provider resource object.
     * </p>
     * <p>
     * This operation is idempotent; it does not fail or return an error if you try to remove a client ID that does not
     * exist.
     * </p>
     *
     * @param removeClientIdFromOpenIdConnectProviderRequest
     * @return Result of the RemoveClientIDFromOpenIDConnectProvider operation returned by the service.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.RemoveClientIDFromOpenIDConnectProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/RemoveClientIDFromOpenIDConnectProvider"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RemoveClientIdFromOpenIdConnectProviderResponse removeClientIDFromOpenIDConnectProvider(
            RemoveClientIdFromOpenIdConnectProviderRequest removeClientIdFromOpenIdConnectProviderRequest)
            throws InvalidInputException, NoSuchEntityException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {

        HttpResponseHandler<RemoveClientIdFromOpenIdConnectProviderResponse> responseHandler = protocolFactory
                .createResponseHandler(RemoveClientIdFromOpenIdConnectProviderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                removeClientIdFromOpenIdConnectProviderRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveClientIDFromOpenIDConnectProvider");

            return clientHandler
                    .execute(new ClientExecutionParams<RemoveClientIdFromOpenIdConnectProviderRequest, RemoveClientIdFromOpenIdConnectProviderResponse>()
                            .withOperationName("RemoveClientIDFromOpenIDConnectProvider").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(removeClientIdFromOpenIdConnectProviderRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RemoveClientIdFromOpenIdConnectProviderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the specified IAM role from the specified EC2 instance profile.
     * </p>
     * <important>
     * <p>
     * Make sure that you do not have any Amazon EC2 instances running with the role you are about to remove from the
     * instance profile. Removing a role from an instance profile that is associated with a running instance might break
     * any applications running on the instance.
     * </p>
     * </important>
     * <p>
     * For more information about IAM roles, go to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/WorkingWithRoles.html">Working with Roles</a>. For more
     * information about instance profiles, go to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/AboutInstanceProfiles.html">About Instance Profiles</a>.
     * </p>
     *
     * @param removeRoleFromInstanceProfileRequest
     * @return Result of the RemoveRoleFromInstanceProfile operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws UnmodifiableEntityException
     *         The request was rejected because only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.RemoveRoleFromInstanceProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/RemoveRoleFromInstanceProfile"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RemoveRoleFromInstanceProfileResponse removeRoleFromInstanceProfile(
            RemoveRoleFromInstanceProfileRequest removeRoleFromInstanceProfileRequest) throws NoSuchEntityException,
            LimitExceededException, UnmodifiableEntityException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {

        HttpResponseHandler<RemoveRoleFromInstanceProfileResponse> responseHandler = protocolFactory
                .createResponseHandler(RemoveRoleFromInstanceProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                removeRoleFromInstanceProfileRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveRoleFromInstanceProfile");

            return clientHandler
                    .execute(new ClientExecutionParams<RemoveRoleFromInstanceProfileRequest, RemoveRoleFromInstanceProfileResponse>()
                            .withOperationName("RemoveRoleFromInstanceProfile").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(removeRoleFromInstanceProfileRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RemoveRoleFromInstanceProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the specified user from the specified group.
     * </p>
     *
     * @param removeUserFromGroupRequest
     * @return Result of the RemoveUserFromGroup operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.RemoveUserFromGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/RemoveUserFromGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public RemoveUserFromGroupResponse removeUserFromGroup(RemoveUserFromGroupRequest removeUserFromGroupRequest)
            throws NoSuchEntityException, LimitExceededException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {

        HttpResponseHandler<RemoveUserFromGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(RemoveUserFromGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeUserFromGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveUserFromGroup");

            return clientHandler.execute(new ClientExecutionParams<RemoveUserFromGroupRequest, RemoveUserFromGroupResponse>()
                    .withOperationName("RemoveUserFromGroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(removeUserFromGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RemoveUserFromGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Resets the password for a service-specific credential. The new password is AWS generated and cryptographically
     * strong. It cannot be configured by the user. Resetting the password immediately invalidates the previous password
     * associated with this user.
     * </p>
     *
     * @param resetServiceSpecificCredentialRequest
     * @return Result of the ResetServiceSpecificCredential operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ResetServiceSpecificCredential
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ResetServiceSpecificCredential"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ResetServiceSpecificCredentialResponse resetServiceSpecificCredential(
            ResetServiceSpecificCredentialRequest resetServiceSpecificCredentialRequest) throws NoSuchEntityException,
            AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<ResetServiceSpecificCredentialResponse> responseHandler = protocolFactory
                .createResponseHandler(ResetServiceSpecificCredentialResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                resetServiceSpecificCredentialRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResetServiceSpecificCredential");

            return clientHandler
                    .execute(new ClientExecutionParams<ResetServiceSpecificCredentialRequest, ResetServiceSpecificCredentialResponse>()
                            .withOperationName("ResetServiceSpecificCredential").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(resetServiceSpecificCredentialRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ResetServiceSpecificCredentialRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Synchronizes the specified MFA device with its IAM resource object on the AWS servers.
     * </p>
     * <p>
     * For more information about creating and working with virtual MFA devices, go to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_VirtualMFA.html">Using a Virtual MFA Device</a> in
     * the <i>IAM User Guide</i>.
     * </p>
     *
     * @param resyncMfaDeviceRequest
     * @return Result of the ResyncMFADevice operation returned by the service.
     * @throws InvalidAuthenticationCodeException
     *         The request was rejected because the authentication code was not recognized. The error message describes
     *         the specific error.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.ResyncMFADevice
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ResyncMFADevice" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ResyncMfaDeviceResponse resyncMFADevice(ResyncMfaDeviceRequest resyncMfaDeviceRequest)
            throws InvalidAuthenticationCodeException, NoSuchEntityException, LimitExceededException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<ResyncMfaDeviceResponse> responseHandler = protocolFactory
                .createResponseHandler(ResyncMfaDeviceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resyncMfaDeviceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResyncMFADevice");

            return clientHandler.execute(new ClientExecutionParams<ResyncMfaDeviceRequest, ResyncMfaDeviceResponse>()
                    .withOperationName("ResyncMFADevice").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(resyncMfaDeviceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ResyncMfaDeviceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Sets the specified version of the specified policy as the policy's default (operative) version.
     * </p>
     * <p>
     * This operation affects all users, groups, and roles that the policy is attached to. To list the users, groups,
     * and roles that the policy is attached to, use the <a>ListEntitiesForPolicy</a> API.
     * </p>
     * <p>
     * For information about managed policies, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html">Managed Policies and
     * Inline Policies</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param setDefaultPolicyVersionRequest
     * @return Result of the SetDefaultPolicyVersion operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.SetDefaultPolicyVersion
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/SetDefaultPolicyVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public SetDefaultPolicyVersionResponse setDefaultPolicyVersion(SetDefaultPolicyVersionRequest setDefaultPolicyVersionRequest)
            throws NoSuchEntityException, InvalidInputException, LimitExceededException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<SetDefaultPolicyVersionResponse> responseHandler = protocolFactory
                .createResponseHandler(SetDefaultPolicyVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, setDefaultPolicyVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetDefaultPolicyVersion");

            return clientHandler
                    .execute(new ClientExecutionParams<SetDefaultPolicyVersionRequest, SetDefaultPolicyVersionResponse>()
                            .withOperationName("SetDefaultPolicyVersion").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(setDefaultPolicyVersionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new SetDefaultPolicyVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Sets the specified version of the global endpoint token as the token version used for the AWS account.
     * </p>
     * <p>
     * By default, AWS Security Token Service (STS) is available as a global service, and all STS requests go to a
     * single endpoint at <code>https://sts.amazonaws.com</code>. AWS recommends using Regional STS endpoints to reduce
     * latency, build in redundancy, and increase session token availability. For information about Regional endpoints
     * for STS, see <a href="https://docs.aws.amazon.com/general/latest/gr/rande.html#sts_region">AWS Regions and
     * Endpoints</a> in the <i>AWS General Reference</i>.
     * </p>
     * <p>
     * If you make an STS call to the global endpoint, the resulting session tokens might be valid in some Regions but
     * not others. It depends on the version that is set in this operation. Version 1 tokens are valid only in AWS
     * Regions that are available by default. These tokens do not work in manually enabled Regions, such as Asia Pacific
     * (Hong Kong). Version 2 tokens are valid in all Regions. However, version 2 tokens are longer and might affect
     * systems where you temporarily store tokens. For information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html">Activating and
     * Deactivating STS in an AWS Region</a> in the <i>IAM User Guide</i>.
     * </p>
     * <p>
     * To view the current session token version, see the <code>GlobalEndpointTokenVersion</code> entry in the response
     * of the <a>GetAccountSummary</a> operation.
     * </p>
     *
     * @param setSecurityTokenServicePreferencesRequest
     * @return Result of the SetSecurityTokenServicePreferences operation returned by the service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.SetSecurityTokenServicePreferences
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/SetSecurityTokenServicePreferences"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SetSecurityTokenServicePreferencesResponse setSecurityTokenServicePreferences(
            SetSecurityTokenServicePreferencesRequest setSecurityTokenServicePreferencesRequest) throws ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<SetSecurityTokenServicePreferencesResponse> responseHandler = protocolFactory
                .createResponseHandler(SetSecurityTokenServicePreferencesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                setSecurityTokenServicePreferencesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SetSecurityTokenServicePreferences");

            return clientHandler
                    .execute(new ClientExecutionParams<SetSecurityTokenServicePreferencesRequest, SetSecurityTokenServicePreferencesResponse>()
                            .withOperationName("SetSecurityTokenServicePreferences").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(setSecurityTokenServicePreferencesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new SetSecurityTokenServicePreferencesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Simulate how a set of IAM policies and optionally a resource-based policy works with a list of API operations and
     * AWS resources to determine the policies' effective permissions. The policies are provided as strings.
     * </p>
     * <p>
     * The simulation does not perform the API operations; it only checks the authorization to determine if the
     * simulated policies allow or deny the operations.
     * </p>
     * <p>
     * If you want to simulate existing policies that are attached to an IAM user, group, or role, use
     * <a>SimulatePrincipalPolicy</a> instead.
     * </p>
     * <p>
     * Context keys are variables that are maintained by AWS and its services and which provide details about the
     * context of an API query request. You can use the <code>Condition</code> element of an IAM policy to evaluate
     * context keys. To get the list of context keys that the policies require for correct simulation, use
     * <a>GetContextKeysForCustomPolicy</a>.
     * </p>
     * <p>
     * If the output is long, you can use <code>MaxItems</code> and <code>Marker</code> parameters to paginate the
     * results.
     * </p>
     *
     * @param simulateCustomPolicyRequest
     * @return Result of the SimulateCustomPolicy operation returned by the service.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws PolicyEvaluationException
     *         The request failed because a provided policy could not be successfully evaluated. An additional detailed
     *         message indicates the source of the failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.SimulateCustomPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/SimulateCustomPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public SimulateCustomPolicyResponse simulateCustomPolicy(SimulateCustomPolicyRequest simulateCustomPolicyRequest)
            throws InvalidInputException, PolicyEvaluationException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<SimulateCustomPolicyResponse> responseHandler = protocolFactory
                .createResponseHandler(SimulateCustomPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, simulateCustomPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SimulateCustomPolicy");

            return clientHandler.execute(new ClientExecutionParams<SimulateCustomPolicyRequest, SimulateCustomPolicyResponse>()
                    .withOperationName("SimulateCustomPolicy").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(simulateCustomPolicyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SimulateCustomPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Simulate how a set of IAM policies and optionally a resource-based policy works with a list of API operations and
     * AWS resources to determine the policies' effective permissions. The policies are provided as strings.
     * </p>
     * <p>
     * The simulation does not perform the API operations; it only checks the authorization to determine if the
     * simulated policies allow or deny the operations.
     * </p>
     * <p>
     * If you want to simulate existing policies that are attached to an IAM user, group, or role, use
     * <a>SimulatePrincipalPolicy</a> instead.
     * </p>
     * <p>
     * Context keys are variables that are maintained by AWS and its services and which provide details about the
     * context of an API query request. You can use the <code>Condition</code> element of an IAM policy to evaluate
     * context keys. To get the list of context keys that the policies require for correct simulation, use
     * <a>GetContextKeysForCustomPolicy</a>.
     * </p>
     * <p>
     * If the output is long, you can use <code>MaxItems</code> and <code>Marker</code> parameters to paginate the
     * results.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #simulateCustomPolicy(software.amazon.awssdk.services.iam.model.SimulateCustomPolicyRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.SimulateCustomPolicyIterable responses = client.simulateCustomPolicyPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.SimulateCustomPolicyIterable responses = client
     *             .simulateCustomPolicyPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.SimulateCustomPolicyResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.SimulateCustomPolicyIterable responses = client.simulateCustomPolicyPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #simulateCustomPolicy(software.amazon.awssdk.services.iam.model.SimulateCustomPolicyRequest)}
     * operation.</b>
     * </p>
     *
     * @param simulateCustomPolicyRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws PolicyEvaluationException
     *         The request failed because a provided policy could not be successfully evaluated. An additional detailed
     *         message indicates the source of the failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.SimulateCustomPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/SimulateCustomPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public SimulateCustomPolicyIterable simulateCustomPolicyPaginator(SimulateCustomPolicyRequest simulateCustomPolicyRequest)
            throws InvalidInputException, PolicyEvaluationException, AwsServiceException, SdkClientException, IamException {
        return new SimulateCustomPolicyIterable(this, applyPaginatorUserAgent(simulateCustomPolicyRequest));
    }

    /**
     * <p>
     * Simulate how a set of IAM policies attached to an IAM entity works with a list of API operations and AWS
     * resources to determine the policies' effective permissions. The entity can be an IAM user, group, or role. If you
     * specify a user, then the simulation also includes all of the policies that are attached to groups that the user
     * belongs to.
     * </p>
     * <p>
     * You can optionally include a list of one or more additional policies specified as strings to include in the
     * simulation. If you want to simulate only policies specified as strings, use <a>SimulateCustomPolicy</a> instead.
     * </p>
     * <p>
     * You can also optionally include one resource-based policy to be evaluated with each of the resources included in
     * the simulation.
     * </p>
     * <p>
     * The simulation does not perform the API operations; it only checks the authorization to determine if the
     * simulated policies allow or deny the operations.
     * </p>
     * <p>
     * <b>Note:</b> This API discloses information about the permissions granted to other users. If you do not want
     * users to see other user's permissions, then consider allowing them to use <a>SimulateCustomPolicy</a> instead.
     * </p>
     * <p>
     * Context keys are variables maintained by AWS and its services that provide details about the context of an API
     * query request. You can use the <code>Condition</code> element of an IAM policy to evaluate context keys. To get
     * the list of context keys that the policies require for correct simulation, use
     * <a>GetContextKeysForPrincipalPolicy</a>.
     * </p>
     * <p>
     * If the output is long, you can use the <code>MaxItems</code> and <code>Marker</code> parameters to paginate the
     * results.
     * </p>
     *
     * @param simulatePrincipalPolicyRequest
     * @return Result of the SimulatePrincipalPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws PolicyEvaluationException
     *         The request failed because a provided policy could not be successfully evaluated. An additional detailed
     *         message indicates the source of the failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.SimulatePrincipalPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/SimulatePrincipalPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public SimulatePrincipalPolicyResponse simulatePrincipalPolicy(SimulatePrincipalPolicyRequest simulatePrincipalPolicyRequest)
            throws NoSuchEntityException, InvalidInputException, PolicyEvaluationException, AwsServiceException,
            SdkClientException, IamException {

        HttpResponseHandler<SimulatePrincipalPolicyResponse> responseHandler = protocolFactory
                .createResponseHandler(SimulatePrincipalPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, simulatePrincipalPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SimulatePrincipalPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<SimulatePrincipalPolicyRequest, SimulatePrincipalPolicyResponse>()
                            .withOperationName("SimulatePrincipalPolicy").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(simulatePrincipalPolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new SimulatePrincipalPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Simulate how a set of IAM policies attached to an IAM entity works with a list of API operations and AWS
     * resources to determine the policies' effective permissions. The entity can be an IAM user, group, or role. If you
     * specify a user, then the simulation also includes all of the policies that are attached to groups that the user
     * belongs to.
     * </p>
     * <p>
     * You can optionally include a list of one or more additional policies specified as strings to include in the
     * simulation. If you want to simulate only policies specified as strings, use <a>SimulateCustomPolicy</a> instead.
     * </p>
     * <p>
     * You can also optionally include one resource-based policy to be evaluated with each of the resources included in
     * the simulation.
     * </p>
     * <p>
     * The simulation does not perform the API operations; it only checks the authorization to determine if the
     * simulated policies allow or deny the operations.
     * </p>
     * <p>
     * <b>Note:</b> This API discloses information about the permissions granted to other users. If you do not want
     * users to see other user's permissions, then consider allowing them to use <a>SimulateCustomPolicy</a> instead.
     * </p>
     * <p>
     * Context keys are variables maintained by AWS and its services that provide details about the context of an API
     * query request. You can use the <code>Condition</code> element of an IAM policy to evaluate context keys. To get
     * the list of context keys that the policies require for correct simulation, use
     * <a>GetContextKeysForPrincipalPolicy</a>.
     * </p>
     * <p>
     * If the output is long, you can use the <code>MaxItems</code> and <code>Marker</code> parameters to paginate the
     * results.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #simulatePrincipalPolicy(software.amazon.awssdk.services.iam.model.SimulatePrincipalPolicyRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.SimulatePrincipalPolicyIterable responses = client.simulatePrincipalPolicyPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.iam.paginators.SimulatePrincipalPolicyIterable responses = client
     *             .simulatePrincipalPolicyPaginator(request);
     *     for (software.amazon.awssdk.services.iam.model.SimulatePrincipalPolicyResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.iam.paginators.SimulatePrincipalPolicyIterable responses = client.simulatePrincipalPolicyPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxItems won't limit the number of results you get with the paginator.
     * It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #simulatePrincipalPolicy(software.amazon.awssdk.services.iam.model.SimulatePrincipalPolicyRequest)}
     * operation.</b>
     * </p>
     *
     * @param simulatePrincipalPolicyRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws PolicyEvaluationException
     *         The request failed because a provided policy could not be successfully evaluated. An additional detailed
     *         message indicates the source of the failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.SimulatePrincipalPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/SimulatePrincipalPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public SimulatePrincipalPolicyIterable simulatePrincipalPolicyPaginator(
            SimulatePrincipalPolicyRequest simulatePrincipalPolicyRequest) throws NoSuchEntityException, InvalidInputException,
            PolicyEvaluationException, AwsServiceException, SdkClientException, IamException {
        return new SimulatePrincipalPolicyIterable(this, applyPaginatorUserAgent(simulatePrincipalPolicyRequest));
    }

    /**
     * <p>
     * Adds one or more tags to an IAM role. The role can be a regular role or a service-linked role. If a tag with the
     * same key name already exists, then that tag is overwritten with the new value.
     * </p>
     * <p>
     * A tag consists of a key name and an associated value. By assigning tags to your resources, you can do the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Administrative grouping and discovery</b> - Attach tags to resources to aid in organization and search. For
     * example, you could search for all resources with the key name <i>Project</i> and the value
     * <i>MyImportantProject</i>. Or search for all resources with the key name <i>Cost Center</i> and the value
     * <i>41200</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Access control</b> - Reference tags in IAM user-based and resource-based policies. You can use tags to
     * restrict access to only an IAM user or role that has a specified tag attached. You can also restrict access to
     * only those resources that have a certain tag attached. For examples of policies that show how to use tags to
     * control access, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Control Access
     * Using IAM Tags</a> in the <i>IAM User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Cost allocation</b> - Use tags to help track which individuals and teams are using which AWS resources.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <ul>
     * <li>
     * <p>
     * Make sure that you have no invalid tags and that you do not exceed the allowed number of tags per role. In either
     * case, the entire request fails and <i>no</i> tags are added to the role.
     * </p>
     * </li>
     * <li>
     * <p>
     * AWS always interprets the tag <code>Value</code> as a single string. If you need to store an array, you can store
     * comma-separated values in the string. However, you must interpret the value in your code.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM Identities</a> in the <i>IAM
     * User Guide</i>.
     * </p>
     *
     * @param tagRoleRequest
     * @return Result of the TagRole operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ConcurrentModificationException
     *         The request was rejected because multiple requests to change this object were submitted simultaneously.
     *         Wait a few minutes and submit your request again.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.TagRole
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/TagRole" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagRoleResponse tagRole(TagRoleRequest tagRoleRequest) throws NoSuchEntityException, LimitExceededException,
            InvalidInputException, ConcurrentModificationException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {

        HttpResponseHandler<TagRoleResponse> responseHandler = protocolFactory.createResponseHandler(TagRoleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagRoleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagRole");

            return clientHandler.execute(new ClientExecutionParams<TagRoleRequest, TagRoleResponse>()
                    .withOperationName("TagRole").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(tagRoleRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new TagRoleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds one or more tags to an IAM user. If a tag with the same key name already exists, then that tag is
     * overwritten with the new value.
     * </p>
     * <p>
     * A tag consists of a key name and an associated value. By assigning tags to your resources, you can do the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Administrative grouping and discovery</b> - Attach tags to resources to aid in organization and search. For
     * example, you could search for all resources with the key name <i>Project</i> and the value
     * <i>MyImportantProject</i>. Or search for all resources with the key name <i>Cost Center</i> and the value
     * <i>41200</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Access control</b> - Reference tags in IAM user-based and resource-based policies. You can use tags to
     * restrict access to only an IAM requesting user or to a role that has a specified tag attached. You can also
     * restrict access to only those resources that have a certain tag attached. For examples of policies that show how
     * to use tags to control access, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html">Control Access Using IAM Tags</a> in the
     * <i>IAM User Guide</i>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>Cost allocation</b> - Use tags to help track which individuals and teams are using which AWS resources.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <ul>
     * <li>
     * <p>
     * Make sure that you have no invalid tags and that you do not exceed the allowed number of tags per role. In either
     * case, the entire request fails and <i>no</i> tags are added to the role.
     * </p>
     * </li>
     * <li>
     * <p>
     * AWS always interprets the tag <code>Value</code> as a single string. If you need to store an array, you can store
     * comma-separated values in the string. However, you must interpret the value in your code.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM Identities</a> in the <i>IAM
     * User Guide</i>.
     * </p>
     *
     * @param tagUserRequest
     * @return Result of the TagUser operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws ConcurrentModificationException
     *         The request was rejected because multiple requests to change this object were submitted simultaneously.
     *         Wait a few minutes and submit your request again.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.TagUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/TagUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagUserResponse tagUser(TagUserRequest tagUserRequest) throws NoSuchEntityException, LimitExceededException,
            InvalidInputException, ConcurrentModificationException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {

        HttpResponseHandler<TagUserResponse> responseHandler = protocolFactory.createResponseHandler(TagUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagUser");

            return clientHandler.execute(new ClientExecutionParams<TagUserRequest, TagUserResponse>()
                    .withOperationName("TagUser").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(tagUserRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new TagUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the specified tags from the role. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM Identities</a> in the <i>IAM
     * User Guide</i>.
     * </p>
     *
     * @param untagRoleRequest
     * @return Result of the UntagRole operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ConcurrentModificationException
     *         The request was rejected because multiple requests to change this object were submitted simultaneously.
     *         Wait a few minutes and submit your request again.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.UntagRole
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UntagRole" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagRoleResponse untagRole(UntagRoleRequest untagRoleRequest) throws NoSuchEntityException,
            ConcurrentModificationException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<UntagRoleResponse> responseHandler = protocolFactory
                .createResponseHandler(UntagRoleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagRoleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagRole");

            return clientHandler.execute(new ClientExecutionParams<UntagRoleRequest, UntagRoleResponse>()
                    .withOperationName("UntagRole").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(untagRoleRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new UntagRoleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the specified tags from the user. For more information about tagging, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html">Tagging IAM Identities</a> in the <i>IAM
     * User Guide</i>.
     * </p>
     *
     * @param untagUserRequest
     * @return Result of the UntagUser operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ConcurrentModificationException
     *         The request was rejected because multiple requests to change this object were submitted simultaneously.
     *         Wait a few minutes and submit your request again.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.UntagUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UntagUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagUserResponse untagUser(UntagUserRequest untagUserRequest) throws NoSuchEntityException,
            ConcurrentModificationException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<UntagUserResponse> responseHandler = protocolFactory
                .createResponseHandler(UntagUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagUser");

            return clientHandler.execute(new ClientExecutionParams<UntagUserRequest, UntagUserResponse>()
                    .withOperationName("UntagUser").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(untagUserRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new UntagUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Changes the status of the specified access key from Active to Inactive, or vice versa. This operation can be used
     * to disable a user's key as part of a key rotation workflow.
     * </p>
     * <p>
     * If the <code>UserName</code> is not specified, the user name is determined implicitly based on the AWS access key
     * ID used to sign the request. This operation works for access keys under the AWS account. Consequently, you can
     * use this operation to manage AWS account root user credentials even if the AWS account has no associated users.
     * </p>
     * <p>
     * For information about rotating keys, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/ManagingCredentials.html">Managing Keys and
     * Certificates</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param updateAccessKeyRequest
     * @return Result of the UpdateAccessKey operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.UpdateAccessKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateAccessKey" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateAccessKeyResponse updateAccessKey(UpdateAccessKeyRequest updateAccessKeyRequest) throws NoSuchEntityException,
            LimitExceededException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<UpdateAccessKeyResponse> responseHandler = protocolFactory
                .createResponseHandler(UpdateAccessKeyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAccessKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAccessKey");

            return clientHandler.execute(new ClientExecutionParams<UpdateAccessKeyRequest, UpdateAccessKeyResponse>()
                    .withOperationName("UpdateAccessKey").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateAccessKeyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateAccessKeyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the password policy settings for the AWS account.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * This operation does not support partial updates. No parameters are required, but if you do not specify a
     * parameter, that parameter's value reverts to its default value. See the <b>Request Parameters</b> section for
     * each parameter's default value. Also note that some parameters do not allow the default parameter to be
     * explicitly set. Instead, to invoke the default value, do not include that parameter when you invoke the
     * operation.
     * </p>
     * </li>
     * </ul>
     * </note>
     * <p>
     * For more information about using a password policy, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingPasswordPolicies.html">Managing an IAM
     * Password Policy</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param updateAccountPasswordPolicyRequest
     * @return Result of the UpdateAccountPasswordPolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws MalformedPolicyDocumentException
     *         The request was rejected because the policy document was malformed. The error message describes the
     *         specific error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.UpdateAccountPasswordPolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateAccountPasswordPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateAccountPasswordPolicyResponse updateAccountPasswordPolicy(
            UpdateAccountPasswordPolicyRequest updateAccountPasswordPolicyRequest) throws NoSuchEntityException,
            MalformedPolicyDocumentException, LimitExceededException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {

        HttpResponseHandler<UpdateAccountPasswordPolicyResponse> responseHandler = protocolFactory
                .createResponseHandler(UpdateAccountPasswordPolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAccountPasswordPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAccountPasswordPolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateAccountPasswordPolicyRequest, UpdateAccountPasswordPolicyResponse>()
                            .withOperationName("UpdateAccountPasswordPolicy").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateAccountPasswordPolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateAccountPasswordPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the policy that grants an IAM entity permission to assume a role. This is typically referred to as the
     * "role trust policy". For more information about roles, go to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/roles-toplevel.html">Using Roles to Delegate Permissions
     * and Federate Identities</a>.
     * </p>
     *
     * @param updateAssumeRolePolicyRequest
     * @return Result of the UpdateAssumeRolePolicy operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws MalformedPolicyDocumentException
     *         The request was rejected because the policy document was malformed. The error message describes the
     *         specific error.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws UnmodifiableEntityException
     *         The request was rejected because only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.UpdateAssumeRolePolicy
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateAssumeRolePolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateAssumeRolePolicyResponse updateAssumeRolePolicy(UpdateAssumeRolePolicyRequest updateAssumeRolePolicyRequest)
            throws NoSuchEntityException, MalformedPolicyDocumentException, LimitExceededException, UnmodifiableEntityException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<UpdateAssumeRolePolicyResponse> responseHandler = protocolFactory
                .createResponseHandler(UpdateAssumeRolePolicyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAssumeRolePolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAssumeRolePolicy");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateAssumeRolePolicyRequest, UpdateAssumeRolePolicyResponse>()
                            .withOperationName("UpdateAssumeRolePolicy").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateAssumeRolePolicyRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateAssumeRolePolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the name and/or the path of the specified IAM group.
     * </p>
     * <important>
     * <p>
     * You should understand the implications of changing a group's path or name. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_WorkingWithGroupsAndUsers.html">Renaming Users and
     * Groups</a> in the <i>IAM User Guide</i>.
     * </p>
     * </important> <note>
     * <p>
     * The person making the request (the principal), must have permission to change the role group with the old name
     * and the new name. For example, to change the group named <code>Managers</code> to <code>MGRs</code>, the
     * principal must have a policy that allows them to update both groups. If the principal has permission to update
     * the <code>Managers</code> group, but not the <code>MGRs</code> group, then the update fails. For more information
     * about permissions, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access
     * Management</a>.
     * </p>
     * </note>
     *
     * @param updateGroupRequest
     * @return Result of the UpdateGroup operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.UpdateGroup
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateGroupResponse updateGroup(UpdateGroupRequest updateGroupRequest) throws NoSuchEntityException,
            EntityAlreadyExistsException, LimitExceededException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {

        HttpResponseHandler<UpdateGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(UpdateGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateGroup");

            return clientHandler.execute(new ClientExecutionParams<UpdateGroupRequest, UpdateGroupResponse>()
                    .withOperationName("UpdateGroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Changes the password for the specified IAM user.
     * </p>
     * <p>
     * IAM users can change their own passwords by calling <a>ChangePassword</a>. For more information about modifying
     * passwords, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_ManagingLogins.html">Managing
     * Passwords</a> in the <i>IAM User Guide</i>.
     * </p>
     *
     * @param updateLoginProfileRequest
     * @return Result of the UpdateLoginProfile operation returned by the service.
     * @throws EntityTemporarilyUnmodifiableException
     *         The request was rejected because it referenced an entity that is temporarily unmodifiable, such as a user
     *         name that was deleted and then recreated. The error indicates that the request is likely to succeed if
     *         you try again after waiting several minutes. The error message describes the entity.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws PasswordPolicyViolationException
     *         The request was rejected because the provided password did not meet the requirements imposed by the
     *         account password policy.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.UpdateLoginProfile
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateLoginProfile" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateLoginProfileResponse updateLoginProfile(UpdateLoginProfileRequest updateLoginProfileRequest)
            throws EntityTemporarilyUnmodifiableException, NoSuchEntityException, PasswordPolicyViolationException,
            LimitExceededException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<UpdateLoginProfileResponse> responseHandler = protocolFactory
                .createResponseHandler(UpdateLoginProfileResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateLoginProfileRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateLoginProfile");

            return clientHandler.execute(new ClientExecutionParams<UpdateLoginProfileRequest, UpdateLoginProfileResponse>()
                    .withOperationName("UpdateLoginProfile").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateLoginProfileRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateLoginProfileRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Replaces the existing list of server certificate thumbprints associated with an OpenID Connect (OIDC) provider
     * resource object with a new list of thumbprints.
     * </p>
     * <p>
     * The list that you pass with this operation completely replaces the existing list of thumbprints. (The lists are
     * not merged.)
     * </p>
     * <p>
     * Typically, you need to update a thumbprint only when the identity provider's certificate changes, which occurs
     * rarely. However, if the provider's certificate <i>does</i> change, any attempt to assume an IAM role that
     * specifies the OIDC provider as a principal fails until the certificate thumbprint is updated.
     * </p>
     * <note>
     * <p>
     * Trust for the OIDC provider is derived from the provider's certificate and is validated by the thumbprint.
     * Therefore, it is best to limit access to the <code>UpdateOpenIDConnectProviderThumbprint</code> operation to
     * highly privileged users.
     * </p>
     * </note>
     *
     * @param updateOpenIdConnectProviderThumbprintRequest
     * @return Result of the UpdateOpenIDConnectProviderThumbprint operation returned by the service.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.UpdateOpenIDConnectProviderThumbprint
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateOpenIDConnectProviderThumbprint"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateOpenIdConnectProviderThumbprintResponse updateOpenIDConnectProviderThumbprint(
            UpdateOpenIdConnectProviderThumbprintRequest updateOpenIdConnectProviderThumbprintRequest)
            throws InvalidInputException, NoSuchEntityException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {

        HttpResponseHandler<UpdateOpenIdConnectProviderThumbprintResponse> responseHandler = protocolFactory
                .createResponseHandler(UpdateOpenIdConnectProviderThumbprintResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateOpenIdConnectProviderThumbprintRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateOpenIDConnectProviderThumbprint");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateOpenIdConnectProviderThumbprintRequest, UpdateOpenIdConnectProviderThumbprintResponse>()
                            .withOperationName("UpdateOpenIDConnectProviderThumbprint").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateOpenIdConnectProviderThumbprintRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateOpenIdConnectProviderThumbprintRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the description or maximum session duration setting of a role.
     * </p>
     *
     * @param updateRoleRequest
     * @return Result of the UpdateRole operation returned by the service.
     * @throws UnmodifiableEntityException
     *         The request was rejected because only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.UpdateRole
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateRole" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateRoleResponse updateRole(UpdateRoleRequest updateRoleRequest) throws UnmodifiableEntityException,
            NoSuchEntityException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<UpdateRoleResponse> responseHandler = protocolFactory
                .createResponseHandler(UpdateRoleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRoleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRole");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateRoleRequest, UpdateRoleResponse>().withOperationName("UpdateRole")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateRoleRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateRoleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Use <a>UpdateRole</a> instead.
     * </p>
     * <p>
     * Modifies only the description of a role. This operation performs the same function as the
     * <code>Description</code> parameter in the <code>UpdateRole</code> operation.
     * </p>
     *
     * @param updateRoleDescriptionRequest
     * @return Result of the UpdateRoleDescription operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws UnmodifiableEntityException
     *         The request was rejected because only the service that depends on the service-linked role can modify or
     *         delete the role on your behalf. The error message includes the name of the service that depends on this
     *         service-linked role. You must request the change through that service.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.UpdateRoleDescription
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateRoleDescription" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateRoleDescriptionResponse updateRoleDescription(UpdateRoleDescriptionRequest updateRoleDescriptionRequest)
            throws NoSuchEntityException, UnmodifiableEntityException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {

        HttpResponseHandler<UpdateRoleDescriptionResponse> responseHandler = protocolFactory
                .createResponseHandler(UpdateRoleDescriptionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRoleDescriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRoleDescription");

            return clientHandler.execute(new ClientExecutionParams<UpdateRoleDescriptionRequest, UpdateRoleDescriptionResponse>()
                    .withOperationName("UpdateRoleDescription").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateRoleDescriptionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateRoleDescriptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the metadata document for an existing SAML provider resource object.
     * </p>
     * <note>
     * <p>
     * This operation requires <a
     * href="https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html">Signature Version 4</a>.
     * </p>
     * </note>
     *
     * @param updateSamlProviderRequest
     * @return Result of the UpdateSAMLProvider operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidInputException
     *         The request was rejected because an invalid or out-of-range value was supplied for an input parameter.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.UpdateSAMLProvider
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateSAMLProvider" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateSamlProviderResponse updateSAMLProvider(UpdateSamlProviderRequest updateSamlProviderRequest)
            throws NoSuchEntityException, InvalidInputException, LimitExceededException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<UpdateSamlProviderResponse> responseHandler = protocolFactory
                .createResponseHandler(UpdateSamlProviderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSamlProviderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSAMLProvider");

            return clientHandler.execute(new ClientExecutionParams<UpdateSamlProviderRequest, UpdateSamlProviderResponse>()
                    .withOperationName("UpdateSAMLProvider").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateSamlProviderRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateSamlProviderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Sets the status of an IAM user's SSH public key to active or inactive. SSH public keys that are inactive cannot
     * be used for authentication. This operation can be used to disable a user's SSH public key as part of a key
     * rotation work flow.
     * </p>
     * <p>
     * The SSH public key affected by this operation is used only for authenticating the associated IAM user to an AWS
     * CodeCommit repository. For more information about using SSH keys to authenticate to an AWS CodeCommit repository,
     * see <a href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up AWS
     * CodeCommit for SSH Connections</a> in the <i>AWS CodeCommit User Guide</i>.
     * </p>
     *
     * @param updateSshPublicKeyRequest
     * @return Result of the UpdateSSHPublicKey operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.UpdateSSHPublicKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateSSHPublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateSshPublicKeyResponse updateSSHPublicKey(UpdateSshPublicKeyRequest updateSshPublicKeyRequest)
            throws NoSuchEntityException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<UpdateSshPublicKeyResponse> responseHandler = protocolFactory
                .createResponseHandler(UpdateSshPublicKeyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSshPublicKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSSHPublicKey");

            return clientHandler.execute(new ClientExecutionParams<UpdateSshPublicKeyRequest, UpdateSshPublicKeyResponse>()
                    .withOperationName("UpdateSSHPublicKey").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateSshPublicKeyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateSshPublicKeyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the name and/or the path of the specified server certificate stored in IAM.
     * </p>
     * <p>
     * For more information about working with server certificates, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with Server
     * Certificates</a> in the <i>IAM User Guide</i>. This topic also includes a list of AWS services that can use the
     * server certificates that you manage with IAM.
     * </p>
     * <important>
     * <p>
     * You should understand the implications of changing a server certificate's path or name. For more information, see
     * <a href=
     * "https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs_manage.html#RenamingServerCerts"
     * >Renaming a Server Certificate</a> in the <i>IAM User Guide</i>.
     * </p>
     * </important> <note>
     * <p>
     * The person making the request (the principal), must have permission to change the server certificate with the old
     * name and the new name. For example, to change the certificate named <code>ProductionCert</code> to
     * <code>ProdCert</code>, the principal must have a policy that allows them to update both certificates. If the
     * principal has permission to update the <code>ProductionCert</code> group, but not the <code>ProdCert</code>
     * certificate, then the update fails. For more information about permissions, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/access.html">Access Management</a> in the <i>IAM User
     * Guide</i>.
     * </p>
     * </note>
     *
     * @param updateServerCertificateRequest
     * @return Result of the UpdateServerCertificate operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.UpdateServerCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateServerCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateServerCertificateResponse updateServerCertificate(UpdateServerCertificateRequest updateServerCertificateRequest)
            throws NoSuchEntityException, EntityAlreadyExistsException, LimitExceededException, ServiceFailureException,
            AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<UpdateServerCertificateResponse> responseHandler = protocolFactory
                .createResponseHandler(UpdateServerCertificateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateServerCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateServerCertificate");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateServerCertificateRequest, UpdateServerCertificateResponse>()
                            .withOperationName("UpdateServerCertificate").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateServerCertificateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateServerCertificateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Sets the status of a service-specific credential to <code>Active</code> or <code>Inactive</code>.
     * Service-specific credentials that are inactive cannot be used for authentication to the service. This operation
     * can be used to disable a user's service-specific credential as part of a credential rotation work flow.
     * </p>
     *
     * @param updateServiceSpecificCredentialRequest
     * @return Result of the UpdateServiceSpecificCredential operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.UpdateServiceSpecificCredential
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateServiceSpecificCredential"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateServiceSpecificCredentialResponse updateServiceSpecificCredential(
            UpdateServiceSpecificCredentialRequest updateServiceSpecificCredentialRequest) throws NoSuchEntityException,
            AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<UpdateServiceSpecificCredentialResponse> responseHandler = protocolFactory
                .createResponseHandler(UpdateServiceSpecificCredentialResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateServiceSpecificCredentialRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateServiceSpecificCredential");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateServiceSpecificCredentialRequest, UpdateServiceSpecificCredentialResponse>()
                            .withOperationName("UpdateServiceSpecificCredential").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateServiceSpecificCredentialRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateServiceSpecificCredentialRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Changes the status of the specified user signing certificate from active to disabled, or vice versa. This
     * operation can be used to disable an IAM user's signing certificate as part of a certificate rotation work flow.
     * </p>
     * <p>
     * If the <code>UserName</code> field is not specified, the user name is determined implicitly based on the AWS
     * access key ID used to sign the request. This operation works for access keys under the AWS account. Consequently,
     * you can use this operation to manage AWS account root user credentials even if the AWS account has no associated
     * users.
     * </p>
     *
     * @param updateSigningCertificateRequest
     * @return Result of the UpdateSigningCertificate operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.UpdateSigningCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateSigningCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateSigningCertificateResponse updateSigningCertificate(
            UpdateSigningCertificateRequest updateSigningCertificateRequest) throws NoSuchEntityException,
            LimitExceededException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<UpdateSigningCertificateResponse> responseHandler = protocolFactory
                .createResponseHandler(UpdateSigningCertificateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSigningCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSigningCertificate");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateSigningCertificateRequest, UpdateSigningCertificateResponse>()
                            .withOperationName("UpdateSigningCertificate").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateSigningCertificateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateSigningCertificateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the name and/or the path of the specified IAM user.
     * </p>
     * <important>
     * <p>
     * You should understand the implications of changing an IAM user's path or name. For more information, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_manage.html#id_users_renaming">Renaming an IAM
     * User</a> and <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_groups_manage_rename.html">Renaming an
     * IAM Group</a> in the <i>IAM User Guide</i>.
     * </p>
     * </important> <note>
     * <p>
     * To change a user name, the requester must have appropriate permissions on both the source object and the target
     * object. For example, to change Bob to Robert, the entity making the request must have permission on Bob and
     * Robert, or must have permission on all (*). For more information about permissions, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/PermissionsAndPolicies.html">Permissions and Policies</a>.
     * </p>
     * </note>
     *
     * @param updateUserRequest
     * @return Result of the UpdateUser operation returned by the service.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws EntityTemporarilyUnmodifiableException
     *         The request was rejected because it referenced an entity that is temporarily unmodifiable, such as a user
     *         name that was deleted and then recreated. The error indicates that the request is likely to succeed if
     *         you try again after waiting several minutes. The error message describes the entity.
     * @throws ConcurrentModificationException
     *         The request was rejected because multiple requests to change this object were submitted simultaneously.
     *         Wait a few minutes and submit your request again.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.UpdateUser
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateUserResponse updateUser(UpdateUserRequest updateUserRequest) throws NoSuchEntityException,
            LimitExceededException, EntityAlreadyExistsException, EntityTemporarilyUnmodifiableException,
            ConcurrentModificationException, ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<UpdateUserResponse> responseHandler = protocolFactory
                .createResponseHandler(UpdateUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateUser");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateUserRequest, UpdateUserResponse>().withOperationName("UpdateUser")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateUserRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Uploads an SSH public key and associates it with the specified IAM user.
     * </p>
     * <p>
     * The SSH public key uploaded by this operation can be used only for authenticating the associated IAM user to an
     * AWS CodeCommit repository. For more information about using SSH keys to authenticate to an AWS CodeCommit
     * repository, see <a
     * href="https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-credentials-ssh.html">Set up AWS
     * CodeCommit for SSH Connections</a> in the <i>AWS CodeCommit User Guide</i>.
     * </p>
     *
     * @param uploadSshPublicKeyRequest
     * @return Result of the UploadSSHPublicKey operation returned by the service.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws InvalidPublicKeyException
     *         The request was rejected because the public key is malformed or otherwise invalid.
     * @throws DuplicateSshPublicKeyException
     *         The request was rejected because the SSH public key is already associated with the specified IAM user.
     * @throws UnrecognizedPublicKeyEncodingException
     *         The request was rejected because the public key encoding format is unsupported or unrecognized.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.UploadSSHPublicKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UploadSSHPublicKey" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UploadSshPublicKeyResponse uploadSSHPublicKey(UploadSshPublicKeyRequest uploadSshPublicKeyRequest)
            throws LimitExceededException, NoSuchEntityException, InvalidPublicKeyException, DuplicateSshPublicKeyException,
            UnrecognizedPublicKeyEncodingException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<UploadSshPublicKeyResponse> responseHandler = protocolFactory
                .createResponseHandler(UploadSshPublicKeyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, uploadSshPublicKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UploadSSHPublicKey");

            return clientHandler.execute(new ClientExecutionParams<UploadSshPublicKeyRequest, UploadSshPublicKeyResponse>()
                    .withOperationName("UploadSSHPublicKey").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(uploadSshPublicKeyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UploadSshPublicKeyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Uploads a server certificate entity for the AWS account. The server certificate entity includes a public key
     * certificate, a private key, and an optional certificate chain, which should all be PEM-encoded.
     * </p>
     * <p>
     * We recommend that you use <a href="https://docs.aws.amazon.com/acm/">AWS Certificate Manager</a> to provision,
     * manage, and deploy your server certificates. With ACM you can request a certificate, deploy it to AWS resources,
     * and let ACM handle certificate renewals for you. Certificates provided by ACM are free. For more information
     * about using ACM, see the <a href="https://docs.aws.amazon.com/acm/latest/userguide/">AWS Certificate Manager User
     * Guide</a>.
     * </p>
     * <p>
     * For more information about working with server certificates, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_server-certs.html">Working with Server
     * Certificates</a> in the <i>IAM User Guide</i>. This topic includes a list of AWS services that can use the server
     * certificates that you manage with IAM.
     * </p>
     * <p>
     * For information about the number of server certificates you can upload, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-limits.html">Limitations on IAM Entities and
     * Objects</a> in the <i>IAM User Guide</i>.
     * </p>
     * <note>
     * <p>
     * Because the body of the public key certificate, private key, and the certificate chain can be large, you should
     * use POST rather than GET when calling <code>UploadServerCertificate</code>. For information about setting up
     * signatures and authorization through the API, go to <a
     * href="https://docs.aws.amazon.com/general/latest/gr/signing_aws_api_requests.html">Signing AWS API Requests</a>
     * in the <i>AWS General Reference</i>. For general information about using the Query API with IAM, go to <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/programming.html">Calling the API by Making HTTP Query
     * Requests</a> in the <i>IAM User Guide</i>.
     * </p>
     * </note>
     *
     * @param uploadServerCertificateRequest
     * @return Result of the UploadServerCertificate operation returned by the service.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws MalformedCertificateException
     *         The request was rejected because the certificate was malformed or expired. The error message describes
     *         the specific error.
     * @throws KeyPairMismatchException
     *         The request was rejected because the public key certificate and the private key do not match.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.UploadServerCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UploadServerCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UploadServerCertificateResponse uploadServerCertificate(UploadServerCertificateRequest uploadServerCertificateRequest)
            throws LimitExceededException, EntityAlreadyExistsException, MalformedCertificateException, KeyPairMismatchException,
            ServiceFailureException, AwsServiceException, SdkClientException, IamException {

        HttpResponseHandler<UploadServerCertificateResponse> responseHandler = protocolFactory
                .createResponseHandler(UploadServerCertificateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, uploadServerCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UploadServerCertificate");

            return clientHandler
                    .execute(new ClientExecutionParams<UploadServerCertificateRequest, UploadServerCertificateResponse>()
                            .withOperationName("UploadServerCertificate").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(uploadServerCertificateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UploadServerCertificateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Uploads an X.509 signing certificate and associates it with the specified IAM user. Some AWS services use X.509
     * signing certificates to validate requests that are signed with a corresponding private key. When you upload the
     * certificate, its default status is <code>Active</code>.
     * </p>
     * <p>
     * If the <code>UserName</code> is not specified, the IAM user name is determined implicitly based on the AWS access
     * key ID used to sign the request. This operation works for access keys under the AWS account. Consequently, you
     * can use this operation to manage AWS account root user credentials even if the AWS account has no associated
     * users.
     * </p>
     * <note>
     * <p>
     * Because the body of an X.509 certificate can be large, you should use POST rather than GET when calling
     * <code>UploadSigningCertificate</code>. For information about setting up signatures and authorization through the
     * API, go to <a href="https://docs.aws.amazon.com/general/latest/gr/signing_aws_api_requests.html">Signing AWS API
     * Requests</a> in the <i>AWS General Reference</i>. For general information about using the Query API with IAM, go
     * to <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/IAM_UsingQueryAPI.html">Making Query Requests</a> in
     * the <i>IAM User Guide</i>.
     * </p>
     * </note>
     *
     * @param uploadSigningCertificateRequest
     * @return Result of the UploadSigningCertificate operation returned by the service.
     * @throws LimitExceededException
     *         The request was rejected because it attempted to create resources beyond the current AWS account
     *         limitations. The error message describes the limit exceeded.
     * @throws EntityAlreadyExistsException
     *         The request was rejected because it attempted to create a resource that already exists.
     * @throws MalformedCertificateException
     *         The request was rejected because the certificate was malformed or expired. The error message describes
     *         the specific error.
     * @throws InvalidCertificateException
     *         The request was rejected because the certificate is invalid.
     * @throws DuplicateCertificateException
     *         The request was rejected because the same certificate is associated with an IAM user in the account.
     * @throws NoSuchEntityException
     *         The request was rejected because it referenced a resource entity that does not exist. The error message
     *         describes the resource.
     * @throws ServiceFailureException
     *         The request processing has failed because of an unknown error, exception or failure.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws IamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample IamClient.UploadSigningCertificate
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/UploadSigningCertificate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UploadSigningCertificateResponse uploadSigningCertificate(
            UploadSigningCertificateRequest uploadSigningCertificateRequest) throws LimitExceededException,
            EntityAlreadyExistsException, MalformedCertificateException, InvalidCertificateException,
            DuplicateCertificateException, NoSuchEntityException, ServiceFailureException, AwsServiceException,
            SdkClientException, IamException {

        HttpResponseHandler<UploadSigningCertificateResponse> responseHandler = protocolFactory
                .createResponseHandler(UploadSigningCertificateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, uploadSigningCertificateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "IAM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UploadSigningCertificate");

            return clientHandler
                    .execute(new ClientExecutionParams<UploadSigningCertificateRequest, UploadSigningCertificateResponse>()
                            .withOperationName("UploadSigningCertificate").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(uploadSigningCertificateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UploadSigningCertificateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory
                .builder()
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConcurrentModification")
                                .exceptionBuilderSupplier(ConcurrentModificationException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MalformedPolicyDocument")
                                .exceptionBuilderSupplier(MalformedPolicyDocumentException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnmodifiableEntity")
                                .exceptionBuilderSupplier(UnmodifiableEntityException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DeleteConflict")
                                .exceptionBuilderSupplier(DeleteConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidCertificate")
                                .exceptionBuilderSupplier(InvalidCertificateException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PasswordPolicyViolation")
                                .exceptionBuilderSupplier(PasswordPolicyViolationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReportExpired")
                                .exceptionBuilderSupplier(CredentialReportExpiredException::builder).httpStatusCode(410).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceeded")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidUserType")
                                .exceptionBuilderSupplier(InvalidUserTypeException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NoSuchEntity")
                                .exceptionBuilderSupplier(NoSuchEntityException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EntityTemporarilyUnmodifiable")
                                .exceptionBuilderSupplier(EntityTemporarilyUnmodifiableException::builder).httpStatusCode(409)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotSupportedService")
                                .exceptionBuilderSupplier(ServiceNotSupportedException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DuplicateCertificate")
                                .exceptionBuilderSupplier(DuplicateCertificateException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("KeyPairMismatch")
                                .exceptionBuilderSupplier(KeyPairMismatchException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReportInProgress")
                                .exceptionBuilderSupplier(CredentialReportNotReadyException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("EntityAlreadyExists")
                                .exceptionBuilderSupplier(EntityAlreadyExistsException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceFailure")
                                .exceptionBuilderSupplier(ServiceFailureException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPublicKey")
                                .exceptionBuilderSupplier(InvalidPublicKeyException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DuplicateSSHPublicKey")
                                .exceptionBuilderSupplier(DuplicateSshPublicKeyException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PolicyEvaluation")
                                .exceptionBuilderSupplier(PolicyEvaluationException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidAuthenticationCode")
                                .exceptionBuilderSupplier(InvalidAuthenticationCodeException::builder).httpStatusCode(403)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidInput")
                                .exceptionBuilderSupplier(InvalidInputException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReportNotPresent")
                                .exceptionBuilderSupplier(CredentialReportNotPresentException::builder).httpStatusCode(410)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnrecognizedPublicKeyEncoding")
                                .exceptionBuilderSupplier(UnrecognizedPublicKeyEncodingException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ReportGenerationLimitExceeded")
                                .exceptionBuilderSupplier(ReportGenerationLimitExceededException::builder).httpStatusCode(409)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PolicyNotAttachable")
                                .exceptionBuilderSupplier(PolicyNotAttachableException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MalformedCertificate")
                                .exceptionBuilderSupplier(MalformedCertificateException::builder).httpStatusCode(400).build())
                .clientConfiguration(clientConfiguration).defaultServiceExceptionSupplier(IamException::builder).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends IamRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    @Override
    public IamWaiter waiter() {
        return IamWaiter.builder().client(this).build();
    }
}
