/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UploadServerCertificateRequest extends IamRequest implements
        ToCopyableBuilder<UploadServerCertificateRequest.Builder, UploadServerCertificateRequest> {
    private static final SdkField<String> PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UploadServerCertificateRequest::path)).setter(setter(Builder::path))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()).build();

    private static final SdkField<String> SERVER_CERTIFICATE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UploadServerCertificateRequest::serverCertificateName)).setter(setter(Builder::serverCertificateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServerCertificateName").build())
            .build();

    private static final SdkField<String> CERTIFICATE_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UploadServerCertificateRequest::certificateBody)).setter(setter(Builder::certificateBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateBody").build()).build();

    private static final SdkField<String> PRIVATE_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UploadServerCertificateRequest::privateKey)).setter(setter(Builder::privateKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateKey").build()).build();

    private static final SdkField<String> CERTIFICATE_CHAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UploadServerCertificateRequest::certificateChain)).setter(setter(Builder::certificateChain))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateChain").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD,
            SERVER_CERTIFICATE_NAME_FIELD, CERTIFICATE_BODY_FIELD, PRIVATE_KEY_FIELD, CERTIFICATE_CHAIN_FIELD));

    private final String path;

    private final String serverCertificateName;

    private final String certificateBody;

    private final String privateKey;

    private final String certificateChain;

    private UploadServerCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.path = builder.path;
        this.serverCertificateName = builder.serverCertificateName;
        this.certificateBody = builder.certificateBody;
        this.privateKey = builder.privateKey;
        this.certificateChain = builder.certificateChain;
    }

    /**
     * <p>
     * The path for the server certificate. For more information about paths, see <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the <i>IAM
     * User Guide</i>.
     * </p>
     * <p>
     * This parameter is optional. If it is not included, it defaults to a slash (/). This parameter allows (through its
     * <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either a
     * forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can contain
     * any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>), including
     * most punctuation characters, digits, and upper and lowercased letters.
     * </p>
     * <note>
     * <p>
     * If you are uploading a server certificate specifically for use with Amazon CloudFront distributions, you must
     * specify a path using the <code>path</code> parameter. The path must begin with <code>/cloudfront</code> and must
     * include a trailing slash (for example, <code>/cloudfront/test/</code>).
     * </p>
     * </note>
     * 
     * @return The path for the server certificate. For more information about paths, see <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the
     *         <i>IAM User Guide</i>.</p>
     *         <p>
     *         This parameter is optional. If it is not included, it defaults to a slash (/). This parameter allows
     *         (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters
     *         consisting of either a forward slash (/) by itself or a string that must begin and end with forward
     *         slashes. In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the DEL
     *         character (<code>\u007F</code>), including most punctuation characters, digits, and upper and lowercased
     *         letters.
     *         </p>
     *         <note>
     *         <p>
     *         If you are uploading a server certificate specifically for use with Amazon CloudFront distributions, you
     *         must specify a path using the <code>path</code> parameter. The path must begin with
     *         <code>/cloudfront</code> and must include a trailing slash (for example, <code>/cloudfront/test/</code>).
     *         </p>
     */
    public String path() {
        return path;
    }

    /**
     * <p>
     * The name for the server certificate. Do not include the path in this value. The name of the certificate cannot
     * contain any spaces.
     * </p>
     * <p>
     * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
     * characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any of
     * the following characters: _+=,.@-
     * </p>
     * 
     * @return The name for the server certificate. Do not include the path in this value. The name of the certificate
     *         cannot contain any spaces.</p>
     *         <p>
     *         This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string
     *         of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also
     *         include any of the following characters: _+=,.@-
     */
    public String serverCertificateName() {
        return serverCertificateName;
    }

    /**
     * <p>
     * The contents of the public key certificate in PEM-encoded format.
     * </p>
     * <p>
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of
     * characters consisting of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the ASCII
     * character range
     * </p>
     * </li>
     * <li>
     * <p>
     * The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>
     * )
     * </p>
     * </li>
     * </ul>
     * 
     * @return The contents of the public key certificate in PEM-encoded format.</p>
     *         <p>
     *         The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a
     *         string of characters consisting of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of
     *         the ASCII character range
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The printable characters in the Basic Latin and Latin-1 Supplement character set (through
     *         <code>\u00FF</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (
     *         <code>\u000D</code>)
     *         </p>
     *         </li>
     */
    public String certificateBody() {
        return certificateBody;
    }

    /**
     * <p>
     * The contents of the private key in PEM-encoded format.
     * </p>
     * <p>
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of
     * characters consisting of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the ASCII
     * character range
     * </p>
     * </li>
     * <li>
     * <p>
     * The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>
     * )
     * </p>
     * </li>
     * </ul>
     * 
     * @return The contents of the private key in PEM-encoded format.</p>
     *         <p>
     *         The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a
     *         string of characters consisting of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of
     *         the ASCII character range
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The printable characters in the Basic Latin and Latin-1 Supplement character set (through
     *         <code>\u00FF</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (
     *         <code>\u000D</code>)
     *         </p>
     *         </li>
     */
    public String privateKey() {
        return privateKey;
    }

    /**
     * <p>
     * The contents of the certificate chain. This is typically a concatenation of the PEM-encoded public key
     * certificates of the chain.
     * </p>
     * <p>
     * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string of
     * characters consisting of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the ASCII
     * character range
     * </p>
     * </li>
     * <li>
     * <p>
     * The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (<code>\u000D</code>
     * )
     * </p>
     * </li>
     * </ul>
     * 
     * @return The contents of the certificate chain. This is typically a concatenation of the PEM-encoded public key
     *         certificates of the chain.</p>
     *         <p>
     *         The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a
     *         string of characters consisting of the following:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of
     *         the ASCII character range
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The printable characters in the Basic Latin and Latin-1 Supplement character set (through
     *         <code>\u00FF</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (
     *         <code>\u000D</code>)
     *         </p>
     *         </li>
     */
    public String certificateChain() {
        return certificateChain;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(path());
        hashCode = 31 * hashCode + Objects.hashCode(serverCertificateName());
        hashCode = 31 * hashCode + Objects.hashCode(certificateBody());
        hashCode = 31 * hashCode + Objects.hashCode(privateKey());
        hashCode = 31 * hashCode + Objects.hashCode(certificateChain());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadServerCertificateRequest)) {
            return false;
        }
        UploadServerCertificateRequest other = (UploadServerCertificateRequest) obj;
        return Objects.equals(path(), other.path()) && Objects.equals(serverCertificateName(), other.serverCertificateName())
                && Objects.equals(certificateBody(), other.certificateBody()) && Objects.equals(privateKey(), other.privateKey())
                && Objects.equals(certificateChain(), other.certificateChain());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UploadServerCertificateRequest").add("Path", path())
                .add("ServerCertificateName", serverCertificateName()).add("CertificateBody", certificateBody())
                .add("PrivateKey", privateKey() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CertificateChain", certificateChain()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Path":
            return Optional.ofNullable(clazz.cast(path()));
        case "ServerCertificateName":
            return Optional.ofNullable(clazz.cast(serverCertificateName()));
        case "CertificateBody":
            return Optional.ofNullable(clazz.cast(certificateBody()));
        case "PrivateKey":
            return Optional.ofNullable(clazz.cast(privateKey()));
        case "CertificateChain":
            return Optional.ofNullable(clazz.cast(certificateChain()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UploadServerCertificateRequest, T> g) {
        return obj -> g.apply((UploadServerCertificateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamRequest.Builder, SdkPojo, CopyableBuilder<Builder, UploadServerCertificateRequest> {
        /**
         * <p>
         * The path for the server certificate. For more information about paths, see <a
         * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in the
         * <i>IAM User Guide</i>.
         * </p>
         * <p>
         * This parameter is optional. If it is not included, it defaults to a slash (/). This parameter allows (through
         * its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters consisting of either
         * a forward slash (/) by itself or a string that must begin and end with forward slashes. In addition, it can
         * contain any ASCII character from the ! (<code>\u0021</code>) through the DEL character (<code>\u007F</code>),
         * including most punctuation characters, digits, and upper and lowercased letters.
         * </p>
         * <note>
         * <p>
         * If you are uploading a server certificate specifically for use with Amazon CloudFront distributions, you must
         * specify a path using the <code>path</code> parameter. The path must begin with <code>/cloudfront</code> and
         * must include a trailing slash (for example, <code>/cloudfront/test/</code>).
         * </p>
         * </note>
         * 
         * @param path
         *        The path for the server certificate. For more information about paths, see <a
         *        href="https://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">IAM Identifiers</a> in
         *        the <i>IAM User Guide</i>.</p>
         *        <p>
         *        This parameter is optional. If it is not included, it defaults to a slash (/). This parameter allows
         *        (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of characters
         *        consisting of either a forward slash (/) by itself or a string that must begin and end with forward
         *        slashes. In addition, it can contain any ASCII character from the ! (<code>\u0021</code>) through the
         *        DEL character (<code>\u007F</code>), including most punctuation characters, digits, and upper and
         *        lowercased letters.
         *        </p>
         *        <note>
         *        <p>
         *        If you are uploading a server certificate specifically for use with Amazon CloudFront distributions,
         *        you must specify a path using the <code>path</code> parameter. The path must begin with
         *        <code>/cloudfront</code> and must include a trailing slash (for example,
         *        <code>/cloudfront/test/</code>).
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder path(String path);

        /**
         * <p>
         * The name for the server certificate. Do not include the path in this value. The name of the certificate
         * cannot contain any spaces.
         * </p>
         * <p>
         * This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a string of
         * characters consisting of upper and lowercase alphanumeric characters with no spaces. You can also include any
         * of the following characters: _+=,.@-
         * </p>
         * 
         * @param serverCertificateName
         *        The name for the server certificate. Do not include the path in this value. The name of the
         *        certificate cannot contain any spaces.</p>
         *        <p>
         *        This parameter allows (through its <a href="http://wikipedia.org/wiki/regex">regex pattern</a>) a
         *        string of characters consisting of upper and lowercase alphanumeric characters with no spaces. You can
         *        also include any of the following characters: _+=,.@-
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serverCertificateName(String serverCertificateName);

        /**
         * <p>
         * The contents of the public key certificate in PEM-encoded format.
         * </p>
         * <p>
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string
         * of characters consisting of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the
         * ASCII character range
         * </p>
         * </li>
         * <li>
         * <p>
         * The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>
         * )
         * </p>
         * </li>
         * <li>
         * <p>
         * The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (
         * <code>\u000D</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param certificateBody
         *        The contents of the public key certificate in PEM-encoded format.</p>
         *        <p>
         *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a
         *        string of characters consisting of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end
         *        of the ASCII character range
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The printable characters in the Basic Latin and Latin-1 Supplement character set (through
         *        <code>\u00FF</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return
         *        (<code>\u000D</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateBody(String certificateBody);

        /**
         * <p>
         * The contents of the private key in PEM-encoded format.
         * </p>
         * <p>
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string
         * of characters consisting of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the
         * ASCII character range
         * </p>
         * </li>
         * <li>
         * <p>
         * The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>
         * )
         * </p>
         * </li>
         * <li>
         * <p>
         * The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (
         * <code>\u000D</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param privateKey
         *        The contents of the private key in PEM-encoded format.</p>
         *        <p>
         *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a
         *        string of characters consisting of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end
         *        of the ASCII character range
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The printable characters in the Basic Latin and Latin-1 Supplement character set (through
         *        <code>\u00FF</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return
         *        (<code>\u000D</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateKey(String privateKey);

        /**
         * <p>
         * The contents of the certificate chain. This is typically a concatenation of the PEM-encoded public key
         * certificates of the chain.
         * </p>
         * <p>
         * The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a string
         * of characters consisting of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end of the
         * ASCII character range
         * </p>
         * </li>
         * <li>
         * <p>
         * The printable characters in the Basic Latin and Latin-1 Supplement character set (through <code>\u00FF</code>
         * )
         * </p>
         * </li>
         * <li>
         * <p>
         * The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return (
         * <code>\u000D</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param certificateChain
         *        The contents of the certificate chain. This is typically a concatenation of the PEM-encoded public key
         *        certificates of the chain.</p>
         *        <p>
         *        The <a href="http://wikipedia.org/wiki/regex">regex pattern</a> used to validate this parameter is a
         *        string of characters consisting of the following:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Any printable ASCII character ranging from the space character (<code>\u0020</code>) through the end
         *        of the ASCII character range
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The printable characters in the Basic Latin and Latin-1 Supplement character set (through
         *        <code>\u00FF</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The special characters tab (<code>\u0009</code>), line feed (<code>\u000A</code>), and carriage return
         *        (<code>\u000D</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateChain(String certificateChain);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private String path;

        private String serverCertificateName;

        private String certificateBody;

        private String privateKey;

        private String certificateChain;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadServerCertificateRequest model) {
            super(model);
            path(model.path);
            serverCertificateName(model.serverCertificateName);
            certificateBody(model.certificateBody);
            privateKey(model.privateKey);
            certificateChain(model.certificateChain);
        }

        public final String getPath() {
            return path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        public final String getServerCertificateName() {
            return serverCertificateName;
        }

        @Override
        public final Builder serverCertificateName(String serverCertificateName) {
            this.serverCertificateName = serverCertificateName;
            return this;
        }

        public final void setServerCertificateName(String serverCertificateName) {
            this.serverCertificateName = serverCertificateName;
        }

        public final String getCertificateBody() {
            return certificateBody;
        }

        @Override
        public final Builder certificateBody(String certificateBody) {
            this.certificateBody = certificateBody;
            return this;
        }

        public final void setCertificateBody(String certificateBody) {
            this.certificateBody = certificateBody;
        }

        public final String getPrivateKey() {
            return privateKey;
        }

        @Override
        public final Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public final void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        public final String getCertificateChain() {
            return certificateChain;
        }

        @Override
        public final Builder certificateChain(String certificateChain) {
            this.certificateChain = certificateChain;
            return this;
        }

        public final void setCertificateChain(String certificateChain) {
            this.certificateChain = certificateChain;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UploadServerCertificateRequest build() {
            return new UploadServerCertificateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
