/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a successful <a>GetOpenIDConnectProvider</a> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOpenIdConnectProviderResponse extends IamResponse implements
        ToCopyableBuilder<GetOpenIdConnectProviderResponse.Builder, GetOpenIdConnectProviderResponse> {
    private static final SdkField<String> URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetOpenIdConnectProviderResponse::url)).setter(setter(Builder::url))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Url").build()).build();

    private static final SdkField<List<String>> CLIENT_ID_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GetOpenIdConnectProviderResponse::clientIDList))
            .setter(setter(Builder::clientIDList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientIDList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> THUMBPRINT_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(GetOpenIdConnectProviderResponse::thumbprintList))
            .setter(setter(Builder::thumbprintList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThumbprintList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(GetOpenIdConnectProviderResponse::createDate)).setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(URL_FIELD,
            CLIENT_ID_LIST_FIELD, THUMBPRINT_LIST_FIELD, CREATE_DATE_FIELD));

    private final String url;

    private final List<String> clientIDList;

    private final List<String> thumbprintList;

    private final Instant createDate;

    private GetOpenIdConnectProviderResponse(BuilderImpl builder) {
        super(builder);
        this.url = builder.url;
        this.clientIDList = builder.clientIDList;
        this.thumbprintList = builder.thumbprintList;
        this.createDate = builder.createDate;
    }

    /**
     * <p>
     * The URL that the IAM OIDC provider resource object is associated with. For more information, see
     * <a>CreateOpenIDConnectProvider</a>.
     * </p>
     * 
     * @return The URL that the IAM OIDC provider resource object is associated with. For more information, see
     *         <a>CreateOpenIDConnectProvider</a>.
     */
    public String url() {
        return url;
    }

    /**
     * Returns true if the ClientIDList property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasClientIDList() {
        return clientIDList != null && !(clientIDList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of client IDs (also known as audiences) that are associated with the specified IAM OIDC provider resource
     * object. For more information, see <a>CreateOpenIDConnectProvider</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasClientIDList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of client IDs (also known as audiences) that are associated with the specified IAM OIDC provider
     *         resource object. For more information, see <a>CreateOpenIDConnectProvider</a>.
     */
    public List<String> clientIDList() {
        return clientIDList;
    }

    /**
     * Returns true if the ThumbprintList property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasThumbprintList() {
        return thumbprintList != null && !(thumbprintList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of certificate thumbprints that are associated with the specified IAM OIDC provider resource object. For
     * more information, see <a>CreateOpenIDConnectProvider</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasThumbprintList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of certificate thumbprints that are associated with the specified IAM OIDC provider resource
     *         object. For more information, see <a>CreateOpenIDConnectProvider</a>.
     */
    public List<String> thumbprintList() {
        return thumbprintList;
    }

    /**
     * <p>
     * The date and time when the IAM OIDC provider resource object was created in the AWS account.
     * </p>
     * 
     * @return The date and time when the IAM OIDC provider resource object was created in the AWS account.
     */
    public Instant createDate() {
        return createDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(url());
        hashCode = 31 * hashCode + Objects.hashCode(clientIDList());
        hashCode = 31 * hashCode + Objects.hashCode(thumbprintList());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOpenIdConnectProviderResponse)) {
            return false;
        }
        GetOpenIdConnectProviderResponse other = (GetOpenIdConnectProviderResponse) obj;
        return Objects.equals(url(), other.url()) && Objects.equals(clientIDList(), other.clientIDList())
                && Objects.equals(thumbprintList(), other.thumbprintList()) && Objects.equals(createDate(), other.createDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetOpenIdConnectProviderResponse").add("Url", url()).add("ClientIDList", clientIDList())
                .add("ThumbprintList", thumbprintList()).add("CreateDate", createDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Url":
            return Optional.ofNullable(clazz.cast(url()));
        case "ClientIDList":
            return Optional.ofNullable(clazz.cast(clientIDList()));
        case "ThumbprintList":
            return Optional.ofNullable(clazz.cast(thumbprintList()));
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetOpenIdConnectProviderResponse, T> g) {
        return obj -> g.apply((GetOpenIdConnectProviderResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetOpenIdConnectProviderResponse> {
        /**
         * <p>
         * The URL that the IAM OIDC provider resource object is associated with. For more information, see
         * <a>CreateOpenIDConnectProvider</a>.
         * </p>
         * 
         * @param url
         *        The URL that the IAM OIDC provider resource object is associated with. For more information, see
         *        <a>CreateOpenIDConnectProvider</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder url(String url);

        /**
         * <p>
         * A list of client IDs (also known as audiences) that are associated with the specified IAM OIDC provider
         * resource object. For more information, see <a>CreateOpenIDConnectProvider</a>.
         * </p>
         * 
         * @param clientIDList
         *        A list of client IDs (also known as audiences) that are associated with the specified IAM OIDC
         *        provider resource object. For more information, see <a>CreateOpenIDConnectProvider</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientIDList(Collection<String> clientIDList);

        /**
         * <p>
         * A list of client IDs (also known as audiences) that are associated with the specified IAM OIDC provider
         * resource object. For more information, see <a>CreateOpenIDConnectProvider</a>.
         * </p>
         * 
         * @param clientIDList
         *        A list of client IDs (also known as audiences) that are associated with the specified IAM OIDC
         *        provider resource object. For more information, see <a>CreateOpenIDConnectProvider</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientIDList(String... clientIDList);

        /**
         * <p>
         * A list of certificate thumbprints that are associated with the specified IAM OIDC provider resource object.
         * For more information, see <a>CreateOpenIDConnectProvider</a>.
         * </p>
         * 
         * @param thumbprintList
         *        A list of certificate thumbprints that are associated with the specified IAM OIDC provider resource
         *        object. For more information, see <a>CreateOpenIDConnectProvider</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbprintList(Collection<String> thumbprintList);

        /**
         * <p>
         * A list of certificate thumbprints that are associated with the specified IAM OIDC provider resource object.
         * For more information, see <a>CreateOpenIDConnectProvider</a>.
         * </p>
         * 
         * @param thumbprintList
         *        A list of certificate thumbprints that are associated with the specified IAM OIDC provider resource
         *        object. For more information, see <a>CreateOpenIDConnectProvider</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbprintList(String... thumbprintList);

        /**
         * <p>
         * The date and time when the IAM OIDC provider resource object was created in the AWS account.
         * </p>
         * 
         * @param createDate
         *        The date and time when the IAM OIDC provider resource object was created in the AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);
    }

    static final class BuilderImpl extends IamResponse.BuilderImpl implements Builder {
        private String url;

        private List<String> clientIDList = DefaultSdkAutoConstructList.getInstance();

        private List<String> thumbprintList = DefaultSdkAutoConstructList.getInstance();

        private Instant createDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOpenIdConnectProviderResponse model) {
            super(model);
            url(model.url);
            clientIDList(model.clientIDList);
            thumbprintList(model.thumbprintList);
            createDate(model.createDate);
        }

        public final String getUrl() {
            return url;
        }

        @Override
        public final Builder url(String url) {
            this.url = url;
            return this;
        }

        public final void setUrl(String url) {
            this.url = url;
        }

        public final Collection<String> getClientIDList() {
            return clientIDList;
        }

        @Override
        public final Builder clientIDList(Collection<String> clientIDList) {
            this.clientIDList = _clientIDListTypeCopier.copy(clientIDList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientIDList(String... clientIDList) {
            clientIDList(Arrays.asList(clientIDList));
            return this;
        }

        public final void setClientIDList(Collection<String> clientIDList) {
            this.clientIDList = _clientIDListTypeCopier.copy(clientIDList);
        }

        public final Collection<String> getThumbprintList() {
            return thumbprintList;
        }

        @Override
        public final Builder thumbprintList(Collection<String> thumbprintList) {
            this.thumbprintList = _thumbprintListTypeCopier.copy(thumbprintList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thumbprintList(String... thumbprintList) {
            thumbprintList(Arrays.asList(thumbprintList));
            return this;
        }

        public final void setThumbprintList(Collection<String> thumbprintList) {
            this.thumbprintList = _thumbprintListTypeCopier.copy(thumbprintList);
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        public GetOpenIdConnectProviderResponse build() {
            return new GetOpenIdConnectProviderResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
