/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a successful <a>GetGroupPolicy</a> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetGroupPolicyResponse extends IamResponse implements
        ToCopyableBuilder<GetGroupPolicyResponse.Builder, GetGroupPolicyResponse> {
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetGroupPolicyResponse::groupName)).setter(setter(Builder::groupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()).build();

    private static final SdkField<String> POLICY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetGroupPolicyResponse::policyName)).setter(setter(Builder::policyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyName").build()).build();

    private static final SdkField<String> POLICY_DOCUMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(GetGroupPolicyResponse::policyDocument)).setter(setter(Builder::policyDocument))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyDocument").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_NAME_FIELD,
            POLICY_NAME_FIELD, POLICY_DOCUMENT_FIELD));

    private final String groupName;

    private final String policyName;

    private final String policyDocument;

    private GetGroupPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.groupName = builder.groupName;
        this.policyName = builder.policyName;
        this.policyDocument = builder.policyDocument;
    }

    /**
     * <p>
     * The group the policy is associated with.
     * </p>
     * 
     * @return The group the policy is associated with.
     */
    public String groupName() {
        return groupName;
    }

    /**
     * <p>
     * The name of the policy.
     * </p>
     * 
     * @return The name of the policy.
     */
    public String policyName() {
        return policyName;
    }

    /**
     * <p>
     * The policy document.
     * </p>
     * <p>
     * IAM stores policies in JSON format. However, resources that were created using AWS CloudFormation templates can
     * be formatted in YAML. AWS CloudFormation always converts a YAML policy to JSON format before submitting it to
     * IAM.
     * </p>
     * 
     * @return The policy document.</p>
     *         <p>
     *         IAM stores policies in JSON format. However, resources that were created using AWS CloudFormation
     *         templates can be formatted in YAML. AWS CloudFormation always converts a YAML policy to JSON format
     *         before submitting it to IAM.
     */
    public String policyDocument() {
        return policyDocument;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(groupName());
        hashCode = 31 * hashCode + Objects.hashCode(policyName());
        hashCode = 31 * hashCode + Objects.hashCode(policyDocument());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetGroupPolicyResponse)) {
            return false;
        }
        GetGroupPolicyResponse other = (GetGroupPolicyResponse) obj;
        return Objects.equals(groupName(), other.groupName()) && Objects.equals(policyName(), other.policyName())
                && Objects.equals(policyDocument(), other.policyDocument());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetGroupPolicyResponse").add("GroupName", groupName()).add("PolicyName", policyName())
                .add("PolicyDocument", policyDocument()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "GroupName":
            return Optional.ofNullable(clazz.cast(groupName()));
        case "PolicyName":
            return Optional.ofNullable(clazz.cast(policyName()));
        case "PolicyDocument":
            return Optional.ofNullable(clazz.cast(policyDocument()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetGroupPolicyResponse, T> g) {
        return obj -> g.apply((GetGroupPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetGroupPolicyResponse> {
        /**
         * <p>
         * The group the policy is associated with.
         * </p>
         * 
         * @param groupName
         *        The group the policy is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupName(String groupName);

        /**
         * <p>
         * The name of the policy.
         * </p>
         * 
         * @param policyName
         *        The name of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyName(String policyName);

        /**
         * <p>
         * The policy document.
         * </p>
         * <p>
         * IAM stores policies in JSON format. However, resources that were created using AWS CloudFormation templates
         * can be formatted in YAML. AWS CloudFormation always converts a YAML policy to JSON format before submitting
         * it to IAM.
         * </p>
         * 
         * @param policyDocument
         *        The policy document.</p>
         *        <p>
         *        IAM stores policies in JSON format. However, resources that were created using AWS CloudFormation
         *        templates can be formatted in YAML. AWS CloudFormation always converts a YAML policy to JSON format
         *        before submitting it to IAM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyDocument(String policyDocument);
    }

    static final class BuilderImpl extends IamResponse.BuilderImpl implements Builder {
        private String groupName;

        private String policyName;

        private String policyDocument;

        private BuilderImpl() {
        }

        private BuilderImpl(GetGroupPolicyResponse model) {
            super(model);
            groupName(model.groupName);
            policyName(model.policyName);
            policyDocument(model.policyDocument);
        }

        public final String getGroupName() {
            return groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        public final String getPolicyName() {
            return policyName;
        }

        @Override
        public final Builder policyName(String policyName) {
            this.policyName = policyName;
            return this;
        }

        public final void setPolicyName(String policyName) {
            this.policyName = policyName;
        }

        public final String getPolicyDocument() {
            return policyDocument;
        }

        @Override
        public final Builder policyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
            return this;
        }

        public final void setPolicyDocument(String policyDocument) {
            this.policyDocument = policyDocument;
        }

        @Override
        public GetGroupPolicyResponse build() {
            return new GetGroupPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
