/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an AWS access key, without its secret key.
 * </p>
 * <p>
 * This data type is used as a response element in the <a>ListAccessKeys</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessKeyMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<AccessKeyMetadata.Builder, AccessKeyMetadata> {
    private static final SdkField<String> USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AccessKeyMetadata::userName)).setter(setter(Builder::userName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserName").build()).build();

    private static final SdkField<String> ACCESS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AccessKeyMetadata::accessKeyId)).setter(setter(Builder::accessKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessKeyId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AccessKeyMetadata::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATE_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(AccessKeyMetadata::createDate)).setter(setter(Builder::createDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_NAME_FIELD,
            ACCESS_KEY_ID_FIELD, STATUS_FIELD, CREATE_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String userName;

    private final String accessKeyId;

    private final String status;

    private final Instant createDate;

    private AccessKeyMetadata(BuilderImpl builder) {
        this.userName = builder.userName;
        this.accessKeyId = builder.accessKeyId;
        this.status = builder.status;
        this.createDate = builder.createDate;
    }

    /**
     * <p>
     * The name of the IAM user that the key is associated with.
     * </p>
     * 
     * @return The name of the IAM user that the key is associated with.
     */
    public String userName() {
        return userName;
    }

    /**
     * <p>
     * The ID for this access key.
     * </p>
     * 
     * @return The ID for this access key.
     */
    public String accessKeyId() {
        return accessKeyId;
    }

    /**
     * <p>
     * The status of the access key. <code>Active</code> means that the key is valid for API calls;
     * <code>Inactive</code> means it is not.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the access key. <code>Active</code> means that the key is valid for API calls;
     *         <code>Inactive</code> means it is not.
     * @see StatusType
     */
    public StatusType status() {
        return StatusType.fromValue(status);
    }

    /**
     * <p>
     * The status of the access key. <code>Active</code> means that the key is valid for API calls;
     * <code>Inactive</code> means it is not.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StatusType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the access key. <code>Active</code> means that the key is valid for API calls;
     *         <code>Inactive</code> means it is not.
     * @see StatusType
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date when the access key was created.
     * </p>
     * 
     * @return The date when the access key was created.
     */
    public Instant createDate() {
        return createDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(userName());
        hashCode = 31 * hashCode + Objects.hashCode(accessKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createDate());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessKeyMetadata)) {
            return false;
        }
        AccessKeyMetadata other = (AccessKeyMetadata) obj;
        return Objects.equals(userName(), other.userName()) && Objects.equals(accessKeyId(), other.accessKeyId())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(createDate(), other.createDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AccessKeyMetadata").add("UserName", userName()).add("AccessKeyId", accessKeyId())
                .add("Status", statusAsString()).add("CreateDate", createDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserName":
            return Optional.ofNullable(clazz.cast(userName()));
        case "AccessKeyId":
            return Optional.ofNullable(clazz.cast(accessKeyId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreateDate":
            return Optional.ofNullable(clazz.cast(createDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccessKeyMetadata, T> g) {
        return obj -> g.apply((AccessKeyMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessKeyMetadata> {
        /**
         * <p>
         * The name of the IAM user that the key is associated with.
         * </p>
         * 
         * @param userName
         *        The name of the IAM user that the key is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userName(String userName);

        /**
         * <p>
         * The ID for this access key.
         * </p>
         * 
         * @param accessKeyId
         *        The ID for this access key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessKeyId(String accessKeyId);

        /**
         * <p>
         * The status of the access key. <code>Active</code> means that the key is valid for API calls;
         * <code>Inactive</code> means it is not.
         * </p>
         * 
         * @param status
         *        The status of the access key. <code>Active</code> means that the key is valid for API calls;
         *        <code>Inactive</code> means it is not.
         * @see StatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusType
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the access key. <code>Active</code> means that the key is valid for API calls;
         * <code>Inactive</code> means it is not.
         * </p>
         * 
         * @param status
         *        The status of the access key. <code>Active</code> means that the key is valid for API calls;
         *        <code>Inactive</code> means it is not.
         * @see StatusType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StatusType
         */
        Builder status(StatusType status);

        /**
         * <p>
         * The date when the access key was created.
         * </p>
         * 
         * @param createDate
         *        The date when the access key was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createDate(Instant createDate);
    }

    static final class BuilderImpl implements Builder {
        private String userName;

        private String accessKeyId;

        private String status;

        private Instant createDate;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessKeyMetadata model) {
            userName(model.userName);
            accessKeyId(model.accessKeyId);
            status(model.status);
            createDate(model.createDate);
        }

        public final String getUserName() {
            return userName;
        }

        @Override
        public final Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public final void setUserName(String userName) {
            this.userName = userName;
        }

        public final String getAccessKeyId() {
            return accessKeyId;
        }

        @Override
        public final Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public final void setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StatusType status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreateDate() {
            return createDate;
        }

        @Override
        public final Builder createDate(Instant createDate) {
            this.createDate = createDate;
            return this;
        }

        public final void setCreateDate(Instant createDate) {
            this.createDate = createDate;
        }

        @Override
        public AccessKeyMetadata build() {
            return new AccessKeyMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
