/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a successful <a>UploadSSHPublicKey</a> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UploadSshPublicKeyResponse extends IamResponse implements
        ToCopyableBuilder<UploadSshPublicKeyResponse.Builder, UploadSshPublicKeyResponse> {
    private static final SdkField<SSHPublicKey> SSH_PUBLIC_KEY_FIELD = SdkField.<SSHPublicKey> builder(MarshallingType.SDK_POJO)
            .getter(getter(UploadSshPublicKeyResponse::sshPublicKey)).setter(setter(Builder::sshPublicKey))
            .constructor(SSHPublicKey::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SSHPublicKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SSH_PUBLIC_KEY_FIELD));

    private final SSHPublicKey sshPublicKey;

    private UploadSshPublicKeyResponse(BuilderImpl builder) {
        super(builder);
        this.sshPublicKey = builder.sshPublicKey;
    }

    /**
     * <p>
     * Contains information about the SSH public key.
     * </p>
     * 
     * @return Contains information about the SSH public key.
     */
    public SSHPublicKey sshPublicKey() {
        return sshPublicKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sshPublicKey());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadSshPublicKeyResponse)) {
            return false;
        }
        UploadSshPublicKeyResponse other = (UploadSshPublicKeyResponse) obj;
        return Objects.equals(sshPublicKey(), other.sshPublicKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UploadSshPublicKeyResponse").add("SSHPublicKey", sshPublicKey()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SSHPublicKey":
            return Optional.ofNullable(clazz.cast(sshPublicKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UploadSshPublicKeyResponse, T> g) {
        return obj -> g.apply((UploadSshPublicKeyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamResponse.Builder, SdkPojo, CopyableBuilder<Builder, UploadSshPublicKeyResponse> {
        /**
         * <p>
         * Contains information about the SSH public key.
         * </p>
         * 
         * @param sshPublicKey
         *        Contains information about the SSH public key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshPublicKey(SSHPublicKey sshPublicKey);

        /**
         * <p>
         * Contains information about the SSH public key.
         * </p>
         * This is a convenience that creates an instance of the {@link SSHPublicKey.Builder} avoiding the need to
         * create one manually via {@link SSHPublicKey#builder()}.
         *
         * When the {@link Consumer} completes, {@link SSHPublicKey.Builder#build()} is called immediately and its
         * result is passed to {@link #sshPublicKey(SSHPublicKey)}.
         * 
         * @param sshPublicKey
         *        a consumer that will call methods on {@link SSHPublicKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sshPublicKey(SSHPublicKey)
         */
        default Builder sshPublicKey(Consumer<SSHPublicKey.Builder> sshPublicKey) {
            return sshPublicKey(SSHPublicKey.builder().applyMutation(sshPublicKey).build());
        }
    }

    static final class BuilderImpl extends IamResponse.BuilderImpl implements Builder {
        private SSHPublicKey sshPublicKey;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadSshPublicKeyResponse model) {
            super(model);
            sshPublicKey(model.sshPublicKey);
        }

        public final SSHPublicKey.Builder getSshPublicKey() {
            return sshPublicKey != null ? sshPublicKey.toBuilder() : null;
        }

        @Override
        public final Builder sshPublicKey(SSHPublicKey sshPublicKey) {
            this.sshPublicKey = sshPublicKey;
            return this;
        }

        public final void setSshPublicKey(SSHPublicKey.BuilderImpl sshPublicKey) {
            this.sshPublicKey = sshPublicKey != null ? sshPublicKey.build() : null;
        }

        @Override
        public UploadSshPublicKeyResponse build() {
            return new UploadSshPublicKeyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
