/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateOpenIdConnectProviderThumbprintRequest extends IamRequest implements
        ToCopyableBuilder<UpdateOpenIdConnectProviderThumbprintRequest.Builder, UpdateOpenIdConnectProviderThumbprintRequest> {
    private static final SdkField<String> OPEN_ID_CONNECT_PROVIDER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateOpenIdConnectProviderThumbprintRequest::openIDConnectProviderArn))
            .setter(setter(Builder::openIDConnectProviderArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpenIDConnectProviderArn").build())
            .build();

    private static final SdkField<List<String>> THUMBPRINT_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(UpdateOpenIdConnectProviderThumbprintRequest::thumbprintList))
            .setter(setter(Builder::thumbprintList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThumbprintList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            OPEN_ID_CONNECT_PROVIDER_ARN_FIELD, THUMBPRINT_LIST_FIELD));

    private final String openIDConnectProviderArn;

    private final List<String> thumbprintList;

    private UpdateOpenIdConnectProviderThumbprintRequest(BuilderImpl builder) {
        super(builder);
        this.openIDConnectProviderArn = builder.openIDConnectProviderArn;
        this.thumbprintList = builder.thumbprintList;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM OIDC provider resource object for which you want to update the
     * thumbprint. You can get a list of OIDC provider ARNs by using the <a>ListOpenIDConnectProviders</a> operation.
     * </p>
     * <p>
     * For more information about ARNs, see <a
     * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names (ARNs)
     * and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM OIDC provider resource object for which you want to update the
     *         thumbprint. You can get a list of OIDC provider ARNs by using the <a>ListOpenIDConnectProviders</a>
     *         operation.</p>
     *         <p>
     *         For more information about ARNs, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
     *         (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.
     */
    public String openIDConnectProviderArn() {
        return openIDConnectProviderArn;
    }

    /**
     * Returns true if the ThumbprintList property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasThumbprintList() {
        return thumbprintList != null && !(thumbprintList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of certificate thumbprints that are associated with the specified IAM OpenID Connect provider. For more
     * information, see <a>CreateOpenIDConnectProvider</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasThumbprintList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of certificate thumbprints that are associated with the specified IAM OpenID Connect provider. For
     *         more information, see <a>CreateOpenIDConnectProvider</a>.
     */
    public List<String> thumbprintList() {
        return thumbprintList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(openIDConnectProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(thumbprintList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOpenIdConnectProviderThumbprintRequest)) {
            return false;
        }
        UpdateOpenIdConnectProviderThumbprintRequest other = (UpdateOpenIdConnectProviderThumbprintRequest) obj;
        return Objects.equals(openIDConnectProviderArn(), other.openIDConnectProviderArn())
                && Objects.equals(thumbprintList(), other.thumbprintList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateOpenIdConnectProviderThumbprintRequest")
                .add("OpenIDConnectProviderArn", openIDConnectProviderArn()).add("ThumbprintList", thumbprintList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OpenIDConnectProviderArn":
            return Optional.ofNullable(clazz.cast(openIDConnectProviderArn()));
        case "ThumbprintList":
            return Optional.ofNullable(clazz.cast(thumbprintList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateOpenIdConnectProviderThumbprintRequest, T> g) {
        return obj -> g.apply((UpdateOpenIdConnectProviderThumbprintRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IamRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateOpenIdConnectProviderThumbprintRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM OIDC provider resource object for which you want to update the
         * thumbprint. You can get a list of OIDC provider ARNs by using the <a>ListOpenIDConnectProviders</a>
         * operation.
         * </p>
         * <p>
         * For more information about ARNs, see <a
         * href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource Names
         * (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.
         * </p>
         * 
         * @param openIDConnectProviderArn
         *        The Amazon Resource Name (ARN) of the IAM OIDC provider resource object for which you want to update
         *        the thumbprint. You can get a list of OIDC provider ARNs by using the
         *        <a>ListOpenIDConnectProviders</a> operation.</p>
         *        <p>
         *        For more information about ARNs, see <a
         *        href="https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html">Amazon Resource
         *        Names (ARNs) and AWS Service Namespaces</a> in the <i>AWS General Reference</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openIDConnectProviderArn(String openIDConnectProviderArn);

        /**
         * <p>
         * A list of certificate thumbprints that are associated with the specified IAM OpenID Connect provider. For
         * more information, see <a>CreateOpenIDConnectProvider</a>.
         * </p>
         * 
         * @param thumbprintList
         *        A list of certificate thumbprints that are associated with the specified IAM OpenID Connect provider.
         *        For more information, see <a>CreateOpenIDConnectProvider</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbprintList(Collection<String> thumbprintList);

        /**
         * <p>
         * A list of certificate thumbprints that are associated with the specified IAM OpenID Connect provider. For
         * more information, see <a>CreateOpenIDConnectProvider</a>.
         * </p>
         * 
         * @param thumbprintList
         *        A list of certificate thumbprints that are associated with the specified IAM OpenID Connect provider.
         *        For more information, see <a>CreateOpenIDConnectProvider</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thumbprintList(String... thumbprintList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IamRequest.BuilderImpl implements Builder {
        private String openIDConnectProviderArn;

        private List<String> thumbprintList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOpenIdConnectProviderThumbprintRequest model) {
            super(model);
            openIDConnectProviderArn(model.openIDConnectProviderArn);
            thumbprintList(model.thumbprintList);
        }

        public final String getOpenIDConnectProviderArn() {
            return openIDConnectProviderArn;
        }

        @Override
        public final Builder openIDConnectProviderArn(String openIDConnectProviderArn) {
            this.openIDConnectProviderArn = openIDConnectProviderArn;
            return this;
        }

        public final void setOpenIDConnectProviderArn(String openIDConnectProviderArn) {
            this.openIDConnectProviderArn = openIDConnectProviderArn;
        }

        public final Collection<String> getThumbprintList() {
            return thumbprintList;
        }

        @Override
        public final Builder thumbprintList(Collection<String> thumbprintList) {
            this.thumbprintList = _thumbprintListTypeCopier.copy(thumbprintList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder thumbprintList(String... thumbprintList) {
            thumbprintList(Arrays.asList(thumbprintList));
            return this;
        }

        public final void setThumbprintList(Collection<String> thumbprintList) {
            this.thumbprintList = _thumbprintListTypeCopier.copy(thumbprintList);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateOpenIdConnectProviderThumbprintRequest build() {
            return new UpdateOpenIdConnectProviderThumbprintRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
