/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iam.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the effect that a permissions boundary has on a policy simulation when the boundary is
 * applied to an IAM entity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PermissionsBoundaryDecisionDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<PermissionsBoundaryDecisionDetail.Builder, PermissionsBoundaryDecisionDetail> {
    private static final SdkField<Boolean> ALLOWED_BY_PERMISSIONS_BOUNDARY_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(PermissionsBoundaryDecisionDetail::allowedByPermissionsBoundary))
            .setter(setter(Builder::allowedByPermissionsBoundary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedByPermissionsBoundary")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ALLOWED_BY_PERMISSIONS_BOUNDARY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean allowedByPermissionsBoundary;

    private PermissionsBoundaryDecisionDetail(BuilderImpl builder) {
        this.allowedByPermissionsBoundary = builder.allowedByPermissionsBoundary;
    }

    /**
     * <p>
     * Specifies whether an action is allowed by a permissions boundary that is applied to an IAM entity (user or role).
     * A value of <code>true</code> means that the permissions boundary does not deny the action. This means that the
     * policy includes an <code>Allow</code> statement that matches the request. In this case, if an identity-based
     * policy also allows the action, the request is allowed. A value of <code>false</code> means that either the
     * requested action is not allowed (implicitly denied) or that the action is explicitly denied by the permissions
     * boundary. In both of these cases, the action is not allowed, regardless of the identity-based policy.
     * </p>
     * 
     * @return Specifies whether an action is allowed by a permissions boundary that is applied to an IAM entity (user
     *         or role). A value of <code>true</code> means that the permissions boundary does not deny the action. This
     *         means that the policy includes an <code>Allow</code> statement that matches the request. In this case, if
     *         an identity-based policy also allows the action, the request is allowed. A value of <code>false</code>
     *         means that either the requested action is not allowed (implicitly denied) or that the action is
     *         explicitly denied by the permissions boundary. In both of these cases, the action is not allowed,
     *         regardless of the identity-based policy.
     */
    public Boolean allowedByPermissionsBoundary() {
        return allowedByPermissionsBoundary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allowedByPermissionsBoundary());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PermissionsBoundaryDecisionDetail)) {
            return false;
        }
        PermissionsBoundaryDecisionDetail other = (PermissionsBoundaryDecisionDetail) obj;
        return Objects.equals(allowedByPermissionsBoundary(), other.allowedByPermissionsBoundary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PermissionsBoundaryDecisionDetail")
                .add("AllowedByPermissionsBoundary", allowedByPermissionsBoundary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllowedByPermissionsBoundary":
            return Optional.ofNullable(clazz.cast(allowedByPermissionsBoundary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PermissionsBoundaryDecisionDetail, T> g) {
        return obj -> g.apply((PermissionsBoundaryDecisionDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PermissionsBoundaryDecisionDetail> {
        /**
         * <p>
         * Specifies whether an action is allowed by a permissions boundary that is applied to an IAM entity (user or
         * role). A value of <code>true</code> means that the permissions boundary does not deny the action. This means
         * that the policy includes an <code>Allow</code> statement that matches the request. In this case, if an
         * identity-based policy also allows the action, the request is allowed. A value of <code>false</code> means
         * that either the requested action is not allowed (implicitly denied) or that the action is explicitly denied
         * by the permissions boundary. In both of these cases, the action is not allowed, regardless of the
         * identity-based policy.
         * </p>
         * 
         * @param allowedByPermissionsBoundary
         *        Specifies whether an action is allowed by a permissions boundary that is applied to an IAM entity
         *        (user or role). A value of <code>true</code> means that the permissions boundary does not deny the
         *        action. This means that the policy includes an <code>Allow</code> statement that matches the request.
         *        In this case, if an identity-based policy also allows the action, the request is allowed. A value of
         *        <code>false</code> means that either the requested action is not allowed (implicitly denied) or that
         *        the action is explicitly denied by the permissions boundary. In both of these cases, the action is not
         *        allowed, regardless of the identity-based policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedByPermissionsBoundary(Boolean allowedByPermissionsBoundary);
    }

    static final class BuilderImpl implements Builder {
        private Boolean allowedByPermissionsBoundary;

        private BuilderImpl() {
        }

        private BuilderImpl(PermissionsBoundaryDecisionDetail model) {
            allowedByPermissionsBoundary(model.allowedByPermissionsBoundary);
        }

        public final Boolean getAllowedByPermissionsBoundary() {
            return allowedByPermissionsBoundary;
        }

        @Override
        public final Builder allowedByPermissionsBoundary(Boolean allowedByPermissionsBoundary) {
            this.allowedByPermissionsBoundary = allowedByPermissionsBoundary;
            return this;
        }

        public final void setAllowedByPermissionsBoundary(Boolean allowedByPermissionsBoundary) {
            this.allowedByPermissionsBoundary = allowedByPermissionsBoundary;
        }

        @Override
        public PermissionsBoundaryDecisionDetail build() {
            return new PermissionsBoundaryDecisionDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
